@ vim: set ft=armv4 noet:

@ thanks to tiririca for this unpacking code

.arch armv4
.cpu  arm7tdmi

.section .text.crt0,"ax",%progbits

.arm

.type _start,%function
.globl _start
_start:
	b main

.type ninlogo,%object
ninlogo:
	@ nintendo logo
	.incbin "nintendo.bin"

	@ game code (16 bytes)
.type main,%function
.globl main
main:
	add r4, pc, #1
	bx  r4

.thumb
.thumb_func
.type main$thumb,%function
main$thumb:
	mov r7, #0x60
	lsl r7, #19 @ r7 == 0x03000000 (IWRAM)
	add r0, pc, #16 @ r0 == &payload
	mov r1, r7  @ r1 == IWRAM

	@ maker code (2 bytes)
	swi 0x11 @ LZ77DecompressU8 (WRAM)

	@ ROM magic! (1 byte), main unit type (1 byte)
	.byte 0x96, 0x36 @ adds r6, 0x96
	@ device type (1 byte), reserved (7 bytes)
	mov r1, r7 @ r1 == IWRAM
	lsl r7, #1 @ r7 == 0x06000000 (VRAM)
	mov r4, #0x40
	lsl r4, #20 @ r4 == 0x04000000 (MMIO)

	@ sw version, checksum
	mov pc, r1
	@ reserved?
	.byte 0x50, 0x69

	@ multiboot entrypoint (=> won't work on multiboot...)
.type payload,%object
.globl payload
payload:
	.incbin "obj/payload.lz77"
.globl payload_end
payload_end:

