
// Main sketch for RAM by d vibe / nature.
// www.dvibe.se


/* Files that should be included in the archive:


p5.dom.js   ---.
p5.js          |____ the p5 library....
p5.min.js      |     
p5.sound.js ---'

plasmaBump.js
sketch.js
Sound FFT Waveform.js
soundRing.js
spiderTunnel.js
Squaretunnel.js
start.js
style.css
bounce.js
dotTunnel.js
endText.js
fftBalls.js
glassBump.js
greeTings.js
index.html
interFerence.js
introFFT.js
juliaSet.js
kassettAnim.js
files/Kassettband_Left2.png
files/Kassettband_Left3.png
files/Kassettband_Left4.png
files/Kassettband_Left5.png
files/Kassettband_Left6.png
files/Kassettband_Left7.png
files/Kassettband_Left8.png
files/Kassettband_Left9.png
files/Kassettband_Left10.png
files/Kassettband_Left11.png
files/Kassettband_Left12.png
files/Kassettband_right1.png
files/Kassettband_right2.png
files/Kassettband_right3.png
files/Kassettband_right4.png
files/Kassettband_right5.png
files/Kassettband_right6.png
files/Kassettband_right7.png
files/Kassettband_right8.png
files/Kassettband_right9.png
files/Kassettband_right10.png
files/Kassettband_right11.png
files/Kassettband_right12.png
files/lakrits2.png
files/LakritsDemo.png
files/LakritsDemo_light.png
files/loading.png
files/Orgel_1920x1080.png
files/RAM.png
files/RAM_Soundtrack_7.ogg
files/rx15_crop_1920.png
files/80s_tv2_test2.png
files/diskett1.png
files/diskett2.png
files/diskett3.png
files/diskett4.png
files/dvibelogo2.png
files/funkmachine.ttf
files/glasbump_light_new_1920x1080.gif
files/glasbump_light2_new_1920x1080.gif
files/glasbump_light2_new_1920x1080_dvibe.gif
files/glasbump_new_1920x1080.gif
files/glasses2.png
files/HUSKYSTA.TTF
files/Kassettband_Left1.png 

*/


let bpm = 103
let beat = 60000 / bpm //ms
let skipahead = 0// + beat * 304 // makes it possible to skip ahead in the demo (milliseconds)
//                            .
//                           /|\
// Parts:                     |
// introFFT 0 ----------------'                 
// squareTunnel 48 -----------'
// waveForm 80 ---------------'
// glassBump 112 -------------'
// soundRing 144 -------------'
// dotTunnel 176 -------------'
// spiderTunnel 208 ----------'
// plasmaBump 240 ------------'
// interFerence 256 ----------'
// fftBalls 272 --------------'
// juliaSet 304 --------------'
// endpart 340 ---------------'


//IntroFFT
let song, fft, turn, startmilli, timer, count, move, backcolour, spectrum, img, fillalpha, strokealpha,back;
let textsize = 0
let frames = 1;
let c = 1;
let history = [] 
let movement = 0
let framecount = 0
let vy = 100
let my = 0
let presents = []
let index = 0
let backover = 0


// IntroFFT

// FFT Ring

let running = false;
let doneloading = false;
let resW = "1280"
let resH = "720"
let resNew = 720 // Begins with this resolution
let demobutton = false
// FFT Ring

// Squaretunnel
let squares = new Array(512)
let MAX_DEPTH = 127 // Z-depth of where squares will be start be plotted
let nsquares = 256 // Number of squares
let speed = 10
let pos
let logospeed = 100
let retraction = 0
/* Bounce variables */
let logos = [];
let numberoflogos = 1;
let bottom
let sqrtnl = 50
let frametimer
// Squaretunnel

// Sound FFT Waveform
let human = []
let rotatespeed=0.00000000001
let huefftvert=200
let huefftline=50
let hueffthistory=255
// Sound FFT Waveform

//glassBump
let r,dirY, dirX, light, rolling, rollingvalue1, rollingvalue2, rollingvalue3, bumpresizedivider, rgb;
dirX = 1;
dirY = 1;
light = 50
rolling = 0
bumpresizedivider = 4
rgb = 25
//glassBump

//spiderTunnel
let spiderballs = new Array(64)
let spiderballs_MAX_DEPTH = spiderballs.length - 1 // Z-depth of where balls will be start be plotted
let spiderNballs = spiderballs.length // Number of balls
let timermultiplier
let frog = []
//spiderTunnel


//dotTunnel
// - General variable and array declarations - //
let degree = 360 // radians
let ndots = 20 // number of dots
ndots = ndots / degree
let baseSize, distance, circlesize, offsetreset, ym, xm, xinv, yinv, cirklar, orgelx, orgely, timerbeat2, timerbeat
let maximumframes = 10000 // How many frames the tunnel will execute before reseted to zero - Will also be the maximum size of the ymove and xmove arrays.
let x = []
let y = []
let offset = 0
let xmove = []
let ymove = []
let frame = 0
let framemove = 0
let colour = 0
let xskew = 0
let yskew = 0
let skewmove = 0
let xskewspeed = 0
let yskewspeed = 0
let xskewamp = 0
let yskewamp = 0
let rotationframe = 0
let endmove = 0
//- Extra settings for the tunnel - //
let ycorrection = -0.8 // Will move the tunnel against the centre in y axis
let xcorrection = -0.5 // Will move the tunnel against the centre in x axis
let xspeed = 0.1 // Speed for moving in x
let yspeed = 0.2 // Speed for moving in y
let xspeed2 = 0.04 // Frequency of xspeed
let yspeed2 = 0.06 // Frequency of yspeed
let xspeedamp = 0.002 // Amp of sine wave
let yspeedamp = 0.004 // Amp of sine wave
let yskewstart = beat*16 // millisecond where skew will start
let colourtimes = 5 // How white the tunnel will be 
let rotationspeed = 0.01 //rotates the tunnel
//---------------//


//dotTunnel


//soundRing
let soundr, cassetty, leftcountold, rightcountold, orgcass 
let ringhistory = []
let dizzy = []
let rightwheel = []
let leftwheel = []
let leftcount = 0
let leftdelay = 30
let rightcount = 0
let rightdelay = 0
let flip = 100
let animcount = 100
let ampwgth
let movend=0
//soundRing

//interFerence
let circles = 30;
//interFerence


//fftBalls
let numberofballs = 50; //many balls will be sloooooow
let diameter, bbottom, W, objectx, objecty, objectw, objecth;
let numberofbands = 256;
let balls = [];
let mass = 1;
let ballsgravity = 0.5;
let ballsbounce = 0.2;
let drummachine = [];
let scaletext = 1
//fftBalls

//juliaSet
let ja
let jb
let texthue = 0
let jmovea = 0;
let jmoveb = 0;
// let startmilli
let jsmear

let jbrightr
let jbrightg
let jbrightb
let jbrighth
let jmaxiterations = 0
//juliaSet
//greetText
let greetString
let greetTexts = []
let greetText = []
let lineoffset = 0
// let xoff = 0.0

//greetText
function execute() {

  running = true;
  song.setVolume(1);
  song.play();
  song.jump(skipahead / 1000);
  
}
//greetText

//endPart
let endString,endspeed
let endTexts = []
let endText = []
let maskar=[]
/* let endScroll = false
let endPause = false */


//endPart



function preload() {
  for (i = 1; i < 12; i++) {
    leftwheel[i - 1] = loadImage(`files/Kassettband_Left${i}.png`)
    rightwheel[i - 1] = loadImage(`files/Kassettband_right${i}.png`)


  }
  fontRegular = loadFont('files/HUSKYSTA.TTF'); // Husky Stash - https://www.1001freefonts.com/husky-stash.font - Larabie Fonts Freeware Fonts - Designer: Typodermic Fonts - http://typodermicfonts.com/ 
  fontCubic = loadFont('files/funkmachine.ttf'); // Funk Machine - https://www.1001freefonts.com/funk-machine.font - Iconian fonts - Designer: Dan Zadorozny. http://www.iconian.com/
  presents[0] = "- in 2020 - at GERP"
  presents[1] = "- Javascript / p5.js -"
  presents[2] = "- without webGL -"
  presents[3] = "first demo ever made by"
  human[0] = ".. hello human"
  human[1] = "is everything alright?"
  human[2] = "just hanging around?"
  human[3] = "watching some TV?"
  dizzy[0] = ".. perhaps dizzy?"
  dizzy[1] = "like a cat.."
  dizzy[2] = " on a hot tin roof?"
  dizzy[3] = "closing your eyes.."
  dizzy[4] = ".. seeing a tunnel of blue dots?"
  frog[0] = "stuck in a moment of"
  frog[1] = "toxic nostalgia?"
  frog[2] = "like a frog in"
  frog[3] = "cyberspace?"
  frog[4] = "cyberfrogspace?"
  drummachine[0] = ".. did you know"
  drummachine[1] = "your life always"
  drummachine[2] = "bounces like a"
  drummachine[3] = "drummachine?"

  bumpmap = loadImage('files/glasbump_new_1920x1080.gif');
  lightsource = loadImage('files/glasbump_light_new_1920x1080.gif');
  tv = loadImage('files/80s_tv2_test2.png');
  logo = loadImage('files/dvibelogo2.png');
  ram = loadImage('files/RAM.png');
  orgel = loadImage('files/Orgel_1920x1080.png');
  plasmabump = loadImage('files/glasbump_light2_new_1920x1080_dvibe.gif');
  plasmabump2 = loadImage('files/glasbump_light2_new_1920x1080.gif');

  lakrits = loadImage('files/LakritsDemo.png');
  lakritslight = loadImage('files/LakritsDemo_light.png');
  lakrits2 = loadImage('files/lakrits2.png');
  glasses = loadImage('files/glasses2.png');
  diskett1 = loadImage('files/diskett1.png');
  diskett2 = loadImage('files/diskett2.png');
  diskett4 = loadImage('files/diskett4.png');
  rx15 = loadImage('files/rx15_crop_1920.png');

  song = loadSound("files/RAM_Soundtrack_7.ogg", loaded) // Songs called Neostalgia and End Boss - a Nova
}

function toggleStart() {
  if (!running) {
	  
    startmilli = millis()
    stop();
    clear();
    colorMode(HSB)
    angleMode(DEGREES)
    rectMode(CENTER)
    imageMode(CENTER)
    textAlign(CENTER, CENTER)
    execute();
  }
}

function loaded() {
  doneloading = true
}


function setup() {
	p5.disableFriendlyErrors = true;
  //1024x576, 1280x720, 1536x864, 1920x1080 (resolutions)
  createCanvas(resW, resH);
  pixelDensity(1)
  frameRate(60) // Should lock the framerate to 60fps, but seems to go above it anyway
  frDiv = createDiv('');

  // ---- introFFT -----
  fft = new p5.FFT(0.6, 256);
  amplitude = new p5.Amplitude(0.5);
  textFont(fontRegular)
  //---- introFFT -----

  //---- Squaretunnel ----
  for (i = 0; i < squares.length; i++) {
    squares[i] = {
      z: i
    }
  }

  //---- spiderTunnel ----
  for (i = 0; i < spiderballs.length; i++) {
    spiderballs[i] = {
      z: i
    }
  }
  //---- spiderTunnel ----


  //---- dotTunnel ----
  orgelx = 0;
  orgely = -height
  cirklar = 72
  //---- dotTunnel ----
  //  resizeValues()

  //---- soundRing ----
  fft2 = new p5.FFT(0.9, 128);

  //---- soundRing ----

  //---- endPart ----
  endString = "Thank you for watching$$"
  endString += "- -- --------------------- -- -$"
  endString += "Retrograde Amnesia Memory-loss$"
  endString += "- -- --------------------- -- -$$"
  endString +="Presented at Gerp 2020$$$"
  endString +="(Left mousebutton to pause scroller)$$$"
  endString +="-- Credits --$$"
  endString +="- -- --------------------- -- -$"
  endString +="Code, gfx/photos, design & music$"
  endString +="- -- --------------------- -- -$"
  endString +="d vibe / nature$$$$"
  endString +="- -- --------------------- -- -$"
  endString +="Fonts (freeware)$"
  endString +="- -- --------------------- -- -$"
  endString +="Funk Machine - Dan Zadorozny$"
  endString +="Husky Stash - Typodermic Fonts$$$" 
  
  endString +="Some additional code were$"
  endString +="borrowed from various places$"
  endString +="on the Internet.$$$"
  endString +="Most noticable$- -- --------------------- -- -$Daniel Shiffman$- -- --------------------- -- -$"
  endString +="from The Coding Train.$$"
  endString +="Check out his Youtube channel$$"
  endString +="Also a big thanks to Youtube channel$"
  endString +="- -- --------------------- -- -$LearnEDU$- -- --------------------- -- -$who kindly "
  endString +="gave the Internet$the collision "
  endString +="detection algorithm$ which I used "
  endString +="in the ball scene,$ when the balls "
  endString +="hit each other.$$ That is the "
  endString +="only 'borrowed'$code I pretty much$"
  endString +="left untouched.$$$"
  endString +="I also want to mention 'Lefam', who made$"
  endString +="some Javascript code with Z-axis that I$"
  endString +="checked out to learn how it works. Some of$"
  endString +="Lefam's code exists in my demo..$$"
  endString +="Check the messy source code files$"
  endString +="for additional (minor) credits,$"
  endString +="links and references.$$$"
  endString +="So this was a journey with$"
  endString +="the goal of learning how to code$"
  endString +="some graphical demo effects in$" 
  endString +="Javascript using p5.js library.$$"
  endString +="There's no webGL involved, so all$"
  endString +="effects are made in 2D.$$"
  endString +="I know that most effects are very basic,$" 
  endString +="but I thought it would be a fun idea to try$"
  endString +="to gather some of them which I gave$" 
  endString +="some efforts to try to understand$"
  endString +="and make my own versions of.$$"
  endString +="The music is made with$Caustic 3 for Android$"
  endString +="Some additional strings on the$" 
  endString +="end song were added plus some post$"
  endString +="effects were added on both songs using$"
  endString +="Cubase Elements 10.$$"
  endString +="The songs are called$"
  endString +="Neostalgia$"
  endString +="&$"
  endString +="End Boss - a Nova$$"
  endString +="Neostalgia (which was the main part song)$"
  endString +="will feature a future Youtube video where$"
  endString +="an inside look will be shown of how it was$"
  endString +="made. Caustic 3 is a great mobile application$"
  endString +="for making music on the go.$$"
  endString +="So I'm here at Gerp 2020, writing this$"
  endString +="text, while watching the first round of$"
  endString +="AMOS live competition, between Highpuff$"
  endString +="and Blueberry.$$"
  endString +="In some aspects p5.js feels like a modern$"
  endString +="version of AMOS (a BASIC interpretor for$"
  endString +="the oldschool Amiga computers), in$"
  endString +="the sense of that it's quick and easy$"
  endString +="to get going with graphical effects.$$"
  endString +="Anyway.. See you around.$$"
  endString +="- -- --------------------- -- -$"
  endString +="Scroller loops$"
  endString +="- -- --------------------- -- -$"
  
  

  
 
 
  endTexts = endString.split("$")


  startRes();

  noLoop();

}

function draw() {

  if (doneloading) {

    loop();
    start();


  }

  if (running) {
    background(0);

    timer = Math.round(round(millis() - startmilli)) + skipahead // resets milliseconds



    // Intro
    if (timer >= 0 && timer < beat * 48) {
      translate(width / 2, height / 2)
      textSize(height / 45)
      textFont(fontCubic)
      introFFT(timer)
    }
    // Intro


    // squareTunnel
    if (timer >= beat * 48 && timer <= beat * 48.5) {
					//bottom, imgwidth, imgheight, x, y, vx, vy, leftx, rightx, image
      logos[0] = new logobounce(height / 2, logo.width, logo.height, width / 2, -height / 2, 0, 0, logo.width / 2, width - logo.width / 2, logo)
      logos[0].gravity = 0.9
      logos[0].bounce = 0.6
    }
    if (timer >= beat * 48 && timer <= beat * 80) {

      squareTunnel(timer - (beat * 48))
    }
    // squareTunnel

    // waveForm    
    if (timer >= beat * 80 && timer <= beat * 80.5) {
      frames = 0;
      move = 1;
      r = 0;
      turn = 0;
      history = []


    }
    if (timer >= beat * 80 && timer <= beat * 112) {
      translate(width / 2, height / 2)
      strokeWeight(width / 300)
      textsize = width / 10
      textSize(textsize)
      textAlign(CENTER, CENTER)
      textFont(fontRegular)

      waveForm(timer - (beat * 80));
    }
    // waveForm




    //soundRing
    if (timer >= beat * 144 && timer <= beat * 144.5) {
      angleMode(DEGREES)
      colorMode(HSB)
      frames = 0



    }
    // if (timer >= beat*208 && timer <= beat *240){
    if (timer >= beat * 144 && timer <= beat * 176) {

      // textFont(fontRegular)
      soundRing(timer - (beat * 144))

    }

    //soundRing
	
    // glassBump
    if (timer >= beat * 112 && timer <= beat * 112.5) {
      logos[1] = new logobounce(height + tv.height / 5, tv.width, tv.height, width / 2, -tv.height / 2, 0, 0, tv.width / 2, width - tv.width / 2, tv)
      logos[1].gravity = 2 
      logos[1].bounce = 0.1

      logos[2] = new logobounce(height, ram.width, ram.height, width / 2, -height / 2, 0, 0, ram.width / 2, width - tv.width / 2, ram)
      logos[2].gravity = 0.4 
      logos[2].bounce = 0.2

      light = 0

    }
    if (timer >= beat * 112 && timer <= beat * 146) {

      glassBump(timer - (beat * 112))
    }
    //glassBump
    //kassettAnim
    if (timer >= beat * 138 && timer <= beat * 138.5) {
      orgcass = 1 //eftwheel[0].width
      textsize = width / 10
      textFont(fontRegular)
      textSize(textsize)
    }
    if (timer >= beat * 138 && timer <= beat * 178) {

      kassettAnim(timer - (beat * 138))

    }


    //kassettAnim

    //dotTunnel
    if (timer >= beat * 176 && timer <= beat * 176.5) {
      angleMode(RADIANS)
      colorMode(RGB)


      imageMode(CENTER)
    }
    if (timer >= beat * 176 && timer <= beat * 208) {
      dotTunnel(timer - (beat * 176))

    }
    //dotTunnel



    //spiderTunnel
    if (timer >= beat * 208 && timer <= beat * 208.5) {
      translate(0, 0)
      angleMode(DEGREES)
      speed = 1
      history = []
      colorMode(RGB)

      textFont(fontRegular)
    }


    if (timer >= beat * 208 && timer <= beat * 239.75) {
      textsize = width / 10
      textSize(textsize)

      spiderTunnel(timer - (beat * 208))

    }
    //spiderTunnel

    // plasmaBump
    if (timer >= beat * 240 && timer <= beat * 240.5) {
      amplitude = new p5.Amplitude(0.1);
      light = -10
      let plasma = plasmabump
    }
    if (timer >= beat * 240 && timer <= beat * 255.75) {

      plasmaBump(timer - (beat * 240))
    }
    //plasmaBump

    //interFerence
    if (timer >= beat * 255.75 && beat <= beat * 256.5) {
      colorMode(HSB)
    }
    if (timer >= beat * 255.75 && timer <= beat * 272) {
      interFerence(timer - (beat * 256))
    }

    if (timer >= beat * 272 && timer <= beat * 272.5) {
      let wght = false 
      let c = false 
      let level = false
      let r = false 
    }

    //interFerence

    // fftBalls
    if (timer >= beat * 272 && timer <= beat * 272.5) {


      colorMode(HSB)
      objecty = 0
      textsize = width / 10
      for (i = 0; i < numberofballs; i++) {
        const radius = diameter / 2
        let vx = i / 2
        let x = i
        let y = radius * 2

        balls.push(new ball(x, y, radius, mass, ballsgravity, ballsbounce, bbottom, vx, 0, objecty, 0, 0));
      }

      fft = new p5.FFT(0.1, numberofbands);

      w = width / numberofbands;
      logos[3] = new logobounce(height, rx15.width, rx15.height, width / 2, -height / 2, 0, 0, ram.width / 2, width - tv.width / 2, rx15)
      logos[3].gravity = 0.8
      logos[3].bounce = 0.2


    }
    if (timer >= beat * 272 && timer <= beat * 304) {
      fftBalls(timer - (beat * 272))


    }
    if (timer >= beat * 304 && timer <= beat * 304.5) {
      for (i = 0; i < balls.length; i++) {
        balls.splice(i)
      }
      fft = false
    }


    // fftBalls

    // juliaSet
    if (timer >= beat * 304 && timer <= beat * 304.5) {
      loadPixels();

    }
    if (timer >= beat * 304 && timer <= beat * 335.75) {
      juliaSet(timer - (beat * 304))
    }

    // juliaSet

    //greeTings
    if (timer >= beat * 304 && timer <= beat * 304.5) {
      greetString = "$- -- Greetings -- -$$"
      greetString += "All forgotten$"
      greetString += "Nature, Traktor$"
      greetString += "Tulou, AINT$"
      greetString += "Pacific, Trash 8o$"
      greetString += "Five Finger Punch$"
      greetString += "Insane, Loonies$"
      greetString += "DHS, Ephidrena$"
	  greetString += "LateX, Keso$"
      greetString += "Everyone at Gerp$$"
      greetString += "- -- Greetings -- -"

      greetTexts = greetString.split("$")
      index = 0

      strokeWeight(height * 0.005)
      stroke(0)
      fill(255, 0, 255, 0.5)
      textAlign(CENTER, BOTTOM)



      for (i = 0; i < greetTexts.length; i++) {
        greetText.push(new textObj(greetTexts[i], textsize, (i * textsize)*1.5));
      }
    }
    if (timer >= beat * 304 && timer <= beat * 335.75) {
		      textsize = height * 0.1
      textFont(fontRegular)
      textSize(textsize)
      greeTings(timer - (beat * 304))
    }


    //greeTings

    //endPart
    if (timer >= beat * 340 && timer <= beat * 340.5) {
      textFont(fontCubic)
      lineoffset = 0
      index = 0

      strokeWeight(width * 0.004)
	  endmove = height/2+textsize
	  stroke(0)
	  fill(255)


    }
    if (timer >= beat * 340) {
	  endScroll=true
      textsize = height / 18
      textSize(textsize)
      textAlign(CENTER, CENTER)
      rectMode(CORNER)
      endPart(timer - (beat * 340))
    }


    //endPart



  }

/*  // Uncomment this to get a frameRate counter in left corner
 frDiv.style("color:grey;")
  frDiv.position(0, 0)
  frDiv.html(floor(frameRate()));
  
 */

}