// Original Mandelbrot algorithm by
// Daniel Shiffman
// https://youtu.be/6z7GQewK-Ks

// Modified for Juliaset by d vibe


function juliaSet(timer) {
  angleMode(DEGREES)
  jsmear = abs(sin(timer * 0.01) * 2)
  let zoomh = abs(sin(timer * 0.01) * 128) + 64
  let sin_a = sin((timer) * 0.04) * 128
  let cos_a = cos((timer) * 0.02) * 128
  let sin_a2 = sin(timer * 0.1) * 1.8

  
  jmovea = (sin_a * 0.0035)
  jmoveb = (cos_a * 0.003) + 1
  
  
  jmaxiterations = abs(sin(timer * 0.0097) * 30);

  for (let x = 0; x < width / 4; x++) {
    for (let y = 0; y < height / 4; y++) {

      let ja = (x * zoomh * 0.00015) - 3
      let jb = (y * zoomh * 0.0001) - 1.5


      for (jiterations = 0; jiterations < jmaxiterations; jiterations++) {
        let newa = (ja * ja - jb * jb)
        let newb = jsmear * ja * jb;
        ja = newa + jmovea + sin_a2 * ja;
        jb = newb + jmoveb + sin_a2 * jb;
        if (ja * ja + jb * jb > 1000) {
          break;
        }
      }
      jbrightr = jiterations * 10
      jbrightg = jbrightr * 4
      jbrightb = jbrightr * 10
      jbrighth = jbrightr * 12


      if (jiterations == jmaxiterations) {
        jbrightr = 255;
        jbrightb = 255;
        jbrightg = 255;
        jbrighth = 255;
      }

      let pixel = (x + y * width) * 4;
      for (i = 0; i < 4; i++) {


        pixels[pixel * 4 + ((width * i) * 4)] = jbrightr;
        pixels[pixel * 4 + ((width * i) * 4) + 1] = jbrightg;
        pixels[pixel * 4 + ((width * i) * 4) + 2] = jbrightb;
        pixels[pixel * 4 + ((width * i) * 4) + 3] = jbrighth;

        pixels[pixel * 4 + ((width * i) * 4) + 4] = jbrightr;
        pixels[pixel * 4 + ((width * i) * 4) + 5] = jbrightg;
        pixels[pixel * 4 + ((width * i) * 4) + 6] = jbrightb;
        pixels[pixel * 4 + ((width * i) * 4) + 7] = jbrighth;

        pixels[pixel * 4 + ((width * i) * 4) + 8] = jbrightr;
        pixels[pixel * 4 + ((width * i) * 4) + 9] = jbrightg;
        pixels[pixel * 4 + ((width * i) * 4) + 10] = jbrightb;
        pixels[pixel * 4 + ((width * i) * 4) + 11] = jbrighth;

        pixels[pixel * 4 + ((width * i) * 4) + 12] = jbrightr;
        pixels[pixel * 4 + ((width * i) * 4) + 13] = jbrightg;
        pixels[pixel * 4 + ((width * i) * 4) + 14] = jbrightb;
        pixels[pixel * 4 + ((width * i) * 4) + 15] = jbrighth;


      }


    }
  }
  updatePixels();

}