

function fftBalls(timer) {
  timebeat = timer * 0.5
  timebeat %= beat / 2
  angleMode(DEGREES)

  let level = amplitude.getLevel();
  let r = level * 128
  background(180, 40, r)
  textAlign(CENTER, CENTER)

  let spectrum3 = fft.analyze();
  for (i = 0; i < numberofballs; i++) {
    let fx, fy
    balls[i].move()
    balls[i].display()
    for (j = 0; j < numberofballs; j++) {

      if (i !== j && balls[i].intersects(balls[j])) {


        resolveCollision(balls[i], balls[j])
        balls[i].hit = true
        balls[j].hit = true

      }

    }

    for (k = 0; k < spectrum3.length; k++) {
      let amp = spectrum3[k];
      let y = map(amp, 0, numberofbands, height/1.2, height);


        

      if ((balls[i].x - (balls[i].radius * 2) < k * w && balls[i].x + (balls[i].radius * 2) > k * w &&  balls[i].y + balls[i].radius*2 > y) && timer < beat * 28) {
        balls[i].bottom=y
        balls[i].velocity.y -= 1
       
        balls[i].roof = objecty


      }

    }
    if (timer >= beat * 28 && timer <= beat * 32) {

      balls[i].bottom = height * 3

    }


  }
  for (k = 0; k < spectrum3.length; k++) {
    let amp = spectrum3[k];
	let fy = map(amp, 0, numberofbands, height/1.3, height/1.1);
    fx = map(k, 0, 32, 0, width)
    noStroke()
    fill(255, 0, 255, map(fy, height, height / 1.12, 0.2, 1))
    push()

    rect(fx, fy, width / 32, height / 256)
    pop()
  }


  if (timer >= beat * 8 && timer <= beat * 32) {
    logos[3].display()
    logos[3].move()
    if (timer >= beat * 8 && timer <= beat * 16) {
      logos[3].bottom = height / 3
      objecty = logos[3].bottom + diameter
    }
    if (timer >= beat * 16 && timer <= beat * 23.5) {

      logos[3].bottom = height / 1.5 
      objecty = logos[3].bottom + diameter

    }


    if (timer >= beat * 23.5 && timer <= beat * 23.6) {

      logos[3].vy = -15
      objecty = logos[3].bottom + diameter
    }
    if (timer >= beat * 28 && timer <= beat * 32) {

      logos[3].bottom = height * 3 
      objecty = logos[3].bottom + diameter


    }


  }

  push()
  translate(width / 2, height / 2)
  fill(255, 0, 255, 0.8)
  strokeWeight(height * 0.02)
  stroke(0, 0, 0, 0.5)
  if (timer >= beat * 16 && timer <= beat * 20) {
    text(drummachine[0], 0, 0) 

  }
  if (timer >= beat * 20 && timer <= beat * 23.5) {
    text(drummachine[1], 0, 0)
  }
  if (timer >= beat * 23.5 && timer <= beat * 28) {
    text(drummachine[2], 0, 0 + sin(timebeat) * width * 0.006)
  }
  if (timer >= beat * 28 && timer <= beat * 32) {

    if (timer >= beat * 30 && timer <= beat * 32) {
    scaletext += (timer - beat * 28) * 0.001
      rotate(sin((timer - beat * 30)*0.03)*360)
    }
    scale(scaletext)
    text(drummachine[3], 0, 0 + sin(timebeat) * width * 0.011)
  }


  pop()
}