#include "neslib.h"

#define PROFILE_BEGIN()			*((unsigned char*)0x401e)=0;
#define PROFILE_END()			*((unsigned char*)0x401f)=0;

enum {
	NMI_EMPTY=0,
	NMI_NORMAL,
	NMI_STAR,
	NMI_YEAR
};

enum {
	IRQ_EMPTY=0,
	IRQ_STAR,
	IRQ_ROW_FULLX,
	IRQ_YEAR,
	IRQ_TEXT
};

#define M_VERTICAL			0
#define M_HORIZONTAL		1

#define PRG_BGM				0x00	//music
#define PRG_STAR_ANIM		0x01

#define PRG_OVL4			0x04
#define PRG_OVL5			0x05

#define PRG_MAIN			0x06

#define CHR_FONT			(0x00*8+0)
#define CHR_SPRITES			(0x00*8+4)
#define CHR_STAR_LARGE		(0x01*8+0)
#define CHR_NEWYEAR_BG 		(0x05*8+0)
#define CHR_STAR_SMALL		(0x07*8+0)
#define CHR_BACK			(0x0b*8+0)
#define CHR_NU_2			(0x0c*8+0)
#define CHR_NU_0			(0x0d*8+0)
#define CHR_SIDE_1			(0x0e*8+0)
#define CHR_SIDE_2			(0x0f*8+0)

//update and split list put into separate segments to keep them aligned to page
//they're also reused sometimes for other purposes

#pragma bssseg (push,"UPDLST")
#pragma dataseg(push,"UPDLST")

unsigned char update_list[128];

#pragma dataseg(pop);
#pragma bssseg (pop);

#pragma bssseg (push,"ZEROPAGE")
#pragma dataseg(push,"ZEROPAGE")

unsigned char oam_off;
unsigned char oam_step;

unsigned char upd_off;

unsigned char _i;
unsigned char _j;
unsigned char _n;
unsigned char _id;
unsigned char _sx;
unsigned char _sy;
unsigned char _pal;
unsigned char _col;
unsigned char _col1;
unsigned char _col2;
unsigned char _row;
unsigned char _spr;
unsigned char _chr;
unsigned char _tile;
unsigned char _attr;
unsigned char _mask;
unsigned char _ptr;
unsigned char _off;
unsigned char _bright;
unsigned char _done;
unsigned char _frame;
unsigned int _ssx;
unsigned int _ssy;

unsigned char pal_req[16];
unsigned char pal_scr[16];

#pragma dataseg(pop);
#pragma bssseg (pop);



//assembly functions

void __fastcall__ ovl_call(unsigned char prg,void (*func)(void));

void __fastcall__ set_nmi_handler(unsigned char id);
void __fastcall__ set_irq_handler(unsigned char id);

void __fastcall__ mmc3_irq_enable(unsigned char enable);
void __fastcall__ mmc3_chr_bank(unsigned char bank,unsigned char page);
void __fastcall__ mmc3_set_mirroring(unsigned char mode);

void __fastcall__ oam_clear_fast(void);

void __fastcall__ oam_meta_clip_y(int sx,int sy,unsigned char pal,const unsigned char *meta);
void __fastcall__ oam_meta_clip_x(int sx,int sy,unsigned char pal,const unsigned char *meta);

unsigned char ft_song_done;		//FT player sets it to 1 when a song ends
unsigned char ft_current_frame;	//current order list position to sync the action to the music
unsigned char ft_prev_frame;
unsigned char ft_current_row;
unsigned char ft_prev_row;

void __fastcall__ music_play(unsigned char prg,const unsigned char* data);
void __fastcall__ music_stop(void);

extern unsigned char music_data[];



#pragma rodataseg (push,"STARTUP")
#pragma codeseg   (push,"STARTUP")

void morph_palette(void);
/*
void morph_palette(void)
{
	for(_i=0;_i<16;++_i)
	{
		if(_i&&!(_i&3)) continue;
		
		_col1=pal_scr[_i];
		_col2=pal_req[_i];
		
		if(_col2==0x30)
		{
			_col1+=0x10;
			
			if(_col1>=0x40) _col1=0x30;
		}
		else
		{
			if((_col1&0x0f)!=(_col2&0x0f))
			{
				if((_col1&0x0f)>=0x0e)
				{
					_col1=_col2&0x0f;
				}
				else
				{
					if((_col1&0x0f)<(_col2&0x0f)) ++_col1;
					if((_col1&0x0f)>(_col2&0x0f)) --_col1;
				}
			}
			else
			{
				if((_col1&0xf0)<(_col2&0xf0)) _col1+=0x10;
				if((_col1&0xf0)>(_col2&0xf0)) _col1-=0x10;
			}
		}

		pal_scr[_i]=_col1;
	}
}
*/
#pragma codeseg   (pop)
#pragma rodataseg (pop)



#pragma rodataseg (push,"PRG_OVL4")
#pragma codeseg   (push,"PRG_OVL4")

#include "e_year.h"

#pragma codeseg   (pop)
#pragma rodataseg (pop)



#pragma rodataseg (push,"PRG_OVL5")
#pragma codeseg   (push,"PRG_OVL5")

#include "e_star.h"
#include "e_snow.h"
#include "e_text.h"

#pragma codeseg   (pop)
#pragma rodataseg (pop)




void main(void)
{
	set_nmi_handler(NMI_NORMAL);
	
	delay(1*60);
	
	music_play(PRG_BGM,music_data);
	
	while(1)
	{
		ovl_call(PRG_OVL5,e_snow);
		ovl_call(PRG_OVL5,e_text_1);
		ovl_call(PRG_OVL5,e_star);
		ovl_call(PRG_OVL5,e_text_2);
		ovl_call(PRG_OVL4,e_year);
		ovl_call(PRG_OVL5,e_text_3);
	}
}
