.importzp __i,__sx,__sy

.segment "FIXED"

;void __fastcall__ sin_scaled(unsigned char a,unsigned char s);

SS_SSX=TEMP+0		;word
SS_SC=TEMP+2		;word

.export _sin_scaled

_sin_scaled:

	sta <SS_SC+1		;MSB>>2 instead of LSB<<6
	lda #0
	lsr <SS_SC+1
	ror a
	lsr <SS_SC+1
	ror a
	sta <SS_SC+0
	
	;lda <SS_SC+0
	clc
	adc #<_sincos
	sta <SS_SC+0
	lda <SS_SC+1
	adc #>_sincos
	sta <SS_SC+1
	
	lda #<(128-8)
	sta <SS_SSX+0
	lda #>(128-8)
	sta <SS_SSX+1
	
	jsr popa
	
	ora #0
	bmi @minus
	
@plus:

	cmp #$40
	bcc :+
	and #$3f
	eor #$3f
:

	tay
	
	lda <SS_SSX+0
	clc
	adc (SS_SC),y
	sta <SS_SSX+0
	bcc :+
	inc <SS_SSX+1
:
	
	jmp @next
	
@minus:

	cmp #$c0
	bcc :+
	eor #$3f
:
	and #$3f
	
	tay
	
	lda <SS_SSX+0
	sec
	sbc (SS_SC),y
	sta <SS_SSX+0
	bcs :+
	dec <SS_SSX+1
:

@next:

	lda <SS_SSX+1
	bne @skip
	
	lda <SS_SSX+0
	cmp #8
	bcc @skip
	cmp #240
	bcs @skip

	sta <__sx
	rts
	
@skip:

	lda #255
	sta <__sx

	rts



;void __fastcall__ cos_scaled(unsigned char a,unsigned char s);

.export _cos_scaled

_cos_scaled:

	sta <SS_S+1		;MSB>>2 instead of LSB<<6
	lda #0
	lsr <SS_S+1
	ror a
	lsr <SS_S+1
	ror a
	sta <SS_S+0
	
	;lda <SS_S+0
	clc
	adc #<_sincos
	sta <SS_S+0
	lda <SS_S+1
	adc #>_sincos
	sta <SS_S+1
	
	lda #<(120-8)
	sta <SS_SSX+0
	lda #>(128-8)
	sta <SS_SSX+1
	
	jsr popa
	
	sec
	sbc #$40		;cos from sin
	
	bmi @minus
	
@plus:

	cmp #$40
	bcc :+
	and #$3f
	eor #$3f
:

	tay
	
	lda <SS_SSX+0
	clc
	adc (SS_S),y
	sta <SS_SSX+0
	bcc :+
	inc <SS_SSX+1
:
	
	jmp @next
	
@minus:

	cmp #$c0
	bcc :+
	eor #$3f
:
	and #$3f
	
	tay
	
	lda <SS_SSX+0
	sec
	sbc (SS_S),y
	sta <SS_SSX+0
	bcs :+
	dec <SS_SSX+1
:

@next:

	lda <SS_SSX+1
	bne @skip
	
	lda <SS_SSX+0
	cmp #8
	bcc @skip
	cmp #240
	bcs @skip

	sta <__sy
	rts
	
@skip:

	lda #255
	sta <__sy

	rts
	
	

;void persp_update(void);

SS_R=TEMP+4		;byte
SS_SZ=TEMP+5	;byte
SS_A=TEMP+6		;byte
SS_S=TEMP+7		;byte
SS_TILE=TEMP+8	;byte
SS_PAL=TEMP+9	;byte

.export _persp_update

_persp_update:

	lda _persp_rotate+1
	sta <SS_R
	
	lda #0
	sta <__i
	
@loop:

	lda <__i
	asl a
	tax
	lda _persp_z+1,x
	lsr a
	sta <SS_SZ
	
	cmp #120
	bcc :+
	jsr _set_persp
	jmp @skip
:
	cmp #40
	bcs :+
	jmp @next
:
	
	ldx <__i
	lda _persp_a,x
	clc
	adc <SS_R
	sta <SS_A
	
	ldx <SS_SZ
	lda _rescale_s,x
	sta <SS_S
	
	;lda <SS_A
	;jsr pusha
	lda <SS_S
	
	;----------------
	
	sta <SS_SC+1		;MSB>>2 instead of LSB<<6
	lda #0
	lsr <SS_SC+1
	ror a
	lsr <SS_SC+1
	ror a
	sta <SS_SC+0
	
	;lda <SS_SC+0
	clc
	adc #<_sincos
	sta <SS_SC+0
	lda <SS_SC+1
	adc #>_sincos
	sta <SS_SC+1
	
	lda #<(128-8)
	sta <SS_SSX+0
	lda #>(128-8)
	sta <SS_SSX+1
	
	;jsr popa
	lda <SS_A
	;ora #0
	bmi @sminus
	
@splus:

	cmp #$40
	bcc :+
	and #$3f
	eor #$3f
:

	tay
	
	lda <SS_SSX+0
	clc
	adc (SS_SC),y
	sta <SS_SSX+0
	bcc :+
	inc <SS_SSX+1
:
	
	jmp @snext
	
@sminus:

	cmp #$c0
	bcc :+
	eor #$3f
:
	and #$3f
	
	tay
	
	lda <SS_SSX+0
	sec
	sbc (SS_SC),y
	sta <SS_SSX+0
	bcs :+
	dec <SS_SSX+1
:

@snext:

	lda <SS_SSX+1
	bne @sskip
	
	lda <SS_SSX+0
	cmp #8
	bcc @sskip
	cmp #240
	bcs @sskip

	sta <__sx
	jmp @sskip1
	
@sskip:

	lda #255
	sta <__sx
	
@sskip1:

	;----------------
	
	;lda <SS_A
	;jsr pusha
	lda <SS_S
	
	;---------
	
	sta <SS_S+1		;MSB>>2 instead of LSB<<6
	lda #0
	lsr <SS_S+1
	ror a
	lsr <SS_S+1
	ror a
	sta <SS_S+0
	
	;lda <SS_S+0
	clc
	adc #<_sincos
	sta <SS_S+0
	lda <SS_S+1
	adc #>_sincos
	sta <SS_S+1
	
	lda #<(120-8)
	sta <SS_SSX+0
	lda #>(128-8)
	sta <SS_SSX+1
	
	;jsr popa
	lda <SS_A
	
	sec
	sbc #$40		;cos from sin
	
	bmi @cminus
	
@cplus:

	cmp #$40
	bcc :+
	and #$3f
	eor #$3f
:

	tay
	
	lda <SS_SSX+0
	clc
	adc (SS_S),y
	sta <SS_SSX+0
	bcc :+
	inc <SS_SSX+1
:
	
	jmp @cnext
	
@cminus:

	cmp #$c0
	bcc :+
	eor #$3f
:
	and #$3f
	
	tay
	
	lda <SS_SSX+0
	sec
	sbc (SS_S),y
	sta <SS_SSX+0
	bcs :+
	dec <SS_SSX+1
:

@cnext:

	lda <SS_SSX+1
	bne @cskip
	
	lda <SS_SSX+0
	cmp #8
	bcc @cskip
	cmp #240
	bcs @cskip

	sta <__sy
	jmp @cskip1
	
@cskip:

	lda #255
	sta <__sy
	
@cskip1:

	;---------

	lda <__sx
	cmp #255
	bcs @next
	lda <__sy
	cmp #255
	bcs @next
	
	ldx <SS_SZ
	
	lda _tile_s,x
	sta <SS_TILE
	
	lda _pal_s,x
	ldx <__sy
	cpx #8*8
	bcc :+
	cpx #20*8
	bcs :+
	ora #OAM_BEHIND
:
	sta <SS_PAL

	ldx <_oam_off
	
	lda <__sy
	sta OAM_BUF+0,x
	lda <SS_TILE
	sta OAM_BUF+1,x
	lda <SS_PAL
	sta OAM_BUF+2,x
	lda <__sx
	sta OAM_BUF+3,x
	inx
	inx
	inx
	inx
	
	; lda <SS_TILE
	; cmp #$70
	; bcc :+
	
	; lda <__sy
	; sta OAM_BUF+0,x
	; lda <SS_TILE
	; clc
	; adc #2
	; sta OAM_BUF+1,x
	; lda <SS_PAL
	; sta OAM_BUF+2,x
	; lda <__sx
	; clc
	; adc #8
	; sta OAM_BUF+3,x
	; inx
	; inx
	; inx
	; inx
; :

	stx <_oam_off
	
@next:

	lda <__i
	asl a
	tax
	
	lda _persp_z+0,x
	clc
	adc _persp_zx+0,x
	sta _persp_z+0,x
	lda _persp_z+1,x
	adc _persp_zx+1,x
	sta _persp_z+1,x

@skip:

	inc <__i
	lda <__i
	cmp #MAX_PERSP
	bcs :+
	jmp @loop
:
	rts