#include "data/year_nam.h"

#define ROTATE_DELTA		4
#define ROTATE_MAX			512

const unsigned char year_palette_bg[]={
0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,//0  clear
0x04,0x04,0x24,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,//1  2---
0x04,0x04,0x04,0x24,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,//2  -0--
0x04,0x04,0x04,0x04,0x04,0x04,0x24,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,//3  --2-
0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x24,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,//4  ---0
0x04,0x14,0x24,0x24,0x04,0x14,0x24,0x24,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,//5  2020

0x04,0x14,0x30,0x30,0x04,0x15,0x30,0x30,0x04,0x13,0x13,0x13,0x04,0x14,0x14,0x14,//6 layer1
0x04,0x14,0x33,0x34,0x04,0x15,0x35,0x36,0x04,0x13,0x22,0x22,0x04,0x14,0x25,0x25,//7 layer12
0x04,0x14,0x23,0x24,0x04,0x15,0x25,0x26,0x04,0x13,0x22,0x31,0x04,0x14,0x25,0x37,//8 layer123

0x04,0x14,0x30,0x24,0x04,0x15,0x25,0x26,0x04,0x13,0x22,0x31,0x04,0x14,0x25,0x37,//9 flash 2
0x04,0x14,0x23,0x30,0x04,0x15,0x25,0x26,0x04,0x13,0x22,0x31,0x04,0x14,0x25,0x37,//10 flash 0
0x04,0x14,0x23,0x24,0x04,0x15,0x30,0x26,0x04,0x13,0x22,0x31,0x04,0x14,0x25,0x37,//11 flash 2
0x04,0x14,0x23,0x24,0x04,0x15,0x25,0x30,0x04,0x13,0x22,0x31,0x04,0x14,0x25,0x37,//12 flash 0

0x04,0x14,0x23,0x24,0x04,0x15,0x25,0x26,0x04,0x14,0x25,0x37,0x04,0x13,0x22,0x31,//13
};

const unsigned char year_palette_spr[16]={ 0x04,0x04,0x04,0x14,0x04,0x04,0x04,0x24,0x04,0x04,0x04,0x34,0x04,0x04,0x04,0x30 };

const unsigned char year_pal_sequence[]={
	0,0,0,0,1,1,1,1,
	0,0,0,0,2,2,2,2,
	0,0,0,0,3,3,3,3,
	0,0,0,0,4,4,4,4,
	0,0,0,0,5,5,5,5,
	6,6,6,6,7,7,7,7,

	8,9,8,10,8,11,8,12,
	8,11,8,10,8,9,8,8,
	
	8,8,
	13,13,13,13,13,13,13,
	13,13,13,13,13,13,13,
	8,8,8,8,8,8,8,8,
	8,8,8,8,8,8,8,8,
	13,13,13,13,13,13,13,
	13,13,13,13,13,13,13,
	8
};

const unsigned char year_sine[64]={
	0,0,0,0,0,0,0,0,1,1,1,2,2,2,3,3,3,4,4,5,5,5,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,5,5,5,4,4,4,3,3,2,2,2,1,1,1,0,0,0,0,0,0,0,
};

const unsigned char sincos[64*84]={
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
0,0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,4,5,5,5,5,5,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
0,0,0,0,1,1,1,2,2,2,2,3,3,3,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,
0,0,0,1,1,1,2,2,2,3,3,3,4,4,4,4,5,5,5,6,6,6,7,7,7,7,8,8,8,9,9,9,9,10,10,10,10,10,11,11,11,11,11,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,
0,0,0,1,1,1,2,2,3,3,3,4,4,4,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,11,11,11,12,12,12,12,12,13,13,13,13,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,
0,0,0,1,1,2,2,3,3,3,4,4,5,5,6,6,6,7,7,8,8,8,9,9,9,10,10,10,11,11,11,12,12,12,13,13,13,14,14,14,14,15,15,15,15,15,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,
0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,8,9,9,10,10,11,11,11,12,12,12,13,13,14,14,14,15,15,15,15,16,16,16,17,17,17,17,17,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,19,
0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,14,14,15,15,15,16,16,16,17,17,17,18,18,18,18,19,19,19,19,20,20,20,20,20,21,21,21,21,21,21,21,21,21,21,21,
0,0,1,1,2,2,3,4,4,5,5,6,6,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,16,16,17,17,18,18,18,19,19,19,20,20,20,21,21,21,21,21,22,22,22,22,22,23,23,23,23,23,23,23,23,23,23,
0,0,1,1,2,3,3,4,5,5,6,6,7,8,8,9,9,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,19,20,20,21,21,21,22,22,22,23,23,23,23,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,
0,0,1,2,2,3,4,4,5,6,6,7,8,8,9,9,10,11,11,12,13,13,14,14,15,15,16,17,17,18,18,19,19,20,20,21,21,21,22,22,23,23,23,24,24,24,25,25,25,25,26,26,26,26,26,27,27,27,27,27,27,27,27,27,
0,0,1,2,2,3,4,5,5,6,7,7,8,9,10,10,11,12,12,13,14,14,15,15,16,17,17,18,18,19,19,20,21,21,22,22,23,23,23,24,24,25,25,25,26,26,26,27,27,27,28,28,28,28,28,29,29,29,29,29,29,29,29,29,
0,0,1,2,3,3,4,5,6,6,7,8,9,9,10,11,12,12,13,14,14,15,16,16,17,18,18,19,20,20,21,21,22,22,23,24,24,25,25,25,26,26,27,27,28,28,28,29,29,29,29,30,30,30,30,30,31,31,31,31,31,31,31,31,
0,0,1,2,3,4,4,5,6,7,8,8,9,10,11,12,12,13,14,15,15,16,17,18,18,19,20,20,21,22,22,23,23,24,24,25,26,26,27,27,28,28,28,29,29,30,30,30,31,31,31,32,32,32,32,32,33,33,33,33,33,33,33,33,
0,0,1,2,3,4,5,6,6,7,8,9,10,11,12,12,13,14,15,16,16,17,18,19,19,20,21,21,22,23,23,24,25,25,26,27,27,28,28,29,29,30,30,31,31,31,32,32,32,33,33,33,34,34,34,34,35,35,35,35,35,35,35,35,
0,0,1,2,3,4,5,6,7,8,9,10,10,11,12,13,14,15,16,16,17,18,19,20,20,21,22,23,23,24,25,25,26,27,27,28,29,29,30,30,31,31,32,32,33,33,34,34,34,35,35,35,36,36,36,36,36,37,37,37,37,37,37,37,
0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,16,17,18,19,20,21,22,22,23,24,25,25,26,27,28,28,29,30,30,31,31,32,32,33,34,34,35,35,35,36,36,37,37,37,37,38,38,38,38,39,39,39,39,39,39,39,
0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,14,15,16,17,18,19,20,21,22,23,23,24,25,26,27,27,28,29,30,30,31,32,32,33,34,34,35,35,36,36,37,37,38,38,38,39,39,39,40,40,40,40,41,41,41,41,41,41,41,
0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,26,27,28,29,30,30,31,32,33,33,34,35,35,36,36,37,37,38,38,39,39,40,40,41,41,41,42,42,42,42,43,43,43,43,43,43,43,
0,1,2,3,4,5,6,7,8,9,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,28,29,30,31,32,33,33,34,35,35,36,37,37,38,39,39,40,40,41,41,42,42,42,43,43,43,44,44,44,44,45,45,45,45,45,45,
0,1,2,3,4,5,6,8,9,10,11,12,13,14,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,31,32,33,34,35,36,36,37,38,38,39,40,40,41,42,42,43,43,43,44,44,45,45,45,46,46,46,46,47,47,47,47,47,47,
0,1,2,3,4,6,7,8,9,10,12,13,14,15,16,17,18,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,35,36,37,38,39,39,40,41,41,42,43,43,44,44,45,45,46,46,47,47,47,48,48,48,48,49,49,49,49,49,49,
0,1,2,3,5,6,7,8,10,11,12,13,14,16,17,18,19,20,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,39,40,41,42,42,43,44,44,45,46,46,47,47,48,48,48,49,49,50,50,50,50,51,51,51,51,51,51,
0,1,2,3,5,6,7,9,10,11,13,14,15,16,18,19,20,21,22,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,43,44,45,45,46,47,47,48,48,49,49,50,50,51,51,51,52,52,52,52,53,53,53,53,53,
0,1,2,4,5,6,8,9,10,12,13,14,16,17,18,19,21,22,23,24,26,27,28,29,30,31,33,34,35,36,37,38,39,40,41,42,42,43,44,45,46,46,47,48,49,49,50,50,51,51,52,52,53,53,53,54,54,54,54,55,55,55,55,55,
0,1,2,4,5,7,8,9,11,12,13,15,16,18,19,20,22,23,24,25,27,28,29,30,31,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,47,48,49,50,50,51,52,52,53,53,54,54,55,55,55,56,56,56,56,57,57,57,57,57,
0,1,2,4,5,7,8,10,11,13,14,15,17,18,20,21,22,24,25,26,28,29,30,31,33,34,35,36,37,38,39,41,42,43,44,45,46,46,47,48,49,50,51,51,52,53,53,54,54,55,56,56,56,57,57,58,58,58,58,59,59,59,59,59,
0,1,3,4,6,7,9,10,12,13,14,16,17,19,20,22,23,24,26,27,28,30,31,32,34,35,36,37,39,40,41,42,43,44,45,46,47,48,49,50,51,51,52,53,54,54,55,56,56,57,57,58,58,59,59,60,60,60,60,61,61,61,61,61,
0,1,3,4,6,7,9,10,12,13,15,16,18,19,21,22,24,25,27,28,29,31,32,33,35,36,37,39,40,41,42,43,44,45,47,48,49,50,51,51,52,53,54,55,56,56,57,58,58,59,59,60,60,61,61,61,62,62,62,63,63,63,63,63,
0,1,3,4,6,8,9,11,12,14,15,17,19,20,22,23,25,26,27,29,30,32,33,35,36,37,39,40,41,42,43,45,46,47,48,49,50,51,52,53,54,55,56,56,57,58,59,59,60,61,61,62,62,63,63,63,64,64,64,64,65,65,65,65,
0,1,3,4,6,8,9,11,13,14,16,17,19,21,22,24,25,27,28,30,31,33,34,36,37,38,40,41,42,44,45,46,47,48,49,51,52,53,54,55,56,57,57,58,59,60,60,61,62,62,63,64,64,65,65,65,66,66,66,66,67,67,67,67,
0,1,3,5,6,8,10,11,13,15,16,18,20,21,23,24,26,28,29,31,32,34,35,37,38,39,41,42,44,45,46,47,49,50,51,52,53,54,55,56,57,58,59,60,61,62,62,63,64,64,65,65,66,66,67,67,68,68,68,68,69,69,69,69,
0,1,3,5,7,8,10,12,13,15,17,19,20,22,24,25,27,28,30,32,33,35,36,38,39,41,42,43,45,46,47,49,50,51,52,54,55,56,57,58,59,60,61,62,63,63,64,65,65,66,67,67,68,68,69,69,70,70,70,70,71,71,71,71,
0,1,3,5,7,8,10,12,14,16,17,19,21,23,24,26,28,29,31,33,34,36,37,39,40,42,43,45,46,47,49,50,51,53,54,55,56,57,58,60,61,62,62,63,64,65,66,67,67,68,69,69,70,70,71,71,72,72,72,72,73,73,73,73,
0,1,3,5,7,9,11,12,14,16,18,20,21,23,25,27,28,30,32,33,35,37,38,40,41,43,44,46,47,49,50,51,53,54,55,57,58,59,60,61,62,63,64,65,66,67,68,68,69,70,70,71,72,72,73,73,73,74,74,74,75,75,75,75,
0,1,3,5,7,9,11,13,15,16,18,20,22,24,26,27,29,31,33,34,36,38,39,41,42,44,46,47,49,50,51,53,54,56,57,58,59,61,62,63,64,65,66,67,68,69,69,70,71,72,72,73,74,74,75,75,75,76,76,76,77,77,77,77,
0,1,3,5,7,9,11,13,15,17,19,21,23,24,26,28,30,32,33,35,37,39,40,42,44,45,47,48,50,51,53,54,56,57,58,60,61,62,63,64,65,67,68,69,70,70,71,72,73,74,74,75,75,76,76,77,77,78,78,78,78,79,79,79,
0,1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,32,34,36,38,40,41,43,45,46,48,50,51,53,54,56,57,58,60,61,62,64,65,66,67,68,69,70,71,72,73,74,75,75,76,77,77,78,78,79,79,80,80,80,80,81,81,81,
0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,29,31,33,35,37,39,41,42,44,46,47,49,51,52,54,55,57,58,60,61,63,64,65,66,68,69,70,71,72,73,74,75,76,76,77,78,79,79,80,80,81,81,82,82,82,82,83,83,83,
0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,43,45,47,49,50,52,54,55,57,58,60,61,63,64,65,67,68,69,70,72,73,74,75,76,77,78,78,79,80,81,81,82,82,83,83,84,84,84,84,85,85,85,
0,2,4,6,8,10,12,14,17,19,21,23,25,27,29,31,33,35,37,39,41,43,44,46,48,50,52,53,55,57,58,60,61,63,64,66,67,68,70,71,72,73,74,75,77,77,78,79,80,81,82,82,83,84,84,85,85,86,86,86,86,87,87,87,
0,2,4,6,8,10,13,15,17,19,21,23,25,28,30,32,34,36,38,40,42,44,45,47,49,51,53,54,56,58,59,61,63,64,66,67,69,70,71,73,74,75,76,77,78,79,80,81,82,83,84,84,85,86,86,87,87,87,88,88,88,89,89,89,
0,2,4,6,8,11,13,15,17,19,22,24,26,28,30,32,34,36,39,41,43,44,46,48,50,52,54,56,57,59,61,62,64,66,67,69,70,71,73,74,75,77,78,79,80,81,82,83,84,85,85,86,87,87,88,89,89,89,90,90,90,91,91,91,
0,2,4,6,9,11,13,15,18,20,22,24,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,60,62,64,65,67,69,70,72,73,74,76,77,78,79,81,82,83,84,85,86,87,87,88,89,89,90,90,91,91,92,92,92,93,93,93,
0,2,4,7,9,11,13,16,18,20,23,25,27,29,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,63,65,67,68,70,72,73,75,76,77,79,80,81,82,84,85,86,87,87,88,89,90,91,91,92,92,93,93,94,94,94,94,95,95,
0,2,4,7,9,11,14,16,18,21,23,25,28,30,32,34,37,39,41,43,45,47,49,52,54,55,57,59,61,63,65,67,68,70,72,73,75,76,78,79,80,82,83,84,85,86,87,88,89,90,91,92,93,93,94,94,95,95,96,96,96,96,97,97,
0,2,4,7,9,12,14,16,19,21,24,26,28,31,33,35,37,40,42,44,46,48,51,53,55,57,59,61,62,64,66,68,70,71,73,75,76,78,79,81,82,83,85,86,87,88,89,90,91,92,93,94,94,95,96,96,97,97,98,98,98,98,99,99,
0,2,4,7,9,12,14,17,19,22,24,26,29,31,34,36,38,41,43,45,47,49,52,54,56,58,60,62,64,66,67,69,71,73,74,76,78,79,81,82,84,85,86,88,89,90,91,92,93,94,95,96,96,97,98,98,99,99,100,100,100,100,101,101,
0,2,5,7,10,12,15,17,20,22,25,27,29,32,34,37,39,41,44,46,48,50,53,55,57,59,61,63,65,67,69,71,72,74,76,78,79,81,82,84,85,87,88,89,91,92,93,94,95,96,97,97,98,99,100,100,101,101,102,102,102,102,103,103,
0,2,5,7,10,12,15,17,20,23,25,28,30,32,35,37,40,42,44,47,49,51,54,56,58,60,62,64,66,68,70,72,74,76,77,79,81,82,84,85,87,88,90,91,92,93,95,96,97,98,99,99,100,101,102,102,103,103,104,104,104,104,105,105,
0,2,5,7,10,13,15,18,20,23,26,28,31,33,36,38,41,43,45,48,50,52,55,57,59,61,63,65,67,69,71,73,75,77,79,81,82,84,86,87,89,90,91,93,94,95,96,97,98,99,100,101,102,103,103,104,105,105,105,106,106,106,107,107,
0,2,5,8,10,13,16,18,21,23,26,29,31,34,36,39,41,44,46,49,51,53,56,58,60,62,65,67,69,71,73,75,77,79,80,82,84,86,87,89,90,92,93,94,96,97,98,99,100,101,102,103,104,105,105,106,107,107,107,108,108,108,109,109,
0,2,5,8,10,13,16,18,21,24,27,29,32,34,37,39,42,45,47,49,52,54,57,59,61,63,66,68,70,72,74,76,78,80,82,84,85,87,89,90,92,93,95,96,98,99,100,101,102,103,104,105,106,107,107,108,108,109,109,110,110,110,110,111,
0,2,5,8,11,13,16,19,22,24,27,30,32,35,38,40,43,45,48,50,53,55,58,60,62,65,67,69,71,73,75,77,79,81,83,85,87,89,90,92,94,95,97,98,99,101,102,103,104,105,106,107,108,109,109,110,110,111,111,112,112,112,112,113,
0,2,5,8,11,14,16,19,22,25,27,30,33,36,38,41,44,46,49,51,54,56,59,61,63,66,68,70,73,75,77,79,81,83,85,87,88,90,92,94,95,97,98,100,101,102,104,105,106,107,108,109,110,110,111,112,112,113,113,114,114,114,114,115,
0,2,5,8,11,14,17,20,22,25,28,31,33,36,39,42,44,47,50,52,55,57,60,62,65,67,69,72,74,76,78,80,82,84,86,88,90,92,94,95,97,98,100,101,103,104,105,107,108,109,110,111,112,112,113,114,114,115,115,116,116,116,116,117,
0,2,5,8,11,14,17,20,23,26,28,31,34,37,40,42,45,48,50,53,56,58,61,63,66,68,70,73,75,77,79,82,84,86,88,90,92,93,95,97,98,100,102,103,105,106,107,108,109,111,112,113,113,114,115,116,116,117,117,118,118,118,118,119,
0,2,5,8,11,14,17,20,23,26,29,32,35,37,40,43,46,49,51,54,57,59,62,64,67,69,72,74,76,79,81,83,85,87,89,91,93,95,97,98,100,102,103,105,106,108,109,110,111,112,113,114,115,116,117,118,118,119,119,120,120,120,120,121,
0,3,6,9,12,15,18,21,24,26,29,32,35,38,41,44,47,49,52,55,57,60,63,65,68,70,73,75,78,80,82,84,86,89,91,93,95,96,98,100,102,103,105,107,108,109,111,112,113,114,115,116,117,118,119,120,120,121,121,122,122,122,122,122,
0,3,6,9,12,15,18,21,24,27,30,33,36,39,42,44,47,50,53,56,58,61,64,66,69,71,74,76,79,81,83,86,88,90,92,94,96,98,100,102,103,105,107,108,110,111,113,114,115,116,117,118,119,120,121,121,122,123,123,124,124,124,124,124,
0,3,6,9,12,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,59,62,65,67,70,73,75,78,80,82,85,87,89,91,94,96,98,100,102,103,105,107,108,110,112,113,114,116,117,118,119,120,121,122,123,123,124,125,125,126,126,126,126,126,
0,3,6,9,12,15,18,22,25,28,31,34,37,40,43,46,49,52,55,57,60,63,66,69,71,74,76,79,81,84,86,88,91,93,95,97,99,101,103,105,107,108,110,112,113,115,116,117,119,120,121,122,123,124,125,125,126,127,127,128,128,128,128,128,
0,3,6,9,12,16,19,22,25,28,31,34,38,41,44,47,50,53,55,58,61,64,67,70,72,75,78,80,83,85,87,90,92,94,97,99,101,103,105,107,108,110,112,113,115,116,118,119,120,122,123,124,125,126,127,127,128,129,129,129,130,130,130,130,
0,3,6,9,13,16,19,22,25,29,32,35,38,41,44,47,50,53,56,59,62,65,68,71,73,76,79,81,84,86,89,91,94,96,98,100,102,104,106,108,110,112,114,115,117,118,120,121,122,124,125,126,127,128,128,129,130,130,131,131,132,132,132,132,
0,3,6,9,13,16,19,23,26,29,32,35,39,42,45,48,51,54,57,60,63,66,69,72,74,77,80,83,85,88,90,93,95,97,99,102,104,106,108,110,112,114,115,117,119,120,121,123,124,125,127,128,129,130,130,131,132,132,133,133,134,134,134,134,
0,3,6,10,13,16,20,23,26,29,33,36,39,42,46,49,52,55,58,61,64,67,70,73,76,78,81,84,86,89,91,94,96,99,101,103,105,107,109,111,113,115,117,119,120,122,123,125,126,127,128,130,131,131,132,133,134,134,135,135,136,136,136,136,
0,3,6,10,13,17,20,23,27,30,33,37,40,43,46,49,53,56,59,62,65,68,71,74,77,79,82,85,88,90,93,95,98,100,102,105,107,109,111,113,115,117,119,120,122,124,125,126,128,129,130,131,132,133,134,135,136,136,137,137,138,138,138,138,
0,3,6,10,13,17,20,24,27,30,34,37,40,44,47,50,53,57,60,63,66,69,72,75,78,81,83,86,89,92,94,97,99,102,104,106,108,111,113,115,117,119,120,122,124,125,127,128,130,131,132,133,134,135,136,137,138,138,139,139,140,140,140,140,
0,3,7,10,14,17,20,24,27,31,34,38,41,44,48,51,54,57,61,64,67,70,73,76,79,82,85,87,90,93,95,98,101,103,105,108,110,112,114,116,118,120,122,124,126,127,129,130,131,133,134,135,136,137,138,139,140,140,141,141,142,142,142,142,
0,3,7,10,14,17,21,24,28,31,35,38,42,45,48,52,55,58,61,65,68,71,74,77,80,83,86,89,91,94,97,99,102,104,107,109,111,114,116,118,120,122,124,126,127,129,130,132,133,135,136,137,138,139,140,141,142,142,143,143,144,144,144,144,
0,3,7,10,14,17,21,25,28,32,35,39,42,46,49,52,56,59,62,66,69,72,75,78,81,84,87,90,93,95,98,101,103,106,108,111,113,115,117,120,122,124,125,127,129,131,132,134,135,137,138,139,140,141,142,143,144,144,145,145,146,146,146,146,
0,3,7,10,14,18,21,25,29,32,36,39,43,46,50,53,56,60,63,66,70,73,76,79,82,85,88,91,94,97,99,102,105,107,110,112,115,117,119,121,123,125,127,129,131,132,134,136,137,138,140,141,142,143,144,145,145,146,147,147,148,148,148,148,
0,3,7,11,14,18,22,25,29,33,36,40,43,47,50,54,57,61,64,67,71,74,77,80,83,86,89,92,95,98,101,103,106,109,111,114,116,118,121,123,125,127,129,131,133,134,136,137,139,140,141,143,144,145,146,147,147,148,149,149,150,150,150,150,
0,3,7,11,14,18,22,26,29,33,37,40,44,47,51,54,58,61,65,68,72,75,78,81,84,87,91,94,96,99,102,105,108,110,113,115,118,120,122,124,127,129,131,132,134,136,138,139,141,142,143,145,146,147,148,149,149,150,151,151,152,152,152,152,
0,3,7,11,15,18,22,26,30,33,37,41,44,48,52,55,59,62,66,69,72,76,79,82,85,89,92,95,98,101,103,106,109,112,114,117,119,122,124,126,128,130,132,134,136,138,139,141,142,144,145,146,148,149,150,151,151,152,153,153,154,154,154,154,
0,3,7,11,15,19,23,26,30,34,38,41,45,49,52,56,59,63,67,70,73,77,80,83,87,90,93,96,99,102,105,108,110,113,116,118,121,123,125,128,130,132,134,136,138,140,141,143,144,146,147,148,150,151,152,152,153,154,155,155,156,156,156,156,
0,3,7,11,15,19,23,27,30,34,38,42,46,49,53,57,60,64,67,71,74,78,81,84,88,91,94,97,100,103,106,109,112,114,117,120,122,125,127,129,131,134,136,138,140,141,143,145,146,148,149,150,151,152,153,154,155,156,157,157,157,158,158,158,
0,3,7,11,15,19,23,27,31,35,39,42,46,50,54,57,61,65,68,72,75,79,82,85,89,92,95,98,101,104,107,110,113,116,119,121,124,126,129,131,133,135,137,139,141,143,145,146,148,149,151,152,153,154,155,156,157,158,158,159,159,160,160,160,
0,3,7,11,15,19,23,27,31,35,39,43,47,51,54,58,62,65,69,73,76,80,83,87,90,93,96,100,103,106,109,112,115,117,120,123,125,128,130,133,135,137,139,141,143,145,147,148,150,151,153,154,155,156,157,158,159,160,160,161,161,162,162,162,
0,4,8,12,16,20,24,28,32,36,40,43,47,51,55,59,63,66,70,74,77,81,84,88,91,94,98,101,104,107,110,113,116,119,122,124,127,129,132,134,136,139,141,143,145,147,148,150,152,153,155,156,157,158,159,160,161,162,162,163,163,164,164,164,




};

const unsigned char rescale_s[128]={
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,5,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,9,9,9,9,10,10,11,11,11,12,12,13,13,14,14,15,15,16,16,17,18,18,19,20,20,21,22,23,23,24,25,26,27,28,29,30,31,32,33,35,36,37,38,40,41,43,44,46,48,49,51,53,55,57,59,61,63,65,68,70,73,75,78,81,83,
};

const unsigned char tile_s[128]={
0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+0,0x78+1,0x78+1,0x78+1,0x78+1,0x78+1,0x78+1,0x78+1,0x78+1,0x78+1,0x78+1,0x78+1,0x78+1,0x78+1,0x78+1,0x78+1,0x78+1,0x78+1,0x78+1,0x78+1,0x78+1,0x78+1,0x78+1,0x78+1,0x78+2,0x78+2,0x78+2,0x78+2,0x78+2,0x78+2,0x78+2,0x78+2,0x78+2,0x78+2,0x78+2,0x78+2,0x78+2,0x78+2,0x78+2,0x78+2,0x78+3,0x78+3,0x78+3,0x78+3,0x78+3,0x78+3,0x78+3,0x78+3,0x78+3,0x78+3,0x78+3,0x78+3,0x78+3,0x78+4,0x78+4,0x78+4,0x78+4,0x78+4,0x78+4,0x78+4,0x78+4,0x78+4,0x78+4,0x78+5,0x78+5,0x78+5,0x78+5,0x78+5,0x78+5,0x78+5,0x78+5,0x78+5,0x78+6,0x78+6,0x78+6,0x78+6,0x78+6,0x78+6,0x78+6,0x78+7,0x78+7,0x78+7,0x78+7,0x78+7,0x78+7,0x78+7,0x78+7,0x78+7,0x78+7,0x78+7,
};

const unsigned char pal_s[128]={
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
};

//const unsigned char persp_flash[16]={0,1,2,3,4,5,6,7,7,6,5,4,3,2,1,0};



#define MAX_PERSP		40


#pragma bssseg (push,"SHAREDRAM2")
#pragma dataseg(push,"SHAREDRAM2")

unsigned int year_frame[4];
unsigned int year_frame_dx[4];

unsigned char persp_a  [MAX_PERSP];
unsigned int  persp_z  [MAX_PERSP];
unsigned int  persp_zx [MAX_PERSP];
//unsigned char persp_cnt[MAX_PERSP];

unsigned int persp_rotate;
signed int persp_rotate_x;
unsigned char persp_rotate_dir;

unsigned char persp_add;

unsigned int year_scroll[6];
unsigned int year_scroll_dx[6];

#pragma dataseg(pop);
#pragma bssseg (pop);


	
void preset_persp(void)
{
	persp_zx [_i]=256+_i*8;
}
	
void set_persp(void)
{
	if(!persp_add)
	{
		persp_zx[_i]=0;
		return;
	}
	
	persp_a  [_i]=rand8()&0xf8;
	persp_z  [_i]=48*512;
}



void __fastcall__ sin_scaled(unsigned char a,unsigned char s);
/*
void __fastcall__ sin_scaled(unsigned char a,unsigned char s)
{
	_ssx=128-8;
	
	if(a<0x80)	//plus
	{
		if(a>=0x40) a=(a&0x3f)^0x3f;

		_ssx+=sincos[a+(unsigned int)s*64];
	}
	else	//minus
	{
		if(a>=0xc0) a=(a&0x3f)^0x3f; else a=a&0x3f;
		
		_ssx-=sincos[a+(unsigned int)s*64];
	}
	
	if(_ssx<8||_ssx>=240) _sx=255; else _sx=_ssx;
}
*/


void __fastcall__ cos_scaled(unsigned char a,unsigned char s);
/*
void __fastcall__ cos_scaled(unsigned char a,unsigned char s)
{
	_ssy=120-8;
	
	a-=0x40;
	
	if(a<0x80)	//plus
	{
		if(a>=0x40) a=(a&0x3f)^0x3f;

		_ssy+=sincos[a+(unsigned int)s*64];
	}
	else	//minus
	{
		if(a>=0xc0) a=(a&0x3f)^0x3f; else a=a&0x3f;

		_ssy-=sincos[a+(unsigned int)s*64];
	}
	
	if(_ssy<8||_ssy>=240) _sy=255; else _sy=_ssy;
}
*/


void persp_update(void);
/*	
void persp_update(void)
{
	unsigned char a,s,r,sz;

	r=persp_rotate>>8;
	
	for(_i=0;_i<MAX_PERSP;++_i)
	{
		sz=persp_z[_i]>>9;
		
		if(sz>=120)
		{
			set_persp();
			continue;
		}
		
		if(sz>=40)
		{
			_tile=tile_s[sz];//-(persp_flash[(persp_cnt[_i]>>2)&15]<<2);
			
			//if(_tile>=0x60)
			{
				a=(persp_a[_i]+r)&255;
				s=rescale_s[sz];
				
				sin_scaled(a,s);
				cos_scaled(a,s);

				if(_sx<255&&_sy<255)
				{
					_pal=pal_s[sz];
				
					if(_sy>=8*8&&_sy<20*8) _pal|=OAM_BEHIND;
					
					oam_spr(_sx,_sy,_tile+0,_pal,oam_off);
					
					oam_off+=4;
					
					// if(_tile>=0x70)
					// {
						// oam_spr(_sx+8,_sy,_tile+2,_pal,oam_off);
						// oam_off+=4;
					// }
					
					//if(oam_off==0xfc) break;
				}
			}
		}
		
		persp_z[_i]+=persp_zx[_i];
		
		//++persp_cnt[_i];
	}
}
*/


void e_year(void)
{
	unsigned char step,stars,rotate,flash;
	
	bank_bg(1);
	bank_spr(0);
	
	oam_clear_fast();
	oam_size(0);
	oam_update();

	_chr=CHR_SPRITES;
	
	mmc3_chr_bank(_chr+0,0);
	mmc3_chr_bank(_chr+2,1);
		
	_chr=CHR_NU_2;
	
	mmc3_chr_bank(_chr+0,2);
	mmc3_chr_bank(_chr+0,3);
	mmc3_chr_bank(_chr+0,4);
	mmc3_chr_bank(_chr+0,5);
	
	mmc3_set_mirroring(M_HORIZONTAL);
	
	memfill(pal_scr,0x0f,sizeof(pal_scr));
	memcpy (pal_req,year_palette_bg,sizeof(pal_req));
	
	pal_bg (pal_scr);
	pal_spr(year_palette_spr);

	vram_adr(NAMETABLE_A);
	vram_unrle(year_nam);

	scroll(0,0);
	
	memfill(update_list,0,sizeof(update_list));

	for(_i=0;_i<4;++_i)
	{
		year_frame[_i]=0;
		year_frame_dx[_i]=256+_i*128;
	}
	
	for(_i=0;_i<3;++_i)
	{
		year_scroll   [_i+0]=0;
		year_scroll_dx[_i+0]=256+(2-_i)*128;
		year_scroll   [_i+3]=0;
		year_scroll_dx[_i+3]=-(256+_i*128);
	}
	
	persp_rotate=0;
	persp_rotate_x=0;
	persp_rotate_dir=0;
	persp_add=TRUE;
	
	for(_i=0;_i<MAX_PERSP;++_i)
	{
		preset_persp();
		set_persp();
	}
	
	step=0;
	stars=FALSE;
	rotate=FALSE;
	flash=0;
	
	_frame=0;
	_bright=4;
	_done=0;
	
	set_irq_handler(IRQ_YEAR);
	set_nmi_handler(NMI_YEAR);		
	mmc3_irq_enable(7);
	
	pal_bright(_bright);
	ppu_on_all();
	
	ft_prev_frame=ft_current_frame;
	ft_prev_row=ft_current_row;
	
	while(!_done||_bright)
	{
		if(ft_prev_row!=ft_current_row)
		{
			ft_prev_row=ft_current_row;
			
			if(!(ft_prev_row&1))
			{
				++step;
				
				if(step<sizeof(year_pal_sequence))
				{
					memcpy(pal_req,&year_palette_bg[year_pal_sequence[step]*16],sizeof(pal_req));	
				}
					
				if(step<9*4)
				{
					if((step&7)==4)
					{
						for(_i=0;_i<4;++_i)
						{
							year_frame[_i]=0;
							year_frame_dx[_i]=512;
						}
					}
				}
				
				if(step==68) stars=TRUE;
				
				if(step==64+16) rotate=TRUE;
				
				if(step==64+32)
				{
					for(_i=0;_i<4;++_i)
					{
						year_frame_dx[_i]=512+(_i^2)*64;
					}
				}
				
				if(step==64||step==96) flash=1;
				
				if(step==128-14)
				{
					rotate=FALSE;
					persp_add=FALSE;
				}
				
				if(step==124) _done=TRUE;
			}
		}
		
		if((_frame&7)==3)
		{
			if(stars) for(_i=0;_i<4;++_i) pal_col(0x13+_i*4,(rand8()&0x0f)|0x20);
		}
		
		for(_i=0;_i<4;++_i)
		{
			_chr=(!(_i&1)?CHR_NU_2:CHR_NU_0)+year_sine[(year_frame[_i]>>8)&63];
			
			mmc3_chr_bank(_chr,2+_i);
			
			year_frame[_i]+=year_frame_dx[_i];
		}
	
		oam_off=0;
	
		if(stars) persp_update();
	
		if(oam_off) oam_hide_rest(oam_off); else oam_clear_fast();

		oam_update();
	
		if(_done)
		{
			if(!(_frame&7))
			{
				if(_bright>0)
				{
					--_bright;
					pal_bright(_bright);
				}
			}
		}
		
		if(!(_frame&3)&&flash)
		{
			if(flash==1)
			{
				++_bright;
				
				if(_bright==8) flash=2;
			}
			else
			{
				--_bright;
				
				if(_bright==4) flash=0;
			}
			
			pal_bright(_bright);
		}
		
		if((_frame&7)==3)
		{
			if(_bright<=4) morph_palette();
		}
		
		pal_bg(pal_scr);
		
		ppu_wait_nmi();

		persp_rotate+=persp_rotate_x;
			
		if(!persp_rotate_dir)
		{
			persp_rotate_x+=ROTATE_DELTA;
			
			if(!rotate&&persp_rotate_x>0) persp_rotate_x=0;
			
			if(persp_rotate_x<=-ROTATE_MAX) persp_rotate_dir^=1;
		}
		else
		{
			persp_rotate_x-=ROTATE_DELTA;
			
			if(!rotate&&persp_rotate_x<0) persp_rotate_x=0;
			
			if(persp_rotate_x<=-ROTATE_MAX) persp_rotate_dir^=1;
		}
		
		for(_i=0;_i<6;++_i) year_scroll[_i]+=year_scroll_dx[_i];
	
		++_frame;
	}
	
	ppu_off();
}