;                       /|
;                      //|.
;                     //_| .
;                 __ // /| .
;                /_ \/\__|. 
;                \\_/  _/|_
;                .g.e.n.d.a.
;
;______________________________________________________
;
;
;         Tunguska (256b intro/procedural gfx)
;
;______________________________________________________
;
;	CODE:	        svoy
;	GFX:		piesiu
;______________________________________________________
;
;         Demodulation 2020
;         Atari XL/XE intro (256b, compo filler)
;______________________________________________________
; tomaswoj@gmail.com
; http://pl.linkedin.com/in/tomaswoj
; Cracow

STARTX	equ $80 ; tree pos X
STARTY	equ $81 ; tree pos Y
WIDTH	equ $82 ; base width of the tree (main trunk)
RWIDTH	equ $83 ; current width of the tree, with edge 
HEIGHT	equ $84
;TRCNT	equ $85
TREDAT	equ $87


; OS addresses:
VCOUNT	equ $D40B
WSYNC	equ $D40a

ROWCRS	equ $54		;Row of cursor, 1 byte
COLCRS	equ $55		;Column of cursor, 2 bytes

OLDROW  equ $5A
OLDCOL  equ $5B     ; 2 bytes
FILFLG 	equ $2B7
FILDAT 	equ $2fD

VVBLKD  equ $0224
XITVBV  equ $e462

; Aliases, because orig reg names are hard to remember ;)
PCOLOR	    equ $2fb	;Color for graphics operations
cursor_y    equ ROWCRS
cursor_x    equ COLCRS
prev_y      equ OLDROW
prev_x      equ OLDCOL

; OS functions
drawto    equ $f9c2

	opt h+	
	
	org $a0
comet	dta b(128,40,21,2,9,4,0); by Piesiu
comet2	dta b(160,120,182,251,127,63,14); by Piesiu
coldat	dta b($1d,$1f,$60,$68, $26, $0, $13); note - last color val is also used and changed by tree renderer (TRECNT)
;TRCNT	dta b(19) ; initial tree count - used last value in coldat table

treepx	dta b(20,40,65,90,110,150, 10,35,54,80,120,140,   15,30,48,70,145,110,130); start (horizontal)
treepy	dta b(96,105,95,90,96,95,   80,65,72,75,70,80,	    40,52,45,50,45,50, 55,57); start (vertical)
	; treepy,0=>96/$60 is used as PMBASE, so it has to be left like it is now

render:
	sta cursor_x
	lda $D20a
cmprender:	
	cmp #32
	bcc skiprender
	jsr drawto
skiprender:
	lda STARTY
	rts

; program entry point
start:
	; create/setup mode f, using OS routines, and we are going to mess with it later (multimode, move to a different place in memory)
	lda #15	
	jsr $EF9C
			
	; looks like y=1 (from gfx mode jsr)
	; generate nice looking sky gradient, from darker-brown/pink to light-yellow (on the horizon), also with limited bands versus simple regular gradient of single color	
skygen:
	tya
	lsr
	lsr
	lsr
	tax
	cpy $D20a
	bcc usepink
	ora #%00010000 ; brown part of the pallete
	adc #1	
	bne donebrown
usepink:	
	ora #%00100000 ; pinkish
donebrown:		
	sta $5000,y ; this will be used in main frame loop below
; above loop:
	; populate tree colors and edges, store on ZP
	txa
	lsr
	tax
	lda #%00000110
	sta TREDAT-2,x
	lsr
	sta TREDAT+6-2,x
	lsr
	sta TREDAT+12,x
	; populate comet PMG and colors
	lda coldat,x
	sta $2c0,x ; colors setup
	sta $D000-2,x ; comet position left/right
	lda comet-1,x
	sta $6000+512+20-1,x
	lda comet2-1,x
	sta $6000+512+128+20+3-1,x
	; comet pmg, ok, assuming PMG gets enabled down there...
	;lda coldat+2-6,x	
	;sta $D000-6,x ; meteor position left/right		
	iny
	bpl skygen
			
 		
treeloop:		
	;ldx TRCNT 
	ldx coldat+6; (re-use the color here... for initial tree count=20) 
	; packed version			
	lda tredat,x
	sta PCOLOR
	;lda treepx,x
	;sta STARTX ; treetop X position ; swapped with SMC below
	lda treepy,x ; treetop Y position
	sta STARTY
	sta $D407; PMBASE at 96 (STARTY of the last tree conveniently set to 96/$60, to be used as PMBASE)	
	lda #0
	sta WIDTH
	sta HEIGHT
drawtree:
	inc STARTY
	lda STARTY	
	sta prev_y
	sta cursor_y
	lda HEIGHT
	;and TREDGE ; edges pattern
	and PCOLOR ; PCOLOR serves as a TREDGE (how zigzagy are the trees)
	adc width
	sta RWIDTH
fetchxpos:	
	;lda STARTX
	;lda treepy-1
	lda treepy
	pha		
	adc #1
	sta prev_x
	sbc RWIDTH
	; i: - sta cursor_x	
	jsr render ; render left part of the tree line 
	; o: lda starty 
	sta cursor_y
	;sta prev_y ; not needed?					
	;lda STARTX
	pla	
	sbc #1
	sta prev_x	
	adc RWIDTH
	; i: sta cursor_x
	jsr render ; render right part of the tree line
	; o: lda starty
	and #%00000111 ; every 8th pixel increase trunk (or not)
	bne skipwidth
	adc WIDTH ; increase width with CLC
	sta WIDTH	
	;inc WIDTH ; simpler 
skipwidth:	
	inc HEIGHT
	bpl drawtree	
	dec fetchxpos+1 ; iterate down through startX tables
	dec cmprender+1 ; to change the randomization level for tree, as we go...
	dec coldat+6 ; tree count
	bpl treeloop
	
	lda #%101010 ; double line, no missle DMA
	; default
	;    100010
	;sta $D400; DMACTL - DEC 46 - double line, normal playfield
	sta $22f
	sta $D01D ; GRACTL, players only is OK
		
frame:
	lda VCOUNT ; X=0 used in several effects reached by jsr
	bne frame
	;ldy #0
skyloop:	
	lda $5000-20,y
	sta WSYNC ; 3b
	sta $D01a ; 3b	
	iny 
	bne skyloop
	beq frame ; wait for new frame
		
	run start

	end	
		
	