; pasmo -d -1 -v --tap --name md16k169 md16k169.asm md16k169.tap md16k169.symbol
; quick compile in kate:
; pasmo -d --tap --name %n %f %n.tap %n.symbol
; pasmo -d %f %n.bin %n.symbol
; -----------------------------;--------------------------------

; based on "The BorderTron 3000" Chris Cowley
; Please use this code freely.
; used by Chris Born for 16kb ZX Spectrum timings in
; Full Contended Cycle periodes
; which are also known as "machine cycles"

; On first issues 16k zx spectrum and actualy all lower memory on a ZX Spectrum,
; RAM executed opcodes are fully contended, delayed, when executes while ULA is active building the screen
; ROM is not but all other are since they reach between 0x4000 and 0x7fff.
; This gives a slower execution, which needs a different way off counting for eg borderlines and black/white&bright pictures
; In fact in 16k memory you will have to count in M-cycle off 8 t-state each very often during screen time.

;  halt = wait for first entry tv-raster and set cycle to zero
; cycle = 14335 tstate from halt/start of screen V and H sync= 16/48k zx screen
;   l3b = last 3 bits
; compl = complement of l3b
;   dec = decimal
; delay = by ULA implemented delay is Contended Delay
;  ogev = omgekeerd evenredig=Inversely proportional
;     c = almost constante
;     n = complemented 3 bit cycle number (NAND %00000000.00000111) nand= NOT AND
;     t = tstate
; 1 t duration equals 1 n duration
; Z80 cycle count of 8 goes up while ULA delay count of 6 goes down

; cycle   binary               l3b    compl  delay ogev delay-to-3bitcount 
; 14335 = 11 0111 1111 1111  111(7) = 000(0)  6t   0n-6t=-6 > 8n-6t= 2 ,8is4bit 1000 so borrow '1'
; 14336 = 11 1000 0000 0000  000(0) = 111(7)  5t   7n-5t= 2
; 14337 = 11 1000 0000 0001  001(1) = 110(6)  4t   6n-4t= 2
;ulabus writing aka 'screenvalue', if not attached (?fysic adres above 0x3fff 32767?)
; 14338 = 11 1000 0000 0010  010(2) = 101(5)  3t   5n-3t= 2
; 14339 = 11 1000 0000 0011  011(3) = 100(4)  2t   4n-2t= 2
; 14340 = 11 1000 0000 0100  100(4) = 011(3)  1t   3n-1t= 2
; 14341 = 11 1000 0000 0101  101(5) = 010(2)  0t   2n-0t= 2
;ulabus idle aka 255 or 0 or 191?
; 14342 = 11 1000 0000 0110  110(6) = 001(1)  0t   1n-0t= 1   almost constante = c= 2
; === next ula cycle
; 14343 = 11 1000 0000 0111  111 = 000 0-2= 6
; 14344 = 11 1000 0000 1000
; 14345 = 11 1000 0000 1001 >3bit> 001 >complement> 110 >n-c=t> 6n-2= 4t delay 
;ulabus writing

;as formula(?)
;set Z80-cycle number, fetch LSB 3 bits, complement them, substract 2 and that gives the delay,
; >>  except for n=0(first make it 4bit by ADD 8) and n=1(delay=0 anyway)

; 1 scanline takes 224 tstate on 16k and 48k zx
; 224/8=28 exact, so every display scanline starts an 8fold time periode later
; and thus every display scanline starts with a delay of 6t by ULA
;14335+  0=14335  11011111111111 > 111 = 000 0-2= 6
;14335+224=14559  11100011011111
;14559+224=14783  11100110111111
;14783+224=15007  11101010011111  

;https://faqwiki.zxnet.co.uk/wiki/Contended_memory#16K_and_48K
; moments of ULA Delay are:
; using RAM from $4000 up to $7FFF
; using a port with even number/ last bit=0

;    High byte   |         | 
;    in 40 - 7F? | Low bit | Contention pattern  
;    ------------+---------+-------------------
;         No     |  Reset  | N:1, C:3
;         No     |   Set   | N:4
;        Yes     |  Reset  | C:1, C:3
;        Yes     |   Set   | C:1, C:1, C:1, C:1
;
;The 'Contention pattern' column should be interpreted from left to right. An
; "N:n" entry means that no delay is applied at this cycle, and the Z80 continues
; uninterrupted for 'n' T states. A "C:n" entry means that the ULA halts the Z80
; the delay is exactly the same as would occur for a contended memory access at
; this cycle (eg 6 T states at cycle 14335, 5 at 14336, etc on the 48K machine).
; After this delay, the Z80 then continues for 'n' cycles.


setchan          equ 0x1601           ; ROM openchannel routine
attr             equ 0x5800           ; 22528, start screen attribute field
prbuf            equ 0x5b00           ; 23296, printer buffer on zx 16 and 48 only
kstate           equ 0x5c00           ; 23552, first of 8 (temp) system key storage
seed             equ 0x5c76           ; 23670, RaNDomise system value use as temp

                 org 0x6590           ; 26000

Start:            exx
                  push hl
                  call  SetupIntHandler

BorderLoop:
                  halt                ;  0t wait for start of frame, cycle=0t,actualy last code of the frame, before waiting at interrupt
; In IM 2, it takes 19 cycles to get to the interrupt routine, which is 14t by it self, ei=4 ret=10.
t1 equ 0+19+4+10  ;tcycle=33
A_tc1 equ 33

; time counter
A_halt            ld a,128            ;  7t        background colour
                  out (254),a         ; 11t[4,3,4] contended
                  ld hl,23672         ; 10t 
                  inc (hl)            ; 11t        256*1/50 sec max
                  jr nz,nsec          ; 12t 7+11+10+11+12=52
t2a  equ 7 +11 +10 +11 +12
                                      ; -5t
                  inc hl              ;  6t
                  inc (hl)            ; 11t
                  jr nz,nmin          ; 12t -5+6+11+12=24
t2b  equ 6 +11 +12 -5
t2zx  equ  -5  +6 +11 +12   ; pasmo BUGGED RESULT ! the '-' sign is added AS LAST SUM INFLUENCE by which a false negative number is created !!
                                      ; -5t
                  inc hl              ;  6t
                  inc (hl)            ; 11t if 255 aswel, several day's are done!
                  jr tdone            ; 12t -5+6+11+12=24
t2c  equ 6 +11 +12 -5

nsec              jr $+2  ;12t
                  jr $+2  ;12t=24
t2b2  equ 12+12
nmin              jr $+2  ;12t
                  jr $+2  ;12t=24
tdone:

t2c2  equ 12+12
t2 equ t2a + t2b + t2c  ;  =99t in 26 bytes
A_tc2  equ A_tc1 + t2

                  ld b,5              ; 7t
hre               djnz hre            ; 7+ 5*13-5 =67
                  scf                 ; 4t
                  inc bc              ; 6t
                  ret nc              ; 5t =15

t3 equ 7+(5*13)-5 +7+7
A_tc3 equ A_tc2+t3
;                  ld d,128            ; 7t  sound bite influencer

                  ld bc,0x260e        ; 10t  b=38, c=14
;tc=212+10
a13               nop                 ;  4t delay !!

;                  ld a,128+64         ;  7t %11000000 ,high adres, bit 6 set, black
;                  rrc d               ;  8t
;                  jp nc,nosou         ; 10t
;                  out (254),a         ;}11t[4,3,4] contended
;                  jp sosou            ;}10t (}21t)
;nosou             ld e,0              ;|7tt
;                  nop                 ;|4tt
;                  jp sosou            ;|10t (|21t)
;sosou:

                  nop                 ;  4t delay !!
                  ld a,14             ;  7t a=14
noa               dec a               ;  4t
                  jp nz,noa           ; 10t
                  djnz a13            ; 13t 4+4+7+14*(4+10)+13 = 224 per loop
                                      ; -5t
; 10+ 38*(7+4+4+14*(4+10)+13) -5= 8517
t4 equ 10+ 38*(7+4+4+14*(4+10)+13) -5
A_tc4 equ A_tc3 + t4

                  ld b,7              ; 7t
here              djnz here           ; 7+(7*13)-5 =236
;                  nop                 ; 4t
;                  nop                 ; 4t
;                  nop                 ; 4t
t5 equ 7+(7*13)-5
A_tc5 equ A_tc4+t5

twist             ld a,(twice)        ; 13t
                  xor 1               ;  7t
                  ld (twice),a        ; 13t
                  jp z,oldc           ; 10t

                  ld bc,$86FE         ;|10t(4,3,3)  b=yellow  c=prt254
                  ld hl,$8782         ;|10t   h=white   l= red
                  ld de,$8684         ;|10t   d=yellow     e= green
                  jp coldo            ;|10t

oldc              ld bc,$82FE         ;}10t(4,3,3)  b=red  c=prt254
                  ld hl,$8581         ;}10t   h=light blue l= darkblue
                  ld de,$8684         ;}10t   d=yellow     e= green
                  jp coldo            ;}10t
coldo:
                  ld a,$80            ; 7t   a=black

t6 equ 13+7+13+10 +10+10+10+10 +4+4+4 +7
A_tc6 equ A_tc5 +t6
;tm=8901+10+10+10+7=8938    ;39 scanline+ 202 tstate ; !! 40x224=8960 !!!
                  ; ScanLine 40
REPT 18
	          out (c),l           ; 12t(4,4,4)  ; blue line
ENDM
	          nop
	          nop                 ; 4t   = (18*12)+4+4=216+8=224

                  ; ScanLine 41
                  out   (c),a         ; black HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),b  ; red
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h  ; lightblue
                  out   (c),h
                  out   (c),h
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 42
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 43
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 44
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 45
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),e
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 46
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),e
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),d  ;yellow  ;yellow
                  out   (c),h
                  out   (c),d  ;yellow  ;yellow
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 47
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),d  ;yellow
                  out   (c),h
                  out   (c),d  ;yellow
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 48
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),a
                  out   (c),h
                  out   (c),a
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 49
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 50
                  out   (c),d  ;yellow   HIDDEN - Background
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),d  ;yellow
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 51
                  out   (c),d  ;yellow  HIDDEN - Background
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),d  ;yellow
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 52
                  out   (c),d  ;yellow  HIDDEN - Background
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),d  ;yellow
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 53
                  out   (c),d  ;yellow  HIDDEN - Background
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),d  ;yellow
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 54
                  out   (c),d  ;yellow  HIDDEN - Background
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),d  ;yellow
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 55
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 56
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 57
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 58
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 59
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 60
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),a
                  out   (c),h
                  out   (c),a
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 61
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 62
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 63
REPT 17
	          out (c),l    ; blue
ENDM
                  out (c),a    ; black    
                  exx          ; 4t
                  scf          ; 4t  line complete !! Carry set for FURTHER DELAY !!!!
t7 equ 24 * 224
A_tc7 equ A_tc6 + t7


A_time            ld hl,$c880         ; 10t [4,3,3]   h=lines+8  l=128+0  tc=14301 to 14303
borlin1 equ $-1
                  ret nc       ; 5t carry is set
                  ret nc       ; 5t
                  nop          ; 4t
                  nop          ; 4t
                  nop          ; 4t

t8 equ 10+5+5+4+4+4
A_tc8 equ A_tc7 + t8

;Fully Contended Area, ScanLine 64
;ttt===14337 ? CONTENDED for 128 tstate
                                      ; manual copying Tstate from FUSE 1.5.7
lab               nop                 ;  8t
                  nop                 ;  8t
                  nop                 ;  8t
                  nop                 ;  8t HELLO THERE
                  nop                 ;  8t ANY BODY OUT THERE ??? 192 times 104 T-state in 12 M-cycle max
                  nop                 ;  8t
                  nop                 ;  8t
                  nop                 ;  8t
                  nop                 ;  8t
                  nop                 ;  8t
                  nop                 ;  8t

                  ld    a,h           ;  8t   8+8+8+8+8+8+8+8+8+8+8+8+8 =112
                  or    l             ;  8t make high adres , NZ-flag set  14*8=120

                  and   %10000111     ; 15t switch off bit 6,5,4,3 beeper ticks/ear/mic
                                      ; t=135

; Not contended for a while
                  nop                 ;  8t

                  ret z               ;  5t DELAY BY NZ
                  ret z               ;  5t DELAY BY NZ
                  ret z               ;  5t DELAY BY NZ   11 +5 +5 +5  +127 =153
A_ou              out   (254),a       ; 11t colour, around border

                  dec   a             ;  4t decrease colour ahead of counter h
                  and   %00000111     ;  7t switch off bit 6, beeper ticks/ear/mic
                  or    %10000000     ;  7t NZ-flag 
                  out   (254),a       ; 11t colour
                  ld    a,l           ;  4t
                  out   (254),a       ; 11t black   4+7+7+11+4+11  +153=197
                  dec h               ;  4t
                  ld a,8              ;  7t last line+8
borlin2 equ $-1
                  cp h                ;  4t compare a high or low Areg
                  jr nz,lab           ; 12t (*192)  4+7+4+12 +197 =224
                                      ; -5t no jump
;192*224=43,008 tstate

                  ; ScanLine 64+192=256
noncontended      exx                 ; 4t  fetch color scheme again
                  ld a,128            ; 7t
                  scf                 ; 4t

                  ret nc              ; 5t
                  ret nc              ; 5t

;                  out   (c),a
;                  out   (c),a
;                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),l
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop                  

                  ; ScanLine 257
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),l
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop                  

; ScanLines 258-267
REPT 3
REPT 18
	out (c),a
ENDM
	nop
	nop
ENDM
                  ; ScanLine 268
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 269
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 270
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 271
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),d  ;yellow  ;yellow
                  out   (c),d  ;yellow  ;yellow
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 272
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),d  ;yellow  ;yellow
                  out   (c),d  ;yellow
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 273
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),d  ;yellow
                  out   (c),d  ;yellow
                  out   (c),d  ;yellow
                  out   (c),d  ;yellow
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 274
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),d  ;yellow
                  out   (c),e
                  out   (c),e
                  out   (c),d  ;yellow
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 275
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),d  ;yellow
                  out   (c),d  ;yellow
                  out   (c),e
                  out   (c),e
                  out   (c),d  ;yellow
                  out   (c),d  ;yellow
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 276
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),d  ;yellow
                  out   (c),d  ;yellow
                  out   (c),e
                  out   (c),e
                  out   (c),e
                  out   (c),e
                  out   (c),d  ;yellow
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 277
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),d  ;yellow
                  out   (c),d  ;yellow
                  out   (c),e
                  out   (c),h
                  out   (c),h
                  out   (c),e
                  out   (c),d  ;yellow
                  out   (c),d  ;yellow
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 278
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),d  ;yellow
                  out   (c),e
                  out   (c),e
                  out   (c),h
                  out   (c),h
                  out   (c),e
                  out   (c),d  ;yellow
                  out   (c),d  ;yellow
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 279
                  out   (c),a
                  out   (c),b
                  out   (c),d  ;yellow
                  out   (c),e
                  out   (c),e
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),e
                  out   (c),d  ;yellow
                  out   (c),d  ;yellow
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 280
                  out   (c),b
                  out   (c),b
                  out   (c),d  ;yellow
                  out   (c),e
                  out   (c),e
                  out   (c),h
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),e
                  out   (c),e
                  out   (c),d  ;yellow
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 281
                  out   (c),b
                  out   (c),b
                  out   (c),d  ;yellow
                  out   (c),e
                  out   (c),h
                  out   (c),h
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),e
                  out   (c),e
                  out   (c),d  ;yellow
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop
; ScanLine 282 =224*282= 63168 T-state, should be

xee               exx                 ; 4t
                  ld a,(23672)        ;13t
                  and %00011111       ; 4t

                  jr nz,nra2          ;12t jump 31 out of 32
                  ;jr nra2

brl1              ld hl,borlin1       ;10t shift border rainbow
                  dec (hl)            ; 7t
                  ld a,(hl)           ; 7t
                  cp 192              ; 7t
                  jr nz,nra            ;12t
                  ld (hl),192+8       ; 7t
nra:
brl2              ld hl,borlin2       ;10t
                  dec (hl)            ; 7t
                  ld a,(hl)           ; 7t
                  and a               ; 4t cp 0                ; 7t
                  jr nz,nra2          ;12t
                  ld (hl),0+8         ; 7t

nra2              exx                 ; 4t colour settings again

                  ld a,128            ; 7t
                  in    a,($FE)       ;11t port $80fe
                  and   $1F           ; 7t check ANY key touch with bin 11111
                  cp    $1F           ; 7t
                  jp    z,BorderLoop  ;10t keep looping without system!

;big key check here
                  ld hl,keys+7        ;10t
                  ld de,keys2+7       ;10t to old key
                  ld bc,8             ;10t
                  lddr                ; 8*21-5 t=163t
                  inc hl              ; 6t 
                  ld bc,0xfefe        ;10t
ky                in a,(c)            ;12t 8 x contended 
                  ld (hl),a           ; 7t
                  inc hl              ; 6t
                  rlc b               ; 8t
                  jp c,ky             ;10t
                                      ;       10+10+10+(8*21)-5 +6+10+8*(12+7+6+8+10)= 553 = 2 scanlines!!

                  ld hl,keys
                  ld de,keys2
                  bit 0,(hl)
                  jr nz,nok           ; if 0 key pressed
                  ex de,hl
                  bit 0,(hl)
                  jr Z,nok            ; if 0 key STIL pressed

do_a_key

nok

ReturnToBASIC:    di
                  ld a,$3F
                  ld i,a
                  im 1
                  ei
                  pop hl
                  exx
                  ret

numstr            defm 0,22,1,0,16,9,17,8,"0123456789abcde><edcba9876543210",255
SetupIntHandler:  di
screen            call 0x0d6b             ; clear bitmap
                  ld hl,16384
                  ld de,16385
                  ld a,%00001111
                  ld bc,1024
                  push bc
                  ld (hl),a
                  ldir
                  rrca
                  rrca
                  rrca
                  rrca
                  ld (hl),a
                  pop bc
                  ldir

                  ld a,%01010101
                  ld b,16
spix              push bc
                  ld (hl),a
                  ld bc,256
                  ldir
                  rrca
                  pop bc
                  djnz spix

ihl               inc hl

;colourwrap       ; replace for sm_attr routine
                  ld hl,attr
phl               push hl
                  ld bc,32
                  ld d,3
moink             ld e,8
numbr             ld a,7         ; bright 0, paper 0, ink 7
ink0              ld (hl),a
                  add hl,bc
                  dec a         
                  dec e
                  jr nz,ink0
                  dec d
                  jr nz,moink

                  pop hl
                  inc hl

                  ld a,l         ; l raises and so does paper
                  and %00001110  ; STEP 2, carry reset
                  rlca           ; %00011100
                  rlca           ; %00111000
                  ld b,a

                  ld a,(numbr+1)
                  and %11000111  ; exclude PAPER
                  or b           ; write PAPER
                  xor 64         ; bright on/off
                  ld (numbr+1),a

                  ld a,31
                  cp l           ; on l=32 Carry set
                  jr nc,phl      ;


                  push hl
                  ld hl,numstr
                  call fetchan
                  pop hl


; Put an EI and RET at $7f7f
                  ld    a,i
                  cp    $7e
                  jr    z,imset    ; assume all set and return
                  ld    hl,$7f7f
intadres equ $-2
                  ld    a,h
                  ld    (hl),$FB
                  inc   hl
                  ld    (hl),$C9

; on 16k the vector table COULD be the printerbuffer as long as 0x5C00 is re-written correctly OR basic a.k.a. 0x0038 is avoided!!
; Put interrupt vector table at $7E00
                  ld    hl,$7E00
intjump equ $-2
                  ld    (hl),a
                  ld    a,h
                  push hl
                  pop de
                  inc de
                  ld    bc,$0100       ; 256+1
                  ldir
kend              ld    i,a            ; a= h MSB jumptable
                  im    2
imset             ei
dummy             ret                  ; set 'dummy' for empty CALLs without changing length of code

; FIRST value/char is CHANNEL-INFO and used to set the correct channel, 0,2,4
; HL must be set to the string before calling this routine
fetchan           ld a,(hl)
                  push hl
                  call setchan
                  pop hl
; if ploop is used as entry notice first value will be skipped so set HL=HL-1 instead before calling, or call ploop1
ploop:            inc hl           
ploop1            ld a,(hl)
                  cp 0xFF
                  ret z
                  rst 16          ; takes very long, must be DIY
                  jr ploop

keys              defs 8,0        ; 8 key storage
keys2             defs 8,0        ; 8 OLD key storage
twice             defb 1



the               end 26000




; Z80 delay routine
; by Jan Bobrowski, license GPL
; wait bc T (including call; bc>=141)
; destroys: af, bc, hl
;call with BC set !! remember !!
DELAY:  ld      hl,-141
        add     hl,bc
        ld      bc,-23
.loop   add     hl,bc
        jr      c,.loop
        ld      a,l
        add     a,15
        jr      nc,.g0
        cp      8
        jr      c,.g1
        or      0
.g0     inc     hl
.g1     rra
        jr      c,.b0
        nop
.b0     rra
        jr      nc,.b1
        or      0
.b1     rra
        ret     nc
        ret



;small 1/6 screen ATTR , actualy counting 0 to 127 in another following order
smattr            defb      7, 71, 15, 79, 23, 87, 31, 95, 39,103, 47,111, 55,119, 63,127
                  defb      6, 70, 14, 78, 22, 86, 30, 94, 38,102, 46,110, 54,118, 62,126
                  defb      5, 69, 13, 77, 21, 85, 29, 93, 37,101, 45,109, 53,117, 61,125
                  defb      4, 68, 12, 76, 20, 84, 28, 92, 36,100, 44,108, 52,116, 60,124
                  defb      3, 67, 11, 75, 19, 83, 27, 91, 35, 99, 43,107, 51,115, 59,123
                  defb      2, 66, 10, 74, 18, 82, 26, 90, 34, 98, 42,106, 50,114, 58,122
                  defb      1, 65,  9, 73, 17, 81, 25, 89, 33, 97, 41,105, 49,113, 57,121
                  defb      0, 64,  8, 72, 16, 80, 24, 88, 32, 96, 40,104, 48,112, 56,120

