
#version 330 core
in vec2 texCoord;
in vec4 vertexFragColor;
out vec4 fragColor;


uniform sampler2D texture0;
uniform float tim3 = 21.0;
uniform float speedX = 0.1;
uniform float speedY = 0.3;
uniform float video = 0.0;
uniform float value1 = 1.0;
uniform float value2 = 0.5;
uniform float value3 = 2.0;
uniform float value4 = 2.0;
uniform float contrast = 0.025;
void main()
{
vec4 colors;
	float t = tim3;
    	vec2 xy = texCoord.xy;
		

    xy.x += step(xy.x, .5 ) * (0.5-xy.x) * 3.0;
    xy.y += step(xy.y, .5) * (0.5-xy.y) * 3.0;
    
    xy.x += t * speedX; //step(sin(t),0.2);
    xy.y -= t * speedY; //step(sin(t),0.2);

	xy.x += value1;
	xy.y += value2;
	   float blursize=20;
   float range=floor(blursize/2.);
    vec4 color=vec4(0.);
    
    for(float a=-range;a<=range;++a)
    for(float b=-range;b<=range;++b)
      color+=texture(texture0,xy+vec2(a*.0025,b*.0025));
      //color=0.0001*color*pow(blursize,2.);
      color=color/pow(blursize,1.4);
      vec4 color2=texture(texture0,xy);
	  colors=(color2*.9+color*.15); 
	  colors.rgb=((colors.rgb - 0.5) * max(contrast + 1.0, 0.0)) + 0.5;
	  
	 
	  fragColor=color2*.5;
	  
 
}