cpu 386
org	0100h

WIDTH equ 320
HEIGHT equ 200

;Assume we're called from text mode and take font offset from int 0x43?
;mov cx, [fs:0x43*4]
;mov ax, 1130h
;mov bh, 6
;int 10h


;Setup vesa video mode.
mov	al, 13h
int	10h

;2 Buffers
push 0x3f72			
value_scale equ $-4 ;Gives a nice 0.95 ish value
pop ds

push 0x8000
pop es

;FS is used to access vram
push 0xa000
pop fs

;Setup font pointer 
;push 0xf000 + 0xfa6
;Hardcoded dosbox font...
push 0xc000 + 170h
pop gs

restart:

dozoomPixel:

;Create center pixel coordinate
mov ax, di
xor dx, dx
mov bp, WIDTH
value_width equ ($-2)
div bp

;Store coordinates for later
pusha

sub ax, HEIGHT / 2
value_half_height equ ($-2)

sub dx, WIDTH / 2
value_half_width equ ($-2)

shr bx, 3
pusha

mov bp, sp

; rx = cos * x - sin * y
; ry = cos * y + sin * x;

;load bx for sine

BXOFFSET equ (4*2)
XOFFSET equ (5*2)
YOFFSET equ (7*2)
SOFFSET equ (6*2)

;BP value at this time is
BPVALUE equ ( 0xfffe - 16*2 )

xor si, si
;Carry should be 0 by this
again:
fild word [bp+BXOFFSET]
fsin 
fidiv word [bp + value_33 - BPVALUE]
fsincos
;cos, sin
jnc skipswap
fxch st1,st0
skipswap:
;cos/sin * x
fimul word [bp+XOFFSET]
fxch st1
;cos/sin * y
fimul word [bp+YOFFSET]
;don't invert x in second pass
jc skipneg
FCHS
skipneg:
faddp
;scale it
fild word [bp+BXOFFSET]
fsin
fadd st0
faddp
fmul dword [bp + value_scale - BPVALUE]
fistp word [bp+si+SOFFSET-2]

lodsw
cmc
jc again

popa

mov bx, dx
mov si, cx
imul si, bp

;Sample the original texture
mov al, [es:bx+si+WIDTH*(HEIGHT/2)+(WIDTH/2)]
;lea si, [bx+si+WIDTH*(HEIGHT/2)+(WIDTH/2)]
;mov al, [es:si]
;cmp si, 320*99+158
;dec ax

;Write to work buffer
mov [di], al

;Restore /320 coordinates for font drawing
popa 

;Is it time to draw a new character
test bl, 30
jne skipText

sub ax, (HEIGHT/2) - 4*8
jb skipText
cmp al, 8*8
jae skipText

mov cx, bx
and cx, 32
add dx, cx

sub dx, (WIDTH/2) - 2*8 + 16
jb skipText
cmp dl, 4*8
jae skipText

;Get Character
mov bp, bx
shr bp, 5
and bp, 15
;Should read from ss
movzx si, byte [textStart+bp]
shl si, 4

;Generate final 0-7 values
shr ax, 2
shr dx, 2

mov cx, dx
add si, ax

;fs is zero so address the font directly
;f0fb4
;shl byte [gs:bp+0xe],cl
shl byte [gs:si],cl
jnc skipText

add al, bl
test bl, 1
jne skipColor
xor al, [di]
skipColor:

;or al, bl
;add al, bl
;mov al, bl

writeText:
mov byte [di], al

;The most basic of sounds, just output the pixels to 0x60
add al, al
out 0x61,al	

skipText:

;Read back and copy to the screen as well
mov al, [di]
mov byte [fs:di], al

;semi randomly walk through the entire display space
imul di, byte 57
inc di
jnz dozoomPixel

;Swap the buffers
push ds
push es
pop ds
pop es

;Can probably be cl
;mov cl, 3

;Wait for retrace
;mov	dx,0x3da
;wait_off:
;in	al,dx
;test al,8

;jnz	wait_off
;wait_on:
;in al,dx
;test al,8
;jz wait_on
;Delay for multiple retraces
;loop wait_off

test bl, 30
je skipSound
;Speaker hooked to the pit
mov     al, 00000011b  
out     61h, al

mov     al, 0xa6		;timer 2, mode 3, hi byte only
out     43h, al         ; a new countdown value

mov ax, bx
shr ax, 4
out		42h, al





skipSound:


;Increase frame counter
inc bx

;Wait esc and repeat
in al, 60h
dec al
jnz restart

;Quit
ret

textStart:
;db ' Come'
;db 'To'
;db 'Outline!'

textStart2:
db ' COME'
db 'TO'
db 'OUTLINE!'
;! gives a nice 33 value
value_33 equ $-1

