uniform sampler2D texture;
uniform float time = 1.0;
uniform vec3 lightSource = (0.0,0.0,0.0);
uniform vec4 frontLight = (1.0,1.0,1.0,1.0);
varying vec3 N;
varying vec3 v;

void main() 
{
   

   vec3 L = normalize(lightSource*2.0 - v);   
   vec4 Idiff = frontLight * max(dot(N,L), 0.0);  
   Idiff = clamp(Idiff, 0.0, 1.0); 
   
   	vec2 coord = gl_TexCoord[0].xy;

	vec4 color=texture2D(texture,coord);

	vec4 newColor=(color+.05*Idiff*sin(25*time));
    newColor*=color.a;
	newColor.a=1.0;
	gl_FragColor = newColor;
}