uniform sampler2D texture;
uniform float time = 1.0;
uniform vec3 lightSource = (0.0,1.0,0.0);
uniform vec4 frontLight = (1.5,1.0,1.0,1.0);
varying vec3 N;
varying vec3 v;

void main() 
{
   

   vec3 L = normalize(lightSource - v);   
   vec4 Idiff = frontLight * max(dot(N,L), 0.0);  
   Idiff = clamp(Idiff, 0.0, 1.0); 
   
   	vec2 coord = gl_TexCoord[0].xy;

	vec4 color=texture2D(texture,coord);
	color.r=(color.r*sin(time*125+ 3))*.4+.1;
	color.g=(color.g*sin(time*125+ 7))*.4+.1;
	color.b=(color.b*sin(time*125+ 5))*.4+.1;
	vec4 newColor=(color+Idiff*.8);
    newColor*=color.a;
	newColor.a=1.0;
	gl_FragColor = newColor;
}