/*
 * Decompiled with CFR 0.152.
 */
package glm.quat;

import glm.glm;
import glm.mat3x3.Mat3;
import glm.mat3x3.Mat3d;
import glm.mat4x4.Mat4;
import glm.mat4x4.Mat4d;
import glm.quat.Quat;
import glm.quat.QuatD;
import glm.vec3.Vec3;
import glm.vec3.Vec3d;
import glm.vec4.Vec4bool;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0002\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J(\u0010\b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J0\u0010\b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u000fH\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J(\u0010\b\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J0\u0010\b\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\t\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u000fH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u000fH\u0016J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J \u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0015H\u0016J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J \u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0015H\u0016J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0015H\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0015H\u0016J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0007H\u0016J \u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J(\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J \u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0006H\u0016J(\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0018\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J \u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0015H\u0016J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J \u0010 \u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0015H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\"H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010%\u001a\u00020&2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020&2\u0006\u0010\u0004\u001a\u00020\u0007H\u0016J \u0010(\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J(\u0010(\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J \u0010(\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0006H\u0016J(\u0010(\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010)\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010)\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010)\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0007H\u0016J\u0018\u0010)\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0018\u0010*\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J \u0010*\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0015H\u0016J\u0010\u0010+\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010+\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0007H\u0016J\u0010\u0010,\u001a\u00020\u00072\u0006\u0010$\u001a\u00020-H\u0016J\u0018\u0010,\u001a\u00020\u00072\u0006\u0010$\u001a\u00020-2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010,\u001a\u00020\u00072\u0006\u0010$\u001a\u00020.H\u0016J\u0018\u0010,\u001a\u00020\u00072\u0006\u0010$\u001a\u00020.2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016JP\u0010,\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u0006H\u0016JX\u0010,\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u00108\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\"H\u0016J\u0018\u00108\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u00108\u001a\u00020\u00052\u0006\u0010$\u001a\u00020&H\u0016J\u0018\u00108\u001a\u00020\u00052\u0006\u0010$\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016JP\u00108\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u0003H\u0016JX\u00108\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u00109\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u00109\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0007H\u0016J \u0010:\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u000fH\u0016J(\u0010:\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J0\u0010:\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u00032\u0006\u0010>\u001a\u00020\u0003H\u0016J8\u0010:\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u00032\u0006\u0010>\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J \u0010:\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\nH\u0016J(\u0010:\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J0\u0010:\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u00062\u0006\u0010>\u001a\u00020\u0006H\u0016J8\u0010:\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u00062\u0006\u0010>\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J \u0010?\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J(\u0010?\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J \u0010?\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0006H\u0016J(\u0010?\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010@\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010@\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0007H\u0016\u00a8\u0006A"}, d2={"Lglm/quat/quat_func;", "", "angle", "", "q", "Lglm/quat/Quat;", "", "Lglm/quat/QuatD;", "angleAxis", "axis", "Lglm/vec3/Vec3d;", "res", "axisX", "axisY", "axisZ", "Lglm/vec3/Vec3;", "conjugate", "a", "dot", "b", "equal", "Lglm/vec4/Vec4bool;", "eulerAngles", "greater", "greaterThan", "inverse", "isInf", "isNan", "length", "lerp", "interp", "lessThan", "lessThanEqual", "mat3_cast", "Lglm/mat3x3/Mat3;", "mat3d_cast", "m", "mat4_cast", "Lglm/mat4x4/Mat4;", "mat4d_cast", "mix", "normalize", "notEqual", "pitch", "quatD_cast", "Lglm/mat3x3/Mat3d;", "Lglm/mat4x4/Mat4d;", "m00", "m01", "m02", "m10", "m11", "m12", "m20", "m21", "m22", "quat_cast", "roll", "rotate", "v", "vX", "vY", "vZ", "slerp", "yaw", "build_main"})
public interface quat_func {
    public float length(@NotNull Quat var1);

    public double length(@NotNull QuatD var1);

    @NotNull
    public Quat normalize(@NotNull Quat var1, @NotNull Quat var2);

    @NotNull
    public Quat normalize(@NotNull Quat var1);

    @NotNull
    public QuatD normalize(@NotNull QuatD var1, @NotNull QuatD var2);

    @NotNull
    public QuatD normalize(@NotNull QuatD var1);

    public float dot(@NotNull Quat var1, @NotNull Quat var2);

    public double dot(@NotNull QuatD var1, @NotNull QuatD var2);

    @NotNull
    public Quat mix(@NotNull Quat var1, @NotNull Quat var2, float var3, @NotNull Quat var4);

    @NotNull
    public Quat mix(@NotNull Quat var1, @NotNull Quat var2, float var3);

    @NotNull
    public QuatD mix(@NotNull QuatD var1, @NotNull QuatD var2, double var3, @NotNull QuatD var5);

    @NotNull
    public QuatD mix(@NotNull QuatD var1, @NotNull QuatD var2, double var3);

    @NotNull
    public Quat lerp(@NotNull Quat var1, @NotNull Quat var2, float var3, @NotNull Quat var4);

    @NotNull
    public Quat lerp(@NotNull Quat var1, @NotNull Quat var2, float var3);

    @NotNull
    public QuatD lerp(@NotNull QuatD var1, @NotNull QuatD var2, double var3, @NotNull QuatD var5);

    @NotNull
    public QuatD lerp(@NotNull QuatD var1, @NotNull QuatD var2, double var3);

    @NotNull
    public Quat slerp(@NotNull Quat var1, @NotNull Quat var2, float var3, @NotNull Quat var4);

    @NotNull
    public Quat slerp(@NotNull Quat var1, @NotNull Quat var2, float var3);

    @NotNull
    public QuatD slerp(@NotNull QuatD var1, @NotNull QuatD var2, double var3, @NotNull QuatD var5);

    @NotNull
    public QuatD slerp(@NotNull QuatD var1, @NotNull QuatD var2, double var3);

    @NotNull
    public Quat conjugate(@NotNull Quat var1, @NotNull Quat var2);

    @NotNull
    public Quat conjugate(@NotNull Quat var1);

    @NotNull
    public QuatD conjugate(@NotNull QuatD var1, @NotNull QuatD var2);

    @NotNull
    public QuatD conjugate(@NotNull QuatD var1);

    @NotNull
    public Quat inverse(@NotNull Quat var1, @NotNull Quat var2);

    @NotNull
    public Quat inverse(@NotNull Quat var1);

    @NotNull
    public QuatD inverse(@NotNull QuatD var1, @NotNull QuatD var2);

    @NotNull
    public QuatD inverse(@NotNull QuatD var1);

    @NotNull
    public Quat rotate(@NotNull Quat var1, float var2, float var3, float var4, float var5, @NotNull Quat var6);

    @NotNull
    public Quat rotate(@NotNull Quat var1, float var2, float var3, float var4, float var5);

    @NotNull
    public Quat rotate(@NotNull Quat var1, float var2, @NotNull Vec3 var3, @NotNull Quat var4);

    @NotNull
    public Quat rotate(@NotNull Quat var1, float var2, @NotNull Vec3 var3);

    @NotNull
    public QuatD rotate(@NotNull QuatD var1, double var2, double var4, double var6, double var8, @NotNull QuatD var10);

    @NotNull
    public QuatD rotate(@NotNull QuatD var1, double var2, double var4, double var6, double var8);

    @NotNull
    public QuatD rotate(@NotNull QuatD var1, double var2, @NotNull Vec3d var4, @NotNull QuatD var5);

    @NotNull
    public QuatD rotate(@NotNull QuatD var1, double var2, @NotNull Vec3d var4);

    @NotNull
    public Vec3 eulerAngles(@NotNull Quat var1, @NotNull Vec3 var2);

    @NotNull
    public Vec3 eulerAngles(@NotNull Quat var1);

    @NotNull
    public Vec3d eulerAngles(@NotNull QuatD var1, @NotNull Vec3d var2);

    @NotNull
    public Vec3d eulerAngles(@NotNull QuatD var1);

    public float roll(@NotNull Quat var1);

    public double roll(@NotNull QuatD var1);

    public float pitch(@NotNull Quat var1);

    public double pitch(@NotNull QuatD var1);

    public float yaw(@NotNull Quat var1);

    public double yaw(@NotNull QuatD var1);

    @NotNull
    public Mat3 mat3_cast(@NotNull Quat var1, @NotNull Mat3 var2);

    @NotNull
    public Mat3 mat3_cast(@NotNull Quat var1);

    @NotNull
    public Mat3 mat3d_cast(@NotNull QuatD var1, @NotNull Mat3 var2);

    @NotNull
    public Mat4 mat4_cast(@NotNull Quat var1, @NotNull Mat4 var2);

    @NotNull
    public Mat4 mat4_cast(@NotNull Quat var1);

    @NotNull
    public Mat4 mat4d_cast(@NotNull Mat4 var1, @NotNull QuatD var2);

    @NotNull
    public Quat quat_cast(@NotNull Mat3 var1, @NotNull Quat var2);

    @NotNull
    public QuatD quatD_cast(@NotNull Mat3d var1, @NotNull QuatD var2);

    @NotNull
    public Quat quat_cast(@NotNull Mat3 var1);

    @NotNull
    public QuatD quatD_cast(@NotNull Mat3d var1);

    @NotNull
    public Quat quat_cast(@NotNull Mat4 var1, @NotNull Quat var2);

    @NotNull
    public QuatD quatD_cast(@NotNull Mat4d var1, @NotNull QuatD var2);

    @NotNull
    public Quat quat_cast(@NotNull Mat4 var1);

    @NotNull
    public QuatD quatD_cast(@NotNull Mat4d var1);

    @NotNull
    public Quat quat_cast(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, @NotNull Quat var10);

    @NotNull
    public Quat quat_cast(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9);

    @NotNull
    public QuatD quatD_cast(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, @NotNull QuatD var19);

    @NotNull
    public QuatD quatD_cast(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17);

    public float angle(@NotNull Quat var1);

    public double angle(@NotNull QuatD var1);

    @NotNull
    public Vec3 axis(@NotNull Quat var1, @NotNull Vec3 var2);

    @NotNull
    public Vec3 axis(@NotNull Quat var1);

    @NotNull
    public Vec3d axis(@NotNull QuatD var1, @NotNull Vec3d var2);

    @NotNull
    public Vec3d axis(@NotNull QuatD var1);

    @NotNull
    public Quat angleAxis(float var1, float var2, float var3, float var4, @NotNull Quat var5);

    @NotNull
    public Quat angleAxis(float var1, float var2, float var3, float var4);

    @NotNull
    public Quat angleAxis(float var1, @NotNull Vec3 var2, @NotNull Quat var3);

    @NotNull
    public Quat angleAxis(float var1, @NotNull Vec3 var2);

    @NotNull
    public QuatD angleAxis(double var1, double var3, double var5, double var7, @NotNull QuatD var9);

    @NotNull
    public QuatD angleAxis(double var1, double var3, double var5, double var7);

    @NotNull
    public QuatD angleAxis(double var1, @NotNull Vec3d var3, @NotNull QuatD var4);

    @NotNull
    public QuatD angleAxis(double var1, @NotNull Vec3d var3);

    @NotNull
    public Vec4bool lessThan(@NotNull Quat var1, @NotNull Quat var2, @NotNull Vec4bool var3);

    @NotNull
    public Vec4bool lessThan(@NotNull Quat var1, @NotNull Quat var2);

    @NotNull
    public Vec4bool lessThanEqual(@NotNull Quat var1, @NotNull Quat var2, @NotNull Vec4bool var3);

    @NotNull
    public Vec4bool lessThanEqual(@NotNull Quat var1, @NotNull Quat var2);

    @NotNull
    public Vec4bool greater(@NotNull Quat var1, @NotNull Quat var2, @NotNull Vec4bool var3);

    @NotNull
    public Vec4bool greater(@NotNull Quat var1, @NotNull Quat var2);

    @NotNull
    public Vec4bool greaterThan(@NotNull Quat var1, @NotNull Quat var2, @NotNull Vec4bool var3);

    @NotNull
    public Vec4bool greaterThan(@NotNull Quat var1, @NotNull Quat var2);

    @NotNull
    public Vec4bool equal(@NotNull Quat var1, @NotNull Quat var2, @NotNull Vec4bool var3);

    @NotNull
    public Vec4bool equal(@NotNull Quat var1, @NotNull Quat var2);

    @NotNull
    public Vec4bool notEqual(@NotNull Quat var1, @NotNull Quat var2, @NotNull Vec4bool var3);

    @NotNull
    public Vec4bool notEqual(@NotNull Quat var1, @NotNull Quat var2);

    @NotNull
    public Vec4bool isNan(@NotNull Quat var1, @NotNull Vec4bool var2);

    @NotNull
    public Vec4bool isNan(@NotNull Quat var1);

    @NotNull
    public Vec4bool isInf(@NotNull Quat var1, @NotNull Vec4bool var2);

    @NotNull
    public Vec4bool isInf(@NotNull Quat var1);

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=3)
    public static final class DefaultImpls {
        public static float length(@NotNull quat_func $this, Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return glm.INSTANCE.sqrt($this.dot(q, q));
        }

        public static double length(@NotNull quat_func $this, QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return glm.INSTANCE.sqrt($this.dot(q, q));
        }

        @NotNull
        public static Quat normalize(@NotNull quat_func $this, @NotNull Quat q, Quat res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            float len = $this.length(q);
            if (len <= 0.0f) {
                return res.put(1.0f, 0.0f, 0.0f, 0.0f);
            }
            float oneOverLen = 1.0f / len;
            return res.put(q.w.floatValue() * oneOverLen, q.x.floatValue() * oneOverLen, q.y.floatValue() * oneOverLen, q.z.floatValue() * oneOverLen);
        }

        @NotNull
        public static Quat normalize(@NotNull quat_func $this, Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return $this.normalize(q, new Quat());
        }

        @NotNull
        public static QuatD normalize(@NotNull quat_func $this, @NotNull QuatD q, QuatD res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            double len = $this.length(q);
            if (len <= 0.0) {
                return res.put(1.0, 0.0, 0.0, 0.0);
            }
            double oneOverLen = 1.0 / len;
            return res.put(q.w.doubleValue() * oneOverLen, q.x.doubleValue() * oneOverLen, q.y.doubleValue() * oneOverLen, q.z.doubleValue() * oneOverLen);
        }

        @NotNull
        public static QuatD normalize(@NotNull quat_func $this, QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return $this.normalize(q, new QuatD());
        }

        public static float dot(@NotNull quat_func $this, @NotNull Quat a, Quat b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return a.x.floatValue() * b.x.floatValue() + a.y.floatValue() * b.y.floatValue() + a.z.floatValue() * b.z.floatValue() + a.w.floatValue() * b.w.floatValue();
        }

        public static double dot(@NotNull quat_func $this, @NotNull QuatD a, QuatD b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return a.x.doubleValue() * b.x.doubleValue() + a.y.doubleValue() * b.y.doubleValue() + a.z.doubleValue() * b.z.doubleValue() + a.w.doubleValue() * b.w.doubleValue();
        }

        @NotNull
        public static Quat mix(@NotNull quat_func $this, @NotNull Quat a, Quat b, @NotNull float interp, Quat res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            float cosTheta = $this.dot(a, b);
            if (cosTheta > 1.0f - glm.epsilonF) {
                res.w = Float.valueOf(glm.INSTANCE.mix(a.w.floatValue(), b.w.floatValue(), interp));
                res.x = Float.valueOf(glm.INSTANCE.mix(a.x.floatValue(), b.x.floatValue(), interp));
                res.y = Float.valueOf(glm.INSTANCE.mix(a.y.floatValue(), b.y.floatValue(), interp));
                res.z = Float.valueOf(glm.INSTANCE.mix(a.z.floatValue(), b.z.floatValue(), interp));
                return res;
            }
            float angle = glm.INSTANCE.acos(cosTheta);
            float s0 = glm.INSTANCE.sin((1.0f - interp) * angle);
            float s1 = glm.INSTANCE.sin(interp * angle);
            float s2 = glm.INSTANCE.sin(angle);
            res.w = Float.valueOf((s0 * a.w.floatValue() + s1 * b.w.floatValue()) / s2);
            res.x = Float.valueOf((s0 * a.x.floatValue() + s1 * b.x.floatValue()) / s2);
            res.y = Float.valueOf((s0 * a.y.floatValue() + s1 * b.y.floatValue()) / s2);
            res.z = Float.valueOf((s0 * a.z.floatValue() + s1 * b.z.floatValue()) / s2);
            return res;
        }

        @NotNull
        public static Quat mix(@NotNull quat_func $this, @NotNull Quat a, Quat b, float interp) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.mix(a, b, interp, new Quat());
        }

        @NotNull
        public static QuatD mix(@NotNull quat_func $this, @NotNull QuatD a, QuatD b, @NotNull double interp, QuatD res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            double cosTheta = $this.dot(a, b);
            if (cosTheta > 1.0 - glm.epsilonD) {
                res.w = glm.INSTANCE.mix(a.w.doubleValue(), b.w.doubleValue(), interp);
                res.x = glm.INSTANCE.mix(a.x.doubleValue(), b.x.doubleValue(), interp);
                res.y = glm.INSTANCE.mix(a.y.doubleValue(), b.y.doubleValue(), interp);
                res.z = glm.INSTANCE.mix(a.z.doubleValue(), b.z.doubleValue(), interp);
                return res;
            }
            double angle = glm.INSTANCE.acos(cosTheta);
            double s0 = glm.INSTANCE.sin((1.0 - interp) * angle);
            double s1 = glm.INSTANCE.sin(interp * angle);
            double s2 = glm.INSTANCE.sin(angle);
            res.w = (s0 * a.w.doubleValue() + s1 * b.w.doubleValue()) / s2;
            res.x = (s0 * a.x.doubleValue() + s1 * b.x.doubleValue()) / s2;
            res.y = (s0 * a.y.doubleValue() + s1 * b.y.doubleValue()) / s2;
            res.z = (s0 * a.z.doubleValue() + s1 * b.z.doubleValue()) / s2;
            return res;
        }

        @NotNull
        public static QuatD mix(@NotNull quat_func $this, @NotNull QuatD a, QuatD b, double interp) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.mix(a, b, interp, new QuatD());
        }

        @NotNull
        public static Quat lerp(@NotNull quat_func $this, @NotNull Quat a, Quat b, @NotNull float interp, Quat res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            if (interp < 0.0f || interp > 1.0f) {
                throw (Throwable)new ArithmeticException("interp outside [0, 1]");
            }
            res.w = Float.valueOf(a.w.floatValue() * (1.0f - interp) + b.w.floatValue() * interp);
            res.x = Float.valueOf(a.x.floatValue() * (1.0f - interp) + b.x.floatValue() * interp);
            res.y = Float.valueOf(a.y.floatValue() * (1.0f - interp) + b.y.floatValue() * interp);
            res.z = Float.valueOf(a.z.floatValue() * (1.0f - interp) + b.z.floatValue() * interp);
            return res;
        }

        @NotNull
        public static Quat lerp(@NotNull quat_func $this, @NotNull Quat a, Quat b, float interp) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.lerp(a, b, interp, new Quat());
        }

        @NotNull
        public static QuatD lerp(@NotNull quat_func $this, @NotNull QuatD a, QuatD b, @NotNull double interp, QuatD res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            if (interp < 0.0 || interp > 1.0) {
                throw (Throwable)new ArithmeticException("interp outside [0, 1]");
            }
            res.w = a.w.doubleValue() * (1.0 - interp) + b.w.doubleValue() * interp;
            res.x = a.x.doubleValue() * (1.0 - interp) + b.x.doubleValue() * interp;
            res.y = a.y.doubleValue() * (1.0 - interp) + b.y.doubleValue() * interp;
            res.z = a.z.doubleValue() * (1.0 - interp) + b.z.doubleValue() * interp;
            return res;
        }

        @NotNull
        public static QuatD lerp(@NotNull quat_func $this, @NotNull QuatD a, QuatD b, double interp) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.lerp(a, b, interp, new QuatD());
        }

        @NotNull
        public static Quat slerp(@NotNull quat_func $this, @NotNull Quat a, Quat b, @NotNull float interp, Quat res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            float zW = b.w.floatValue();
            float zX = b.x.floatValue();
            float zY = b.y.floatValue();
            float zZ = b.z.floatValue();
            float cosTheta = $this.dot(a, b);
            if (cosTheta < 0.0f) {
                zW = -b.w.floatValue();
                zX = -b.x.floatValue();
                zY = -b.y.floatValue();
                zZ = -b.z.floatValue();
                cosTheta = -cosTheta;
            }
            if (cosTheta > 1.0f - glm.epsilonF) {
                res.w = Float.valueOf(glm.INSTANCE.mix(a.w.floatValue(), zW, interp));
                res.x = Float.valueOf(glm.INSTANCE.mix(a.x.floatValue(), zX, interp));
                res.y = Float.valueOf(glm.INSTANCE.mix(a.y.floatValue(), zY, interp));
                res.z = Float.valueOf(glm.INSTANCE.mix(a.z.floatValue(), zZ, interp));
                return res;
            }
            float angle = glm.INSTANCE.acos(cosTheta);
            float s0 = glm.INSTANCE.sin((1.0f - interp) * angle);
            float s1 = glm.INSTANCE.sin(interp * angle);
            float s2 = glm.INSTANCE.sin(angle);
            res.w = Float.valueOf((s0 * a.w.floatValue() + s1 * zW) / s2);
            res.x = Float.valueOf((s0 * a.x.floatValue() + s1 * zX) / s2);
            res.y = Float.valueOf((s0 * a.y.floatValue() + s1 * zY) / s2);
            res.z = Float.valueOf((s0 * a.z.floatValue() + s1 * zZ) / s2);
            return res;
        }

        @NotNull
        public static Quat slerp(@NotNull quat_func $this, @NotNull Quat a, Quat b, float interp) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.slerp(a, b, interp, new Quat());
        }

        @NotNull
        public static QuatD slerp(@NotNull quat_func $this, @NotNull QuatD a, QuatD b, @NotNull double interp, QuatD res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            double zW = b.w.doubleValue();
            double zX = b.x.doubleValue();
            double zY = b.y.doubleValue();
            double zZ = b.z.doubleValue();
            double cosTheta = $this.dot(a, b);
            if (cosTheta < 0.0) {
                zW = -b.w.doubleValue();
                zX = -b.x.doubleValue();
                zY = -b.y.doubleValue();
                zZ = -b.z.doubleValue();
                cosTheta = -cosTheta;
            }
            if (cosTheta > 1.0 - glm.epsilonD) {
                res.w = glm.INSTANCE.mix(a.w.doubleValue(), zW, interp);
                res.x = glm.INSTANCE.mix(a.x.doubleValue(), zX, interp);
                res.y = glm.INSTANCE.mix(a.y.doubleValue(), zY, interp);
                res.z = glm.INSTANCE.mix(a.z.doubleValue(), zZ, interp);
                return res;
            }
            double angle = glm.INSTANCE.acos(cosTheta);
            double s0 = glm.INSTANCE.sin((1.0 - interp) * angle);
            double s1 = glm.INSTANCE.sin(interp * angle);
            double s2 = glm.INSTANCE.sin(angle);
            res.w = (s0 * a.w.doubleValue() + s1 * b.w.doubleValue()) / s2;
            res.x = (s0 * a.x.doubleValue() + s1 * b.x.doubleValue()) / s2;
            res.y = (s0 * a.y.doubleValue() + s1 * b.y.doubleValue()) / s2;
            res.z = (s0 * a.z.doubleValue() + s1 * b.z.doubleValue()) / s2;
            return res;
        }

        @NotNull
        public static QuatD slerp(@NotNull quat_func $this, @NotNull QuatD a, QuatD b, double interp) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.slerp(a, b, interp, new QuatD());
        }

        @NotNull
        public static Quat conjugate(@NotNull quat_func $this, @NotNull Quat a, Quat res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            res.w = a.w;
            res.x = Float.valueOf(-a.x.floatValue());
            res.y = Float.valueOf(-a.y.floatValue());
            res.z = Float.valueOf(-a.z.floatValue());
            return res;
        }

        @NotNull
        public static Quat conjugate(@NotNull quat_func $this, Quat a) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            return $this.conjugate(a, new Quat());
        }

        @NotNull
        public static QuatD conjugate(@NotNull quat_func $this, @NotNull QuatD a, QuatD res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            res.w = a.w;
            res.x = -a.x.doubleValue();
            res.y = -a.y.doubleValue();
            res.z = -a.z.doubleValue();
            return res;
        }

        @NotNull
        public static QuatD conjugate(@NotNull quat_func $this, QuatD a) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            return $this.conjugate(a, new QuatD());
        }

        @NotNull
        public static Quat inverse(@NotNull quat_func $this, @NotNull Quat a, Quat res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            float dot = $this.dot(a, a);
            res.w = Float.valueOf(a.w.floatValue() / dot);
            res.x = Float.valueOf(-a.x.floatValue() / dot);
            res.y = Float.valueOf(-a.y.floatValue() / dot);
            res.z = Float.valueOf(-a.z.floatValue() / dot);
            return res;
        }

        @NotNull
        public static Quat inverse(@NotNull quat_func $this, Quat a) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            return $this.inverse(a, new Quat());
        }

        @NotNull
        public static QuatD inverse(@NotNull quat_func $this, @NotNull QuatD a, QuatD res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            double dot = $this.dot(a, a);
            res.w = a.w.doubleValue() / dot;
            res.x = -a.x.doubleValue() / dot;
            res.y = -a.y.doubleValue() / dot;
            res.z = -a.z.doubleValue() / dot;
            return res;
        }

        @NotNull
        public static QuatD inverse(@NotNull quat_func $this, QuatD a) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            return $this.inverse(a, new QuatD());
        }

        @NotNull
        public static Quat rotate(@NotNull quat_func $this, Quat q, float angle, float vX, float vY, @NotNull float vZ, Quat res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            float tmpX = vX;
            float tmpY = vY;
            float tmpZ = vZ;
            float len = glm.INSTANCE.sqrt(vX * vX + vY * vY + vZ * vZ);
            if (glm.INSTANCE.abs(len - 1.0f) > 0.001f) {
                float oneOverLen = 1.0f / len;
                tmpX *= oneOverLen;
                tmpY *= oneOverLen;
                tmpZ *= oneOverLen;
            }
            float sin = glm.INSTANCE.sin(angle * 0.5f);
            float pW = glm.INSTANCE.cos(angle * 0.5f);
            float pX = tmpX * sin;
            float pY = tmpY * sin;
            float pZ = tmpZ * sin;
            float w = q.w.floatValue() * pW - q.x.floatValue() * pX - q.y.floatValue() * pY - q.z.floatValue() * pZ;
            float x = q.w.floatValue() * pX + q.x.floatValue() * pW + q.y.floatValue() * pZ - q.z.floatValue() * pY;
            float y = q.w.floatValue() * pY + q.y.floatValue() * pW + q.z.floatValue() * pX - q.x.floatValue() * pZ;
            float z = q.w.floatValue() * pZ + q.z.floatValue() * pW + q.x.floatValue() * pY - q.y.floatValue() * pX;
            res.w = Float.valueOf(w);
            res.x = Float.valueOf(x);
            res.y = Float.valueOf(y);
            res.z = Float.valueOf(z);
            return res;
        }

        @NotNull
        public static Quat rotate(@NotNull quat_func $this, Quat q, float angle, float vX, float vY, float vZ) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return $this.rotate(q, angle, vX, vY, vZ, new Quat());
        }

        @NotNull
        public static Quat rotate(@NotNull quat_func $this, Quat q, @NotNull float angle, @NotNull Vec3 v, Quat res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return $this.rotate(q, angle, v.x.floatValue(), v.y.floatValue(), v.z.floatValue(), res);
        }

        @NotNull
        public static Quat rotate(@NotNull quat_func $this, Quat q, @NotNull float angle, Vec3 v) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            return $this.rotate(q, angle, v.x.floatValue(), v.y.floatValue(), v.z.floatValue(), new Quat());
        }

        @NotNull
        public static QuatD rotate(@NotNull quat_func $this, QuatD q, double angle, double vX, double vY, @NotNull double vZ, QuatD res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            double tmpX = vX;
            double tmpY = vY;
            double tmpZ = vZ;
            double len = glm.INSTANCE.sqrt(vX * vX + vY * vY + vZ * vZ);
            if (glm.INSTANCE.abs(len - (double)1.0f) > 0.001) {
                double oneOverLen = (double)1.0f / len;
                tmpX *= oneOverLen;
                tmpY *= oneOverLen;
                tmpZ *= oneOverLen;
            }
            double sin = glm.INSTANCE.sin(angle * (double)0.5f);
            double pW = glm.INSTANCE.cos(angle * (double)0.5f);
            double pX = tmpX * sin;
            double pY = tmpY * sin;
            double pZ = tmpZ * sin;
            double w = q.w.doubleValue() * pW - q.x.doubleValue() * pX - q.y.doubleValue() * pY - q.z.doubleValue() * pZ;
            double x = q.w.doubleValue() * pX + q.x.doubleValue() * pW + q.y.doubleValue() * pZ - q.z.doubleValue() * pY;
            double y = q.w.doubleValue() * pY + q.y.doubleValue() * pW + q.z.doubleValue() * pX - q.x.doubleValue() * pZ;
            double z = q.w.doubleValue() * pZ + q.z.doubleValue() * pW + q.x.doubleValue() * pY - q.y.doubleValue() * pX;
            res.w = w;
            res.x = x;
            res.y = y;
            res.z = z;
            return res;
        }

        @NotNull
        public static QuatD rotate(@NotNull quat_func $this, QuatD q, double angle, double vX, double vY, double vZ) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return $this.rotate(q, angle, vX, vY, vZ, new QuatD());
        }

        @NotNull
        public static QuatD rotate(@NotNull quat_func $this, QuatD q, @NotNull double angle, @NotNull Vec3d v, QuatD res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return $this.rotate(q, angle, v.x.doubleValue(), v.y.doubleValue(), v.z.doubleValue(), res);
        }

        @NotNull
        public static QuatD rotate(@NotNull quat_func $this, QuatD q, @NotNull double angle, Vec3d v) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            return $this.rotate(q, angle, v.x.doubleValue(), v.y.doubleValue(), v.z.doubleValue(), new QuatD());
        }

        @NotNull
        public static Vec3 eulerAngles(@NotNull quat_func $this, @NotNull Quat a, Vec3 res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            res.x = Float.valueOf($this.pitch(a));
            res.y = Float.valueOf($this.yaw(a));
            res.z = Float.valueOf($this.roll(a));
            return res;
        }

        @NotNull
        public static Vec3 eulerAngles(@NotNull quat_func $this, Quat a) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            return $this.eulerAngles(a, new Vec3());
        }

        @NotNull
        public static Vec3d eulerAngles(@NotNull quat_func $this, @NotNull QuatD a, Vec3d res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            res.x = $this.pitch(a);
            res.y = $this.yaw(a);
            res.z = $this.roll(a);
            return res;
        }

        @NotNull
        public static Vec3d eulerAngles(@NotNull quat_func $this, QuatD a) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            return $this.eulerAngles(a, new Vec3d());
        }

        public static float roll(@NotNull quat_func $this, Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return glm.INSTANCE.atan(2.0f * (q.x.floatValue() * q.y.floatValue() + q.w.floatValue() * q.z.floatValue()), q.w.floatValue() * q.w.floatValue() + q.x.floatValue() * q.x.floatValue() - q.y.floatValue() * q.y.floatValue() - q.z.floatValue() * q.z.floatValue());
        }

        public static double roll(@NotNull quat_func $this, QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return glm.INSTANCE.atan(2.0 * (q.x.doubleValue() * q.y.doubleValue() + q.w.doubleValue() * q.z.doubleValue()), q.w.doubleValue() * q.w.doubleValue() + q.x.doubleValue() * q.x.doubleValue() - q.y.doubleValue() * q.y.doubleValue() - q.z.doubleValue() * q.z.doubleValue());
        }

        public static float pitch(@NotNull quat_func $this, Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return glm.INSTANCE.atan(2.0f * (q.y.floatValue() * q.z.floatValue() + q.w.floatValue() * q.x.floatValue()), q.w.floatValue() * q.w.floatValue() - q.x.floatValue() * q.x.floatValue() - q.y.floatValue() * q.y.floatValue() + q.z.floatValue() * q.z.floatValue());
        }

        public static double pitch(@NotNull quat_func $this, QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return glm.INSTANCE.atan(2.0 * (q.y.doubleValue() * q.z.doubleValue() + q.w.doubleValue() * q.x.doubleValue()), q.w.doubleValue() * q.w.doubleValue() - q.x.doubleValue() * q.x.doubleValue() - q.y.doubleValue() * q.y.doubleValue() + q.z.doubleValue() * q.z.doubleValue());
        }

        public static float yaw(@NotNull quat_func $this, Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return glm.INSTANCE.asin(glm.INSTANCE.clamp(-2.0f * (q.x.floatValue() * q.z.floatValue() - q.w.floatValue() * q.y.floatValue()), -1.0f, 1.0f));
        }

        public static double yaw(@NotNull quat_func $this, QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return glm.INSTANCE.asin(glm.INSTANCE.clamp(-2.0 * (q.x.doubleValue() * q.z.doubleValue() - q.w.doubleValue() * q.y.doubleValue()), -1.0, 1.0));
        }

        @NotNull
        public static Mat3 mat3_cast(@NotNull quat_func $this, @NotNull Quat q, Mat3 res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            float qxx = q.x.floatValue() * q.x.floatValue();
            float qyy = q.y.floatValue() * q.y.floatValue();
            float qzz = q.z.floatValue() * q.z.floatValue();
            float qxz = q.x.floatValue() * q.z.floatValue();
            float qxy = q.x.floatValue() * q.y.floatValue();
            float qyz = q.y.floatValue() * q.z.floatValue();
            float qwx = q.w.floatValue() * q.x.floatValue();
            float qwy = q.w.floatValue() * q.y.floatValue();
            float qwz = q.w.floatValue() * q.z.floatValue();
            res.get(0).set(0, Float.valueOf(1.0f - 2.0f * (qyy + qzz)));
            res.get(0).set(1, Float.valueOf(2.0f * (qxy + qwz)));
            res.get(0).set(2, Float.valueOf(2.0f * (qxz - qwy)));
            res.get(1).set(0, Float.valueOf(2.0f * (qxy - qwz)));
            res.get(1).set(1, Float.valueOf(1.0f - 2.0f * (qxx + qzz)));
            res.get(1).set(2, Float.valueOf(2.0f * (qyz + qwx)));
            res.get(2).set(0, Float.valueOf(2.0f * (qxz + qwy)));
            res.get(2).set(1, Float.valueOf(2.0f * (qyz - qwx)));
            res.get(2).set(2, Float.valueOf(1.0f - 2.0f * (qxx + qyy)));
            return res;
        }

        @NotNull
        public static Mat3 mat3_cast(@NotNull quat_func $this, Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return $this.mat3_cast(q, new Mat3());
        }

        @NotNull
        public static Mat3 mat3d_cast(@NotNull quat_func $this, @NotNull QuatD q, Mat3 m) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(m, "m");
            throw (Throwable)new NotImplementedError(null, 1, null);
        }

        @NotNull
        public static Mat4 mat4_cast(@NotNull quat_func $this, @NotNull Quat q, Mat4 res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            float qxx = q.x.floatValue() * q.x.floatValue();
            float qyy = q.y.floatValue() * q.y.floatValue();
            float qzz = q.z.floatValue() * q.z.floatValue();
            float qxz = q.x.floatValue() * q.z.floatValue();
            float qxy = q.x.floatValue() * q.y.floatValue();
            float qyz = q.y.floatValue() * q.z.floatValue();
            float qwx = q.w.floatValue() * q.x.floatValue();
            float qwy = q.w.floatValue() * q.y.floatValue();
            float qwz = q.w.floatValue() * q.z.floatValue();
            res.get(0).set(0, Float.valueOf(1.0f - 2.0f * (qyy + qzz)));
            res.get(0).set(1, Float.valueOf(2.0f * (qxy + qwz)));
            res.get(0).set(2, Float.valueOf(2.0f * (qxz - qwy)));
            res.get(1).set(0, Float.valueOf(2.0f * (qxy - qwz)));
            res.get(1).set(1, Float.valueOf(1.0f - 2.0f * (qxx + qzz)));
            res.get(1).set(2, Float.valueOf(2.0f * (qyz + qwx)));
            res.get(2).set(0, Float.valueOf(2.0f * (qxz + qwy)));
            res.get(2).set(1, Float.valueOf(2.0f * (qyz - qwx)));
            res.get(2).set(2, Float.valueOf(1.0f - 2.0f * (qxx + qyy)));
            return res;
        }

        @NotNull
        public static Mat4 mat4_cast(@NotNull quat_func $this, Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return $this.mat4_cast(q, new Mat4());
        }

        @NotNull
        public static Mat4 mat4d_cast(@NotNull quat_func $this, @NotNull Mat4 res, QuatD q) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(q, "q");
            throw (Throwable)new NotImplementedError(null, 1, null);
        }

        @NotNull
        public static Quat quat_cast(@NotNull quat_func $this, @NotNull Mat3 m, Quat res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return $this.quat_cast(m.get(0).get(0), m.get(0).get(1), m.get(0).get(2), m.get(1).get(0), m.get(1).get(1), m.get(1).get(2), m.get(2).get(0), m.get(2).get(1), m.get(2).get(2), res);
        }

        @NotNull
        public static QuatD quatD_cast(@NotNull quat_func $this, @NotNull Mat3d m, QuatD res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return $this.quatD_cast(m.get(0).get(0), m.get(0).get(1), m.get(0).get(2), m.get(1).get(0), m.get(1).get(1), m.get(1).get(2), m.get(2).get(0), m.get(2).get(1), m.get(2).get(2), res);
        }

        @NotNull
        public static Quat quat_cast(@NotNull quat_func $this, Mat3 m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return $this.quat_cast(m, new Quat());
        }

        @NotNull
        public static QuatD quatD_cast(@NotNull quat_func $this, Mat3d m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return $this.quatD_cast(m, new QuatD());
        }

        @NotNull
        public static Quat quat_cast(@NotNull quat_func $this, @NotNull Mat4 m, Quat res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return $this.quat_cast(m.get(0).get(0), m.get(0).get(1), m.get(0).get(2), m.get(1).get(0), m.get(1).get(1), m.get(1).get(2), m.get(2).get(0), m.get(2).get(1), m.get(2).get(2), res);
        }

        @NotNull
        public static QuatD quatD_cast(@NotNull quat_func $this, @NotNull Mat4d m, QuatD res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return $this.quatD_cast(m.get(0).get(0), m.get(0).get(1), m.get(0).get(2), m.get(1).get(0), m.get(1).get(1), m.get(1).get(2), m.get(2).get(0), m.get(2).get(1), m.get(2).get(2), res);
        }

        @NotNull
        public static Quat quat_cast(@NotNull quat_func $this, Mat4 m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return $this.quat_cast(m, new Quat());
        }

        @NotNull
        public static QuatD quatD_cast(@NotNull quat_func $this, Mat4d m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return $this.quatD_cast(m, new QuatD());
        }

        @NotNull
        public static Quat quat_cast(quat_func $this, float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, @NotNull float m22, Quat res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            float fourXSquaredMinus1 = m00 - m11 - m22;
            float fourYSquaredMinus1 = m11 - m00 - m22;
            float fourZSquaredMinus1 = m22 - m00 - m11;
            float fourWSquaredMinus1 = m00 + m11 + m22;
            int biggestIndex = 0;
            float fourBiggestSquaredMinus1 = fourWSquaredMinus1;
            if (fourXSquaredMinus1 > fourBiggestSquaredMinus1) {
                fourBiggestSquaredMinus1 = fourXSquaredMinus1;
                biggestIndex = 1;
            }
            if (fourYSquaredMinus1 > fourBiggestSquaredMinus1) {
                fourBiggestSquaredMinus1 = fourYSquaredMinus1;
                biggestIndex = 2;
            }
            if (fourZSquaredMinus1 > fourBiggestSquaredMinus1) {
                fourBiggestSquaredMinus1 = fourZSquaredMinus1;
                biggestIndex = 3;
            }
            float biggestVal = glm.INSTANCE.sqrt(fourBiggestSquaredMinus1 + 1.0f) * 0.5f;
            float mult = 0.25f / biggestVal;
            switch (biggestIndex) {
                case 0: {
                    res.w = Float.valueOf(biggestVal);
                    res.x = Float.valueOf((m12 - m21) * mult);
                    res.y = Float.valueOf((m20 - m02) * mult);
                    res.z = Float.valueOf((m01 - m10) * mult);
                    break;
                }
                case 1: {
                    res.w = Float.valueOf((m12 - m21) * mult);
                    res.x = Float.valueOf(biggestVal);
                    res.y = Float.valueOf((m01 + m10) * mult);
                    res.z = Float.valueOf((m20 + m02) * mult);
                    break;
                }
                case 2: {
                    res.w = Float.valueOf((m20 - m02) * mult);
                    res.x = Float.valueOf((m01 + m10) * mult);
                    res.y = Float.valueOf(biggestVal);
                    res.z = Float.valueOf((m12 + m21) * mult);
                    break;
                }
                case 3: {
                    res.w = Float.valueOf((m01 - m10) * mult);
                    res.x = Float.valueOf((m20 + m02) * mult);
                    res.y = Float.valueOf((m12 + m21) * mult);
                    res.z = Float.valueOf(biggestVal);
                    break;
                }
                default: {
                    boolean bl = false;
                    if (!_Assertions.ENABLED || bl) break;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
            }
            return res;
        }

        @NotNull
        public static Quat quat_cast(quat_func $this, float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
            return $this.quat_cast(m00, m01, m02, m10, m11, m12, m20, m21, m22, new Quat());
        }

        @NotNull
        public static QuatD quatD_cast(quat_func $this, double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, @NotNull double m22, QuatD res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            double fourXSquaredMinus1 = m00 - m11 - m22;
            double fourYSquaredMinus1 = m11 - m00 - m22;
            double fourZSquaredMinus1 = m22 - m00 - m11;
            double fourWSquaredMinus1 = m00 + m11 + m22;
            int biggestIndex = 0;
            double fourBiggestSquaredMinus1 = fourWSquaredMinus1;
            if (fourXSquaredMinus1 > fourBiggestSquaredMinus1) {
                fourBiggestSquaredMinus1 = fourXSquaredMinus1;
                biggestIndex = 1;
            }
            if (fourYSquaredMinus1 > fourBiggestSquaredMinus1) {
                fourBiggestSquaredMinus1 = fourYSquaredMinus1;
                biggestIndex = 2;
            }
            if (fourZSquaredMinus1 > fourBiggestSquaredMinus1) {
                fourBiggestSquaredMinus1 = fourZSquaredMinus1;
                biggestIndex = 3;
            }
            double biggestVal = glm.INSTANCE.sqrt(fourBiggestSquaredMinus1 + 1.0) * 0.5;
            double mult = 0.25 / biggestVal;
            switch (biggestIndex) {
                case 0: {
                    res.w = biggestVal;
                    res.x = (m12 - m21) * mult;
                    res.y = (m20 - m02) * mult;
                    res.z = (m01 - m10) * mult;
                    break;
                }
                case 1: {
                    res.w = (m12 - m21) * mult;
                    res.x = biggestVal;
                    res.y = (m01 + m10) * mult;
                    res.z = (m20 + m02) * mult;
                    break;
                }
                case 2: {
                    res.w = (m20 - m02) * mult;
                    res.x = (m01 + m10) * mult;
                    res.y = biggestVal;
                    res.z = (m12 + m21) * mult;
                    break;
                }
                case 3: {
                    res.w = (m01 - m10) * mult;
                    res.x = (m20 + m02) * mult;
                    res.y = (m12 + m21) * mult;
                    res.z = biggestVal;
                    break;
                }
                default: {
                    boolean bl = false;
                    if (!_Assertions.ENABLED || bl) break;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
            }
            return res;
        }

        @NotNull
        public static QuatD quatD_cast(quat_func $this, double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
            return $this.quatD_cast(m00, m01, m02, m10, m11, m12, m20, m21, m22, new QuatD());
        }

        public static float angle(@NotNull quat_func $this, Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return glm.INSTANCE.acos(q.w.floatValue()) * 2.0f;
        }

        public static double angle(@NotNull quat_func $this, QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return glm.INSTANCE.acos(q.w.doubleValue()) * 2.0;
        }

        @NotNull
        public static Vec3 axis(@NotNull quat_func $this, @NotNull Quat q, Vec3 res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            float tmp1 = 1.0f - q.w.floatValue() * q.w.floatValue();
            if (tmp1 <= 0.0f) {
                res.x = Float.valueOf(0.0f);
                res.y = Float.valueOf(0.0f);
                res.z = Float.valueOf(1.0f);
                return res;
            }
            float tmp2 = 1.0f / glm.INSTANCE.sqrt(tmp1);
            res.x = Float.valueOf(q.x.floatValue() * tmp2);
            res.y = Float.valueOf(q.y.floatValue() * tmp2);
            res.z = Float.valueOf(q.z.floatValue() * tmp2);
            return res;
        }

        @NotNull
        public static Vec3 axis(@NotNull quat_func $this, Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return $this.axis(q, new Vec3());
        }

        @NotNull
        public static Vec3d axis(@NotNull quat_func $this, @NotNull QuatD q, Vec3d res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            double tmp1 = 1.0 - q.w.doubleValue() * q.w.doubleValue();
            if (tmp1 <= 0.0) {
                res.x = 0.0;
                res.y = 0.0;
                res.z = 1.0;
                return res;
            }
            double tmp2 = 1.0 / glm.INSTANCE.sqrt(tmp1);
            res.x = q.x.doubleValue() * tmp2;
            res.y = q.y.doubleValue() * tmp2;
            res.z = q.z.doubleValue() * tmp2;
            return res;
        }

        @NotNull
        public static Vec3d axis(@NotNull quat_func $this, QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return $this.axis(q, new Vec3d());
        }

        @NotNull
        public static Quat angleAxis(quat_func $this, float angle, float axisX, float axisY, @NotNull float axisZ, Quat res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            float a = angle * 0.5f;
            float s = glm.INSTANCE.sin(a);
            res.w = Float.valueOf(glm.INSTANCE.cos(a));
            res.x = Float.valueOf(axisX * s);
            res.y = Float.valueOf(axisY * s);
            res.z = Float.valueOf(axisZ * s);
            return res;
        }

        @NotNull
        public static Quat angleAxis(quat_func $this, float angle, float axisX, float axisY, float axisZ) {
            return $this.angleAxis(angle, axisX, axisY, axisZ, new Quat());
        }

        @NotNull
        public static Quat angleAxis(quat_func $this, @NotNull float angle, @NotNull Vec3 axis, Quat res) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return $this.angleAxis(angle, axis.x.floatValue(), axis.y.floatValue(), axis.z.floatValue(), res);
        }

        @NotNull
        public static Quat angleAxis(quat_func $this, @NotNull float angle, Vec3 axis) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            return $this.angleAxis(angle, axis.x.floatValue(), axis.y.floatValue(), axis.z.floatValue(), new Quat());
        }

        @NotNull
        public static QuatD angleAxis(quat_func $this, double angle, double axisX, double axisY, @NotNull double axisZ, QuatD res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            double a = angle * 0.5;
            double s = glm.INSTANCE.sin(a);
            res.w = glm.INSTANCE.cos(a);
            res.x = axisX * s;
            res.y = axisY * s;
            res.z = axisZ * s;
            return res;
        }

        @NotNull
        public static QuatD angleAxis(quat_func $this, double angle, double axisX, double axisY, double axisZ) {
            return $this.angleAxis(angle, axisX, axisY, axisZ, new QuatD());
        }

        @NotNull
        public static QuatD angleAxis(quat_func $this, @NotNull double angle, @NotNull Vec3d axis, QuatD res) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return $this.angleAxis(angle, axis.x.doubleValue(), axis.y.doubleValue(), axis.z.doubleValue(), res);
        }

        @NotNull
        public static QuatD angleAxis(quat_func $this, @NotNull double angle, Vec3d axis) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            return $this.angleAxis(angle, axis.x.doubleValue(), axis.y.doubleValue(), axis.z.doubleValue(), new QuatD());
        }

        @NotNull
        public static Vec4bool lessThan(@NotNull quat_func $this, @NotNull Quat a, @NotNull Quat b, Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            res.setX(a.x.floatValue() < b.x.floatValue());
            res.setY(a.y.floatValue() < b.y.floatValue());
            res.setZ(a.z.floatValue() < b.z.floatValue());
            res.setW(a.w.floatValue() < b.w.floatValue());
            return res;
        }

        @NotNull
        public static Vec4bool lessThan(@NotNull quat_func $this, @NotNull Quat a, Quat b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.lessThan(a, b, new Vec4bool(false, false, false, false, 15, null));
        }

        @NotNull
        public static Vec4bool lessThanEqual(@NotNull quat_func $this, @NotNull Quat a, @NotNull Quat b, Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            res.setX(a.x.floatValue() <= b.x.floatValue());
            res.setY(a.y.floatValue() <= b.y.floatValue());
            res.setZ(a.z.floatValue() <= b.z.floatValue());
            res.setW(a.w.floatValue() <= b.w.floatValue());
            return res;
        }

        @NotNull
        public static Vec4bool lessThanEqual(@NotNull quat_func $this, @NotNull Quat a, Quat b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.lessThanEqual(a, b, new Vec4bool(false, false, false, false, 15, null));
        }

        @NotNull
        public static Vec4bool greater(@NotNull quat_func $this, @NotNull Quat a, @NotNull Quat b, Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            res.setX(a.x.floatValue() > b.x.floatValue());
            res.setY(a.y.floatValue() > b.y.floatValue());
            res.setZ(a.z.floatValue() > b.z.floatValue());
            res.setW(a.w.floatValue() > b.w.floatValue());
            return res;
        }

        @NotNull
        public static Vec4bool greater(@NotNull quat_func $this, @NotNull Quat a, Quat b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.greater(a, b, new Vec4bool(false, false, false, false, 15, null));
        }

        @NotNull
        public static Vec4bool greaterThan(@NotNull quat_func $this, @NotNull Quat a, @NotNull Quat b, Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            res.setX(a.x.floatValue() >= b.x.floatValue());
            res.setY(a.y.floatValue() >= b.y.floatValue());
            res.setZ(a.z.floatValue() >= b.z.floatValue());
            res.setW(a.w.floatValue() >= b.w.floatValue());
            return res;
        }

        @NotNull
        public static Vec4bool greaterThan(@NotNull quat_func $this, @NotNull Quat a, Quat b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.greaterThan(a, b, new Vec4bool(false, false, false, false, 15, null));
        }

        @NotNull
        public static Vec4bool equal(@NotNull quat_func $this, @NotNull Quat a, @NotNull Quat b, Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            res.setX(a.x.floatValue() == b.x.floatValue());
            res.setY(a.y.floatValue() == b.y.floatValue());
            res.setZ(a.z.floatValue() == b.z.floatValue());
            res.setW(a.w.floatValue() == b.w.floatValue());
            return res;
        }

        @NotNull
        public static Vec4bool equal(@NotNull quat_func $this, @NotNull Quat a, Quat b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.equal(a, b, new Vec4bool(false, false, false, false, 15, null));
        }

        @NotNull
        public static Vec4bool notEqual(@NotNull quat_func $this, @NotNull Quat a, @NotNull Quat b, Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            res.setX(a.x.floatValue() != b.x.floatValue());
            res.setY(a.y.floatValue() != b.y.floatValue());
            res.setZ(a.z.floatValue() != b.z.floatValue());
            res.setW(a.w.floatValue() != b.w.floatValue());
            return res;
        }

        @NotNull
        public static Vec4bool notEqual(@NotNull quat_func $this, @NotNull Quat a, Quat b) {
            Intrinsics.checkParameterIsNotNull(a, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return $this.notEqual(a, b, new Vec4bool(false, false, false, false, 15, null));
        }

        @NotNull
        public static Vec4bool isNan(@NotNull quat_func $this, @NotNull Quat q, Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            float f = q.x.floatValue();
            Vec4bool vec4bool = res;
            boolean bl = Float.isNaN(f);
            vec4bool.setX(bl);
            f = q.y.floatValue();
            vec4bool = res;
            bl = Float.isNaN(f);
            vec4bool.setY(bl);
            f = q.z.floatValue();
            vec4bool = res;
            bl = Float.isNaN(f);
            vec4bool.setZ(bl);
            f = q.w.floatValue();
            vec4bool = res;
            bl = Float.isNaN(f);
            vec4bool.setW(bl);
            return res;
        }

        @NotNull
        public static Vec4bool isNan(@NotNull quat_func $this, Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return $this.isNan(q, new Vec4bool(false, false, false, false, 15, null));
        }

        @NotNull
        public static Vec4bool isInf(@NotNull quat_func $this, @NotNull Quat q, Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            float f = q.x.floatValue();
            Vec4bool vec4bool = res;
            boolean bl = Float.isInfinite(f);
            vec4bool.setX(bl);
            f = q.y.floatValue();
            vec4bool = res;
            bl = Float.isInfinite(f);
            vec4bool.setY(bl);
            f = q.z.floatValue();
            vec4bool = res;
            bl = Float.isInfinite(f);
            vec4bool.setZ(bl);
            f = q.w.floatValue();
            vec4bool = res;
            bl = Float.isInfinite(f);
            vec4bool.setW(bl);
            return res;
        }

        @NotNull
        public static Vec4bool isInf(@NotNull quat_func $this, Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return $this.isInf(q, new Vec4bool(false, false, false, false, 15, null));
        }
    }
}

