/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.scenes.demo1;

import com.badlogic.gdx.math.Interpolation;
import com.mygdx.game.Camera;
import com.mygdx.game.Config;
import com.mygdx.game.DemoScene;
import com.mygdx.game.DrawManager;
import com.mygdx.game.LerpService;
import com.mygdx.game.Linefeed;
import com.mygdx.game.Scene;
import com.mygdx.game.Syncable;
import com.mygdx.game.Timestamp;
import com.mygdx.game.app.LightChunk;
import com.mygdx.game.app.NetworkLights;
import com.mygdx.game.drawables.TextureTerrain;
import com.mygdx.game.scenes.demo1.FinalDSC;
import glm.vec3.Vec3;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0011H\u0016J\u0010\u00103\u001a\u0002012\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u0002012\u0006\u00107\u001a\u000205H\u0016J\b\u00108\u001a\u000201H\u0016J\b\u00109\u001a\u000201H\u0016J\u0010\u0010:\u001a\u0002012\u0006\u00102\u001a\u00020\u0011H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000bR\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u0015R\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u000fR\u0014\u0010.\u001a\u00020\u0011X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0013\u00a8\u0006;"}, d2={"Lcom/mygdx/game/scenes/demo1/TriangleWaveDSC;", "Lcom/mygdx/game/DemoScene;", "Lcom/mygdx/game/Syncable;", "cfg", "Lcom/mygdx/game/Config;", "drawManager", "Lcom/mygdx/game/DrawManager;", "(Lcom/mygdx/game/Config;Lcom/mygdx/game/DrawManager;)V", "brightChunk", "Lcom/mygdx/game/app/LightChunk;", "getBrightChunk", "()Lcom/mygdx/game/app/LightChunk;", "cameraBump", "Lcom/mygdx/game/LerpService;", "getCameraBump", "()Lcom/mygdx/game/LerpService;", "cameraZBase", "", "getCameraZBase", "()F", "setCameraZBase", "(F)V", "greenChunk", "getGreenChunk", "lf", "Lcom/mygdx/game/Linefeed;", "getLf", "()Lcom/mygdx/game/Linefeed;", "rotcam", "getRotcam", "setRotcam", "softLightDrop", "", "getSoftLightDrop", "()Z", "setSoftLightDrop", "(Z)V", "syncGreenSnarehit", "getSyncGreenSnarehit", "()Lcom/mygdx/game/Syncable;", "tt", "Lcom/mygdx/game/drawables/TextureTerrain;", "getTt", "()Lcom/mygdx/game/drawables/TextureTerrain;", "zoomCameraOut", "getZoomCameraOut", "zoomedOutCameraZ", "getZoomedOutCameraZ", "dispose", "", "delta", "onEnter", "fromScene", "Lcom/mygdx/game/Scene;", "onExit", "toScene", "reset", "sync", "update", "core"})
public final class TriangleWaveDSC
extends DemoScene
implements Syncable {
    @NotNull
    private final Linefeed lf;
    @NotNull
    private final LerpService zoomCameraOut;
    private final float zoomedOutCameraZ = 0.55f;
    private float cameraZBase;
    @NotNull
    private final LerpService cameraBump;
    @NotNull
    private final TextureTerrain tt;
    @NotNull
    private final LightChunk greenChunk;
    @NotNull
    private final LightChunk brightChunk;
    @NotNull
    private final Syncable syncGreenSnarehit;
    private boolean softLightDrop;
    private float rotcam;

    @Override
    public void sync() {
        this.cameraBump.reset();
    }

    @NotNull
    public final Linefeed getLf() {
        return this.lf;
    }

    @NotNull
    public final LerpService getZoomCameraOut() {
        return this.zoomCameraOut;
    }

    public final float getZoomedOutCameraZ() {
        return this.zoomedOutCameraZ;
    }

    public final float getCameraZBase() {
        return this.cameraZBase;
    }

    public final void setCameraZBase(float f) {
        this.cameraZBase = f;
    }

    @NotNull
    public final LerpService getCameraBump() {
        return this.cameraBump;
    }

    @NotNull
    public final TextureTerrain getTt() {
        return this.tt;
    }

    @NotNull
    public final LightChunk getGreenChunk() {
        return this.greenChunk;
    }

    @NotNull
    public final LightChunk getBrightChunk() {
        return this.brightChunk;
    }

    @NotNull
    public final Syncable getSyncGreenSnarehit() {
        return this.syncGreenSnarehit;
    }

    public final boolean getSoftLightDrop() {
        return this.softLightDrop;
    }

    public final void setSoftLightDrop(boolean bl) {
        this.softLightDrop = bl;
    }

    @Override
    public void reset() {
        super.reset();
        this.tt.reset();
        this.getCfg().setScreenFadeDarkAmount(0.0f);
        this.getFadeIn().reset();
        this.getFadeIn().setEnabled(true);
        this.getCfg().setEnableBloom(true);
        this.getCfg().setEnableSkybox(true);
        this.getCfg().setBloomDiv(4.0f);
        this.getCfg().setBloomIntensity(3.5f);
        this.cameraBump.reset();
        this.cameraBump.setEnabled(true);
        this.zoomCameraOut.reset();
        this.zoomCameraOut.setEnabled(true);
        this.getFadeOut().setEnabled(false);
        this.getFadeOut().setLengthInSeconds(0.3f);
        this.softLightDrop = false;
    }

    public final float getRotcam() {
        return this.rotcam;
    }

    public final void setRotcam(float f) {
        this.rotcam = f;
    }

    @Override
    public void update(float delta) {
        super.update(delta);
        this.cameraBump.update(delta, this.getCam());
        this.zoomCameraOut.update(delta, this.getCam());
        float bumpsyncAmount = -0.025f * (1.0f - this.cameraBump.apply());
        this.getCam().getPos().z = Float.valueOf(0.08f + this.cameraZBase * this.zoomCameraOut.apply() + bumpsyncAmount);
        if (this.getCfg().getMusic().position() > 66.5f) {
            this.getFadeOut().setEnabled(true);
            this.getFadeOut().update(delta, this.getCam());
            this.getCfg().setScreenFadeDarkAmount(1.0f - this.getFadeOut().apply());
            if (this.getCfg().getScreenFadeDarkAmount() <= 0.0f) {
                this.getCfg().getSceneManager().change(Reflection.getOrCreateKotlinClass(FinalDSC.class));
            }
        } else {
            this.getCfg().setScreenFadeDarkAmount(this.getFadeIn().apply());
        }
        if (this.getCfg().getMusic().position() > 58.8f) {
            NetworkLights networkLights = this.getCfg().getNetworkLights();
            if (networkLights != null) {
                networkLights.setDropAmount(10);
            }
            this.softLightDrop = true;
        }
    }

    @Override
    public void dispose(float delta) {
    }

    @Override
    public void onEnter(@NotNull Scene fromScene) {
        Intrinsics.checkParameterIsNotNull(fromScene, "fromScene");
        this.getCfg().getMusic().addSync(this.syncGreenSnarehit, "FF01");
        NetworkLights networkLights = this.getCfg().getNetworkLights();
        if (networkLights != null) {
            networkLights.setDropAmount(50);
        }
        this.reset();
    }

    @Override
    public void onExit(@NotNull Scene toScene) {
        Intrinsics.checkParameterIsNotNull(toScene, "toScene");
        NetworkLights networkLights = this.getCfg().getNetworkLights();
        if (networkLights != null) {
            networkLights.setDropAmount(25);
        }
        this.getCfg().getMusic().removeSync(this.syncGreenSnarehit, "FF01");
    }

    public TriangleWaveDSC(@NotNull Config cfg, @NotNull DrawManager drawManager) {
        Intrinsics.checkParameterIsNotNull(cfg, "cfg");
        Intrinsics.checkParameterIsNotNull(drawManager, "drawManager");
        super(cfg, drawManager, new Timestamp(0, 0, 51.71f));
        this.lf = new Linefeed(cfg, this.getDebug(), 1024, 1.0f, true);
        Interpolation.ExpOut expOut = Interpolation.exp5Out;
        Intrinsics.checkExpressionValueIsNotNull(expOut, "Interpolation.exp5Out");
        this.zoomCameraOut = new LerpService(cfg, expOut, 5.0f);
        this.zoomedOutCameraZ = 0.55f;
        this.cameraZBase = 0.55f;
        Interpolation.Exp exp = Interpolation.exp5;
        Intrinsics.checkExpressionValueIsNotNull(exp, "Interpolation.exp5");
        this.cameraBump = new LerpService(cfg, exp, 0.5f);
        this.tt = new TextureTerrain(cfg);
        this.greenChunk = new LightChunk(cfg, new int[]{0, 21});
        this.brightChunk = new LightChunk(cfg, new int[]{23, 22, 19, 18, 2, 3});
        this.syncGreenSnarehit = new Syncable(this){
            final /* synthetic */ TriangleWaveDSC this$0;

            public void sync() {
                this.this$0.getTt().sync();
                if (!this.this$0.getSoftLightDrop()) {
                    this.this$0.getGreenChunk().setValue(0.0f, 1.0f, 0.0f);
                } else {
                    this.this$0.getBrightChunk().setValue(0.7f, 0.8f, 1.0f);
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        this.setCam(new Camera(cfg, new Vec3((Number)0, (Number)0, Float.valueOf(this.cameraZBase)), new Vec3((Number)0, (Number)0, (Number)0), null, 8, null));
        this.tt.setPos(new Vec3(-0.5, -0.5, (Number)0));
        this.getDrawables().add(this.tt);
        this.getDrawables().add(this.lf);
        this.reset();
    }
}

