/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.scenes.demo1;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.utils.Array;
import com.mygdx.game.Camera;
import com.mygdx.game.Config;
import com.mygdx.game.CoordFloor;
import com.mygdx.game.DemoScene;
import com.mygdx.game.DrawManager;
import com.mygdx.game.Linefeed;
import com.mygdx.game.Scene;
import com.mygdx.game.Syncable;
import com.mygdx.game.Timestamp;
import com.mygdx.game.app.LightChunk;
import com.mygdx.game.drawables.CameraPath;
import com.mygdx.game.drawables.Sphere;
import com.mygdx.game.scenes.demo1.EyesDSC;
import glm.glm;
import glm.mat4x4.Mat4;
import glm.vec3.Vec3;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0018H\u0016J\u0010\u0010;\u001a\u0002092\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u0002092\u0006\u0010?\u001a\u00020=H\u0016J\b\u0010@\u001a\u000209H\u0016J\b\u0010A\u001a\u000209H\u0016J\u0010\u0010B\u001a\u0002092\u0006\u0010:\u001a\u00020\u0018H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001a\u0010\u0014\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\rR\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010&R\u0011\u0010)\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010&R\u001a\u0010+\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u000e\u00100\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00101\u001a\u000202\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u001a\u00105\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010-\"\u0004\b7\u0010/\u00a8\u0006C"}, d2={"Lcom/mygdx/game/scenes/demo1/StartContinueDSC;", "Lcom/mygdx/game/DemoScene;", "Lcom/mygdx/game/Syncable;", "cfg", "Lcom/mygdx/game/Config;", "drawManager", "Lcom/mygdx/game/DrawManager;", "(Lcom/mygdx/game/Config;Lcom/mygdx/game/DrawManager;)V", "cp1", "Lcom/mygdx/game/drawables/CameraPath;", "getCp1", "()Lcom/mygdx/game/drawables/CameraPath;", "setCp1", "(Lcom/mygdx/game/drawables/CameraPath;)V", "cp2", "getCp2", "setCp2", "cp3", "getCp3", "setCp3", "cp4", "getCp4", "setCp4", "fadeout_slide", "", "floor", "Lcom/mygdx/game/CoordFloor;", "getFloor", "()Lcom/mygdx/game/CoordFloor;", "lf", "Lcom/mygdx/game/Linefeed;", "getLf", "()Lcom/mygdx/game/Linefeed;", "lf2", "getLf2", "lightChunkCyan", "Lcom/mygdx/game/app/LightChunk;", "getLightChunkCyan", "()Lcom/mygdx/game/app/LightChunk;", "lightChunkGreen", "getLightChunkGreen", "lightChunkPink", "getLightChunkPink", "sangle", "getSangle", "()F", "setSangle", "(F)V", "sinrun", "sphere", "Lcom/mygdx/game/drawables/Sphere;", "getSphere", "()Lcom/mygdx/game/drawables/Sphere;", "sphere_jiggle", "getSphere_jiggle", "setSphere_jiggle", "dispose", "", "delta", "onEnter", "fromScene", "Lcom/mygdx/game/Scene;", "onExit", "toScene", "reset", "sync", "update", "core"})
public final class StartContinueDSC
extends DemoScene
implements Syncable {
    @NotNull
    private final Linefeed lf;
    @NotNull
    private final Linefeed lf2;
    @NotNull
    private final Sphere sphere;
    private float sangle;
    @NotNull
    private final LightChunk lightChunkGreen;
    @NotNull
    private final LightChunk lightChunkPink;
    @NotNull
    private final LightChunk lightChunkCyan;
    @NotNull
    private final CoordFloor floor;
    @NotNull
    private CameraPath cp1;
    @NotNull
    private CameraPath cp2;
    @NotNull
    private CameraPath cp3;
    @NotNull
    private CameraPath cp4;
    private float sphere_jiggle;
    private float sinrun;
    private float fadeout_slide;

    @Override
    public void sync() {
        this.getCfg().setBloomDiv(16.0f);
        this.getCfg().setBloomIntensity(4.0f);
        this.lightChunkGreen.setValue(0.0f, 1.0f, 0.2f);
        this.lightChunkPink.setValue(0.71f, 0.39f, 0.8f);
    }

    @NotNull
    public final Linefeed getLf() {
        return this.lf;
    }

    @NotNull
    public final Linefeed getLf2() {
        return this.lf2;
    }

    @NotNull
    public final Sphere getSphere() {
        return this.sphere;
    }

    public final float getSangle() {
        return this.sangle;
    }

    public final void setSangle(float f) {
        this.sangle = f;
    }

    @NotNull
    public final LightChunk getLightChunkGreen() {
        return this.lightChunkGreen;
    }

    @NotNull
    public final LightChunk getLightChunkPink() {
        return this.lightChunkPink;
    }

    @NotNull
    public final LightChunk getLightChunkCyan() {
        return this.lightChunkCyan;
    }

    @NotNull
    public final CoordFloor getFloor() {
        return this.floor;
    }

    @NotNull
    public final CameraPath getCp1() {
        return this.cp1;
    }

    public final void setCp1(@NotNull CameraPath cameraPath) {
        Intrinsics.checkParameterIsNotNull(cameraPath, "<set-?>");
        this.cp1 = cameraPath;
    }

    @NotNull
    public final CameraPath getCp2() {
        return this.cp2;
    }

    public final void setCp2(@NotNull CameraPath cameraPath) {
        Intrinsics.checkParameterIsNotNull(cameraPath, "<set-?>");
        this.cp2 = cameraPath;
    }

    @NotNull
    public final CameraPath getCp3() {
        return this.cp3;
    }

    public final void setCp3(@NotNull CameraPath cameraPath) {
        Intrinsics.checkParameterIsNotNull(cameraPath, "<set-?>");
        this.cp3 = cameraPath;
    }

    @NotNull
    public final CameraPath getCp4() {
        return this.cp4;
    }

    public final void setCp4(@NotNull CameraPath cameraPath) {
        Intrinsics.checkParameterIsNotNull(cameraPath, "<set-?>");
        this.cp4 = cameraPath;
    }

    public final float getSphere_jiggle() {
        return this.sphere_jiggle;
    }

    public final void setSphere_jiggle(float f) {
        this.sphere_jiggle = f;
    }

    @Override
    public void reset() {
        super.reset();
        this.getCam().setPos(new Vec3((Number)-3, 0.5, Float.valueOf(4.0f)));
        this.floor.setPos(new Vec3((Number)0, Float.valueOf(-1.0f), (Number)0));
        this.fadeout_slide = 0.0f;
        this.sphere_jiggle = 0.0f;
        this.sphere.setPos(new Vec3((Number)0, Float.valueOf(0.2f), (Number)0));
        this.sangle = 0.0f;
        this.sphere.setGradualSin(0.0f);
        this.sphere.getLines().setBaseColor(new Color(0.0f, 1.0f, 0.2f, 1.0f));
        this.cp1.setAt(0.0f);
        this.cp1.setLookatObject(this.sphere);
        this.cp1.setAttachedCamera(this.getCam());
        this.cp2.setAt(0.0f);
        this.cp2.setLookatObject(this.sphere);
        this.cp2.setAttachedCamera(null);
        this.cp3.setAt(0.0f);
        this.cp3.setLookatObject(this.sphere);
        this.cp3.setAttachedCamera(null);
        this.cp4.setAt(0.0f);
        this.cp4.setLookatObject(this.sphere);
        this.cp4.setAttachedCamera(null);
        this.getCfg().setEnableSkybox(true);
        this.getCfg().setEnableBloom(true);
        this.getCfg().setScreenFadeDarkAmount(0.0f);
    }

    @Override
    public void update(float delta) {
        float f;
        Object object;
        float f2;
        if (this.getCfg().getBloomDiv() > 4.0f) {
            Config config = this.getCfg();
            config.setBloomDiv(config.getBloomDiv() - delta * 18.0f);
        }
        if (this.getCfg().getBloomIntensity() > 2.0f) {
            float f3 = this.getCfg().getBloomIntensity() - delta * 5.0f;
            f2 = 2.0f;
            object = this.getCfg();
            f = Math.max(f3, f2);
            ((Config)object).setBloomIntensity(f);
        }
        this.getDebug().addScreenMsg("sangle", Float.valueOf(this.sangle));
        Camera camera = this.getCam();
        if (Intrinsics.areEqual(camera, this.cp1.getAttachedCamera())) {
            this.sangle += delta;
            Config config = this.getCfg();
            config.setScreenFadeDarkAmount(config.getScreenFadeDarkAmount() + delta);
            CameraPath cameraPath = this.cp1;
            cameraPath.setAt(cameraPath.getAt() + delta * 0.2f);
            if (this.getCfg().getMusic().position() >= 32.62f) {
                this.cp1.setAttachedCamera(null);
                this.cp2.setAttachedCamera(this.getCam());
            }
        } else if (Intrinsics.areEqual(camera, this.cp2.getAttachedCamera())) {
            this.sangle += delta;
            CameraPath cameraPath = this.cp2;
            cameraPath.setAt(cameraPath.getAt() + delta * 0.2f);
            if (this.getCfg().getMusic().position() >= 35.0f) {
                // empty if block
            }
            if (this.getCfg().getMusic().position() >= 36.4f) {
                this.cp2.setAttachedCamera(null);
                this.cp3.setAttachedCamera(this.getCam());
            }
        } else if (Intrinsics.areEqual(camera, this.cp3.getAttachedCamera())) {
            this.sinrun += delta;
            f2 = this.sinrun;
            object = this;
            f = (float)Math.sin(f2);
            ((StartContinueDSC)object).sangle = f * (float)Math.PI + (float)Math.PI;
            CameraPath cameraPath = this.cp3;
            cameraPath.setAt(cameraPath.getAt() + delta * 0.2f);
            this.sphere.setGradualSin(0.4f);
            if ((double)this.getCfg().getMusic().position() >= 40.167) {
                this.cp3.setAttachedCamera(null);
                this.cp4.setAt(0.0f);
                this.cp4.setAttachedCamera(this.getCam());
            }
        } else if (Intrinsics.areEqual(camera, this.cp4.getAttachedCamera())) {
            this.sinrun += delta;
            f2 = this.sinrun;
            object = this;
            f = (float)Math.sin(f2);
            ((StartContinueDSC)object).sangle = f * (float)Math.PI + (float)Math.PI;
            CameraPath cameraPath = this.cp4;
            cameraPath.setAt(cameraPath.getAt() + delta * 0.2f);
            this.sphere.setGradualSin(0.2f);
            if (this.getCfg().getMusic().position() > 43.445f) {
                this.fadeout_slide += delta;
                float progress = Math.min(1.0f, this.fadeout_slide / 0.8f);
                this.getCfg().setScreenFadeDarkAmount(1.0f - Interpolation.linear.apply(progress));
                if (this.getCfg().getScreenFadeDarkAmount() <= 0.0f) {
                    this.getCfg().getSceneManager().change(Reflection.getOrCreateKotlinClass(EyesDSC.class));
                }
            }
        }
    }

    @Override
    public void dispose(float delta) {
    }

    @Override
    public void onEnter(@NotNull Scene fromScene) {
        Intrinsics.checkParameterIsNotNull(fromScene, "fromScene");
        this.reset();
        this.getCfg().getMusic().addSync((Syncable)this, "FF02");
        this.getCfg().getMusic().addSync((Syncable)this.sphere, "FF01");
    }

    @Override
    public void onExit(@NotNull Scene toScene) {
        Intrinsics.checkParameterIsNotNull(toScene, "toScene");
        this.getCfg().getMusic().removeSync((Syncable)this, "FF02");
        this.getCfg().getMusic().removeSync((Syncable)this.sphere, "FF01");
    }

    public StartContinueDSC(@NotNull Config cfg, @NotNull DrawManager drawManager) {
        Intrinsics.checkParameterIsNotNull(cfg, "cfg");
        Intrinsics.checkParameterIsNotNull(drawManager, "drawManager");
        super(cfg, drawManager, new Timestamp(0, 0, 28.932f));
        this.lf = new Linefeed(cfg, this.getDebug(), 800, 1.3f, false, 16, null);
        this.lf2 = new Linefeed(cfg, this.getDebug(), 800, 1.0f, false, 16, null);
        this.sphere = new Sphere(cfg, 190, this.lf, null, null, 24, null);
        this.lightChunkGreen = new LightChunk(cfg, new int[]{3, 1, 21, 19});
        this.lightChunkPink = new LightChunk(cfg, new int[]{2, 0, 20, 18});
        this.lightChunkCyan = new LightChunk(cfg, new int[]{0, 21});
        this.floor = new CoordFloor(cfg, null, this.lf2, 8);
        this.setCam(new Camera(cfg, new Vec3((Number)0, (Number)0, (Number)-5), null, null, 12, null));
        this.cp1 = new CameraPath(cfg, null, (Array)((Function0)1.INSTANCE).invoke(), false);
        this.cp2 = new CameraPath(cfg, null, (Array)((Function0)2.INSTANCE).invoke(), false);
        this.cp3 = new CameraPath(cfg, null, (Array)((Function0)3.INSTANCE).invoke(), false);
        this.cp4 = new CameraPath(cfg, null, (Array)((Function0)4.INSTANCE).invoke(), false);
        this.getDrawables().add(this.floor);
        this.getDrawables().add(this.sphere);
        this.getDrawables().add(this.lf);
        this.getDrawables().add(this.lf2);
        this.getDrawables().add(this.cp1);
        this.getDrawables().add(this.cp2);
        this.getDrawables().add(this.cp3);
        this.getDrawables().add(this.cp4);
        this.sphere.setUpdateAction((Function2<? super Sphere, ? super Float, Unit>)new Function2<Sphere, Float, Unit>(){

            @Override
            public final void invoke(@NotNull Sphere s, float delta) {
                Intrinsics.checkParameterIsNotNull(s, "s");
                if (s.getUscale() > 1.0f) {
                    float f = 1.0f;
                    float f2 = s.getUscale() - delta * 2.0f;
                    Sphere sphere = s;
                    float f3 = Math.max(f, f2);
                    sphere.setUscale(f3);
                }
                s.setModel(new Mat4());
                s.setModel(glm.INSTANCE.translate(s.getModel(), s.getPos()));
                s.setModel(glm.INSTANCE.rotate(s.getModel(), this.getSangle(), new Vec3((Number)1, Float.valueOf(0.4f), Float.valueOf(0.0f))));
                s.setModel(glm.INSTANCE.scale(s.getModel(), s.getUscale(), s.getUscale(), s.getUscale()));
            }
        });
        this.sphere.setSyncAction((Function1<? super Sphere, Unit>)new Function1<Sphere, Unit>(){

            @Override
            public final void invoke(@NotNull Sphere s) {
                Intrinsics.checkParameterIsNotNull(s, "s");
                s.setUscale(1.3f);
                this.getLightChunkCyan().setValue(0, 200, 200);
            }
        });
    }
}

