/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.drawables;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.utils.Array;
import com.mygdx.game.Camera;
import com.mygdx.game.Config;
import com.mygdx.game.DrawableMesh;
import com.mygdx.game.InitDemoException;
import com.mygdx.game.LerpService;
import com.mygdx.game.Syncable;
import com.mygdx.game.UtilsKt;
import com.mygdx.game.VertexBlock;
import glm.glm;
import glm.mat3x3.Mat3;
import glm.mat4x4.Mat4;
import glm.vec2.Vec2;
import glm.vec3.Vec3;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0003ghiB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010Z\u001a\u00020\u000f2\u0006\u0010[\u001a\u00020KJ\u000e\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020_J\u0018\u0010`\u001a\u00020]2\u0006\u0010a\u001a\u00020\u000b2\u0006\u0010b\u001a\u00020cH\u0016J\b\u0010d\u001a\u00020]H\u0016J\b\u0010e\u001a\u00020]H\u0016J\u0018\u0010f\u001a\u00020]2\u0006\u0010a\u001a\u00020\u000b2\u0006\u0010b\u001a\u00020cH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\r\"\u0004\b\u0016\u0010\u0017R!\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u001a0\u0019j\b\u0012\u0004\u0012\u00020\u001a`\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0011\"\u0004\b \u0010\u0013R\u001a\u0010!\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0011\"\u0004\b#\u0010\u0013R\u000e\u0010$\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\r\"\u0004\b'\u0010\u0017R\u0014\u0010(\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\rR\u001a\u0010*\u001a\u00020+X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0014\u00100\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\tR\u0011\u00102\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u001a\u00106\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\r\"\u0004\b8\u0010\u0017R\u001a\u00109\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\r\"\u0004\b;\u0010\u0017R\u0011\u0010<\u001a\u00020=\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u001a\u0010@\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\u0011\"\u0004\bB\u0010\u0013R\u0011\u0010C\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u00105R\u001a\u0010E\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010\r\"\u0004\bG\u0010\u0017R\u0011\u0010H\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u00105R!\u0010J\u001a\u0012\u0012\u0004\u0012\u00020K0\u0019j\b\u0012\u0004\u0012\u00020K`\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010\u001dR\u0011\u0010M\u001a\u00020N\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010PR\u001a\u0010Q\u001a\u00020RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VR\u0011\u0010W\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u00105R\u000e\u0010Y\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006j"}, d2={"Lcom/mygdx/game/drawables/TextureTerrain;", "Lcom/mygdx/game/DrawableMesh;", "Lcom/mygdx/game/Syncable;", "cfg", "Lcom/mygdx/game/Config;", "(Lcom/mygdx/game/Config;)V", "MAX_VERTS", "", "getMAX_VERTS", "()I", "am", "", "getAm", "()F", "ambientLight", "Lglm/vec3/Vec3;", "getAmbientLight", "()Lglm/vec3/Vec3;", "setAmbientLight", "(Lglm/vec3/Vec3;)V", "baseSpecStrength", "getBaseSpecStrength", "setBaseSpecStrength", "(F)V", "indices", "Lcom/badlogic/gdx/utils/Array;", "", "Lktx/collections/GdxArray;", "getIndices", "()Lcom/badlogic/gdx/utils/Array;", "lightColor", "getLightColor", "setLightColor", "lightPos", "getLightPos", "setLightPos", "lightPosX", "lightStrength", "getLightStrength", "setLightStrength", "lightStrengthBase", "getLightStrengthBase", "mesh", "Lcom/badlogic/gdx/graphics/Mesh;", "getMesh", "()Lcom/badlogic/gdx/graphics/Mesh;", "setMesh", "(Lcom/badlogic/gdx/graphics/Mesh;)V", "pointsPerSide", "getPointsPerSide", "putLightsOnLerp", "Lcom/mygdx/game/LerpService;", "getPutLightsOnLerp", "()Lcom/mygdx/game/LerpService;", "siner", "getSiner", "setSiner", "siner2", "getSiner2", "setSiner2", "sp", "Lcom/badlogic/gdx/graphics/glutils/ShaderProgram;", "getSp", "()Lcom/badlogic/gdx/graphics/glutils/ShaderProgram;", "specColor", "getSpecColor", "setSpecColor", "specFadeIn", "getSpecFadeIn", "specStrength", "getSpecStrength", "setSpecStrength", "specSynclerp", "getSpecSynclerp", "storage", "Lcom/mygdx/game/drawables/TextureTerrain$Storage;", "getStorage", "texture", "Lcom/badlogic/gdx/graphics/Texture;", "getTexture", "()Lcom/badlogic/gdx/graphics/Texture;", "vertices", "Lcom/mygdx/game/VertexBlock;", "getVertices", "()Lcom/mygdx/game/VertexBlock;", "setVertices", "(Lcom/mygdx/game/VertexBlock;)V", "zIntensityLerp", "getZIntensityLerp", "zSlideIntensity", "calculateNormal", "s", "doMagic", "", "modelMat", "Lglm/mat4x4/Mat4;", "render", "delta", "cam", "Lcom/mygdx/game/Camera;", "reset", "sync", "update", "Face", "Or", "Storage", "core"})
public final class TextureTerrain
extends DrawableMesh
implements Syncable {
    private final int MAX_VERTS;
    @NotNull
    private Mesh mesh;
    @NotNull
    private VertexBlock vertices;
    @NotNull
    private final ShaderProgram sp;
    @NotNull
    private final Texture texture;
    @NotNull
    private final LerpService specFadeIn;
    @NotNull
    private final LerpService specSynclerp;
    @NotNull
    private final LerpService putLightsOnLerp;
    @NotNull
    private final LerpService zIntensityLerp;
    @NotNull
    private final Array<Storage> storage;
    @NotNull
    private final Array<Short> indices;
    private final int pointsPerSide = 16;
    private float siner;
    private float siner2;
    private float lightPosX;
    private float zSlideIntensity;
    @NotNull
    private Vec3 lightPos;
    @NotNull
    private Vec3 lightColor;
    private final float am = 0.1f;
    @NotNull
    private Vec3 ambientLight;
    @NotNull
    private Vec3 specColor;
    private float baseSpecStrength;
    private float specStrength;
    private final float lightStrengthBase = 0.1f;
    private float lightStrength;

    @Override
    public int getMAX_VERTS() {
        return this.MAX_VERTS;
    }

    @Override
    @NotNull
    public Mesh getMesh() {
        return this.mesh;
    }

    @Override
    public void setMesh(@NotNull Mesh mesh) {
        Intrinsics.checkParameterIsNotNull(mesh, "<set-?>");
        this.mesh = mesh;
    }

    @Override
    @NotNull
    public VertexBlock getVertices() {
        return this.vertices;
    }

    @Override
    public void setVertices(@NotNull VertexBlock vertexBlock) {
        Intrinsics.checkParameterIsNotNull(vertexBlock, "<set-?>");
        this.vertices = vertexBlock;
    }

    @NotNull
    public final ShaderProgram getSp() {
        return this.sp;
    }

    @NotNull
    public final Texture getTexture() {
        return this.texture;
    }

    @NotNull
    public final LerpService getSpecFadeIn() {
        return this.specFadeIn;
    }

    @NotNull
    public final LerpService getSpecSynclerp() {
        return this.specSynclerp;
    }

    @NotNull
    public final LerpService getPutLightsOnLerp() {
        return this.putLightsOnLerp;
    }

    @NotNull
    public final LerpService getZIntensityLerp() {
        return this.zIntensityLerp;
    }

    @NotNull
    public final Array<Storage> getStorage() {
        return this.storage;
    }

    @NotNull
    public final Array<Short> getIndices() {
        return this.indices;
    }

    public final int getPointsPerSide() {
        return this.pointsPerSide;
    }

    public final float getSiner() {
        return this.siner;
    }

    public final void setSiner(float f) {
        this.siner = f;
    }

    public final float getSiner2() {
        return this.siner2;
    }

    public final void setSiner2(float f) {
        this.siner2 = f;
    }

    @Override
    public void update(float delta, @NotNull Camera cam) {
        Intrinsics.checkParameterIsNotNull(cam, "cam");
        this.siner2 += delta * 3.0f;
        this.siner += delta * 1.5f;
        this.specSynclerp.update(delta, cam);
        this.specFadeIn.update(delta, cam);
        this.baseSpecStrength = 0.9f * this.specFadeIn.apply();
        this.zIntensityLerp.update(delta, cam);
        if (this.getCfg().getMusic().position() > 58.0f) {
            this.zIntensityLerp.setEnabled(true);
        }
        this.zSlideIntensity = 0.9f * this.zIntensityLerp.apply();
        this.specStrength = this.baseSpecStrength + 1.2f * (1.0f - this.specSynclerp.apply());
        this.lightPosX += delta;
        float f = this.lightPosX;
        Vec3 vec3 = this.lightPos;
        float f2 = (float)Math.sin(f);
        vec3.x = Float.valueOf(f2 * 0.3f);
        this.putLightsOnLerp.update(delta, cam);
        this.lightStrength = this.lightStrengthBase + 0.4f * this.putLightsOnLerp.apply();
        if (this.getCfg().getMusic().position() > 59.0f) {
            this.putLightsOnLerp.setEnabled(true);
            this.specColor = this.lightColor;
        }
    }

    @NotNull
    public final Vec3 calculateNormal(@NotNull Storage s) {
        Intrinsics.checkParameterIsNotNull(s, "s");
        Array<Vec3> norms = new Array<Vec3>();
        Iterable $receiver$iv = s.getNbFaces();
        for (Object element$iv : $receiver$iv) {
            Face it = (Face)element$iv;
            Vec3 a = this.storage.get(it.getA()).getPos();
            Vec3 b = this.storage.get(it.getB()).getPos();
            Vec3 c = this.storage.get(it.getC()).getPos();
            norms.add(UtilsKt.calcNorm(a, b, c));
        }
        Vec3 out = new Vec3();
        Iterable $receiver$iv2 = norms;
        for (Object element$iv : $receiver$iv2) {
            Vec3 it;
            Vec3 vec3 = it = (Vec3)element$iv;
            Intrinsics.checkExpressionValueIsNotNull(vec3, "it");
            out = out.plus(vec3);
        }
        return Vec3.normalize$default(out, null, 1, null);
    }

    public final void doMagic(@NotNull Mat4 modelMat) {
        Intrinsics.checkParameterIsNotNull(modelMat, "modelMat");
        float jump = 0.0f;
        Mat3 normalFix = new Mat3(glm.INSTANCE.transpose(glm.INSTANCE.inverse(modelMat)));
        Iterable $receiver$iv = this.storage;
        for (Object element$iv : $receiver$iv) {
            Storage it;
            Storage storage = it = (Storage)element$iv;
            Intrinsics.checkExpressionValueIsNotNull(storage, "it");
            Vec3 out = this.calculateNormal(storage);
            float f = this.siner + (jump += 0.9f);
            Vec3 vec3 = it.getPos();
            float f2 = (float)Math.sin(f);
            vec3.z = Float.valueOf(f2 * (1.0f / (float)this.pointsPerSide) * this.zSlideIntensity);
            float x = it.getPos().x.floatValue();
            float y = it.getPos().y.floatValue();
            Vec3 vec32 = it.getPos();
            float f3 = this.siner + jump * 0.1f;
            f2 = vec32.x.floatValue();
            vec3 = vec32;
            float f4 = (float)Math.sin(f3);
            vec3.x = Float.valueOf(f2 + f4 * (0.5f / (float)this.pointsPerSide));
            Vec3 vec33 = it.getPos();
            f3 = this.siner + jump * 0.4f;
            f2 = vec33.y.floatValue();
            vec3 = vec33;
            f4 = (float)Math.sin(f3);
            vec3.y = Float.valueOf(f2 + f4 * (0.5f / (float)this.pointsPerSide) * 0.5f);
            out = normalFix.times(out);
            this.getVertices().queueVertex(it.getPos(), out, it.getUv());
            it.getPos().x = Float.valueOf(x);
            it.getPos().y = Float.valueOf(y);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.specSynclerp.reset();
        this.specSynclerp.setEnabled(true);
        this.zIntensityLerp.reset();
        this.zIntensityLerp.setEnabled(false);
        this.specFadeIn.reset();
        this.specFadeIn.setEnabled(true);
        this.lightPosX = 0.0f;
        this.putLightsOnLerp.reset();
        this.putLightsOnLerp.setEnabled(false);
        this.specColor = new Vec3((Number)0, (Number)1, Float.valueOf(0.4f));
    }

    @Override
    public void sync() {
        this.specSynclerp.reset();
    }

    @NotNull
    public final Vec3 getLightPos() {
        return this.lightPos;
    }

    public final void setLightPos(@NotNull Vec3 vec3) {
        Intrinsics.checkParameterIsNotNull(vec3, "<set-?>");
        this.lightPos = vec3;
    }

    @NotNull
    public final Vec3 getLightColor() {
        return this.lightColor;
    }

    public final void setLightColor(@NotNull Vec3 vec3) {
        Intrinsics.checkParameterIsNotNull(vec3, "<set-?>");
        this.lightColor = vec3;
    }

    public final float getAm() {
        return this.am;
    }

    @NotNull
    public final Vec3 getAmbientLight() {
        return this.ambientLight;
    }

    public final void setAmbientLight(@NotNull Vec3 vec3) {
        Intrinsics.checkParameterIsNotNull(vec3, "<set-?>");
        this.ambientLight = vec3;
    }

    @NotNull
    public final Vec3 getSpecColor() {
        return this.specColor;
    }

    public final void setSpecColor(@NotNull Vec3 vec3) {
        Intrinsics.checkParameterIsNotNull(vec3, "<set-?>");
        this.specColor = vec3;
    }

    public final float getBaseSpecStrength() {
        return this.baseSpecStrength;
    }

    public final void setBaseSpecStrength(float f) {
        this.baseSpecStrength = f;
    }

    public final float getSpecStrength() {
        return this.specStrength;
    }

    public final void setSpecStrength(float f) {
        this.specStrength = f;
    }

    public final float getLightStrengthBase() {
        return this.lightStrengthBase;
    }

    public final float getLightStrength() {
        return this.lightStrength;
    }

    public final void setLightStrength(float f) {
        this.lightStrength = f;
    }

    @Override
    public void render(float delta, @NotNull Camera cam) {
        Intrinsics.checkParameterIsNotNull(cam, "cam");
        boolean flipx = false;
        Gdx.gl20.glEnable(2884);
        Gdx.gl20.glEnable(2884);
        Gdx.gl20.glCullFace(1029);
        Gdx.gl20.glFrontFace(2304);
        Gdx.gl20.glEnable(3042);
        Gdx.gl20.glBlendFunc(770, 771);
        this.getMesh().setVertices(this.getVertices().getVertices());
        ShaderProgram $receiver$iv = this.sp;
        $receiver$iv.begin();
        ShaderProgram it = $receiver$iv;
        this.sp.setUniform3fv("lightColor", UtilsKt.vec3ToFloatAr(this.lightColor), 0, 3);
        this.sp.setUniform3fv("lightPos", UtilsKt.vec3ToFloatAr(this.lightPos), 0, 3);
        this.sp.setUniform3fv("ambientColor", UtilsKt.vec3ToFloatAr(this.ambientLight), 0, 3);
        this.sp.setUniform3fv("specColor", UtilsKt.vec3ToFloatAr(this.specColor), 0, 3);
        this.sp.setUniform3fv("camPos", UtilsKt.vec3ToFloatAr(cam.getPos()), 0, 3);
        this.sp.setUniformf("lightStrength", this.lightStrength);
        this.sp.setUniformf("specStrength", this.specStrength);
        this.setModelMat(new Mat4());
        float scl = 0.8f;
        this.setModelMat(glm.INSTANCE.scale(this.getModelMat(), new Vec3(scl, scl, scl)));
        this.setModelMat(glm.INSTANCE.translate(this.getModelMat(), this.getPos()));
        this.doMagic(this.getModelMat());
        UtilsKt.setUniformMatrix(this.sp, this.getModelMat(), "model");
        UtilsKt.setUniformMatrix(this.sp, cam.projection(), "proj");
        UtilsKt.setUniformMatrix(this.sp, cam.view(), "view");
        Gdx.gl20.glActiveTexture(33984);
        this.texture.bind();
        this.sp.setUniformi("texture", 0);
        Gdx.gl20.glActiveTexture(33984);
        VertexBlock.flush$default(this.getVertices(), this.getMesh(), this.sp, 4, 0, true, 0, 32, null);
        Gdx.gl20.glDisable(2884);
        Gdx.gl20.glDisable(3042);
        $receiver$iv.end();
    }

    /*
     * WARNING - void declaration
     */
    public TextureTerrain(@NotNull Config cfg) {
        void path$iv;
        void $receiver$iv;
        int i;
        int y;
        void x;
        Intrinsics.checkParameterIsNotNull(cfg, "cfg");
        super(cfg);
        this.MAX_VERTS = 4374 * this.getPOSITION_COMPONENTS() * this.getNORMAL_COMPONENTS();
        this.mesh = new Mesh(true, this.getMAX_VERTS(), this.getMAX_VERTS(), new VertexAttribute(1, this.getPOSITION_COMPONENTS(), "a_position"), new VertexAttribute(8, this.getNORMAL_COMPONENTS(), "a_normal"), new VertexAttribute(16, this.getTEXTURE_COMPONENTS(), "a_texCoords"));
        this.vertices = new VertexBlock(this.getMAX_VERTS());
        this.sp = cfg.getShader("textureterrain");
        Interpolation interpolation = Interpolation.linear;
        Intrinsics.checkExpressionValueIsNotNull(interpolation, "Interpolation.linear");
        this.specFadeIn = new LerpService(cfg, interpolation, 5.0f);
        Interpolation.Exp exp = Interpolation.exp5;
        Intrinsics.checkExpressionValueIsNotNull(exp, "Interpolation.exp5");
        this.specSynclerp = new LerpService(cfg, exp, 0.3f);
        Interpolation interpolation2 = Interpolation.linear;
        Intrinsics.checkExpressionValueIsNotNull(interpolation2, "Interpolation.linear");
        this.putLightsOnLerp = new LerpService(cfg, interpolation2, 1.7f);
        Interpolation.Exp exp2 = Interpolation.exp5;
        Intrinsics.checkExpressionValueIsNotNull(exp2, "Interpolation.exp5");
        this.zIntensityLerp = new LerpService(cfg, exp2, 2.0f);
        TextureTerrain textureTerrain = this;
        boolean ordered$iv = true;
        int initialCapacity$iv = 16;
        Object object = new Array(ordered$iv, initialCapacity$iv, Storage.class);
        textureTerrain.storage = object;
        textureTerrain = this;
        ordered$iv = true;
        initialCapacity$iv = 16;
        object = new Array(ordered$iv, initialCapacity$iv, Short.class);
        textureTerrain.indices = object;
        this.pointsPerSide = 16;
        if (this.pointsPerSide % 2 != 0) {
            throw (Throwable)new InitDemoException("points per side can't be odd.");
        }
        float ratio = 1.0f / (float)(this.pointsPerSide - 1);
        initialCapacity$iv = 0;
        int $i$f$gdxArrayOf22 = this.pointsPerSide - 1;
        if (initialCapacity$iv <= $i$f$gdxArrayOf22) {
            while (true) {
                int n;
                int n2;
                if ((n2 = 0) <= (n = this.pointsPerSide - 1)) {
                    while (true) {
                        Vec3 a = new Vec3((Number)((int)x), (Number)y, (Number)0).times(ratio);
                        Vec3 norm = new Vec3();
                        this.storage.add(new Storage(a, norm, new Vec2(a.x.floatValue(), a.y.floatValue()), null, 8, null));
                        if (x == n) break;
                        ++x;
                    }
                }
                if (y == $i$f$gdxArrayOf22) break;
                ++y;
            }
        }
        if ((y = 0) <= ($i$f$gdxArrayOf22 = this.storage.size - 1)) {
            while (true) {
                x = i % this.pointsPerSide;
                int y2 = i / this.pointsPerSide;
                int curIndex = y2 * this.pointsPerSide + x;
                int[] positions = new int[]{-1, -1, -1, -1, -1, -1};
                if (y2 < this.pointsPerSide - 1) {
                    positions[Or.UP.getI()] = (y2 + 1) * this.pointsPerSide + x;
                }
                if (y2 > 0) {
                    positions[Or.DOWN.getI()] = (y2 - 1) * this.pointsPerSide + x;
                }
                if (x > 0) {
                    positions[Or.LEFT.getI()] = y2 * this.pointsPerSide + (x - true);
                }
                if (x < this.pointsPerSide - 1) {
                    positions[Or.RIGHT.getI()] = y2 * this.pointsPerSide + (x + true);
                }
                if (x < this.pointsPerSide - 1 && y2 < this.pointsPerSide - 1) {
                    positions[Or.UPRIGHT.getI()] = (y2 + 1) * this.pointsPerSide + (x + true);
                }
                if (x > 0 && y2 > 0) {
                    positions[Or.DOWNLEFT.getI()] = (y2 - 1) * this.pointsPerSide + (x - true);
                }
                Array<Face> faces = new Array<Face>();
                int pa = positions[Or.UP.getI()];
                int pb = positions[Or.UPRIGHT.getI()];
                if (pa >= 0 && pb >= 0) {
                    faces.add(new Face(curIndex, pa, pb));
                }
                pa = positions[Or.UPRIGHT.getI()];
                pb = positions[Or.RIGHT.getI()];
                if (pa >= 0 && pb >= 0) {
                    faces.add(new Face(curIndex, pa, pb));
                }
                pa = positions[Or.RIGHT.getI()];
                pb = positions[Or.DOWN.getI()];
                if (pa >= 0 && pb >= 0) {
                    faces.add(new Face(curIndex, pa, pb));
                }
                pa = positions[Or.DOWN.getI()];
                pb = positions[Or.DOWNLEFT.getI()];
                if (pa >= 0 && pb >= 0) {
                    faces.add(new Face(curIndex, pa, pb));
                }
                pa = positions[Or.DOWNLEFT.getI()];
                pb = positions[Or.LEFT.getI()];
                if (pa >= 0 && pb >= 0) {
                    faces.add(new Face(curIndex, pa, pb));
                }
                pa = positions[Or.LEFT.getI()];
                pb = positions[Or.UP.getI()];
                if (pa >= 0 && pb >= 0) {
                    faces.add(new Face(curIndex, pa, pb));
                }
                this.storage.get(curIndex).getNbFaces().addAll(faces);
                this.reset();
                if (i == $i$f$gdxArrayOf22) break;
                ++i;
            }
        }
        if ((i = 0) <= ($i$f$gdxArrayOf22 = this.storage.size - this.pointsPerSide - 2)) {
            while (true) {
                if ((i + 1) % this.pointsPerSide != 0) {
                    int pp = this.pointsPerSide;
                    this.indices.add((short)i);
                    this.indices.add((short)(i + pp));
                    this.indices.add((short)(i + pp + 1));
                    this.indices.add((short)i);
                    this.indices.add((short)(i + pp + 1));
                    this.indices.add((short)(i + 1));
                }
                if (i == $i$f$gdxArrayOf22) break;
                ++i;
            }
        }
        this.getMesh().setVertices(this.getVertices().getVertices());
        Mesh mesh = this.getMesh();
        Short[] shortArray = this.indices.toArray();
        Intrinsics.checkExpressionValueIsNotNull(shortArray, "indices.toArray()");
        mesh.setIndices(ArraysKt.toShortArray(shortArray));
        AssetManager i2 = cfg.getAssetManager();
        String $i$f$gdxArrayOf22 = "owltrans.png";
        textureTerrain = this;
        Texture texture = $receiver$iv.get((String)path$iv, Texture.class);
        Intrinsics.checkExpressionValueIsNotNull(texture, "this[path, Type::class.java]");
        object = texture;
        textureTerrain.texture = (Texture)object;
        this.zSlideIntensity = 1.0f;
        this.lightPos = new Vec3(-0.3, 0.2, (Number)1);
        this.lightColor = UtilsKt.Color255to1f(129.0f, 51.0f, 209.0f, 255.0f).toVec3().times(1.7f);
        this.am = 0.1f;
        this.ambientLight = new Vec3(this.am, this.am, this.am);
        this.specColor = new Vec3((Number)0, (Number)1, Float.valueOf(0.4f));
        this.specStrength = this.baseSpecStrength = 0.9f;
        this.lightStrength = this.lightStrengthBase = 0.1f;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/mygdx/game/drawables/TextureTerrain$Face;", "", "a", "", "b", "c", "(III)V", "getA", "()I", "getB", "getC", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "core"})
    public static final class Face {
        private final int a;
        private final int b;
        private final int c;

        public final int getA() {
            return this.a;
        }

        public final int getB() {
            return this.b;
        }

        public final int getC() {
            return this.c;
        }

        public Face(int a, int b, int c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public final int component1() {
            return this.a;
        }

        public final int component2() {
            return this.b;
        }

        public final int component3() {
            return this.c;
        }

        @NotNull
        public final Face copy(int a, int b, int c) {
            return new Face(a, b, c);
        }

        @NotNull
        public static /* synthetic */ Face copy$default(Face face, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = face.a;
            }
            if ((n4 & 2) != 0) {
                n2 = face.b;
            }
            if ((n4 & 4) != 0) {
                n3 = face.c;
            }
            return face.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "Face(a=" + this.a + ", b=" + this.b + ", c=" + this.c + ")";
        }

        public int hashCode() {
            return (this.a * 31 + this.b) * 31 + this.c;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Face)) break block3;
                    Face face = (Face)object;
                    if (!(this.a == face.a) || !(this.b == face.b) || !(this.c == face.c)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0018\b\u0002\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\u0019\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nH\u00c6\u0003JA\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0018\b\u0002\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R!\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/mygdx/game/drawables/TextureTerrain$Storage;", "", "pos", "Lglm/vec3/Vec3;", "norm", "uv", "Lglm/vec2/Vec2;", "nbFaces", "Lcom/badlogic/gdx/utils/Array;", "Lcom/mygdx/game/drawables/TextureTerrain$Face;", "Lktx/collections/GdxArray;", "(Lglm/vec3/Vec3;Lglm/vec3/Vec3;Lglm/vec2/Vec2;Lcom/badlogic/gdx/utils/Array;)V", "getNbFaces", "()Lcom/badlogic/gdx/utils/Array;", "getNorm", "()Lglm/vec3/Vec3;", "getPos", "getUv", "()Lglm/vec2/Vec2;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "core"})
    public static final class Storage {
        @NotNull
        private final Vec3 pos;
        @NotNull
        private final Vec3 norm;
        @NotNull
        private final Vec2 uv;
        @NotNull
        private final Array<Face> nbFaces;

        @NotNull
        public final Vec3 getPos() {
            return this.pos;
        }

        @NotNull
        public final Vec3 getNorm() {
            return this.norm;
        }

        @NotNull
        public final Vec2 getUv() {
            return this.uv;
        }

        @NotNull
        public final Array<Face> getNbFaces() {
            return this.nbFaces;
        }

        public Storage(@NotNull Vec3 pos, @NotNull Vec3 norm, @NotNull Vec2 uv, @NotNull Array<Face> nbFaces) {
            Intrinsics.checkParameterIsNotNull(pos, "pos");
            Intrinsics.checkParameterIsNotNull(norm, "norm");
            Intrinsics.checkParameterIsNotNull(uv, "uv");
            Intrinsics.checkParameterIsNotNull(nbFaces, "nbFaces");
            this.pos = pos;
            this.norm = norm;
            this.uv = uv;
            this.nbFaces = nbFaces;
        }

        public /* synthetic */ Storage(Vec3 vec3, Vec3 vec32, Vec2 vec2, Array array, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                array = new Array<Face>();
            }
            this(vec3, vec32, vec2, array);
        }

        @NotNull
        public final Vec3 component1() {
            return this.pos;
        }

        @NotNull
        public final Vec3 component2() {
            return this.norm;
        }

        @NotNull
        public final Vec2 component3() {
            return this.uv;
        }

        @NotNull
        public final Array<Face> component4() {
            return this.nbFaces;
        }

        @NotNull
        public final Storage copy(@NotNull Vec3 pos, @NotNull Vec3 norm, @NotNull Vec2 uv, @NotNull Array<Face> nbFaces) {
            Intrinsics.checkParameterIsNotNull(pos, "pos");
            Intrinsics.checkParameterIsNotNull(norm, "norm");
            Intrinsics.checkParameterIsNotNull(uv, "uv");
            Intrinsics.checkParameterIsNotNull(nbFaces, "nbFaces");
            return new Storage(pos, norm, uv, nbFaces);
        }

        @NotNull
        public static /* synthetic */ Storage copy$default(Storage storage, Vec3 vec3, Vec3 vec32, Vec2 vec2, Array array, int n, Object object) {
            if ((n & 1) != 0) {
                vec3 = storage.pos;
            }
            if ((n & 2) != 0) {
                vec32 = storage.norm;
            }
            if ((n & 4) != 0) {
                vec2 = storage.uv;
            }
            if ((n & 8) != 0) {
                array = storage.nbFaces;
            }
            return storage.copy(vec3, vec32, vec2, array);
        }

        @NotNull
        public String toString() {
            return "Storage(pos=" + this.pos + ", norm=" + this.norm + ", uv=" + this.uv + ", nbFaces=" + this.nbFaces + ")";
        }

        public int hashCode() {
            Vec3 vec3 = this.pos;
            Vec3 vec32 = this.norm;
            Vec2 vec2 = this.uv;
            Array<Face> array = this.nbFaces;
            return (((vec3 != null ? vec3.hashCode() : 0) * 31 + (vec32 != null ? vec32.hashCode() : 0)) * 31 + (vec2 != null ? vec2.hashCode() : 0)) * 31 + (array != null ? ((Object)array).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Storage)) break block3;
                    Storage storage = (Storage)object;
                    if (!Intrinsics.areEqual(this.pos, storage.pos) || !Intrinsics.areEqual(this.norm, storage.norm) || !Intrinsics.areEqual(this.uv, storage.uv) || !Intrinsics.areEqual(this.nbFaces, storage.nbFaces)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/mygdx/game/drawables/TextureTerrain$Or;", "", "i", "", "(Ljava/lang/String;II)V", "getI", "()I", "UP", "UPRIGHT", "RIGHT", "DOWN", "DOWNLEFT", "LEFT", "NONE", "core"})
    public static final class Or
    extends Enum<Or> {
        public static final /* enum */ Or UP;
        public static final /* enum */ Or UPRIGHT;
        public static final /* enum */ Or RIGHT;
        public static final /* enum */ Or DOWN;
        public static final /* enum */ Or DOWNLEFT;
        public static final /* enum */ Or LEFT;
        public static final /* enum */ Or NONE;
        private static final /* synthetic */ Or[] $VALUES;
        private final int i;

        static {
            Or[] orArray = new Or[7];
            Or[] orArray2 = orArray;
            orArray[0] = UP = new Or(0);
            orArray[1] = UPRIGHT = new Or(1);
            orArray[2] = RIGHT = new Or(2);
            orArray[3] = DOWN = new Or(3);
            orArray[4] = DOWNLEFT = new Or(4);
            orArray[5] = LEFT = new Or(5);
            orArray[6] = NONE = new Or(-1);
            $VALUES = orArray;
        }

        public final int getI() {
            return this.i;
        }

        protected Or(int i) {
            this.i = i;
        }

        public static Or[] values() {
            return (Or[])$VALUES.clone();
        }

        public static Or valueOf(String string) {
            return Enum.valueOf(Or.class, string);
        }
    }
}

