/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.drawables;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.mygdx.game.Camera;
import com.mygdx.game.Config;
import com.mygdx.game.LineContainer;
import com.mygdx.game.LineDrawable;
import com.mygdx.game.Linefeed;
import com.mygdx.game.Syncable;
import com.mygdx.game.UtilsKt;
import glm.glm;
import glm.mat4x4.Mat4;
import glm.vec3.Vec3;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0080\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012:\b\u0002\u0010\t\u001a4\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\n\u0012%\b\u0002\u0010\u0011\u001a\u001f\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\u0016\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\u000eJ\f\u00105\u001a\b\u0012\u0004\u0012\u00020706J\u0018\u00108\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020\u0010H\u0016J\u0018\u0010<\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u00109\u001a\u00020:H\u0016R\u001a\u0010\u0014\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u001a\u0010\u001c\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0016\"\u0004\b\u001e\u0010\u0018R\u001a\u0010\u001f\u001a\u00020 X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0016\"\u0004\b'\u0010\u0018R\u001a\u0010(\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0016\"\u0004\b*\u0010\u0018R7\u0010\u0011\u001a\u001f\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.RL\u0010\t\u001a4\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102\u00a8\u0006="}, d2={"Lcom/mygdx/game/drawables/Sphere;", "Lcom/mygdx/game/LineDrawable;", "Lcom/mygdx/game/Syncable;", "cfg", "Lcom/mygdx/game/Config;", "numVerts", "", "lf", "Lcom/mygdx/game/Linefeed;", "updateAction", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "s", "", "delta", "", "syncAction", "Lkotlin/Function1;", "(Lcom/mygdx/game/Config;ILcom/mygdx/game/Linefeed;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "angle", "getAngle", "()F", "setAngle", "(F)V", "gradualSin", "getGradualSin", "setGradualSin", "jiggle_speed", "getJiggle_speed", "setJiggle_speed", "lines", "Lcom/mygdx/game/LineContainer;", "getLines", "()Lcom/mygdx/game/LineContainer;", "setLines", "(Lcom/mygdx/game/LineContainer;)V", "rotateInc", "getRotateInc", "setRotateInc", "rsin", "getRsin", "setRsin", "getSyncAction", "()Lkotlin/jvm/functions/Function1;", "setSyncAction", "(Lkotlin/jvm/functions/Function1;)V", "getUpdateAction", "()Lkotlin/jvm/functions/Function2;", "setUpdateAction", "(Lkotlin/jvm/functions/Function2;)V", "basicSphere", "put", "disk", "Lcom/badlogic/gdx/utils/Array;", "Lglm/vec3/Vec3;", "render", "cam", "Lcom/mygdx/game/Camera;", "sync", "update", "core"})
public final class Sphere
extends LineDrawable
implements Syncable {
    @NotNull
    private LineContainer lines;
    private float angle;
    private float gradualSin;
    private float jiggle_speed;
    private float rsin;
    private float rotateInc;
    @Nullable
    private Function2<? super Sphere, ? super Float, Unit> updateAction;
    @Nullable
    private Function1<? super Sphere, Unit> syncAction;

    @Override
    public void sync() {
        block0: {
            Function1<? super Sphere, Unit> function1 = this.syncAction;
            if (function1 == null) break block0;
            function1.invoke(this);
        }
    }

    @Override
    @NotNull
    public LineContainer getLines() {
        return this.lines;
    }

    @Override
    public void setLines(@NotNull LineContainer lineContainer) {
        Intrinsics.checkParameterIsNotNull(lineContainer, "<set-?>");
        this.lines = lineContainer;
    }

    public final float getAngle() {
        return this.angle;
    }

    public final void setAngle(float f) {
        this.angle = f;
    }

    @NotNull
    public final Array<Vec3> disk() {
        float i = 0.0f;
        float radius = 1.0f;
        float amnt = 0.3f;
        Array<Vec3> pts = new Array<Vec3>();
        float x = MathUtils.cos(i) * radius;
        float z = MathUtils.sin(i) * radius;
        float y = 0.0f;
        while (i - amnt * (float)10 <= (float)Math.PI * 2) {
            pts.add(new Vec3(x, y, z));
            x = MathUtils.cos(i) * radius;
            z = MathUtils.sin(i) * radius;
            y = 0.0f;
            i += amnt;
            pts.add(new Vec3(x, y, z));
        }
        return pts;
    }

    public final float getGradualSin() {
        return this.gradualSin;
    }

    public final void setGradualSin(float f) {
        this.gradualSin = f;
    }

    public final float getJiggle_speed() {
        return this.jiggle_speed;
    }

    public final void setJiggle_speed(float f) {
        this.jiggle_speed = f;
    }

    /*
     * WARNING - void declaration
     */
    public final void basicSphere(@NotNull LineContainer put, float delta) {
        Intrinsics.checkParameterIsNotNull(put, "put");
        Array<Vec3> center = this.disk();
        float sinOff = MathUtils.sin(delta * this.jiggle_speed) * this.gradualSin;
        Array<Vec3> mid = UtilsKt.translatePoints(center, new Vec3(sinOff, 0.0f, 0.0f));
        put.addAllVec3(mid);
        int warp = 8;
        float sinOff2 = 0.0f;
        boolean bl = true;
        int n = warp;
        while (true) {
            void i;
            float angle = (float)i / (float)warp * 90.0f;
            float radius = 1.0f;
            double s = Math.sqrt(MathUtils.cos((float)Math.PI / 180 * angle) * radius);
            float tam = 1.0f / (float)warp;
            sinOff2 = MathUtils.sin(this.jiggle_speed * delta - (float)i * 0.2f) * this.gradualSin;
            Array<Vec3> bot = UtilsKt.scalePoints(center, new Vec3(s, s, s));
            bot = UtilsKt.translatePoints(bot, new Vec3(sinOff, (float)i * tam, 0.0f));
            put.addAllVec3(bot);
            sinOff = MathUtils.sin(this.jiggle_speed * delta - (float)i * 0.2f) * this.gradualSin;
            Array<Vec3> top = UtilsKt.scalePoints(center, new Vec3(s, s, s));
            top = UtilsKt.translatePoints(top, new Vec3(sinOff2, (float)(-i) * tam, 0.0f));
            put.addAllVec3(top);
            if (i == n) break;
            ++i;
        }
    }

    @Override
    public void render(float delta, @NotNull Camera cam) {
        Intrinsics.checkParameterIsNotNull(cam, "cam");
        super.render(delta, cam);
    }

    public final float getRsin() {
        return this.rsin;
    }

    public final void setRsin(float f) {
        this.rsin = f;
    }

    public final float getRotateInc() {
        return this.rotateInc;
    }

    public final void setRotateInc(float f) {
        this.rotateInc = f;
    }

    @Override
    public void update(float delta, @NotNull Camera cam) {
        Intrinsics.checkParameterIsNotNull(cam, "cam");
        this.rsin += delta;
        this.rotateInc += delta;
        this.angle += delta * 30.0f;
        float rad = 1.0f + MathUtils.sin(this.rsin) * 0.5f;
        this.getLines().clear();
        this.basicSphere(this.getLines(), this.rsin);
        if (this.updateAction != null) {
            Function2<? super Sphere, ? super Float, Unit> function2 = this.updateAction;
            if (function2 != null) {
                function2.invoke(this, Float.valueOf(delta));
            }
        } else {
            this.setModel(new Mat4());
            this.setModel(glm.INSTANCE.translate(this.getModel(), this.getPos()));
            this.setModel(glm.INSTANCE.rotate(this.getModel(), (float)Math.PI / 180 * this.angle, new Vec3((Number)1, Float.valueOf(0.4f), Float.valueOf(0.0f))));
            this.setModel(glm.INSTANCE.scale(this.getModel(), new Vec3(this.getUscale(), this.getUscale(), this.getUscale())));
        }
    }

    @Nullable
    public final Function2<Sphere, Float, Unit> getUpdateAction() {
        return this.updateAction;
    }

    public final void setUpdateAction(@Nullable Function2<? super Sphere, ? super Float, Unit> function2) {
        this.updateAction = function2;
    }

    @Nullable
    public final Function1<Sphere, Unit> getSyncAction() {
        return this.syncAction;
    }

    public final void setSyncAction(@Nullable Function1<? super Sphere, Unit> function1) {
        this.syncAction = function1;
    }

    public Sphere(@NotNull Config cfg, int numVerts, @NotNull Linefeed lf, @Nullable Function2<? super Sphere, ? super Float, Unit> updateAction, @Nullable Function1<? super Sphere, Unit> syncAction) {
        Intrinsics.checkParameterIsNotNull(cfg, "cfg");
        Intrinsics.checkParameterIsNotNull(lf, "lf");
        super(cfg, numVerts, lf);
        this.updateAction = updateAction;
        this.syncAction = syncAction;
        this.lines = new LineContainer(false, false);
        this.jiggle_speed = 4.0f;
        this.setContinuos(false);
        this.getLines().setBaseColor(new Color(0.0f, 0.9f, 0.3f, 1.0f));
    }

    public /* synthetic */ Sphere(Config config, int n, Linefeed linefeed, Function2 function2, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            function2 = null;
        }
        if ((n2 & 0x10) != 0) {
            function1 = null;
        }
        this(config, n, linefeed, function2, function1);
    }
}

