/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.drawables;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.Array;
import com.mygdx.game.Camera;
import com.mygdx.game.Config;
import com.mygdx.game.DrawableMesh;
import com.mygdx.game.UtilsKt;
import com.mygdx.game.VertexBlock;
import com.mygdx.game.drawables.Light;
import glm.glm;
import glm.mat3x3.Mat3;
import glm.mat4x4.Mat4;
import glm.vec2.Vec2;
import glm.vec3.Vec3;
import glm.vec4.Vec4;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002HIB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010<\u001a\u00020=J\u0016\u0010>\u001a\u00020&2\u0006\u0010?\u001a\u00020&2\u0006\u0010@\u001a\u00020\u0016J\u0018\u0010A\u001a\u00020=2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0016J\u0018\u0010F\u001a\u00020=2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0016J\u0006\u0010G\u001a\u00020=R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000f\"\u0004\b\u0010\u0010\u0011R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R(\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u000200\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u001a\u00103\u001a\u000204X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R(\u00109\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u0018\"\u0004\b;\u0010\u001a\u00a8\u0006J"}, d2={"Lcom/mygdx/game/drawables/Plane;", "Lcom/mygdx/game/DrawableMesh;", "cfg", "Lcom/mygdx/game/Config;", "lights", "Lcom/badlogic/gdx/utils/Array;", "Lcom/mygdx/game/drawables/Light;", "Lktx/collections/GdxArray;", "(Lcom/mygdx/game/Config;Lcom/badlogic/gdx/utils/Array;)V", "MAX_VERTS", "", "getMAX_VERTS", "()I", "isReflective", "", "()Z", "setReflective", "(Z)V", "getLights", "()Lcom/badlogic/gdx/utils/Array;", "localRotation", "Lkotlin/Function1;", "Lglm/mat4x4/Mat4;", "getLocalRotation", "()Lkotlin/jvm/functions/Function1;", "setLocalRotation", "(Lkotlin/jvm/functions/Function1;)V", "mesh", "Lcom/badlogic/gdx/graphics/Mesh;", "getMesh", "()Lcom/badlogic/gdx/graphics/Mesh;", "setMesh", "(Lcom/badlogic/gdx/graphics/Mesh;)V", "sp", "Lcom/badlogic/gdx/graphics/glutils/ShaderProgram;", "getSp", "()Lcom/badlogic/gdx/graphics/glutils/ShaderProgram;", "staticRotatedCenterPostion", "Lglm/vec3/Vec3;", "getStaticRotatedCenterPostion", "()Lglm/vec3/Vec3;", "setStaticRotatedCenterPostion", "(Lglm/vec3/Vec3;)V", "texture", "Lcom/badlogic/gdx/graphics/Texture;", "getTexture", "()Lcom/badlogic/gdx/graphics/Texture;", "vertData", "Lcom/mygdx/game/drawables/Plane$VertData;", "getVertData", "()Lcom/mygdx/game/drawables/Plane$VertData;", "vertices", "Lcom/mygdx/game/VertexBlock;", "getVertices", "()Lcom/mygdx/game/VertexBlock;", "setVertices", "(Lcom/mygdx/game/VertexBlock;)V", "worldRotation", "getWorldRotation", "setWorldRotation", "calculateNormals", "", "fixNormal", "normal", "modelMat", "render", "delta", "", "cam", "Lcom/mygdx/game/Camera;", "update", "updateVertices", "PlanePoints", "VertData", "core"})
public final class Plane
extends DrawableMesh {
    private final int MAX_VERTS;
    @NotNull
    private Mesh mesh;
    @NotNull
    private VertexBlock vertices;
    @NotNull
    private Vec3 staticRotatedCenterPostion;
    @NotNull
    private final ShaderProgram sp;
    @Nullable
    private Function1<? super Mat4, Mat4> localRotation;
    @Nullable
    private Function1<? super Mat4, Mat4> worldRotation;
    @NotNull
    private final Texture texture;
    private boolean isReflective;
    @NotNull
    private final VertData vertData;
    @NotNull
    private final Array<Light> lights;

    @Override
    public int getMAX_VERTS() {
        return this.MAX_VERTS;
    }

    @Override
    @NotNull
    public Mesh getMesh() {
        return this.mesh;
    }

    @Override
    public void setMesh(@NotNull Mesh mesh) {
        Intrinsics.checkParameterIsNotNull(mesh, "<set-?>");
        this.mesh = mesh;
    }

    @Override
    @NotNull
    public VertexBlock getVertices() {
        return this.vertices;
    }

    @Override
    public void setVertices(@NotNull VertexBlock vertexBlock) {
        Intrinsics.checkParameterIsNotNull(vertexBlock, "<set-?>");
        this.vertices = vertexBlock;
    }

    @NotNull
    public final Vec3 getStaticRotatedCenterPostion() {
        return this.staticRotatedCenterPostion;
    }

    public final void setStaticRotatedCenterPostion(@NotNull Vec3 vec3) {
        Intrinsics.checkParameterIsNotNull(vec3, "<set-?>");
        this.staticRotatedCenterPostion = vec3;
    }

    @NotNull
    public final ShaderProgram getSp() {
        return this.sp;
    }

    @Nullable
    public final Function1<Mat4, Mat4> getLocalRotation() {
        return this.localRotation;
    }

    public final void setLocalRotation(@Nullable Function1<? super Mat4, Mat4> function1) {
        this.localRotation = function1;
    }

    @Nullable
    public final Function1<Mat4, Mat4> getWorldRotation() {
        return this.worldRotation;
    }

    public final void setWorldRotation(@Nullable Function1<? super Mat4, Mat4> function1) {
        this.worldRotation = function1;
    }

    @NotNull
    public final Texture getTexture() {
        return this.texture;
    }

    public final boolean isReflective() {
        return this.isReflective;
    }

    public final void setReflective(boolean bl) {
        this.isReflective = bl;
    }

    @NotNull
    public final VertData getVertData() {
        return this.vertData;
    }

    /*
     * WARNING - void declaration
     */
    public final void calculateNormals() {
        int n = 0;
        IntProgression intProgression = RangesKt.step(new IntRange(n, this.vertData.getIndices().length - 1), 3);
        int n2 = intProgression.getFirst();
        int n3 = intProgression.getLast();
        int n4 = intProgression.getStep();
        int n5 = n2;
        int n6 = n3;
        if (n4 > 0 ? n5 <= n6 : n5 >= n6) {
            while (true) {
                void i;
                PlanePoints a = this.vertData.getPlanePoints().get(this.vertData.getIndices()[i]);
                PlanePoints b = this.vertData.getPlanePoints().get(this.vertData.getIndices()[i + true]);
                PlanePoints c = this.vertData.getPlanePoints().get(this.vertData.getIndices()[i + 2]);
                Vec3 normal = UtilsKt.calcNorm(a.getPos(), b.getPos(), c.getPos());
                a.setNormal(normal);
                b.setNormal(normal);
                c.setNormal(normal);
                if (i == n3) break;
                n2 = i + n4;
            }
        }
    }

    public final void updateVertices() {
        this.calculateNormals();
        Iterable $receiver$iv = this.vertData.getPlanePoints();
        for (Object element$iv : $receiver$iv) {
            PlanePoints it = (PlanePoints)element$iv;
            this.getVertices().queueVertex(it.getPos(), it.getNormal(), it.getUv());
        }
    }

    @NotNull
    public final Vec3 fixNormal(@NotNull Vec3 normal, @NotNull Mat4 modelMat) {
        Intrinsics.checkParameterIsNotNull(normal, "normal");
        Intrinsics.checkParameterIsNotNull(modelMat, "modelMat");
        Vec3 s = Vec3.normalize$default(new Mat3(glm.INSTANCE.transpose(glm.INSTANCE.inverse(modelMat))).times(normal), null, 1, null);
        return s;
    }

    @Override
    public void update(float delta, @NotNull Camera cam) {
        Intrinsics.checkParameterIsNotNull(cam, "cam");
        this.getVertices().setCIndex(0);
        this.setModelMat(new Mat4());
        Function1<? super Mat4, Mat4> function1 = this.worldRotation;
        if (function1 == null || (function1 = function1.invoke(this.getModelMat())) == null) {
            function1 = this.getModelMat();
        }
        this.setModelMat((Mat4)((Object)function1));
        this.setModelMat(glm.INSTANCE.translate(this.getModelMat(), this.getPos()));
        Function1<? super Mat4, Mat4> function12 = this.localRotation;
        if (function12 == null || (function12 = function12.invoke(this.getModelMat())) == null) {
            function12 = this.getModelMat();
        }
        this.setModelMat((Mat4)((Object)function12));
        this.setModelMat(glm.INSTANCE.scale(this.getModelMat(), new Vec3(this.getUscale(), this.getUscale(), this.getUscale())));
        this.staticRotatedCenterPostion = this.getModelMat().times(new Vec4((Number)0, (Number)0, (Number)0, (Number)1)).toVec3();
        Iterable $receiver$iv = this.vertData.getPlanePoints();
        for (Object element$iv : $receiver$iv) {
            PlanePoints it = (PlanePoints)element$iv;
            this.getVertices().queueVertex(it.getPos(), this.fixNormal(it.getNormal(), this.getModelMat()), it.getUv());
        }
    }

    @Override
    public void render(float delta, @NotNull Camera cam) {
        Intrinsics.checkParameterIsNotNull(cam, "cam");
        this.getMesh().setVertices(this.getVertices().getVertices());
        this.getMesh().setIndices(this.vertData.getIndices());
        ShaderProgram $receiver$iv = this.sp;
        $receiver$iv.begin();
        ShaderProgram it = $receiver$iv;
        this.sp.setUniform3fv("camPos", UtilsKt.vec3ToFloatAr(cam.getPos()), 0, 3);
        this.sp.setUniform2fv("resolution", new float[]{this.getCfg().getVirtualWidth(), this.getCfg().getVirtualHeight()}, 0, 2);
        Iterable $receiver$iv2 = this.lights;
        for (Object element$iv : $receiver$iv2) {
            Light it2 = (Light)element$iv;
            it2.setUniforms(this.sp);
        }
        this.sp.setUniformi("specularOnly", 0);
        this.sp.setUniformi("reflection", 0);
        this.sp.setUniformf("alpha", 1.0f);
        this.sp.setUniformi("preCalcNormals", 1);
        this.sp.setUniform3fv("objectAmbientColor", UtilsKt.vec3ToFloatAr(new Vec3(0.0, 0.0, 0.0)), 0, 3);
        UtilsKt.setUniformMatrix(this.sp, this.getModelMat(), "model");
        UtilsKt.setUniformMatrix(this.sp, cam.projection(), "proj");
        UtilsKt.setUniformMatrix(this.sp, cam.view(), "view");
        this.texture.bind();
        VertexBlock.flush$default(this.getVertices(), this.getMesh(), this.sp, 4, 0, true, 0, 32, null);
        $receiver$iv.end();
    }

    @NotNull
    public final Array<Light> getLights() {
        return this.lights;
    }

    /*
     * WARNING - void declaration
     */
    public Plane(@NotNull Config cfg, @NotNull Array<Light> lights) {
        Texture texture;
        void path$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(cfg, "cfg");
        Intrinsics.checkParameterIsNotNull(lights, "lights");
        super(cfg);
        this.lights = lights;
        this.MAX_VERTS = 4 * this.getPOSITION_COMPONENTS() * this.getNORMAL_COMPONENTS() * this.getTEXTURE_COMPONENTS();
        this.mesh = new Mesh(true, this.getMAX_VERTS(), this.getMAX_VERTS(), new VertexAttribute(1, this.getPOSITION_COMPONENTS(), "a_position"), new VertexAttribute(8, this.getNORMAL_COMPONENTS(), "a_normal"), new VertexAttribute(16, this.getTEXTURE_COMPONENTS(), "a_texCoords"));
        this.vertices = new VertexBlock(this.getMAX_VERTS());
        this.staticRotatedCenterPostion = new Vec3();
        this.sp = cfg.getShader("diffuse");
        AssetManager assetManager = cfg.getAssetManager();
        String string = "greenmarmor.png";
        Plane plane = this;
        Texture texture2 = $receiver$iv.get((String)path$iv, Texture.class);
        Intrinsics.checkExpressionValueIsNotNull(texture2, "this[path, Type::class.java]");
        plane.texture = texture = texture2;
        this.vertData = new VertData();
        this.texture.setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
        float tscale = 3.0f;
        this.vertData.getPlanePoints().add(new PlanePoints(new Vec3((Number)-1, (Number)0, (Number)1), new Vec2((Number)0, (Number)1).times(tscale), null, 4, null));
        this.vertData.getPlanePoints().add(new PlanePoints(new Vec3((Number)1, (Number)0, (Number)1), new Vec2((Number)1, (Number)1).times(tscale), null, 4, null));
        this.vertData.getPlanePoints().add(new PlanePoints(new Vec3((Number)1, (Number)0, (Number)-1), new Vec2((Number)1, (Number)0).times(tscale), null, 4, null));
        this.vertData.getPlanePoints().add(new PlanePoints(new Vec3((Number)-1, (Number)0, (Number)-1), new Vec2((Number)0, (Number)0).times(tscale), null, 4, null));
        this.vertData.setIndices(new short[]{3, 1, 0, 3, 2, 1});
        this.calculateNormals();
        this.getMesh().setIndices(this.vertData.getIndices());
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/mygdx/game/drawables/Plane$VertData;", "", "()V", "indices", "", "getIndices", "()[S", "setIndices", "([S)V", "planePoints", "Lcom/badlogic/gdx/utils/Array;", "Lcom/mygdx/game/drawables/Plane$PlanePoints;", "Lktx/collections/GdxArray;", "getPlanePoints", "()Lcom/badlogic/gdx/utils/Array;", "core"})
    public static final class VertData {
        @NotNull
        private final Array<PlanePoints> planePoints = new Array();
        @NotNull
        private short[] indices = new short[0];

        @NotNull
        public final Array<PlanePoints> getPlanePoints() {
            return this.planePoints;
        }

        @NotNull
        public final short[] getIndices() {
            return this.indices;
        }

        public final void setIndices(@NotNull short[] sArray) {
            Intrinsics.checkParameterIsNotNull(sArray, "<set-?>");
            this.indices = sArray;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/mygdx/game/drawables/Plane$PlanePoints;", "", "pos", "Lglm/vec3/Vec3;", "uv", "Lglm/vec2/Vec2;", "normal", "(Lglm/vec3/Vec3;Lglm/vec2/Vec2;Lglm/vec3/Vec3;)V", "getNormal", "()Lglm/vec3/Vec3;", "setNormal", "(Lglm/vec3/Vec3;)V", "getPos", "setPos", "getUv", "()Lglm/vec2/Vec2;", "setUv", "(Lglm/vec2/Vec2;)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "core"})
    public static final class PlanePoints {
        @NotNull
        private Vec3 pos;
        @NotNull
        private Vec2 uv;
        @NotNull
        private Vec3 normal;

        @NotNull
        public final Vec3 getPos() {
            return this.pos;
        }

        public final void setPos(@NotNull Vec3 vec3) {
            Intrinsics.checkParameterIsNotNull(vec3, "<set-?>");
            this.pos = vec3;
        }

        @NotNull
        public final Vec2 getUv() {
            return this.uv;
        }

        public final void setUv(@NotNull Vec2 vec2) {
            Intrinsics.checkParameterIsNotNull(vec2, "<set-?>");
            this.uv = vec2;
        }

        @NotNull
        public final Vec3 getNormal() {
            return this.normal;
        }

        public final void setNormal(@NotNull Vec3 vec3) {
            Intrinsics.checkParameterIsNotNull(vec3, "<set-?>");
            this.normal = vec3;
        }

        public PlanePoints(@NotNull Vec3 pos, @NotNull Vec2 uv, @NotNull Vec3 normal) {
            Intrinsics.checkParameterIsNotNull(pos, "pos");
            Intrinsics.checkParameterIsNotNull(uv, "uv");
            Intrinsics.checkParameterIsNotNull(normal, "normal");
            this.pos = pos;
            this.uv = uv;
            this.normal = normal;
        }

        public /* synthetic */ PlanePoints(Vec3 vec3, Vec2 vec2, Vec3 vec32, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                vec32 = new Vec3((Number)0, (Number)1, (Number)0);
            }
            this(vec3, vec2, vec32);
        }

        @NotNull
        public final Vec3 component1() {
            return this.pos;
        }

        @NotNull
        public final Vec2 component2() {
            return this.uv;
        }

        @NotNull
        public final Vec3 component3() {
            return this.normal;
        }

        @NotNull
        public final PlanePoints copy(@NotNull Vec3 pos, @NotNull Vec2 uv, @NotNull Vec3 normal) {
            Intrinsics.checkParameterIsNotNull(pos, "pos");
            Intrinsics.checkParameterIsNotNull(uv, "uv");
            Intrinsics.checkParameterIsNotNull(normal, "normal");
            return new PlanePoints(pos, uv, normal);
        }

        @NotNull
        public static /* synthetic */ PlanePoints copy$default(PlanePoints planePoints, Vec3 vec3, Vec2 vec2, Vec3 vec32, int n, Object object) {
            if ((n & 1) != 0) {
                vec3 = planePoints.pos;
            }
            if ((n & 2) != 0) {
                vec2 = planePoints.uv;
            }
            if ((n & 4) != 0) {
                vec32 = planePoints.normal;
            }
            return planePoints.copy(vec3, vec2, vec32);
        }

        @NotNull
        public String toString() {
            return "PlanePoints(pos=" + this.pos + ", uv=" + this.uv + ", normal=" + this.normal + ")";
        }

        public int hashCode() {
            Vec3 vec3 = this.pos;
            Vec2 vec2 = this.uv;
            Vec3 vec32 = this.normal;
            return ((vec3 != null ? vec3.hashCode() : 0) * 31 + (vec2 != null ? vec2.hashCode() : 0)) * 31 + (vec32 != null ? vec32.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PlanePoints)) break block3;
                    PlanePoints planePoints = (PlanePoints)object;
                    if (!Intrinsics.areEqual(this.pos, planePoints.pos) || !Intrinsics.areEqual(this.uv, planePoints.uv) || !Intrinsics.areEqual(this.normal, planePoints.normal)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

