/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.drawables;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.mygdx.game.Camera;
import com.mygdx.game.Config;
import com.mygdx.game.Debug;
import com.mygdx.game.DemoObject;
import com.mygdx.game.LineContainer;
import com.mygdx.game.LineDrawable;
import com.mygdx.game.LinePoint;
import com.mygdx.game.Linefeed;
import com.mygdx.game.UtilsKt;
import com.mygdx.game.drawables.Pyramid;
import glm.func.func_geometric;
import glm.glm;
import glm.mat4x4.Mat4;
import glm.vec3.Vec3;
import glm.vec4.Vec4;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020'J\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u00020'2\u0006\u00105\u001a\u000206H\u0016R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010)\"\u0004\b.\u0010+\u00a8\u00067"}, d2={"Lcom/mygdx/game/drawables/Path;", "Lcom/mygdx/game/LineDrawable;", "cfg", "Lcom/mygdx/game/Config;", "lf", "Lcom/mygdx/game/Linefeed;", "pointDefinition", "Lkotlin/Function1;", "Lcom/mygdx/game/LineContainer;", "numMaxVerts", "", "(Lcom/mygdx/game/Config;Lcom/mygdx/game/Linefeed;Lkotlin/jvm/functions/Function1;I)V", "attachment", "Lcom/mygdx/game/DemoObject;", "getAttachment", "()Lcom/mygdx/game/DemoObject;", "setAttachment", "(Lcom/mygdx/game/DemoObject;)V", "b_holder", "Lglm/vec3/Vec3;", "getB_holder", "()Lglm/vec3/Vec3;", "setB_holder", "(Lglm/vec3/Vec3;)V", "convertedPoints", "Lcom/badlogic/gdx/utils/Array;", "Lcom/badlogic/gdx/math/Vector3;", "debug", "Lcom/mygdx/game/Debug;", "getDebug", "()Lcom/mygdx/game/Debug;", "setDebug", "(Lcom/mygdx/game/Debug;)V", "lines", "getLines", "()Lcom/mygdx/game/LineContainer;", "setLines", "(Lcom/mygdx/game/LineContainer;)V", "run", "", "getRun", "()F", "setRun", "(F)V", "where", "getWhere", "setWhere", "lerp", "Lcom/mygdx/game/LinePoint;", "f", "update", "", "delta", "cam", "Lcom/mygdx/game/Camera;", "core"})
public class Path
extends LineDrawable {
    @NotNull
    private LineContainer lines;
    @Nullable
    private DemoObject attachment;
    @Nullable
    private Debug debug;
    private Array<Vector3> convertedPoints;
    private float where;
    private float run;
    @NotNull
    private Vec3 b_holder;

    @Override
    @NotNull
    public final LineContainer getLines() {
        return this.lines;
    }

    @Override
    public final void setLines(@NotNull LineContainer lineContainer) {
        Intrinsics.checkParameterIsNotNull(lineContainer, "<set-?>");
        this.lines = lineContainer;
    }

    @Nullable
    public final DemoObject getAttachment() {
        return this.attachment;
    }

    public final void setAttachment(@Nullable DemoObject demoObject) {
        this.attachment = demoObject;
    }

    @Nullable
    public final Debug getDebug() {
        return this.debug;
    }

    public final void setDebug(@Nullable Debug debug) {
        this.debug = debug;
    }

    public final float getWhere() {
        return this.where;
    }

    public final void setWhere(float f) {
        this.where = f;
    }

    public final float getRun() {
        return this.run;
    }

    public final void setRun(float f) {
        this.run = f;
    }

    @NotNull
    protected final Vec3 getB_holder() {
        return this.b_holder;
    }

    protected final void setB_holder(@NotNull Vec3 vec3) {
        Intrinsics.checkParameterIsNotNull(vec3, "<set-?>");
        this.b_holder = vec3;
    }

    @NotNull
    public final LinePoint lerp(float f) {
        return LineContainer.getLerp$default(this.lines, MathUtils.clamp(f, 0.0f, 1.0f), false, null, 6, null);
    }

    @Override
    public void update(float delta, @NotNull Camera cam) {
        block7: {
            Object object;
            Intrinsics.checkParameterIsNotNull(cam, "cam");
            float speed = 0.2f;
            this.run -= delta * speed;
            this.where = 0.5f + MathUtils.sin(this.run) * 0.5f;
            if (this.where > 1.0f) {
                this.where = 1.0f;
            } else if (this.where < 0.0f) {
                this.where = 0.0f;
            }
            if ((object = this.attachment) == null || (object = ((DemoObject)object).getPos()) == null) {
                object = new Vec3();
            }
            Object p2 = object;
            Debug debug = this.debug;
            if (debug != null) {
                debug.addScreenMsg("cpos", UtilsKt.vec2String((Vec3)p2));
            }
            if (!(this.attachment instanceof Pyramid)) break block7;
            LinePoint lerp = this.lines.getLerp(this.where, true, this.debug);
            Vec3 v = lerp.getPos();
            Vec3 t = Vec3.normalize$default(lerp.getDeriv(), null, 1, null);
            Vec3 n = func_geometric.DefaultImpls.cross$default((func_geometric)glm.INSTANCE, this.b_holder, t, null, 4, null);
            this.b_holder = func_geometric.DefaultImpls.cross$default((func_geometric)glm.INSTANCE, t, n, null, 4, null);
            n = Vec3.normalize$default(n, null, 1, null);
            this.b_holder = Vec3.normalize$default(this.b_holder, null, 1, null);
            t = Vec3.normalize$default(t, null, 1, null);
            DemoObject demoObject = this.attachment;
            if (demoObject == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.mygdx.game.drawables.Pyramid");
            }
            ((Pyramid)demoObject).setAttachModelMat(new Mat4(new Vec4(this.b_holder, Float.valueOf(0.0f)), new Vec4(n, Float.valueOf(0.0f)), new Vec4(t, Float.valueOf(0.0f)), new Vec4(v, Float.valueOf(1.0f))));
            Debug debug2 = this.debug;
            if (debug2 != null) {
                debug2.addScreenMsg("tilt", UtilsKt.vec2String(t));
            }
        }
    }

    public Path(@NotNull Config cfg, @NotNull Linefeed lf, @Nullable Function1<? super LineContainer, LineContainer> pointDefinition, int numMaxVerts) {
        Intrinsics.checkParameterIsNotNull(cfg, "cfg");
        Intrinsics.checkParameterIsNotNull(lf, "lf");
        super(cfg, numMaxVerts, lf);
        this.lines = new LineContainer(true, true);
        if (pointDefinition != null) {
            this.lines = pointDefinition.invoke(this.lines);
        }
        this.setContinuos(true);
        this.b_holder = new Vec3(0.0, 0.0, Float.valueOf(0.99999f));
    }

    public /* synthetic */ Path(Config config, Linefeed linefeed, Function1 function1, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 250;
        }
        this(config, linefeed, function1, n);
    }
}

