/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.drawables;

import com.badlogic.gdx.math.CatmullRomSpline;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.mygdx.game.Camera;
import com.mygdx.game.Config;
import com.mygdx.game.Debug;
import com.mygdx.game.DemoObject;
import com.mygdx.game.LineContainer;
import com.mygdx.game.LineDrawable;
import com.mygdx.game.Linefeed;
import com.mygdx.game.UtilsKt;
import com.mygdx.game.drawables.Pyramid;
import glm.func.func_geometric;
import glm.glm;
import glm.mat4x4.Mat4;
import glm.vec3.Vec3;
import glm.vec4.Vec4;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\b\u00100\u001a\u000201H\u0016J\u0018\u00102\u001a\u0002012\u0006\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u000205H\u0016R$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R \u0010)\u001a\b\u0012\u0004\u0012\u00020+0*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/\u00a8\u00066"}, d2={"Lcom/mygdx/game/drawables/NewPath;", "Lcom/mygdx/game/LineDrawable;", "cfg", "Lcom/mygdx/game/Config;", "points", "Lcom/badlogic/gdx/utils/Array;", "Lglm/vec3/Vec3;", "Lktx/collections/GdxArray;", "looping", "", "lf", "Lcom/mygdx/game/Linefeed;", "debug", "Lcom/mygdx/game/Debug;", "(Lcom/mygdx/game/Config;Lcom/badlogic/gdx/utils/Array;ZLcom/mygdx/game/Linefeed;Lcom/mygdx/game/Debug;)V", "value", "", "at", "getAt", "()F", "setAt", "(F)V", "attachment", "Lcom/mygdx/game/DemoObject;", "getAttachment", "()Lcom/mygdx/game/DemoObject;", "setAttachment", "(Lcom/mygdx/game/DemoObject;)V", "b_holder", "getB_holder", "()Lglm/vec3/Vec3;", "setB_holder", "(Lglm/vec3/Vec3;)V", "getDebug", "()Lcom/mygdx/game/Debug;", "lines", "Lcom/mygdx/game/LineContainer;", "getLines", "()Lcom/mygdx/game/LineContainer;", "setLines", "(Lcom/mygdx/game/LineContainer;)V", "spline", "Lcom/badlogic/gdx/math/CatmullRomSpline;", "Lcom/badlogic/gdx/math/Vector3;", "getSpline", "()Lcom/badlogic/gdx/math/CatmullRomSpline;", "setSpline", "(Lcom/badlogic/gdx/math/CatmullRomSpline;)V", "reset", "", "update", "delta", "cam", "Lcom/mygdx/game/Camera;", "core"})
public final class NewPath
extends LineDrawable {
    @NotNull
    private LineContainer lines;
    @Nullable
    private DemoObject attachment;
    @NotNull
    private CatmullRomSpline<Vector3> spline;
    private float at;
    @NotNull
    private Vec3 b_holder;
    @Nullable
    private final Debug debug;

    @Override
    @NotNull
    public LineContainer getLines() {
        return this.lines;
    }

    @Override
    public void setLines(@NotNull LineContainer lineContainer) {
        Intrinsics.checkParameterIsNotNull(lineContainer, "<set-?>");
        this.lines = lineContainer;
    }

    @Nullable
    public final DemoObject getAttachment() {
        return this.attachment;
    }

    public final void setAttachment(@Nullable DemoObject demoObject) {
        this.attachment = demoObject;
    }

    @Override
    public void reset() {
    }

    @NotNull
    public final CatmullRomSpline<Vector3> getSpline() {
        return this.spline;
    }

    public final void setSpline(@NotNull CatmullRomSpline<Vector3> catmullRomSpline) {
        Intrinsics.checkParameterIsNotNull(catmullRomSpline, "<set-?>");
        this.spline = catmullRomSpline;
    }

    public final float getAt() {
        return this.at;
    }

    public final void setAt(float value) {
        this.at = MathUtils.clamp(value, 0.0f, 1.0f);
    }

    @NotNull
    protected final Vec3 getB_holder() {
        return this.b_holder;
    }

    protected final void setB_holder(@NotNull Vec3 vec3) {
        Intrinsics.checkParameterIsNotNull(vec3, "<set-?>");
        this.b_holder = vec3;
    }

    @Override
    public void update(float delta, @NotNull Camera cam) {
        Intrinsics.checkParameterIsNotNull(cam, "cam");
        float camat = MathUtils.clamp(this.at, 0.0f, 1.0f);
        Vector3 vector3 = this.spline.valueAt((Vector3)((Vector)new Vector3()), camat);
        Intrinsics.checkExpressionValueIsNotNull(vector3, "spline.valueAt(Vector3(), camat)");
        Vec3 v = UtilsKt.vector3gdx2glm(vector3);
        Vector3 vector32 = this.spline.derivativeAt((Vector3)((Vector)new Vector3()), camat);
        Intrinsics.checkExpressionValueIsNotNull(vector32, "spline.derivativeAt(Vector3(), camat)");
        Vec3 t = Vec3.normalize$default(UtilsKt.vector3gdx2glm(vector32), null, 1, null);
        Debug debug = this.debug;
        if (debug != null) {
            debug.addScreenMsg("pos: ", UtilsKt.vec2String(v));
        }
        Vec3 n = func_geometric.DefaultImpls.cross$default((func_geometric)glm.INSTANCE, this.b_holder, t, null, 4, null);
        this.b_holder = func_geometric.DefaultImpls.cross$default((func_geometric)glm.INSTANCE, t, n, null, 4, null);
        n = Vec3.normalize$default(n, null, 1, null);
        this.b_holder = Vec3.normalize$default(this.b_holder, null, 1, null);
        t = Vec3.normalize$default(t, null, 1, null);
        DemoObject demoObject = this.attachment;
        if (demoObject == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.mygdx.game.drawables.Pyramid");
        }
        ((Pyramid)demoObject).setAttachModelMat(new Mat4(new Vec4(this.b_holder, Float.valueOf(0.0f)), new Vec4(n, Float.valueOf(0.0f)), new Vec4(t, Float.valueOf(0.0f)), new Vec4(v, Float.valueOf(1.0f))));
    }

    @Nullable
    public final Debug getDebug() {
        return this.debug;
    }

    /*
     * WARNING - void declaration
     */
    public NewPath(@NotNull Config cfg, @NotNull Array<Vec3> points, boolean looping, @NotNull Linefeed lf, @Nullable Debug debug) {
        Intrinsics.checkParameterIsNotNull(cfg, "cfg");
        Intrinsics.checkParameterIsNotNull(points, "points");
        Intrinsics.checkParameterIsNotNull(lf, "lf");
        super(cfg, 250, lf);
        this.debug = debug;
        this.lines = new LineContainer(true, true);
        this.setContinuos(true);
        Iterable $receiver$iv = points;
        for (Object element$iv : $receiver$iv) {
            Vec3 it = (Vec3)element$iv;
            LineContainer lineContainer = this.getLines();
            Vec3 vec3 = it;
            Intrinsics.checkExpressionValueIsNotNull(vec3, "it");
            lineContainer.add(vec3);
        }
        Array<Vector3> convertedPoints = new Array<Vector3>();
        int n = 0;
        int n2 = points.size - 1;
        if (n <= n2) {
            while (true) {
                void i;
                Vec3 vec3 = points.get((int)i);
                Intrinsics.checkExpressionValueIsNotNull(vec3, "points.get(i)");
                convertedPoints.add(UtilsKt.vector3glm2gdx(vec3));
                if (i == n2) break;
                ++i;
            }
        }
        this.spline = new CatmullRomSpline((Vector[])convertedPoints.toArray(Vector3.class), looping);
        this.b_holder = new Vec3(0.0, 0.0, Float.valueOf(0.99999f));
    }

    public /* synthetic */ NewPath(Config config, Array array, boolean bl, Linefeed linefeed, Debug debug, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            debug = null;
        }
        this(config, array, bl, linefeed, debug);
    }
}

