/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.CatmullRomSpline;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.mygdx.game.LineContainer;
import com.mygdx.game.LinePoint;
import glm.func.func_geometric;
import glm.glm;
import glm.mat4x4.Mat4;
import glm.quat.Quat;
import glm.vec2.Vec2;
import glm.vec3.Vec3;
import glm.vec4.Vec4;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u008c\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u001a\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\t\u001a\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t\u001a*\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u0012\u001a\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019\u001a\u001e\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u0004\u001a\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"\u001a\u000e\u0010#\u001a\u00020\"2\u0006\u0010!\u001a\u00020 \u001a\u0014\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00010'\u001a\u0016\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020\t\u001a\u000e\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\t\u001a&\u0010-\u001a\u00020\t2\u0016\u0010,\u001a\u0012\u0012\u0004\u0012\u00020\t0.j\b\u0012\u0004\u0012\u00020\t`/2\u0006\u00100\u001a\u00020\t\u001a\u000e\u00101\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\t\u001a\u0016\u00102\u001a\u0002032\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\t\u001a*\u00104\u001a\b\u0012\u0004\u0012\u00020\t0\r2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u00106\u001a\u00020\t2\u0006\u00107\u001a\u00020\u0004\u001a\"\u00108\u001a\b\u0012\u0004\u0012\u00020\t0\r2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u00109\u001a\u00020\t\u001a&\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\u0004\u001a\u000e\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u0012\u001a\u001e\u0010C\u001a\u00020A2\u0006\u0010D\u001a\u00020\u00172\u0006\u0010E\u001a\u00020 2\u0006\u0010F\u001a\u00020\u0019\u001a\u001e\u0010G\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u0004\u001a(\u0010H\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010I\u001a\u00020\u0012\u001a\"\u0010J\u001a\b\u0012\u0004\u0012\u00020\t0\r2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010K\u001a\u00020\t\u001a\u000e\u0010L\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\t\u001a\u000e\u0010M\u001a\u00020%2\u0006\u0010,\u001a\u00020\t\u001a\u000e\u0010N\u001a\u00020\t2\u0006\u0010,\u001a\u00020O\u001a\u000e\u0010P\u001a\u00020O2\u0006\u0010,\u001a\u00020\t\u001a \u0010Q\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\t2\b\b\u0002\u0010R\u001a\u00020\u0004\u00a8\u0006S"}, d2={"Color255to1f", "Lglm/vec4/Vec4;", "colors", "r", "", "g", "b", "a", "angle", "Lglm/vec3/Vec3;", "calcNorm", "c", "catmulize", "Lcom/badlogic/gdx/utils/Array;", "sourcePoints", "numOutputPoints", "", "looping", "", "catmulizeLp", "Lcom/mygdx/game/LineContainer;", "useDerivates", "createMeshShader", "Lcom/badlogic/gdx/graphics/glutils/ShaderProgram;", "vertexShaderPath", "", "fragmentShaderPath", "cslerp", "start", "end", "percent", "mat4gdx2glm", "Lglm/mat4x4/Mat4;", "m", "Lcom/badlogic/gdx/math/Matrix4;", "mat4glm2gdx", "mat4tofloatAr", "", "arlist", "", "mulV3", "mat", "vec", "nlize", "v", "proj", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "u", "pv", "quatFromVec", "Lglm/quat/Quat;", "rotatePoints", "points", "axis", "degrees", "scalePoints", "how", "screenCenterToTopDown", "Lglm/vec2/Vec2;", "x", "y", "screenWidth", "screenHeight", "setHWCursorVisible", "", "visible", "setUniformMatrix", "shaderProgram", "matrix", "uniformName", "slerp", "surfaceNormal", "clockwiseVerts", "translatePoints", "where", "vec2String", "vec3ToFloatAr", "vector3gdx2glm", "Lcom/badlogic/gdx/math/Vector3;", "vector3glm2gdx", "vequal", "tol", "core"})
public final class UtilsKt {
    @NotNull
    public static final Vec3 calcNorm(@NotNull Vec3 a, @NotNull Vec3 b, @NotNull Vec3 c) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(c, "c");
        return Vec3.normalize$default(func_geometric.DefaultImpls.cross$default((func_geometric)glm.INSTANCE, a.minus(b), c.minus(a), null, 4, null), null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Array<Vec3> catmulize(@NotNull Array<Vec3> sourcePoints, int numOutputPoints, boolean looping) {
        Intrinsics.checkParameterIsNotNull(sourcePoints, "sourcePoints");
        Array<Vector3> converted = new Array<Vector3>();
        Iterable $receiver$iv = sourcePoints;
        for (Object element$iv : $receiver$iv) {
            Vec3 it;
            Vec3 vec3 = it = (Vec3)element$iv;
            Intrinsics.checkExpressionValueIsNotNull(vec3, "it");
            converted.add(UtilsKt.vector3glm2gdx(vec3));
        }
        CatmullRomSpline k = new CatmullRomSpline((Vector[])converted.toArray(Vector3.class), looping);
        Array<Vec3> outArr = new Array<Vec3>();
        float ratio = 1.0f / (float)numOutputPoints;
        int it = 0;
        int n = numOutputPoints;
        if (it <= n) {
            while (true) {
                void i;
                Vector3 v3 = new Vector3();
                k.valueAt((Vector)v3, (float)i * ratio);
                outArr.add(UtilsKt.vector3gdx2glm(v3));
                if (i > 0 && i < 100) {
                    outArr.add(UtilsKt.vector3gdx2glm(v3));
                }
                if (i == n) break;
                ++i;
            }
        }
        return outArr;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final LineContainer catmulizeLp(@NotNull LineContainer sourcePoints, int numOutputPoints, boolean looping, boolean useDerivates) {
        Intrinsics.checkParameterIsNotNull(sourcePoints, "sourcePoints");
        Array<Vector3> converted = new Array<Vector3>();
        int n = 0;
        int n2 = sourcePoints.size() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                converted.add(UtilsKt.vector3glm2gdx(sourcePoints.get((int)i).getPos()));
                if (i == n2) break;
                ++i;
            }
        }
        CatmullRomSpline k = new CatmullRomSpline((Vector[])converted.toArray(Vector3.class), looping);
        LineContainer outArr = new LineContainer(sourcePoints.getUseColor(), sourcePoints.getUseDerivates());
        float ratio = 1.0f / (float)numOutputPoints;
        Vector3 v3 = new Vector3();
        Vector3 vd3 = new Vector3();
        int n3 = 0;
        int n4 = numOutputPoints;
        if (n3 <= n4) {
            while (true) {
                void i;
                float r = (float)i * ratio;
                k.valueAt((Vector)v3, r);
                if (useDerivates) {
                    k.derivativeAt((Vector)vd3, r);
                }
                Color c = sourcePoints.get((int)(i * (sourcePoints.size() - 1) / numOutputPoints)).getColor();
                outArr.add(new LinePoint(UtilsKt.vector3gdx2glm(v3), c, Vec3.normalize$default(UtilsKt.vector3gdx2glm(vd3), null, 1, null)));
                if (i == n4) break;
                ++i;
            }
        }
        return outArr;
    }

    @NotNull
    public static /* synthetic */ LineContainer catmulizeLp$default(LineContainer lineContainer, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        return UtilsKt.catmulizeLp(lineContainer, n, bl, bl2);
    }

    @NotNull
    public static final Vector3 vector3glm2gdx(@NotNull Vec3 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new Vector3(v.get(0), v.get(1), v.get(2));
    }

    @NotNull
    public static final Vec3 vector3gdx2glm(@NotNull Vector3 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new Vec3(v.x, v.y, v.z);
    }

    @NotNull
    public static final String vec2String(@NotNull Vec3 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return v.x.floatValue() + ", " + v.y.floatValue() + ", " + v.z.floatValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Matrix4 mat4glm2gdx(@NotNull Mat4 m) {
        Intrinsics.checkParameterIsNotNull(m, "m");
        Matrix4 mat = new Matrix4();
        int n = 0;
        int n2 = 3;
        while (n <= n2) {
            void i;
            Vec4 va = m.get((int)i);
            int n3 = 0;
            int n4 = 3;
            while (n3 <= n4) {
                void j;
                mat.getValues()[i * 4 + j] = va.get((int)j);
                ++j;
            }
            ++i;
        }
        return mat;
    }

    @NotNull
    public static final Vec2 screenCenterToTopDown(float x, float y, float screenWidth, float screenHeight) {
        return new Vec2(x - screenWidth / 2.0f, -y + screenHeight / (float)2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Mat4 mat4gdx2glm(@NotNull Matrix4 m) {
        Intrinsics.checkParameterIsNotNull(m, "m");
        Mat4 mat = new Mat4();
        int n = 0;
        int n2 = 3;
        while (n <= n2) {
            void i;
            int n3 = 0;
            int n4 = 3;
            while (n3 <= n4) {
                void j;
                mat.getValue().get((int)i).set((int)j, Float.valueOf(m.getValues()[4 * i + j]));
                ++j;
            }
            ++i;
        }
        return mat;
    }

    @NotNull
    public static final float[] vec3ToFloatAr(@NotNull Vec3 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new float[]{v.x.floatValue(), v.y.floatValue(), v.z.floatValue()};
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final float[] mat4tofloatAr(@NotNull List<Vec4> arlist) {
        Intrinsics.checkParameterIsNotNull(arlist, "arlist");
        int size = 16;
        float[] ra = new float[size];
        int n = 0;
        int n2 = 3;
        while (n <= n2) {
            void i;
            int n3 = 0;
            int n4 = 3;
            while (n3 <= n4) {
                void j;
                ra[i * 4 + j] = arlist.get((int)i).get((int)j);
                ++j;
            }
            ++i;
        }
        return ra;
    }

    public static final void setUniformMatrix(@NotNull ShaderProgram shaderProgram, @NotNull Mat4 matrix, @NotNull String uniformName) {
        Intrinsics.checkParameterIsNotNull(shaderProgram, "shaderProgram");
        Intrinsics.checkParameterIsNotNull(matrix, "matrix");
        Intrinsics.checkParameterIsNotNull(uniformName, "uniformName");
        float[] tmp = UtilsKt.mat4tofloatAr(matrix.getValue());
        shaderProgram.setUniformMatrix4fv(uniformName, tmp, 0, tmp.length);
    }

    @NotNull
    public static final ShaderProgram createMeshShader(@NotNull String vertexShaderPath, @NotNull String fragmentShaderPath) {
        Intrinsics.checkParameterIsNotNull(vertexShaderPath, "vertexShaderPath");
        Intrinsics.checkParameterIsNotNull(fragmentShaderPath, "fragmentShaderPath");
        ShaderProgram.pedantic = false;
        String vertexShader = Gdx.files.internal(vertexShaderPath).readString();
        String fragmentShader = Gdx.files.internal(fragmentShaderPath).readString();
        ShaderProgram shader = new ShaderProgram(vertexShader, fragmentShader);
        String log = shader.getLog();
        if (!shader.isCompiled()) {
            throw (Throwable)new GdxRuntimeException(vertexShaderPath + " and " + fragmentShaderPath + '\n' + log);
        }
        if (log != null && log.length() != 0) {
            String string = "Shader log: " + log;
            System.out.println((Object)string);
        }
        return shader;
    }

    @NotNull
    public static final Vec3 mulV3(@NotNull Mat4 mat, @NotNull Vec3 vec) {
        Intrinsics.checkParameterIsNotNull(mat, "mat");
        Intrinsics.checkParameterIsNotNull(vec, "vec");
        return new Vec3(mat.times(new Vec4(vec)));
    }

    public static final float angle(@NotNull Vec3 a, @NotNull Vec3 b) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        return glm.INSTANCE.dot(a, b) / (a.length() * b.length());
    }

    @NotNull
    public static final String pv(@NotNull Vec3 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return "(" + v.x.floatValue() + " " + v.y.floatValue() + " " + v.z.floatValue() + ")";
    }

    @NotNull
    public static final Vec3 proj(@NotNull ArrayList<Vec3> v, @NotNull Vec3 u) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        Intrinsics.checkParameterIsNotNull(u, "u");
        Vec3 out = new Vec3();
        Iterable $receiver$iv = v;
        for (Object element$iv : $receiver$iv) {
            Vec3 it = (Vec3)element$iv;
            float len = it.length();
            out = out.plus(it.times(glm.INSTANCE.dot(it, u) / (len * len)));
        }
        return out;
    }

    @NotNull
    public static final Vec3 surfaceNormal(@NotNull Vec3 a, @NotNull Vec3 b, @NotNull Vec3 c, boolean clockwiseVerts) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(c, "c");
        Vec3 u = b.minus(c);
        Vec3 v = a.minus(c);
        if (clockwiseVerts) {
            return func_geometric.DefaultImpls.cross$default((func_geometric)glm.INSTANCE, u, v, null, 4, null).normalize_();
        }
        return func_geometric.DefaultImpls.cross$default((func_geometric)glm.INSTANCE, v, u, null, 4, null).normalize_();
    }

    @NotNull
    public static /* synthetic */ Vec3 surfaceNormal$default(Vec3 vec3, Vec3 vec32, Vec3 vec33, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return UtilsKt.surfaceNormal(vec3, vec32, vec33, bl);
    }

    @NotNull
    public static final Array<Vec3> translatePoints(@NotNull Array<Vec3> points, @NotNull Vec3 where) {
        Intrinsics.checkParameterIsNotNull(points, "points");
        Intrinsics.checkParameterIsNotNull(where, "where");
        Array<Vec3> out = new Array<Vec3>();
        Mat4 rMat = new Mat4();
        rMat = glm.INSTANCE.translate(rMat, where);
        Iterable $receiver$iv = points;
        for (Object element$iv : $receiver$iv) {
            Vec3 it;
            Vec3 vec3 = it = (Vec3)element$iv;
            Intrinsics.checkExpressionValueIsNotNull(vec3, "it");
            out.add(new Vec3(rMat.times(new Vec4(vec3, Float.valueOf(1.0f)))));
        }
        return out;
    }

    @NotNull
    public static final Array<Vec3> scalePoints(@NotNull Array<Vec3> points, @NotNull Vec3 how) {
        Intrinsics.checkParameterIsNotNull(points, "points");
        Intrinsics.checkParameterIsNotNull(how, "how");
        Array<Vec3> out = new Array<Vec3>();
        Mat4 rMat = new Mat4();
        rMat = glm.INSTANCE.scale(rMat, how);
        Iterable $receiver$iv = points;
        for (Object element$iv : $receiver$iv) {
            Vec3 it;
            Vec3 vec3 = it = (Vec3)element$iv;
            Intrinsics.checkExpressionValueIsNotNull(vec3, "it");
            out.add(new Vec3(rMat.times(new Vec4(vec3, Float.valueOf(0.0f)))));
        }
        return out;
    }

    @NotNull
    public static final Array<Vec3> rotatePoints(@NotNull Array<Vec3> points, @NotNull Vec3 axis, float degrees) {
        Intrinsics.checkParameterIsNotNull(points, "points");
        Intrinsics.checkParameterIsNotNull(axis, "axis");
        Array<Vec3> out = new Array<Vec3>();
        Mat4 rMat = new Mat4();
        rMat = glm.INSTANCE.rotate(rMat, (float)Math.PI / 180 * degrees, axis);
        Iterable $receiver$iv = points;
        for (Object element$iv : $receiver$iv) {
            Vec3 it;
            Vec3 vec3 = it = (Vec3)element$iv;
            Intrinsics.checkExpressionValueIsNotNull(vec3, "it");
            out.add(new Vec3(rMat.times(new Vec4(vec3, Float.valueOf(0.0f)))));
        }
        return out;
    }

    public static final void setHWCursorVisible(boolean visible) {
    }

    @NotNull
    public static final Vec3 nlize(@NotNull Vec3 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        float length = v.length();
        return new Vec3(v.x.floatValue() / length, v.y.floatValue() / length, v.z.floatValue() / length);
    }

    public static final boolean vequal(@NotNull Vec3 a, @NotNull Vec3 b, float tol) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        return MathUtils.isEqual(a.x.floatValue(), b.x.floatValue(), tol) && MathUtils.isEqual(a.y.floatValue(), b.y.floatValue(), tol) && MathUtils.isEqual(a.z.floatValue(), b.z.floatValue(), tol);
    }

    public static /* synthetic */ boolean vequal$default(Vec3 vec3, Vec3 vec32, float f, int n, Object object) {
        if ((n & 4) != 0) {
            f = 1.0E-6f;
        }
        return UtilsKt.vequal(vec3, vec32, f);
    }

    @NotNull
    public static final Vec3 slerp(@NotNull Vec3 start, @NotNull Vec3 end, float percent) {
        Intrinsics.checkParameterIsNotNull(start, "start");
        Intrinsics.checkParameterIsNotNull(end, "end");
        float dot = glm.INSTANCE.dot(start, end);
        MathUtils.clamp(dot, -1.0f, 1.0f);
        float theta = (float)(Math.acos(dot) * (double)percent);
        Vec3 RelativeVec = end.minus(start.times(dot));
        Vec3.normalize$default(RelativeVec, null, 1, null);
        return start.times(MathUtils.cos(theta)).plus(RelativeVec.times(MathUtils.sin(theta)));
    }

    @NotNull
    public static final Vec3 cslerp(@NotNull Vec3 start, @NotNull Vec3 end, float percent) {
        Intrinsics.checkParameterIsNotNull(start, "start");
        Intrinsics.checkParameterIsNotNull(end, "end");
        double dot = glm.INSTANCE.dot(start, end);
        double angle = Math.acos(dot) / (double)(start.length() * end.length());
        double dp = MathUtils.clamp(percent, 0.0f, 1.0f);
        double d = (double)1.0f - dp;
        Vec3 vec3 = start;
        double d2 = Math.sin(d);
        double d3 = Math.sin(angle);
        d = dp * angle;
        Vec3 vec32 = end;
        vec3 = vec3.times(d2 / d3);
        double d4 = Math.sin(d);
        double d5 = Math.sin(angle);
        return vec3.plus(vec32.times(d4 / d5));
    }

    @NotNull
    public static final Quat quatFromVec(float angle, @NotNull Vec3 vec) {
        Intrinsics.checkParameterIsNotNull(vec, "vec");
        float f = angle / 2.0f;
        float f2 = (float)Math.cos(f);
        f = angle / 2.0f;
        float f3 = vec.x.floatValue();
        float f4 = (float)Math.sin(f);
        float f5 = f3 * f4;
        f = angle / 2.0f;
        f4 = vec.y.floatValue();
        f3 = f5;
        float f6 = (float)Math.sin(f);
        float f7 = f4 * f6;
        f = angle / 2.0f;
        f6 = vec.z.floatValue();
        f4 = f7;
        float f8 = (float)Math.sin(f);
        float f9 = f6 * f8;
        float f10 = f4;
        float f11 = f3;
        float f12 = f2;
        return new Quat(f12, f11, f10, f9);
    }

    @NotNull
    public static final Vec4 Color255to1f(@NotNull Vec4 colors) {
        Intrinsics.checkParameterIsNotNull(colors, "colors");
        return UtilsKt.Color255to1f(colors.x.floatValue(), colors.y.floatValue(), colors.z.floatValue(), colors.w.floatValue());
    }

    @NotNull
    public static final Vec4 Color255to1f(float r, float g, float b, float a) {
        return new Vec4(r / 255.0f, g / 255.0f, b / 255.0f, a / 255.0f);
    }

    @NotNull
    public static /* synthetic */ Vec4 Color255to1f$default(float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 8) != 0) {
            f4 = 255.0f;
        }
        return UtilsKt.Color255to1f(f, f2, f3, f4);
    }
}

