/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.Queue;
import com.badlogic.gdx.utils.SnapshotArray;
import com.mygdx.game.Config;
import com.mygdx.game.Debug;
import com.mygdx.game.DrawManager;
import com.mygdx.game.Drawable;
import com.mygdx.game.MockScene;
import com.mygdx.game.RuntimeDemoException;
import com.mygdx.game.Scene;
import com.mygdx.game.app.NetworkLights;
import com.mygdx.game.scenes.demo1.EyesDSC;
import com.mygdx.game.scenes.demo1.FinalDSC;
import com.mygdx.game.scenes.demo1.FlyStartDSC;
import com.mygdx.game.scenes.demo1.StartContinueDSC;
import com.mygdx.game.scenes.demo1.TriangleWaveDSC;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002:\u00016B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0007J\u0016\u0010\u001b\u001a\u00020\u001a2\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0017J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0007H\u0002J\b\u0010\u001e\u001a\u00020\u001aH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020\"H\u0016J\u000e\u0010*\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0007J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0007H\u0002J\u000e\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020\"H\u0016J(\u00101\u001a\u00020 2\u0006\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020\"2\u0006\u00102\u001a\u00020\"2\u0006\u00103\u001a\u00020\"H\u0016J \u00104\u001a\u00020 2\u0006\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020\"2\u0006\u00102\u001a\u00020\"H\u0016J(\u00105\u001a\u00020 2\u0006\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020\"2\u0006\u00102\u001a\u00020\"2\u0006\u00103\u001a\u00020\"H\u0016R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00060\u0014R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R:\u0010\u0015\u001a.\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0017\u0012\u0004\u0012\u00020\u00070\u0016j\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0017\u0012\u0004\u0012\u00020\u0007`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/mygdx/game/SceneManager;", "Lcom/badlogic/gdx/InputProcessor;", "Lcom/badlogic/gdx/utils/Disposable;", "cfg", "Lcom/mygdx/game/Config;", "s", "Lcom/badlogic/gdx/utils/Array;", "Lcom/mygdx/game/Scene;", "(Lcom/mygdx/game/Config;Lcom/badlogic/gdx/utils/Array;)V", "(Lcom/mygdx/game/Config;)V", "activeScene", "getCfg", "()Lcom/mygdx/game/Config;", "drawManager", "Lcom/mygdx/game/DrawManager;", "getDrawManager", "()Lcom/mygdx/game/DrawManager;", "removeQueue", "Lcom/badlogic/gdx/utils/Queue;", "sceneIterator", "Lcom/mygdx/game/SceneManager$SceneIterator;", "scenes", "Ljava/util/HashMap;", "Lkotlin/reflect/KClass;", "Lkotlin/collections/HashMap;", "add", "", "change", "to", "changeScene", "dispose", "keyDown", "", "keycode", "", "keyTyped", "character", "", "keyUp", "mouseMoved", "screenX", "screenY", "queueSceneRemoval", "removeScene", "render", "delta", "", "scrolled", "amount", "touchDown", "pointer", "button", "touchDragged", "touchUp", "SceneIterator", "core"})
public final class SceneManager
implements InputProcessor,
Disposable {
    private final HashMap<KClass<? extends Scene>, Scene> scenes;
    @NotNull
    private final DrawManager drawManager;
    private Scene activeScene;
    private Queue<Scene> removeQueue;
    private SceneIterator sceneIterator;
    @NotNull
    private final Config cfg;

    @Override
    public void dispose() {
        this.drawManager.dispose();
    }

    @NotNull
    public final DrawManager getDrawManager() {
        return this.drawManager;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        if (!this.cfg.getDEMOPRESENTATION()) {
            if (keycode == 244) {
                this.changeScene(this.sceneIterator.prev(this.scenes));
                Scene scene = this.activeScene;
                System.out.println(scene);
                return true;
            }
            if (keycode == 245) {
                this.changeScene(this.sceneIterator.next(this.scenes));
                Scene scene = this.activeScene;
                System.out.println(scene);
                return true;
            }
            if (keycode == 248) {
                this.cfg.setEnableBloom(!this.cfg.getEnableBloom());
                this.activeScene.getDebug().addScreenMsg("bloom", String.valueOf(this.cfg.getEnableBloom()));
            }
            if (keycode == 252) {
                Config config = this.cfg;
                config.setBloomIntensity(config.getBloomIntensity() - 0.3f);
                this.activeScene.getDebug().addScreenMsg("extractBright intensity", Float.valueOf(this.cfg.getBloomIntensity()));
            }
            if (keycode == 253) {
                Config config = this.cfg;
                config.setBloomIntensity(config.getBloomIntensity() + 0.3f);
                this.activeScene.getDebug().addScreenMsg("extractBright intensity", Float.valueOf(this.cfg.getBloomIntensity()));
            }
            if (keycode == 250) {
                Config config = this.cfg;
                config.setBloomDiv(config.getBloomDiv() - 1.5f);
                this.activeScene.getDebug().addScreenMsg("bloom div intensity", Float.valueOf(this.cfg.getBloomDiv()));
            }
            if (keycode == 251) {
                Config config = this.cfg;
                config.setBloomDiv(config.getBloomDiv() + 1.5f);
                this.activeScene.getDebug().addScreenMsg("bloom div intensity", Float.valueOf(this.cfg.getBloomDiv()));
            }
            this.activeScene.getCam().keyUp(keycode);
        }
        return false;
    }

    public final void queueSceneRemoval(@NotNull Scene s) {
        Intrinsics.checkParameterIsNotNull(s, "s");
        if (Intrinsics.areEqual(this.activeScene, s) ^ true && !CollectionsKt.contains((Iterable)this.removeQueue, s)) {
            this.removeQueue.addLast(s);
        }
    }

    public final void change(@NotNull KClass<? extends Scene> to) {
        Intrinsics.checkParameterIsNotNull(to, "to");
        Scene scene = this.scenes.get(to);
        if (scene == null) {
            throw (Throwable)new RuntimeDemoException("scene " + to.toString() + " does not exist!");
        }
        this.changeScene(scene);
    }

    private final void changeScene(Scene s) {
        SnapshotArray<InputProcessor> snapshotArray = this.cfg.getInputMultiplexer().getProcessors();
        Intrinsics.checkExpressionValueIsNotNull(snapshotArray, "cfg.inputMultiplexer.processors");
        if (CollectionsKt.contains((Iterable)snapshotArray, this.activeScene)) {
            this.cfg.getInputMultiplexer().removeProcessor(this.activeScene);
        }
        Scene holder = this.activeScene;
        this.activeScene = s;
        holder.onExit(s);
        this.activeScene.onEnter(this.activeScene);
        SnapshotArray<InputProcessor> snapshotArray2 = this.cfg.getInputMultiplexer().getProcessors();
        Intrinsics.checkExpressionValueIsNotNull(snapshotArray2, "cfg.inputMultiplexer.processors");
        if (!CollectionsKt.contains((Iterable)snapshotArray2, this.activeScene)) {
            this.cfg.getInputMultiplexer().addProcessor(this.activeScene);
        }
    }

    private final void removeScene(Scene s) {
        if (Intrinsics.areEqual(this.activeScene, s) ^ true && !CollectionsKt.contains((Iterable)this.removeQueue, s)) {
            this.removeQueue.addLast(s);
        }
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    @Override
    public boolean keyDown(int keycode) {
        this.activeScene.getCam().keyDown(keycode);
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        if (!this.cfg.getDEMOPRESENTATION()) {
            switch (button) {
                case 1: {
                    this.activeScene.reset();
                    break;
                }
                case 0: {
                    Scene newScene = this.sceneIterator.next(this.scenes);
                    this.changeScene(newScene);
                }
            }
            return true;
        }
        return false;
    }

    public final void add(@NotNull Scene s) {
        Intrinsics.checkParameterIsNotNull(s, "s");
        Map map = this.scenes;
        KClass kClass = Reflection.getOrCreateKotlinClass(s.getClass());
        Scene scene = s;
        map.put(kClass, scene);
    }

    public final void render(float delta) {
        Drawable it;
        if (!this.removeQueue.isEmpty()) {
            Scene s = this.removeQueue.first();
            s.dispose(delta);
            this.scenes.remove(Reflection.getOrCreateKotlinClass(s.getClass()));
        }
        NetworkLights networkLights = this.cfg.getNetworkLights();
        if (networkLights != null) {
            networkLights.update(delta);
        }
        this.cfg.getMusic().update(this.activeScene.getDebug());
        this.activeScene.getCam().update(delta, this.activeScene.getCam());
        this.activeScene.update(delta);
        Iterable $receiver$iv = this.activeScene.getDrawables();
        for (Object element$iv : $receiver$iv) {
            it = (Drawable)element$iv;
            it.update(delta, this.activeScene.getCam());
        }
        $receiver$iv = this.activeScene.getDrawablesBlendSkyBox();
        for (Object element$iv : $receiver$iv) {
            it = (Drawable)element$iv;
            it.update(delta, this.activeScene.getCam());
        }
        this.drawManager.render(delta, this.activeScene.getDrawables(), this.activeScene.getDrawablesBlendSkyBox(), this.activeScene.getCam());
        Debug debug = this.activeScene.getDebug();
        Graphics graphics = Gdx.graphics;
        Intrinsics.checkExpressionValueIsNotNull(graphics, "Gdx.graphics");
        debug.addScreenMsg("FPS: ", graphics.getFramesPerSecond());
        this.activeScene.getDebug().drawMessages(this.drawManager.getSb());
    }

    @NotNull
    public final Config getCfg() {
        return this.cfg;
    }

    public SceneManager(@NotNull Config cfg) {
        Intrinsics.checkParameterIsNotNull(cfg, "cfg");
        this.cfg = cfg;
        this.scenes = new HashMap();
        this.drawManager = new DrawManager(this.cfg);
        this.activeScene = new MockScene(this.cfg, this.drawManager);
        this.removeQueue = new Queue();
        this.cfg.setSceneManager(this);
        this.add(new FinalDSC(this.cfg, this.drawManager));
        this.add(new FlyStartDSC(this.cfg, this.drawManager));
        this.add(new StartContinueDSC(this.cfg, this.drawManager));
        this.add(new EyesDSC(this.cfg, this.drawManager));
        this.add(new TriangleWaveDSC(this.cfg, this.drawManager));
        if (this.cfg.getDEMOPRESENTATION()) {
            Scene scene = this.scenes.get(Reflection.getOrCreateKotlinClass(FlyStartDSC.class));
            if (scene == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(scene, "scenes.get(FlyStartDSC::class)!!");
            this.changeScene(scene);
        } else {
            Scene scene = this.scenes.get(Reflection.getOrCreateKotlinClass(TriangleWaveDSC.class));
            if (scene == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(scene, "scenes.get(TriangleWaveDSC::class)!!");
            this.changeScene(scene);
        }
        this.sceneIterator = new SceneIterator(this.scenes);
    }

    public SceneManager(@NotNull Config cfg, @NotNull Array<? extends Scene> s) {
        Intrinsics.checkParameterIsNotNull(cfg, "cfg");
        Intrinsics.checkParameterIsNotNull(s, "s");
        this(cfg);
        Iterable $receiver$iv = s;
        for (Object element$iv : $receiver$iv) {
            Scene it;
            Scene scene = it = (Scene)element$iv;
            Intrinsics.checkExpressionValueIsNotNull(scene, "it");
            this.add(scene);
        }
        Collection<Scene> collection = this.scenes.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, "scenes.values");
        Object t = CollectionsKt.first((Iterable)collection);
        Intrinsics.checkExpressionValueIsNotNull(t, "scenes.values.first()");
        this.activeScene = (Scene)t;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B9\u00122\u0010\u0002\u001a.\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\u0002\u0010\u0007J:\u0010\f\u001a\u00020\u000522\u0010\u0002\u001a.\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u0005`\u0006J:\u0010\r\u001a\u00020\u000522\u0010\u0002\u001a.\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u0005`\u0006R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/mygdx/game/SceneManager$SceneIterator;", "", "scenes", "Ljava/util/HashMap;", "Lkotlin/reflect/KClass;", "Lcom/mygdx/game/Scene;", "Lkotlin/collections/HashMap;", "(Lcom/mygdx/game/SceneManager;Ljava/util/HashMap;)V", "iterTable", "Lcom/badlogic/gdx/utils/Array;", "sIndex", "", "next", "prev", "core"})
    public final class SceneIterator {
        private final Array<KClass<? extends Scene>> iterTable;
        private int sIndex;

        @NotNull
        public final Scene next(@NotNull HashMap<KClass<? extends Scene>, Scene> scenes) {
            Intrinsics.checkParameterIsNotNull(scenes, "scenes");
            int n = this.sIndex;
            this.sIndex = n + 1;
            if (this.sIndex > this.iterTable.size - 1) {
                this.sIndex = 0;
            }
            Scene scene = scenes.get(this.iterTable.get(this.sIndex));
            if (scene == null) {
                Intrinsics.throwNpe();
            }
            return scene;
        }

        @NotNull
        public final Scene prev(@NotNull HashMap<KClass<? extends Scene>, Scene> scenes) {
            Intrinsics.checkParameterIsNotNull(scenes, "scenes");
            int n = this.sIndex;
            this.sIndex = n + -1;
            if (this.sIndex < 0) {
                this.sIndex = this.iterTable.size - 1;
            }
            Scene scene = scenes.get(this.iterTable.get(this.sIndex));
            if (scene == null) {
                Intrinsics.throwNpe();
            }
            return scene;
        }

        public SceneIterator(HashMap<KClass<? extends Scene>, Scene> scenes) {
            Intrinsics.checkParameterIsNotNull(scenes, "scenes");
            this.iterTable = new Array();
            this.iterTable.ordered = true;
            Collection<Scene> collection = scenes.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, "scenes.values");
            Iterable $receiver$iv = collection;
            for (Object element$iv : $receiver$iv) {
                Scene it = (Scene)element$iv;
                this.iterTable.add(Reflection.getOrCreateKotlinClass(it.getClass()));
            }
        }
    }
}

