/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.mygdx.game.Camera;
import com.mygdx.game.Config;
import com.mygdx.game.Debug;
import com.mygdx.game.Drawable;
import com.mygdx.game.LineContainer;
import com.mygdx.game.LinePoint;
import com.mygdx.game.LineVertexBlock;
import com.mygdx.game.RuntimeDemoException;
import com.mygdx.game.UtilsKt;
import glm.mat4x4.Mat4;
import glm.vec3.Vec3;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ2\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00012\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\b\b\u0002\u00106\u001a\u00020\u000bH\u0002J6\u00107\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00012\u0006\u00100\u001a\u0002012\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u00104\u001a\u0002052\u0006\u00108\u001a\u0002032\u0006\u00106\u001a\u00020\u000bJ\u0016\u00109\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0007J\u0018\u0010:\u001a\u00020.2\u0006\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020=H\u0016J\u0018\u0010>\u001a\u00020.2\u0006\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020=H\u0016R\u0014\u0010\r\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000fR\u0011\u0010\u0019\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000fR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0014R\u000e\u0010&\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u0006?"}, d2={"Lcom/mygdx/game/Linefeed;", "Lcom/mygdx/game/Drawable;", "cfg", "Lcom/mygdx/game/Config;", "debug", "Lcom/mygdx/game/Debug;", "maxVerts", "", "thicknessMultiplier", "", "allowMultipleQueues", "", "(Lcom/mygdx/game/Config;Lcom/mygdx/game/Debug;IFZ)V", "MAX_VERTS", "getMAX_VERTS", "()I", "getAllowMultipleQueues", "()Z", "baseLineThickness", "getBaseLineThickness", "()F", "getDebug", "()Lcom/mygdx/game/Debug;", "maxIndices", "getMaxIndices", "maxNumVerts", "getMaxNumVerts", "mesh", "Lcom/badlogic/gdx/graphics/Mesh;", "getMesh", "()Lcom/badlogic/gdx/graphics/Mesh;", "setMesh", "(Lcom/badlogic/gdx/graphics/Mesh;)V", "sp", "Lcom/badlogic/gdx/graphics/glutils/ShaderProgram;", "getSp", "()Lcom/badlogic/gdx/graphics/glutils/ShaderProgram;", "getThicknessMultiplier", "triangleIndex", "vertices", "Lcom/mygdx/game/LineVertexBlock;", "getVertices", "()Lcom/mygdx/game/LineVertexBlock;", "setVertices", "(Lcom/mygdx/game/LineVertexBlock;)V", "createLines", "", "d", "points", "Lcom/mygdx/game/LineContainer;", "modelMat", "Lglm/mat4x4/Mat4;", "campos", "Lglm/vec3/Vec3;", "continuous", "queuePoints", "modelMatrix", "register", "render", "delta", "cam", "Lcom/mygdx/game/Camera;", "update", "core"})
public final class Linefeed
extends Drawable {
    private final float baseLineThickness = 8.0E-4f;
    private final int maxNumVerts;
    private final int MAX_VERTS;
    private final int maxIndices;
    @NotNull
    private Mesh mesh;
    @NotNull
    private LineVertexBlock vertices;
    @NotNull
    private final ShaderProgram sp;
    private int triangleIndex;
    @Nullable
    private final Debug debug;
    private final float thicknessMultiplier;
    private final boolean allowMultipleQueues;

    public final float getBaseLineThickness() {
        return this.baseLineThickness;
    }

    public final int getMaxNumVerts() {
        return this.maxNumVerts;
    }

    @Override
    public int getMAX_VERTS() {
        return this.MAX_VERTS;
    }

    public final int getMaxIndices() {
        return this.maxIndices;
    }

    @NotNull
    public final Mesh getMesh() {
        return this.mesh;
    }

    public final void setMesh(@NotNull Mesh mesh) {
        Intrinsics.checkParameterIsNotNull(mesh, "<set-?>");
        this.mesh = mesh;
    }

    @NotNull
    public final LineVertexBlock getVertices() {
        return this.vertices;
    }

    public final void setVertices(@NotNull LineVertexBlock lineVertexBlock) {
        Intrinsics.checkParameterIsNotNull(lineVertexBlock, "<set-?>");
        this.vertices = lineVertexBlock;
    }

    @NotNull
    public final ShaderProgram getSp() {
        return this.sp;
    }

    public final void register(@NotNull Drawable d, int maxNumVerts) {
        Intrinsics.checkParameterIsNotNull(d, "d");
        this.vertices.register(d, maxNumVerts);
    }

    public final void queuePoints(@NotNull Drawable d, @NotNull LineContainer points, int maxNumVerts, @NotNull Vec3 campos, @NotNull Mat4 modelMatrix, boolean continuous) {
        Intrinsics.checkParameterIsNotNull(d, "d");
        Intrinsics.checkParameterIsNotNull(points, "points");
        Intrinsics.checkParameterIsNotNull(campos, "campos");
        Intrinsics.checkParameterIsNotNull(modelMatrix, "modelMatrix");
        if (points.size() * 2 > maxNumVerts) {
            throw (Throwable)new RuntimeDemoException("trying to queue more " + "vertices than allowed. (" + points.size() * 2 + " > " + maxNumVerts + ") " + "Increase the maxNumVerts.");
        }
        this.createLines(d, points, modelMatrix, campos, continuous);
    }

    @Override
    public void update(float delta, @NotNull Camera cam) {
        Intrinsics.checkParameterIsNotNull(cam, "cam");
    }

    @Override
    public void render(float delta, @NotNull Camera cam) {
        Intrinsics.checkParameterIsNotNull(cam, "cam");
        ShaderProgram $receiver$iv = this.sp;
        $receiver$iv.begin();
        ShaderProgram it = $receiver$iv;
        UtilsKt.setUniformMatrix(this.sp, cam.projection(), "proj");
        UtilsKt.setUniformMatrix(this.sp, cam.view(), "view");
        this.sp.setUniformf("thickness", this.baseLineThickness * this.thicknessMultiplier);
        this.sp.setUniform3fv("campos", UtilsKt.vec3ToFloatAr(cam.getPos()), 0, 4);
        this.vertices.flush(this.mesh, this.sp, 4, 0);
        if (this.allowMultipleQueues) {
            this.triangleIndex = 0;
        }
        $receiver$iv.end();
    }

    /*
     * WARNING - void declaration
     */
    private final void createLines(Drawable d, LineContainer points, Mat4 modelMat, Vec3 campos, boolean continuous) {
        int s = 2;
        if (continuous) {
            s = 1;
        }
        if (!this.allowMultipleQueues) {
            this.triangleIndex = 0;
        }
        Vec3 opa = new Vec3();
        Vec3 opb = new Vec3();
        int n = 0;
        IntProgression intProgression = RangesKt.step(new IntRange(n, points.size() - 1), s);
        int n2 = intProgression.getFirst();
        int n3 = intProgression.getLast();
        int n4 = intProgression.getStep();
        int n5 = n2;
        int n6 = n3;
        if (n4 > 0 ? n5 <= n6 : n5 >= n6) {
            void i;
            while (i < points.size() - 1) {
                LinePoint a = points.get((int)i);
                LinePoint b = points.get((int)(i + true));
                opa = UtilsKt.mulV3(modelMat, a.getPos());
                opb = UtilsKt.mulV3(modelMat, b.getPos());
                Vec3 normal = UtilsKt.calcNorm(opa, opb, campos);
                this.vertices.queueVertex(d, opa, normal.unaryMinus(), a.getColor());
                this.vertices.queueVertex(d, opa, normal, a.getColor());
                this.vertices.queueVertex(d, opb, normal.unaryMinus(), b.getColor());
                this.vertices.queueVertex(d, opb, normal, b.getColor());
                this.vertices.queueIndex(d, (short)this.triangleIndex);
                this.vertices.queueIndex(d, (short)(this.triangleIndex + 2));
                this.vertices.queueIndex(d, (short)(this.triangleIndex + 1));
                this.vertices.queueIndex(d, (short)(this.triangleIndex + 1));
                this.vertices.queueIndex(d, (short)(this.triangleIndex + 3));
                this.vertices.queueIndex(d, (short)(this.triangleIndex + 2));
                this.triangleIndex += 4;
                if (i == n3) break;
                i += n4;
            }
        }
    }

    static /* synthetic */ void createLines$default(Linefeed linefeed, Drawable drawable, LineContainer lineContainer, Mat4 mat4, Vec3 vec3, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        linefeed.createLines(drawable, lineContainer, mat4, vec3, bl);
    }

    @Nullable
    public final Debug getDebug() {
        return this.debug;
    }

    public final float getThicknessMultiplier() {
        return this.thicknessMultiplier;
    }

    public final boolean getAllowMultipleQueues() {
        return this.allowMultipleQueues;
    }

    public Linefeed(@NotNull Config cfg, @Nullable Debug debug, int maxVerts, float thicknessMultiplier, boolean allowMultipleQueues) {
        Intrinsics.checkParameterIsNotNull(cfg, "cfg");
        super(cfg);
        this.debug = debug;
        this.thicknessMultiplier = thicknessMultiplier;
        this.allowMultipleQueues = allowMultipleQueues;
        this.baseLineThickness = 8.0E-4f;
        this.maxNumVerts = maxVerts;
        this.MAX_VERTS = this.maxNumVerts * this.getPOSITION_COMPONENTS() * this.getNORMAL_COMPONENTS() * this.getCOLOR_COMPONENTS();
        this.maxIndices = this.getMAX_VERTS();
        this.mesh = new Mesh(false, this.getMAX_VERTS(), this.maxIndices, new VertexAttribute(1, this.getPOSITION_COMPONENTS(), "a_position"), new VertexAttribute(8, this.getNORMAL_COMPONENTS(), "a_normal"), new VertexAttribute(2, this.getCOLOR_COMPONENTS(), "a_color"));
        this.vertices = new LineVertexBlock(this.getMAX_VERTS(), this.maxIndices);
        this.sp = cfg.getShader("linepump");
    }

    public /* synthetic */ Linefeed(Config config, Debug debug, int n, float f, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            f = 1.0f;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        this(config, debug, n, f, bl);
    }
}

