/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.math.Interpolation;
import com.mygdx.game.Camera;
import com.mygdx.game.Config;
import com.mygdx.game.DemoObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0018\u001a\u00020\u0007J\u0006\u0010\u0019\u001a\u00020\nJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Lcom/mygdx/game/LerpService;", "Lcom/mygdx/game/DemoObject;", "cfg", "Lcom/mygdx/game/Config;", "type", "Lcom/badlogic/gdx/math/Interpolation;", "lengthInSeconds", "", "(Lcom/mygdx/game/Config;Lcom/badlogic/gdx/math/Interpolation;F)V", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "getLengthInSeconds", "()F", "setLengthInSeconds", "(F)V", "runningTime", "getRunningTime", "setRunningTime", "getType", "()Lcom/badlogic/gdx/math/Interpolation;", "apply", "isFinished", "reset", "", "update", "delta", "cam", "Lcom/mygdx/game/Camera;", "core"})
public final class LerpService
extends DemoObject {
    private boolean enabled;
    private float runningTime;
    @NotNull
    private final Interpolation type;
    private float lengthInSeconds;

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public void reset() {
        this.runningTime = 0.0f;
    }

    @Override
    public void update(float delta, @NotNull Camera cam) {
        Intrinsics.checkParameterIsNotNull(cam, "cam");
        if (this.enabled) {
            this.runningTime += delta;
        }
    }

    public final float getRunningTime() {
        return this.runningTime;
    }

    public final void setRunningTime(float f) {
        this.runningTime = f;
    }

    public final boolean isFinished() {
        return this.apply() >= 1.0f;
    }

    public final float apply() {
        float progress = Math.min(1.0f, this.runningTime / this.lengthInSeconds);
        return this.type.apply(progress);
    }

    @NotNull
    public final Interpolation getType() {
        return this.type;
    }

    public final float getLengthInSeconds() {
        return this.lengthInSeconds;
    }

    public final void setLengthInSeconds(float f) {
        this.lengthInSeconds = f;
    }

    public LerpService(@NotNull Config cfg, @NotNull Interpolation type, float lengthInSeconds) {
        Intrinsics.checkParameterIsNotNull(cfg, "cfg");
        Intrinsics.checkParameterIsNotNull(type, "type");
        super(cfg);
        this.type = type;
        this.lengthInSeconds = lengthInSeconds;
    }
}

