/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.math.Interpolation;
import com.mygdx.game.Config;
import com.mygdx.game.DrawManager;
import com.mygdx.game.LerpService;
import com.mygdx.game.Scene;
import com.mygdx.game.Timestamp;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0001H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/mygdx/game/DemoScene;", "Lcom/mygdx/game/Scene;", "cfg", "Lcom/mygdx/game/Config;", "drawManager", "Lcom/mygdx/game/DrawManager;", "musicStarts", "Lcom/mygdx/game/Timestamp;", "(Lcom/mygdx/game/Config;Lcom/mygdx/game/DrawManager;Lcom/mygdx/game/Timestamp;)V", "fadeIn", "Lcom/mygdx/game/LerpService;", "getFadeIn", "()Lcom/mygdx/game/LerpService;", "fadeOut", "getFadeOut", "getMusicStarts", "()Lcom/mygdx/game/Timestamp;", "onExit", "", "toScene", "reset", "update", "delta", "", "core"})
public abstract class DemoScene
extends Scene {
    @NotNull
    private final LerpService fadeIn;
    @NotNull
    private final LerpService fadeOut;
    @NotNull
    private final Timestamp musicStarts;

    @Override
    public void reset() {
        this.getCfg().setRunningTime(this.musicStarts.getSeconds());
        if (this.getCfg().getAllowMusicReset()) {
            this.getCfg().getMusic().play(this.musicStarts);
        }
    }

    @Override
    public void onExit(@NotNull Scene toScene) {
        Intrinsics.checkParameterIsNotNull(toScene, "toScene");
        if (this.getCfg().getDEMOPRESENTATION()) {
            this.getCfg().getSceneManager().queueSceneRemoval(this);
        }
    }

    @Override
    public void update(float delta) {
        this.fadeIn.update(delta, this.getCam());
        this.fadeOut.update(delta, this.getCam());
    }

    @NotNull
    public final LerpService getFadeIn() {
        return this.fadeIn;
    }

    @NotNull
    public final LerpService getFadeOut() {
        return this.fadeOut;
    }

    @NotNull
    public final Timestamp getMusicStarts() {
        return this.musicStarts;
    }

    public DemoScene(@NotNull Config cfg, @NotNull DrawManager drawManager, @NotNull Timestamp musicStarts) {
        Intrinsics.checkParameterIsNotNull(cfg, "cfg");
        Intrinsics.checkParameterIsNotNull(drawManager, "drawManager");
        Intrinsics.checkParameterIsNotNull(musicStarts, "musicStarts");
        super(cfg, drawManager);
        this.musicStarts = musicStarts;
        Interpolation interpolation = Interpolation.linear;
        Intrinsics.checkExpressionValueIsNotNull(interpolation, "Interpolation.linear");
        this.fadeIn = new LerpService(cfg, interpolation, 1.0f);
        Interpolation interpolation2 = Interpolation.linear;
        Intrinsics.checkExpressionValueIsNotNull(interpolation2, "Interpolation.linear");
        this.fadeOut = new LerpService(cfg, interpolation2, 1.0f);
    }
}

