function ferryLights(animation) {
    var lights = [
         {"r":0xFF, "g":0x00, "b":0x00}
        ,{"r":0xFF, "g":0xFF, "b":0xFF}
    ];
    if (dmxLightManager.isInitialized()) {

        var p = (Math.sin(getSceneTimeFromStart()*10.0)+1.0)/2.0;

        for (var i = 0; i < dmxLightManager.lightCount; i++) {
            var l = lights[i%lights.length];
            var light = dmxLightManager.headerSize + 6 * i;
            dmxLightManager.dataPacket[light + 3] = l.r * p;
            dmxLightManager.dataPacket[light + 4] = l.g * p;
            dmxLightManager.dataPacket[light + 5] = l.b * p;
        }

        dmxLightManager.sendData();

    }
}

Demo.prototype.init = function()
{
    if (dmxLightManager === void null) {
        // in case menu did not exist
        dmxLightManager = new DmxLightManager();
        dmxLightManager.sock.setHost(dmxLightManagerSettings.host);
        dmxLightManager.sock.setPort(parseInt(dmxLightManagerSettings.port));
        dmxLightManager.init(parseInt(dmxLightManagerSettings.count));
    }

    var start = 0;
    var duration = Settings.demo.length;
    var layer = 1;

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": Settings.demo.custom.background
        ,"scale":JSON.parse("["+(Settings.demo.custom.farjan.background.scale.v||"{}")+"]")
        ,"position":JSON.parse("["+(Settings.demo.custom.farjan.background.position.v||'{"x":"{return getScreenWidth()/2;}","y":"{ return getScreenHeight()/2;}"}')+"]")
        ,"angle":JSON.parse("["+(Settings.demo.custom.farjan.background.angle.v||"{}")+"]")
        ,"runFunction":"{ferryLights(animation);}"
    });

    if (Settings.demo.custom.farjan.sun.shadow.v) {
        this.loader.addAnimation({
             "start": start, "duration":duration
            ,"layer": layer, "image": Settings.demo.custom.sun
            ,"position":[{"x":1700,"y":"{return Math.sin(getSceneTimeFromStart())*20+900;}"}]
            ,"color":[{"r":0,"g":0,"b":0}]
            ,"scale":[{"uniform2d":0.6}]
        });
    }
    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": Settings.demo.custom.sun
        ,"position":[{"x":1700,"y":900}]
        ,"scale":[{"uniform2d":0.6}]
    });


    var fpos = Settings.demo.custom.farjan.ferry.position;
    var fangle = Settings.demo.custom.farjan.ferry.angle;
    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": Settings.demo.custom.ferry
        ,"position":JSON.parse("["+(fpos.v||"{}")+"]")
        ,"angle":JSON.parse("["+(fangle.v||"{}")+"]")
    });

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": Settings.demo.custom.foreground
        ,"scale":JSON.parse("["+(Settings.demo.custom.farjan.foreground.scale.v||"{}")+"]")
        ,"position":JSON.parse("["+(Settings.demo.custom.farjan.foreground.position.v||'{"x":"{return getScreenWidth()/2;}","y":"{ return getScreenHeight()/2;}"}')+"]")
        ,"angle":JSON.parse("["+(Settings.demo.custom.farjan.foreground.angle.v||"{}")+"]")
    });

    var scroller = Settings.demo.custom.farjan.scroller.v;
    this.loader.addAnimation([
    {
         "start": 0, "duration": duration
        ,"layer": 201, "text":{"name":Settings.demo.custom.font,"string":scroller}
        ,"scale":JSON.parse("["+(Settings.demo.custom.farjan.font.scale.v||"{}")+"]")
        ,"angle":JSON.parse("["+(Settings.demo.custom.farjan.font.angle.v||"{}")+"]")
        ,"position":JSON.parse("["+(Settings.demo.custom.farjan.font.position.v||"{}")+"]")
        ,"color": JSON.parse("["+(Settings.demo.custom.farjan.font.color.v||"{}")+"]")
    }]);
}
