#version 330

uniform sampler2D uDiffuseMap;
uniform float uAlpha;
uniform vec3 uDiffuseColor;

in vec2 fTexCoord;

out vec4 fragColor; // first out variable is automatically written to the screen

void main()
{
	vec4 texColor = texture(uDiffuseMap, fTexCoord);
	if (texColor.a < 0.1f)
	{
		discard;
	}
	texColor.a *= uAlpha;

	fragColor = texColor * vec4(uDiffuseColor, 1.0f);
}