#version 330

uniform mat4 uProjectionMatrix;
uniform mat4 uWorldMatrix;
uniform mat4 uViewMatrix;


// attributes of our vertex
in vec3 aPosition;
in vec4 aDiffuseColor;


out vec4 fDiffuseColor; // must match name in fragment shader


void main()
{
	// gl_Position is a special variable of OpenGL that must be set
	 gl_Position =  uProjectionMatrix * uViewMatrix * uWorldMatrix * vec4(aPosition, 1.0);

	fDiffuseColor = aDiffuseColor;
}

