import ddf.minim.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;
import ddf.minim.signals.*;
import ddf.minim.spi.*;
import ddf.minim.ugens.*;

import moonlander.library.*;




ParticleGenerator pgen;
ParticleGenerator pgen2;

//font related
int FONT_SIZE = 20;
int FONT_PARSER_WIDTH = 20;
int FONT_PARSER_HEIGHT = 30;
PFont LETTER_FONT;
HashMap<String, ArrayList<PVector>> FONT_DATA = new HashMap<String, ArrayList<PVector>>();
float TEXT_LETTER_GAP = FONT_PARSER_WIDTH*0.9;


int BPM = 140;
Moonlander moonlander;

boolean transition1to2 = false;
boolean transition2to3 = false;
boolean transition3to4 = false;

PShader bloomShader;
PShader blurShader;

PGraphics offscreen;
PGraphics offscreenBloom;
PGraphics offscreenHBlur;
PGraphics offscreenVBlur;

float blurSize = 5;
float sigma = 6;

void setup(){
  //size(640, 360, P2D);
  fullScreen(P2D); 
  noCursor();
  
  offscreen = createGraphics(width, height, P2D);
  offscreenBloom = createGraphics(width, height, P2D);
  offscreenHBlur = createGraphics(width, height, P2D);
  offscreenVBlur = createGraphics(width, height, P2D);
  bloomShader = loadShader("bloomFrag.glsl");
  blurShader = loadShader("blurFrag.glsl");
  
  //Create "DotMatrix" letter data
  LETTER_FONT = createFont("Arial",FONT_SIZE);
  
  //All possible letters, numbers, etc
  String data = "ABCDEFGHIJKLMNOPQRSTUVWXYZÅÄÖ 1234567890!?|_-";
  for(int letter = 0; letter < data.length();letter++){
    String tmp = ""+data.charAt(letter);
    FONT_DATA.put(tmp, parseLetterToPoints(LETTER_FONT, tmp));
  }
  
  pgen = new ParticleGenerator(20000);
  pgen2 = new ParticleGenerator(20000);
  
  hint(DISABLE_DEPTH_MASK);
  
    frameRate(60);
  
  moonlander = Moonlander.initWithSoundtrack(this, "musa4.wav", BPM, 8);
  moonlander.start();
}

ArrayList<PVector> textToPointCloud(String text){
  ArrayList<PVector> r = new ArrayList<PVector>();
  for(int letter = 0; letter < text.length();letter++){
    String tmp = ""+text.charAt(letter);
    ArrayList<PVector> letterData = FONT_DATA.get(tmp);
    for(PVector vec : letterData){
      r.add(new PVector(vec.x+TEXT_LETTER_GAP*letter, vec.y));
    }
  }
  return r;
}

//time is from 0 to 1
PVector pickPoint(float time, String txt){
  ArrayList<PVector> data = textToPointCloud(txt);
  int index = int(map(time, 0, 1, 0, data.size()-1));
  return data.get(index);
}

PVector sprial(float a, float b, float t){
    float x = a*t*cos(b+t);
    float y = a*t*sin(b+t);
    return new PVector(x, y);
}
  
void drawToGraphics(PGraphics pg){
  //resolution independent scaling
  pg.translate(width/2, height/2);
  pg.scale(height / 1000.0);
  

  float time = (float) moonlander.getCurrentTime();
  int scene = moonlander.getIntValue("scene");
  float change = (float) moonlander.getValue("change");
  
  pg.background(255);
  
  String text = "HELLO";
  if(scene == 0){
    pg.background(0);
    PVector point = pickPoint(change, text);
    pgen.setFill(color(255));
    pgen.setEmitter(point.x * 15 - 800, point.y*35 - 500);
    pgen.update();
    pgen.display(pg);
  }
  if(scene == 1){
    pg.background(0);
    text = "GRAFFATHON";
    PVector point = pickPoint(change, text);
    pgen.setFill(color(255));
    pgen.setEmitter(point.x * 9 - 800, point.y*30 - 300);
    pgen.update();
    pgen.display(pg);
    transition1to2 = true;
  }
  if(scene == 2){
    if(transition1to2){
      transition1to2 = false;
      pgen.reset();
    }
    float x = 16*pow(sin(change),3.0);
    float y = 13*cos(change)-5*cos(2*change)-2*cos(3*change)-cos(4*change);
    x = x*20; 
    y = -y*20;
    println("x:"+x+" y:"+y);
    pgen.setFill(color(255, 0, 0));
    pgen.setEmitter(x,y);
    pgen.update();
    pgen.display(pg);
    transition2to3 = true;
  }
  if(scene == 3){
    if(transition2to3){
      transition2to3 = false;
      pgen.reset();
    }
    PVector pos = sprial(5, 0, change);
    pgen.setFill(color(0, 0, 255));
    pgen.setEmitter(pos.x*5,pos.y*5);
    pgen.update();
    pgen.display(pg);
    
    PVector pos2 = sprial(5, PI, change);
    pgen2.setFill(color(0, 255, 0));
    pgen2.setEmitter(pos2.x*5,pos2.y*5);
    pgen2.update();
    pgen2.display(pg);
    transition3to4 = true;
  }
  if(scene == 4){
    if(transition3to4){
      transition3to4 = false;
      pgen.reset();
    }
    int k = 4;
    float r = change;
    float x = cos(k*r)*cos(r);
    float y = cos(k*r)*sin(r);
    pgen.setFill(color(0, 0, 0));
    pgen.setEmitter(x*500,y*500);
    pgen.update();
    pgen.display(pg);
  }

  if(scene == 5){
   exit(); 
  }
    println("Scene: "+scene+"FPS: "+frameRate  );
}

void draw(){
  moonlander.update();
  
  blurShader.set("blurSize", (int)blurSize);
  blurShader.set("sigma", sigma); 
  
  pushMatrix();
  background(0);  
  int scene = moonlander.getIntValue("scene");
  offscreen.beginDraw();
  drawToGraphics(this.g);
  offscreen.endDraw();
  
  popMatrix();
  image(offscreen, 0,0);
  if(scene < 2){
    offscreenBloom.beginDraw();
    offscreenBloom.shader(bloomShader);
    offscreenBloom.image(offscreen,0,0);
    offscreenBloom.endDraw();
    
    offscreenHBlur.beginDraw();
    blurShader.set("horizontalPass", 1);
    offscreenHBlur.shader(blurShader);
    offscreenHBlur.image(offscreenBloom,0,0);
    offscreenHBlur.endDraw();
    
    offscreenVBlur.beginDraw();
    blurShader.set("horizontalPass", 0);
    offscreenVBlur.shader(blurShader);
    offscreenVBlur.image(offscreenBloom,0,0);
    offscreenVBlur.endDraw();
    
    image(offscreenVBlur, 0,0);
  }else{
    image(offscreen, 0,0);
  }

  
  

  //exit();
}
