//Somewhat based on the Particles Processing example

class Particle{
  PVector velocity;
  float lifespan = 255;
  PShape shape;
  float shapeSize;
  PVector gravity = new PVector(0, 0.02);
  float shapeWidth = 8;
  float shapeHeight = 8;
  
  Particle(){
    shapeSize = random(4,0);
    shape = createShape();
    shape.beginShape(QUAD);
    shape.noStroke();
    //part.texture(sprite);
    shape.normal(0, 0, 1);
    shape.vertex(-shapeSize/2, -shapeSize/2, 0, 0);
    shape.vertex(+shapeSize/2, -shapeSize/2, shapeWidth, 0);
    shape.vertex(+shapeSize/2, +shapeSize/2, shapeWidth, shapeHeight);
    shape.vertex(-shapeSize/2, +shapeSize/2, 0, shapeHeight);
    shape.endShape();
    
    //This should be enough for offscreen..
    rebirth(-40000,-40000);
    lifespan = random(255);
  }
  
  PShape getShape() {
    return shape;
  }
  
  void rebirth(float x, float y) {
    float a = random(TWO_PI);
    float speed = random(0.1,2);
    velocity = new PVector(cos(a), sin(a));
    velocity.mult(speed);
    lifespan = 255;   
    shape.resetMatrix();
    shape.translate(x, y); 
  }
  
  boolean isDead() {
    return lifespan < 0;
  }
  
  void reset(){
    rebirth(-40000,-40000);
    lifespan = random(255);
  }
  
  public void update() {
    lifespan = lifespan - 1;
    velocity.add(gravity);
    
    shape.setTint(color(255,lifespan));
    shape.translate(velocity.x, velocity.y);
  }
  
}

class ParticleGenerator{
  
  ArrayList<Particle> particles = new ArrayList<Particle>();
  PShape parentShape = createShape(PShape.GROUP);
  
  ParticleGenerator(int numberOfParticles){
    for(int i = 0; i < numberOfParticles; i++){
      Particle particle = new Particle();
      particles.add(particle);
      parentShape.addChild(particle.getShape());
    }
  }
  void update() {
    for (Particle particle : particles) {
      particle.update();
    }
  }
  
  void setFill(color c){
    for (Particle particle : particles) {
      particle.getShape().setFill(c);
    }
  }
  
  void reset(){
    for (Particle particle : particles) {
      particle.reset();
    }
  }

  void setEmitter(float x, float y) {
    for (Particle particle : particles) {
      if (particle.isDead()) {
        particle.rebirth(x, y);
      }
    }
  }

  void display(PGraphics pg) {
    pg.shape(parentShape);
  }
  
}
