;-------------------------------------------------------------------------------
; ZX X-MAS '19 - MEMORY MAPPING CONSTANTS
;
;       (/&&&/\&\  /%/  \&\  /%/   /%)(#)(&\ /%###&\ /###)  ()/%|  /&&&\
;         /%/  \&\/%/    \&\/%/,--,|#||#||#| |#| |#| |&&\     |#| (&___&)
;        /%/   /%/\&\    /%/\&\'--'|#||#||#| |###|#|  \&&|    |#|    (&&)
;       /&&&/)/%/  \&\  /%/  \&\   |#||#||#| |#| |#| (###/    |#| (&&&&/
;
; Copyright AbaddoN (C)2018-2019
; Code and gfx by: G.o.D. / AbaddoN
; Mzx by: ern0 / AbaddoN
;-------------------------------------------------------------------------------

; Memory to save
; Low memory area:  Addr=$6000 / Len=$1E48
; High memory area: Addr=$C1B1 / Len=$3C49

; Overwritten $A000-$BAFF Loading screen for testing
LOADING_SCREEN			EQU	$9000


; $5E00-$5FFF Screen line addresses lookup table
; $5E00-$5EBF 192 low bytes for every line / $5F00-$5EBF 192 high bytes
SCRLINE_LOOKUP			EQU	$5E00

;$6000-$6EC6 music player and VT2 song data
MZX_INIT_PROC			EQU	$6000
MZX_PLAY_PROC			EQU	MZX_INIT_PROC+5
MZX_MUTE_PROC			EQU	MZX_INIT_PROC+8
MZX_SETUP_BYTE			EQU	MZX_INIT_PROC+$0A	; bit 0=true -> disable loop
										; bit 7 is set after each loop
MZX_CURRENT_POS		EQU	MZX_INIT_PROC+$0B
MZX_MODULE_ADDR		EQU	MZX_INIT_PROC+$086E
MZX_MODULE_END			EQU	MZX_INIT_PROC+$0EC7	; =$6EC7

; $6F00-$7FFF / background screen at the end will be overwritten
MAIN_CODE_ADDR			EQU	$6EC8

; $8000-$E1FF ($6200) shifted KKU text gfx
KKU_PHASES_ADDR		EQU	$8000

; $E200-$EA3F ($840) attributes for multicolor area / 192 lines
MLTCOL_LINES_ATTR_ADDR	EQU	$E200

; Overwritten $C1B1-$C633 ($483) precalc beginning effects
PRECALC_HIGH_MEM_FX		EQU	$C1B1

; Overwritten $C634-$C66B ($38) background bells images in 5 parts
SCROLL_SINCLAIR_IMAGE	EQU	$C634

; Overwritten $C66C-$C76B ($70) background bells images in 5 parts
SCROLL_SCENERZ_IMAGE	EQU	$C66C

; Overwritten $C6DC-$C76B ($90) background bells images in 5 parts
SCROLL_ABADDON_IMAGE	EQU	$C6DC

; Overwritten $C76C-$CA3B ($2D0) background bells images in 5 parts
BKG_BELLS_IMAGE_1		EQU	$C76C

; Overwritten $CA3C-$CF93 ($558) background socks images in 3 parts
BKG_SOCKS_IMAGE_1		EQU	$CA3C

; Overwritten $CF94-$DDA3 ($CA8+$168)
; background tree bitmap, ULA Plus colors, normal colors
BKG_TREE_IMAGE			EQU	$CF94
BKG_TREE_NORMCOL_ATTR	EQU	$DC3C

; Overwritten $DDA4-$DFB3 ($210)
; background right attributes normal color attributes
BKG_RIGHT_ATTR_NORMCOL	EQU	$DDA4

; Overwritten $DFB4-$E1C3 ($210) background right attributes ULA Plus
BKG_RIGHT_ATTR_ULAPLUS	EQU	$DFB4

; Overwritten $E1C4-$EC83 ($AC0) KKU text original gfx without margins
KKU_ORIG_TEXT_GFX_ADDR	EQU	$E1C4

; Overwritten $EC84-$FD03 (2*$840)
; multicolor area attributes ULA Plus colors, normal colors
MLTCOL_ULAPLUS_ATTR		EQU	$EC84
MLTCOL_NORMCOL_ATTR		EQU	$F4C4

; $EA40-$FD03 ($12C0+4) multicolor code
MLTCOL_CODE_PROC		EQU	$EA40

; $FD04-$FDFC
; im2.inc: IM2_PROC_ADDR			EQU	$FD01

; $FDFD-$FDFF	JMP instruction to IM2 routine

; $FE00-$FF00	IM2 address table (filled with $FD-s)
; im2.inc: IM2_TABLE_ADDR			EQU	$FE00

; $FF01-$FFFF	Stack
