/*  This file is part of Wabbitsign
 
 
Wabbitsign is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
 
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
 
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 
     Copyright 2006, Spencer Putt, James Montelongo*/



#define kMaxLength 130

typedef struct {
    short numlength;
    char sign;
    unsigned char number[kMaxLength];
} bignum;

typedef bignum* big;
big  big_create();
void big_clear(big a);
void big_add_ui(big result, big a, unsigned int b);
void big_add(big result, big a, big b);

void big_sub_ui(big result, big a, unsigned int b);
void big_sub(big result, big a, big b);

void big_set_ui(big result, unsigned int a);
void big_set(big result, big a);

void big_mul_ui(big result, big a, unsigned int b);
void big_mul(big result, big a, big b);
void big_mul2(big result, big a, big b);
void big_mul_long(unsigned int* result, unsigned int a, unsigned int b);

void big_div(big result, big a, big b);

void big_mod(big result, big a, big mod);

void big_powm(big result, big base, big exp, big mod);

void big_srl(big a);
void big_sll(big a);
void big_sl8(big a);
int add_streams(unsigned short *res, unsigned short *a, unsigned short *b, int la, int lb);

void big_read(big result, const unsigned char* buffer, int length);
int  big_cmp(big a, big b);
int  big_cmp_ui(big a, unsigned int b);
void big_print(big a);
void big_neg(big a);
void big_sl32(big a);

int big_legendre(big ia, big in);
