#include "demo.h"

palette_t pal[pal_max];



void init_palettes()
{
  int i;

  palette_t * p;

  //
  p = &pal[pal_green];
  p->colors = 20;

  for (i = 0; i < p->colors; i++)
    p->color[i] = al_map_rgb(60, 150 + i * 5, 60);

  //
  p = &pal[pal_blood];
  p->colors = 1;
  p->color[0] = al_map_rgb(200, 0, 0);

  //
  p = &pal[pal_magenta];
  p->colors = 20;

  for (i = 0; i < p->colors; i++)
    p->color[i] = al_map_rgb(150 + i * 5, 60, 150 + i * 5);

  //
  p = &pal[pal_yellow];
  p->colors = 20;

  for (i = 0; i < p->colors; i++)
    p->color[i] = al_map_rgb(150 + i * 5, 150 + i * 5, 60);

  //
  p = &pal[pal_rainbow];
  p->colors = 20;
  for (i = 0; i < p->colors; i++)
    p->color[i] = al_map_rgb(180 - i * 3, 100 + i * 5, 140 - i * 2);

  //
  p = &pal[pal_deep_green];
  p->colors = 10;
  for (i = 0; i < p->colors; i++)
    p->color[i] = al_map_rgb(0, 20 + i * 5, 0);

  //
  p = &pal[pal_orange];
  p->colors = 20;
  for (i = 0; i < p->colors; i++)
    p->color[i] = al_map_rgb(255, 50 + i * 6, 0);

  //
  p = &pal[pal_blue];
  p->colors = 10;
  for (i = 0; i < p->colors; i++)
    p->color[i] = al_map_rgb(100, 150, 200 + i * 5);

  //
  p = &pal[pal_black];
  p->colors = 1;
  p->color[0] = al_map_rgb(0, 0, 0);

  return;
}



void apply_pal(poly_t * poly, int index)
{
  ASSERT(poly != NULL);
  ASSERT(index >= 0);
  ASSERT(index < pal_max);

  palette_t * p = &pal[index];
  
  ASSERT(p->colors > 0);

  for (edge_t * e = poly->first_edge; e; e = e->next)
    e->color = p->color[get_rand8() % p->colors];
  
  return;
}

