

	org #8000

	;test code

begin

	ld hl,music_data
	call play
	ret
	


;wtbeep 0.1
;experimental beeper engine for ZX Spectrum
;by utz 11'2016 * www.irrlichtproject.de



play
	
	di
	ld e,(hl)
	inc hl
	ld d,(hl)
	inc hl
	;ld (mLoopVar),de
	ld (seqpntr),hl
	exx
	ld c,0			;timer lo
	push hl			;preserve HL' for return to BASIC
	ld (oldSP),sp
	ld ix,0
	ld iy,0

;*******************************************************************************
rdseq
seqpntr equ $+1
	ld sp,0
	xor a
	pop de			;pattern pointer to DE
	or d
	ld (seqpntr),sp
	jr nz,rdptn0
	
;mLoopVar equ $+1
;	ld sp,0		;get loop point		;comment out to disable looping
;	jr rdseq+3					;comment out to disable looping

;*******************************************************************************
exit
oldSP equ $+1
	ld sp,0
	pop hl
	exx
	ei
	ret

;*******************************************************************************
rdptn0
	ld (ptnpntr),de

readPtn
	in a,(#fe)		;read kbd
	cpl
	and #1f
	jr nz,exit


ptnpntr equ $+1
	ld sp,0	
	;jr $
	pop af			;timer + ctrl
	jr z,rdseq
	
	ld b,a			;timer (# ticks)
	
	jr c,_noUpd1
	
	ex af,af'
	
	ld h,mixAlgo/256
	pop de
	ld a,d
	
	and #f8
	ld l,a
	
	ld a,(hl)
	ld (algo1),a
	inc l
	ld a,(hl)
	ld (algo1+1),a
	inc l
	ld a,(hl)
	ld (algo1+2),a
	inc l
	ld a,(hl)
	ld (algo1+3),a
	inc l
	ld a,(hl)
	ld (algo1+4),a
	
	ld hl,0
	
	ld a,d
	and #7
	ld d,a
	
	ex af,af'

_noUpd1
	jp pe,_noUpd2
	
	exx
	ex af,af'
	
	ld h,mixAlgo/256
	pop bc
	ld a,b
	
	and #f8
	ld l,a
	
	ld a,(hl)
	ld (algo2),a
	inc l
	ld a,(hl)
	ld (algo2+1),a
	inc l
	ld a,(hl)
	ld (algo2+2),a
	inc l
	ld a,(hl)
	ld (algo2+3),a
	inc l
	ld a,(hl)
	ld (algo2+4),a
	
	ld hl,0
	
	ld a,b
	and #7
	ld b,a	
	
	ex af,af'
	exx
	
_noUpd2
	jp m,_noUpd3
	
	exx
	
	pop de
	ld a,d
	ex af,af'
	ld a,d
	and #7
	ld d,a
	ld (fdiv3),de
	
	ex af,af'
	and #f8
	ld e,a
	ld d,mixAlgo/256
	
	ld a,(de)
	ld (algo3),a
	inc e
	ld a,(de)
	ld (algo3+1),a
	inc e
	ld a,(de)
	ld (algo3+2),a
	inc e
	ld a,(de)
	ld (algo3+3),a
	inc e
	ld a,(de)
	ld (algo3+4),a
	
	ld de,0
	exx

_noUpd3
	
	pop af
	jp po,_noSweepReset
	
	ld iy,0					;reset sweep registers
	ld ixh,0
_noSweepReset
	jr c,drum1
	jr z,drum2
	dec sp
drumRet	
	
	ld (ptnpntr),sp
	
fdiv3 equ $+1
	ld sp,0

;*******************************************************************************
playNote
	add hl,de	;11	
	ld a,h		;4

algo1	
	ds 5		;20

	out (#fe),a	;11___64
	
	exx		;4
	
	add hl,bc	;11
	ld a,h		;4

algo2	
	ds 5		;20
	
	inc bc		;6		;timing
	out (#fe),a	;11___56
	
	ex de,hl	;4
	
	add hl,sp	;11
	ld a,h		;4

algo3	
	ds 5		;20
	
	dec bc		;6		;timing
	nop		;4
	
	ex de,hl	;4
	
	out (#fe),a	;11___64
	
	
	exx		;4
	
	dec c		;4
	jp nz,playNote	;10
			;184
	
	inc iyl				;update sweep counters
	ld a,iyl
	rrca
	rrca
	ld iyh,a
	rrca
	ld ixh,a
	
	dec b
	jp nz,playNote

	jp readPtn
	
;*******************************************************************************
drum2						;noise
	ld (hlRest),hl
	ld (bcRest),bc
	
	ld b,a
	ex af,af'
	
	ld a,b
	ld hl,1					;#1 (snare) <- 1011 -> #1237 (hat)
	rrca
	jr c,setVol
	ld hl,#1237

setVol	
	and #7f
	ld (dvol),a	
				
	ld bc,#a803				;length
sloop
	add hl,hl		;11
	sbc a,a			;4
	xor l			;4
	ld l,a			;4

dvol equ $+1	
	cp #80			;7		;volume
	sbc a,a			;4
				
	or #7			;7		;border
	out (#fe),a		;11
	djnz sloop		;13/8

	dec c			;4
	jr nz,sloop		;12

	jr drumEnd
	
drum1						;kick
	ld (deRest),de
	ld (bcRest),bc
	ld (hlRest),hl

	ld d,a					;A = start_pitch<<1
	ld e,0					;B = 0
	ld h,e
	ld l,e
	
	ex af,af'
	
	srl d					;set start pitch
	rl e
	
	ld c,#3					;length
	
xlllp
	add hl,de
	jr c,_noUpd
	ld a,e
_slideSpeed equ $+1
	sub #10					;speed
	ld e,a
	sbc a,a
	add a,d
	ld d,a
_noUpd
	ld a,h					
	or #7					;border
	out (#fe),a
	djnz xlllp
	dec c
	jr nz,xlllp

						;45680 (/224 = 248.3)
deRest equ $+1
	ld de,0


drumEnd
hlRest equ $+1
	ld hl,0
bcRest equ $+1
	ld bc,0
	
	ld c,6					;adjust timer
	jp drumRet

;*******************************************************************************

	;align 256
	org #8200

mixAlgo

	ds 8			;00	50% square
	
	daa			;02	32% square
	and h
	ds 6
	
	rlca			;01	25% square
	and h
	ds 6
	
	daa			;03	19% square
	cpl
	and h
	ds 5
	
	inc a			;04	12.5% square
	inc a
	xor h
	rrca
	ds 4
	
	inc a			;05	6.25% square
	xor h
	rrca
	ds 5

	add a,iyl		;06	duty sweep (fast) (cpl, dec a is not needed, but makes for a nicer attack env)
	cpl
	dec a
	or h
	ds 3
	
	add a,iyh		;07	duty sweep (slow)
	cpl
	dec a
	or h
	ds 3
	
	add a,ixh		;08	duty sweep (very slow, start lo)
	cpl
	dec a
	and h
	ds 3

	add a,ixh		;09	duty sweep (very slow, start hi)
	and h
	ds 5
	

	add a,iyh		;0a	duty sweep (slow) + oct
	rlca
	xor h
	ds 4

	add a,iyh		;0b	duty sweep (slow) - oct
	rrca
	xor h
	ds 4
	
	add a,iyl		;0c	duty sweep (fast) - oct
	rrca
	xor h
	ds 4

	daa			;0d	vowel 1
	rlca
	cpl
	xor h
	ds 4
	
	daa			;0e	vowel 2
	rlca
	rlca
	cpl
	xor h
	ds 3
	
	daa			;0f	vowel 3
	cpl
	xor h
	ds 5

	rrca			;10	vowel 4
	rrca
	sbc a,a
	and h
	rlca
	ds 3
	
	rlca			;11	vowel 5
	rlca
	xor h
	rlca
	ds 4
	
	rrca			;12	vowel 6
	sbc a,a
	and h
	rlca
	ds 4
	
	cpl			;13	rasp 1
	daa
	sbc a,a
	rlca
	and h
	ds 3
	
	rlca			;14	rasp 2
	rlca
	sbc a,a
	and h
	ds 4

	daa			;15	phat rasp
	rrca
	rrca
	cpl
	or h
	ds 3

	daa			;16	phat 2
	rrca
	rrca
	cpl
	and h
	ds 3
	
	daa			;17	phat 3
	rlca
	rlca
	cpl
	and h
	ds 3

	daa			;18	phat 4
	rlca
	cpl
	and h
	ds 4
	
	daa			;19	phat 5
	rrca
	rrca
	cpl
	xor h
	ds 3
	
	cpl			;1a	phat 6
	daa
	sbc a,a
	rlca
	xor h
	ds 3
	
	rlca			;1b	phat 7
	rlca
	sbc a,a
	and h
	rlca
	ds 3
	
	rlc h			;1c	noise 1
	and h
	ds 5
	
	rlc h			;1e	noise 2
	sbc a,a
	or h
	ds 4
	
	rlc h			;1d	noise 3
	ds 6
	
	rlc h			;1f	noise 4
	or h
	xor l
	ds 5

;*******************************************************************************



;compiled music data

music_data
	dw .loop
	dw .pattern1
.loop:
	dw .pattern2
	dw 0
.pattern1
	db #40
.pattern2
	dw #400,#0,#288d,#0,#501
	dw #481,#28a8
	db 0
	dw #481,#28d4
	db 0
	dw #481,#288d
	db 0
	dw #481,#28a8,#2640
	dw #481,#28d4
	db 0
	dw #481,#288d,#2640
	dw #481,#28a8
	db 0
	dw #480,#e046,#28d4,#501
	dw #480,#e000,#288d
	db 0
	dw #481,#28a8
	db 0
	dw #481,#28d4
	db 0
	dw #481,#288d,#2640
	dw #481,#28a8
	db 0
	dw #481,#28d4,#2640
	dw #481,#288d
	db 0
	dw #480,#e000,#28a8,#501
	dw #481,#28d4
	db 0
	dw #481,#288d
	db 0
	dw #481,#28a8
	db 0
	dw #481,#28d4,#2640
	dw #481,#288d
	db 0
	dw #481,#28a8,#2640
	dw #481,#28d4
	db 0
	dw #480,#e046,#288d,#501
	dw #480,#e000,#28a8
	db 0
	dw #481,#28d4
	db 0
	dw #481,#288d
	db 0
	dw #481,#28a8,#2640
	dw #481,#28d4
	db 0
	dw #481,#288d,#2640
	dw #481,#28a8
	db 0
	dw #480,#e000,#288d,#501
	dw #481,#28a8
	db 0
	dw #481,#28d4
	db 0
	dw #481,#288d
	db 0
	dw #481,#28a8,#2640
	dw #481,#28d4
	db 0
	dw #481,#288d,#2640
	dw #481,#28a8
	db 0
	dw #480,#e046,#28d4,#501
	dw #480,#e000,#288d
	db 0
	dw #481,#28a8
	db 0
	dw #481,#28d4
	db 0
	dw #481,#288d,#2640
	dw #481,#28a8
	db 0
	dw #481,#28d4,#2640
	dw #481,#288d
	db 0
	dw #480,#e000,#28a8,#501
	dw #481,#28d4
	db 0
	dw #481,#288d
	db 0
	dw #481,#28a8
	db 0
	dw #481,#28d4,#2640
	dw #481,#288d
	db 0
	dw #481,#28a8,#2640
	dw #481,#28d4
	db 0
	dw #480,#e046,#288d,#501
	dw #480,#e000,#28a8
	db 0
	dw #481,#28d4
	db 0
	dw #481,#288d
	db 0
	dw #481,#28a8,#2640
	dw #481,#28d4
	db 0
	dw #481,#288d,#2640
	dw #481,#28a8
	db 0
	dw #400,#e000,#288d,#4046,#501
	dw #481,#28a8
	db 0
	dw #401,#28d4,#4054
	db 0
	dw #481,#288d
	db 0
	dw #400,#5846,#28a8,#404f,#2640
	dw #481,#28d4
	db 0
	dw #401,#288d,#4046,#2640
	dw #481,#28a8
	db 0
	dw #400,#e046,#28d4,#4054,#501
	dw #480,#e000,#288d
	db 0
	dw #401,#28a8,#4046
	db 0
	dw #481,#28d4
	db 0
	dw #400,#5846,#288d,#404f,#2640
	dw #481,#28a8
	db 0
	dw #401,#28d4,#4054,#2640
	dw #481,#288d
	db 0
	dw #400,#5800,#28a8,#4046,#501
	dw #481,#28d4
	db 0
	dw #401,#288d,#4054
	db 0
	dw #481,#28a8
	db 0
	dw #400,#5846,#28d4,#404f,#2640
	dw #481,#288d
	db 0
	dw #401,#28a8,#4046,#2640
	dw #481,#28d4
	db 0
	dw #400,#e046,#288d,#4054,#501
	dw #480,#e000,#28a8
	db 0
	dw #401,#28d4,#4046
	db 0
	dw #481,#288d
	db 0
	dw #400,#5846,#28a8,#404f,#2640
	dw #481,#28d4
	db 0
	dw #401,#288d,#4054,#2640
	dw #481,#28a8
	db 0
	dw #400,#5800,#288d,#4046,#501
	dw #481,#28a8
	db 0
	dw #401,#28d4,#4054
	db 0
	dw #481,#288d
	db 0
	dw #400,#5846,#28a8,#404f,#2640
	dw #481,#28d4
	db 0
	dw #401,#288d,#4046,#2640
	dw #481,#28a8
	db 0
	dw #400,#e046,#28d4,#4054,#501
	dw #480,#e000,#288d
	db 0
	dw #401,#28a8,#4046
	db 0
	dw #481,#28d4
	db 0
	dw #400,#5846,#288d,#404f,#2640
	dw #481,#28a8
	db 0
	dw #401,#28d4,#4054,#2640
	dw #481,#288d
	db 0
	dw #400,#5800,#28a8,#4046,#501
	dw #481,#28d4
	db 0
	dw #401,#288d,#4054
	db 0
	dw #481,#28a8
	db 0
	dw #400,#5846,#28d4,#404f,#2640
	dw #481,#288d
	db 0
	dw #401,#28a8,#4046,#2640
	dw #481,#28d4
	db 0
	dw #400,#e046,#288d,#4054,#501
	dw #480,#e000,#28a8
	db 0
	dw #401,#28d4,#4046
	db 0
	dw #481,#288d
	db 0
	dw #400,#5846,#28a8,#404f,#2640
	dw #481,#28d4
	db 0
	dw #401,#288d,#4054,#2640
	dw #481,#28a8
	db 0
	dw #400,#5800,#288d,#4046,#501
	dw #481,#28a8
	db 0
	dw #401,#28d4,#4054
	db 0
	dw #481,#288d
	db 0
	dw #400,#5846,#28a8,#404f,#2640
	dw #481,#28d4
	db 0
	dw #401,#288d,#4046,#2640
	dw #481,#28a8
	db 0
	dw #400,#e046,#28d4,#4054,#501
	dw #480,#e000,#288d
	db 0
	dw #401,#28a8,#4046
	db 0
	dw #481,#28d4
	db 0
	dw #400,#5846,#288d,#404f,#2640
	dw #481,#28a8
	db 0
	dw #401,#28d4,#4054,#2640
	dw #481,#288d
	db 0
	dw #400,#5800,#28a8,#4046,#501
	dw #481,#28d4
	db 0
	dw #401,#288d,#4054
	db 0
	dw #481,#28a8
	db 0
	dw #400,#5846,#28d4,#404f,#2640
	dw #481,#288d
	db 0
	dw #401,#28a8,#4046,#2640
	dw #481,#28d4
	db 0
	dw #400,#e046,#288d,#4054,#501
	dw #480,#e000,#28a8
	db 0
	dw #401,#28d4,#4046
	db 0
	dw #481,#288d
	db 0
	dw #400,#5846,#28a8,#404f,#2640
	dw #481,#28d4
	db 0
	dw #401,#288d,#4054,#2640
	dw #481,#28a8
	db 0
	dw #400,#5800,#288d,#4046,#501
	dw #481,#28a8
	db 0
	dw #401,#28d4,#4054
	db 0
	dw #481,#288d
	db 0
	dw #400,#5846,#28a8,#404f,#2640
	dw #481,#28d4
	db 0
	dw #401,#288d,#4046,#2640
	dw #481,#28a8
	db 0
	dw #400,#e046,#28d4,#4054,#501
	dw #480,#e000,#288d
	db 0
	dw #401,#28a8,#4046
	db 0
	dw #481,#28d4
	db 0
	dw #400,#5846,#288d,#404f,#2640
	dw #481,#28a8
	db 0
	dw #401,#28d4,#4054,#2640
	dw #481,#288d
	db 0
	dw #400,#5800,#28a8,#4046,#501
	dw #481,#28d4
	db 0
	dw #401,#288d,#4054
	db 0
	dw #481,#28a8
	db 0
	dw #400,#5846,#28d4,#404f,#2640
	dw #481,#288d
	db 0
	dw #401,#28a8,#4046,#2640
	dw #481,#28d4
	db 0
	dw #400,#e046,#288d,#4054,#501
	dw #480,#e000,#28a8
	db 0
	dw #401,#28d4,#4046
	db 0
	dw #481,#288d
	db 0
	dw #400,#5846,#28a8,#404f,#2640
	dw #481,#28d4
	db 0
	dw #401,#288d,#4054,#2640
	dw #481,#28a8
	db 0
	dw #400,#5800,#388d,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#e000
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #404,#5800,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#e000
	db 0
	dw #405,#4046
	db 0
	dw #481,#3800
	db 0
	dw #400,#5846,#388d,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #400,#5800,#38d4,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #400,#e046,#388d,#4054,#501
	dw #484,#e000
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #400,#5846,#38bd,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #404,#5800,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#e000
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #400,#5800,#387e,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#e000
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #404,#5800,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#e000
	db 0
	dw #405,#4046
	db 0
	dw #481,#3800
	db 0
	dw #400,#5846,#387e,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #400,#5800,#38d4,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #400,#e046,#387e,#4054,#501
	dw #484,#e000
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #400,#5846,#38bd,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #404,#5800,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#e000
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#501
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #400,#5800,#3870,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#e000
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #404,#5800,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#e000
	db 0
	dw #405,#4046
	db 0
	dw #481,#3800
	db 0
	dw #400,#5846,#3870,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #400,#5800,#38d4,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #400,#e046,#3870,#4054,#501
	dw #484,#e000
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #400,#5846,#38bd,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #404,#5800,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#e000
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485,#2640
	dw #400,#5800,#386a,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#e000
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #404,#5800,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#e000
	db 0
	dw #405,#4046
	db 0
	dw #481,#3800
	db 0
	dw #400,#5846,#386a,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #400,#5800,#38d4,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #400,#e046,#386a,#4054,#501
	dw #484,#e000
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #400,#5846,#38bd,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #404,#5800,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#e000
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#501
	dw #485
	db 0
	dw #400,#11,#388d,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #404,#11,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #481,#3800
	db 0
	dw #400,#5846,#388d,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #400,#11,#38d4,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #400,#e046,#388d,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #400,#5846,#38bd,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #404,#11,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #400,#11,#387e,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #404,#11,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #481,#3800
	db 0
	dw #400,#5846,#387e,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #400,#11,#38d4,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #400,#e046,#387e,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #400,#5846,#38bd,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #404,#11,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#501
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #400,#11,#3870,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #404,#11,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #481,#3800
	db 0
	dw #400,#5846,#3870,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #400,#11,#38d4,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #400,#e046,#3870,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #400,#5846,#38bd,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #404,#11,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485,#2640
	dw #400,#11,#386a,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #404,#11,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #481,#3800
	db 0
	dw #400,#5846,#386a,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #400,#11,#38d4,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #400,#e046,#386a,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #400,#5846,#38bd,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #404,#11,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#501
	dw #485
	db 0
	dw #400,#11,#408d,#5046,#501
	dw #485
	db 0
	dw #405,#5054
	db 0
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#5046,#2640
	dw #485
	db 0
	dw #404,#e046,#5054,#501
	dw #484,#11
	db 0
	dw #405,#5046
	db 0
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#5054,#2640
	dw #485
	db 0
	dw #404,#11,#5046,#501
	dw #485
	db 0
	dw #405,#5054
	db 0
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #404,#11,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #404,#11,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #404,#11,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #404,#11,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #404,#11,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #404,#11,#4046,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#2640
	dw #485
	db 0
	dw #405,#4046,#2640
	dw #485
	db 0
	dw #404,#e046,#4054,#501
	dw #484,#11
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#404f,#501
	dw #485
	db 0
	dw #405,#4054,#2640
	dw #485
	db 0
	dw #400,#11,#406f,#505e,#501
	dw #485
	db 0
	dw #405,#5070
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#505e,#2640
	dw #485
	db 0
	dw #404,#e046,#5070,#501
	dw #484,#11
	db 0
	dw #405,#505e
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#5070,#2640
	dw #485
	db 0
	dw #404,#11,#505e,#501
	dw #485
	db 0
	dw #405,#5070
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#505e,#2640
	dw #485
	db 0
	dw #404,#e046,#5070,#501
	dw #484,#11
	db 0
	dw #405,#505e
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#5070,#2640
	dw #485
	db 0
	dw #404,#11,#505e,#501
	dw #485
	db 0
	dw #405,#5070
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#505e,#2640
	dw #485
	db 0
	dw #404,#e046,#5070,#501
	dw #484,#11
	db 0
	dw #405,#505e
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#5070,#2640
	dw #485
	db 0
	dw #404,#11,#505e,#501
	dw #485
	db 0
	dw #405,#5070
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#505e,#2640
	dw #485
	db 0
	dw #404,#e046,#5070,#501
	dw #484,#11
	db 0
	dw #405,#505e
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#5070,#2640
	dw #485,#2640
	dw #404,#11,#505e,#501
	dw #485
	db 0
	dw #405,#5070
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#505e,#2640
	dw #485
	db 0
	dw #404,#e046,#5070,#501
	dw #484,#11
	db 0
	dw #405,#505e
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#5070,#2640
	dw #485
	db 0
	dw #404,#11,#505e,#501
	dw #485
	db 0
	dw #405,#5070
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#505e,#2640
	dw #485
	db 0
	dw #404,#e046,#5070,#501
	dw #484,#11
	db 0
	dw #405,#505e
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#5070,#2640
	dw #485
	db 0
	dw #400,#11,#405d,#505e,#501
	dw #485
	db 0
	dw #405,#5070
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#505e,#2640
	dw #485
	db 0
	dw #404,#e046,#5070,#501
	dw #484,#11
	db 0
	dw #405,#505e
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#5070,#2640
	dw #485
	db 0
	dw #404,#11,#505e,#501
	dw #485
	db 0
	dw #405,#5070
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#505e,#2640
	dw #485
	db 0
	dw #404,#e046,#5070,#501
	dw #484,#11
	db 0
	dw #405,#505e
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #404,#e046,#5070,#501
	dw #484,#5846
	db 0
	dw #400,#11,#4053,#6846,#501
	dw #485
	db 0
	dw #405,#6854
	db 0
	dw #485
	db 0
	dw #404,#5846,#684f,#2640
	dw #485
	db 0
	dw #405,#6846,#2640
	dw #485
	db 0
	dw #404,#e046,#6854,#501
	dw #484,#11
	db 0
	dw #405,#6846
	db 0
	dw #485
	db 0
	dw #404,#5846,#684f,#2640
	dw #485
	db 0
	dw #405,#6854,#2640
	dw #485
	db 0
	dw #404,#11,#5046,#501
	dw #485
	db 0
	dw #405,#5054
	db 0
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#5046,#2640
	dw #485
	db 0
	dw #404,#e046,#5054,#501
	dw #484,#11
	db 0
	dw #405,#5046
	db 0
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#5054,#2640
	dw #485
	db 0
	dw #404,#11,#5046,#501
	dw #485
	db 0
	dw #405,#5054,#501
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#5046,#2640
	dw #485
	db 0
	dw #404,#e046,#5054,#501
	dw #484,#11
	db 0
	dw #405,#5046
	db 0
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#5054,#2640
	dw #485
	db 0
	dw #404,#11,#5046,#501
	dw #485
	db 0
	dw #405,#5054
	db 0
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#5046,#2640
	dw #485
	db 0
	dw #404,#e046,#5054,#501
	dw #484,#11
	db 0
	dw #405,#5046
	db 0
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#5054,#501
	dw #485
	db 0
	dw #400,#11,#40d3,#5046,#501
	dw #485
	db 0
	dw #405,#5054
	db 0
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#5046,#2640
	dw #485
	db 0
	dw #404,#e046,#5054,#501
	dw #484,#11
	db 0
	dw #405,#5046
	db 0
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#5054,#2640
	dw #485
	db 0
	dw #404,#11,#5046,#501
	dw #485
	db 0
	dw #405,#5054
	db 0
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#5046,#2640
	dw #485
	db 0
	dw #404,#e046,#5054,#501
	dw #484,#11
	db 0
	dw #405,#5046
	db 0
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#5054,#2640
	dw #485
	db 0
	dw #400,#11,#40d2,#5045,#501
	dw #485
	db 0
	dw #405,#5053
	db 0
	dw #485
	db 0
	dw #404,#5846,#504e,#2640
	dw #485
	db 0
	dw #405,#5045,#2640
	dw #485
	db 0
	dw #404,#e046,#5053,#501
	dw #484,#11
	db 0
	dw #405,#5045
	db 0
	dw #485
	db 0
	dw #404,#5846,#504e,#2640
	dw #485
	db 0
	dw #405,#5053,#2640
	dw #485
	db 0
	dw #400,#11,#40d0,#5044,#501
	dw #485
	db 0
	dw #405,#5052,#501
	dw #485
	db 0
	dw #404,#5846,#504d,#2640
	dw #485
	db 0
	dw #405,#5044,#2640
	dw #485
	db 0
	dw #400,#e046,#40ce,#5051,#501
	dw #484,#11
	db 0
	dw #405,#5043
	db 0
	dw #485
	db 0
	dw #400,#5846,#40cc,#504b,#501
	dw #485
	db 0
	dw #405,#5050,#501
	dw #485
	db 0
	dw #400,#11,#406f,#505e,#501
	dw #485
	db 0
	dw #405,#5070
	db 0
	dw #485
	db 0
	dw #404,#5846,#5067,#2640
	dw #485
	db 0
	dw #405,#505e,#2640
	dw #485
	db 0
	dw #404,#e046,#5070,#501
	dw #484,#11
	db 0
	dw #405,#505e
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#5070,#2640
	dw #485
	db 0
	dw #404,#11,#505e,#501
	dw #485
	db 0
	dw #405,#5070
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#505e,#2640
	dw #485
	db 0
	dw #404,#e046,#5070,#501
	dw #484,#11
	db 0
	dw #405,#505e
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#5070,#2640
	dw #485
	db 0
	dw #404,#11,#505e,#501
	dw #485
	db 0
	dw #405,#5070
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#505e,#2640
	dw #485
	db 0
	dw #404,#e046,#5070,#501
	dw #484,#11
	db 0
	dw #405,#505e
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#5070,#2640
	dw #485
	db 0
	dw #404,#11,#505e,#501
	dw #485
	db 0
	dw #405,#5070
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#505e,#2640
	dw #485
	db 0
	dw #404,#e046,#5070,#501
	dw #484,#11
	db 0
	dw #405,#505e
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#5070,#2640
	dw #485,#2640
	dw #404,#11,#505e,#501
	dw #485
	db 0
	dw #405,#5070
	db 0
	dw #485
	db 0
	dw #404,#584b,#506a,#2640
	dw #485
	db 0
	dw #405,#505e,#2640
	dw #485
	db 0
	dw #404,#e046,#5070,#501
	dw #484,#11
	db 0
	dw #405,#505e
	db 0
	dw #485
	db 0
	dw #404,#584b,#506a,#2640
	dw #485
	db 0
	dw #405,#5070,#2640
	dw #485
	db 0
	dw #404,#11,#505e,#501
	dw #485
	db 0
	dw #405,#5070
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#505e,#2640
	dw #485
	db 0
	dw #404,#e046,#5070,#501
	dw #484,#11
	db 0
	dw #405,#505e
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#5070,#2640
	dw #485
	db 0
	dw #400,#11,#405d,#505e,#501
	dw #485
	db 0
	dw #405,#5070
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#505e,#2640
	dw #485
	db 0
	dw #404,#e046,#5070,#501
	dw #484,#11
	db 0
	dw #405,#505e
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#5070,#2640
	dw #485
	db 0
	dw #404,#11,#505e,#501
	dw #485
	db 0
	dw #405,#5070
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #405,#505e,#2640
	dw #485
	db 0
	dw #404,#e046,#5070,#501
	dw #484,#11
	db 0
	dw #405,#505e
	db 0
	dw #485
	db 0
	dw #404,#5846,#506a,#2640
	dw #485
	db 0
	dw #404,#e046,#5070,#501
	dw #484,#5846
	db 0
	dw #400,#11,#4053,#6846,#501
	dw #485
	db 0
	dw #405,#6854
	db 0
	dw #485
	db 0
	dw #404,#5846,#684f,#2640
	dw #485
	db 0
	dw #405,#6846,#2640
	dw #485
	db 0
	dw #404,#e046,#6854,#501
	dw #484,#11
	db 0
	dw #405,#6846
	db 0
	dw #485
	db 0
	dw #404,#5846,#684f,#2640
	dw #485
	db 0
	dw #405,#6854,#2640
	dw #485
	db 0
	dw #404,#11,#5046,#501
	dw #485
	db 0
	dw #405,#5054
	db 0
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#5046,#2640
	dw #485
	db 0
	dw #404,#e046,#5054,#501
	dw #484,#11
	db 0
	dw #405,#5046
	db 0
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#5054,#2640
	dw #485
	db 0
	dw #404,#11,#5046,#501
	dw #485
	db 0
	dw #405,#5054,#501
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#5046,#2640
	dw #485
	db 0
	dw #404,#e046,#5054,#501
	dw #484,#11
	db 0
	dw #405,#5046
	db 0
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#5054,#2640
	dw #485
	db 0
	dw #404,#11,#5046,#501
	dw #485
	db 0
	dw #405,#5054
	db 0
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#5046,#2640
	dw #485
	db 0
	dw #404,#e046,#5054,#501
	dw #484,#11
	db 0
	dw #405,#5046
	db 0
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#5054,#501
	dw #485
	db 0
	dw #400,#11,#40d3,#5046,#501
	dw #485
	db 0
	dw #405,#5054
	db 0
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#5046,#2640
	dw #485
	db 0
	dw #404,#e046,#5054,#501
	dw #484,#11
	db 0
	dw #405,#5046
	db 0
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#5054,#2640
	dw #485
	db 0
	dw #404,#11,#5046,#501
	dw #485
	db 0
	dw #405,#5054
	db 0
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#5046,#2640
	dw #485
	db 0
	dw #404,#e046,#5054,#501
	dw #484,#11
	db 0
	dw #405,#5046
	db 0
	dw #485
	db 0
	dw #404,#5846,#504f,#2640
	dw #485
	db 0
	dw #405,#5054,#2640
	dw #485
	db 0
	dw #400,#11,#40d2,#5045,#501
	dw #485
	db 0
	dw #405,#5053
	db 0
	dw #485
	db 0
	dw #404,#5846,#504e,#2640
	dw #485
	db 0
	dw #405,#5045,#2640
	dw #485
	db 0
	dw #404,#e046,#5053,#501
	dw #484,#11
	db 0
	dw #405,#5045
	db 0
	dw #485
	db 0
	dw #404,#5846,#504e,#2640
	dw #485
	db 0
	dw #405,#5053,#2640
	dw #485
	db 0
	dw #400,#11,#40d0,#5044,#501
	dw #485
	db 0
	dw #405,#5052,#501
	dw #485
	db 0
	dw #404,#5846,#504d,#2640
	dw #485
	db 0
	dw #405,#5044,#2640
	dw #485
	db 0
	dw #400,#e046,#40ce,#5051,#501
	dw #484,#11
	db 0
	dw #405,#5043
	db 0
	dw #485
	db 0
	dw #400,#5846,#40cc,#504b,#501
	dw #485
	db 0
	dw #405,#5050,#501
	dw #485
	db 0
	dw #400,#11,#408c,#405e,#501
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#405e
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#405e
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#405e
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#405e
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#405e
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#405e
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#405e
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#406a,#501
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#406a
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#406a
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#406a
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#406a
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#406a
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#406a
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#406a
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#501
	dw #485
	db 0
	dw #485,#501
	dw #485
	db 0
	dw #400,#11,#408c,#407e,#501
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#407e
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#407e
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#407e
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#407e
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#407e
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#407e
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#407e,#501
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#501
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#408d,#501
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#4046
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#4046
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#4046
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#4046
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#4046
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#4046
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#4046
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #400,#11,#408c,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #405,#4054,#501
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#501
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #400,#11,#408c,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485,#501
	dw #485
	db 0
	dw #404,#11,#407e,#501
	dw #485
	db 0
	dw #405,#408d
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046,#501
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #400,#11,#8046,#403f,#501
	dw #485
	db 0
	dw #401,#8054,#4046
	db 0
	dw #485
	db 0
	dw #400,#5846,#806a,#408d,#501
	dw #485
	db 0
	dw #481,#805e,#501
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #401,#8054,#4054,#2640
	dw #485
	db 0
	dw #400,#11,#805e,#405e,#501
	dw #485
	db 0
	dw #401,#806a,#406a
	db 0
	dw #485
	db 0
	dw #400,#5846,#8000,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485,#2640
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a,#2640
	dw #485
	db 0
	dw #400,#5846,#8046,#408d,#2640
	dw #485
	db 0
	dw #481,#8054,#2640
	dw #485
	db 0
	dw #400,#11,#807e,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #400,#11,#805e,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#501
	dw #485
	db 0
	dw #400,#11,#806a,#407e,#501
	dw #485
	db 0
	dw #405,#408d
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046,#501
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #400,#11,#8046,#403f,#501
	dw #485
	db 0
	dw #401,#8054,#4046
	db 0
	dw #485
	db 0
	dw #400,#5846,#806a,#408d,#501
	dw #485
	db 0
	dw #481,#805e,#501
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485,#2640
	dw #404,#11,#405e,#501
	dw #481,#805d
	db 0
	dw #401,#805c,#4054
	db 0
	dw #481,#805b
	db 0
	dw #400,#5846,#805a,#408d,#2640
	dw #481,#8059
	db 0
	dw #481,#8058,#2640
	dw #481,#8057
	db 0
	dw #400,#11,#8054,#405e,#501
	dw #481,#8053
	db 0
	dw #401,#8052,#4054
	db 0
	dw #481,#8051
	db 0
	dw #400,#5846,#8050,#408d,#2640
	dw #481,#804f
	db 0
	dw #401,#8054,#4054,#2640
	dw #485
	db 0
	dw #400,#11,#805e,#405e,#501
	dw #485
	db 0
	dw #401,#806a,#406a
	db 0
	dw #485
	db 0
	dw #400,#5846,#8000,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #400,#11,#8000,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485,#2640
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a,#2640
	dw #485
	db 0
	dw #400,#5846,#8046,#408d,#2640
	dw #485,#2640
	dw #481,#8054,#2640
	dw #485,#2640
	dw #400,#11,#807e,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #400,#11,#805e,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#501
	dw #485
	db 0
	dw #400,#11,#8054,#407e,#501
	dw #485
	db 0
	dw #405,#408d
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046,#501
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #400,#11,#8046,#403f,#501
	dw #485
	db 0
	dw #401,#8054,#4046
	db 0
	dw #485
	db 0
	dw #400,#5846,#806a,#408d,#501
	dw #485
	db 0
	dw #481,#805e,#501
	dw #485
	db 0
	dw #404,#17,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#585e,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#17,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#585e,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#17,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#585e,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#17,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#585e,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#15,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5854,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#15,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5854,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#15,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5854,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#15,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5854,#408d,#2640
	dw #485
	db 0
	dw #401,#8054,#4054,#2640
	dw #485
	db 0
	dw #400,#11,#805e,#405e,#501
	dw #485
	db 0
	dw #401,#806a,#406a
	db 0
	dw #485
	db 0
	dw #400,#5846,#8000,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485,#2640
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a,#2640
	dw #485
	db 0
	dw #400,#5846,#8046,#408d,#2640
	dw #485
	db 0
	dw #481,#8054,#2640
	dw #485
	db 0
	dw #400,#1f,#807e,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#587e,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#1f,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#587e,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#1f,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#587e,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#1f,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#587e,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #400,#1a,#805e,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#585e,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#1a,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#586a,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#17,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#585e,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#1a,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#586a,#408d,#2640
	dw #485
	db 0
	dw #485,#501
	dw #485
	db 0
	dw #400,#11,#806a,#407e,#501
	dw #485
	db 0
	dw #405,#408d
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#403f,#501
	dw #485
	db 0
	dw #405,#4046,#501
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #400,#11,#8046,#403f,#501
	dw #485
	db 0
	dw #401,#8054,#4046
	db 0
	dw #485
	db 0
	dw #400,#5846,#806a,#408d,#501
	dw #485
	db 0
	dw #481,#805e,#501
	dw #485
	db 0
	dw #404,#17,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#585e,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#17,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#585e,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#17,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#585e,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#17,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#585e,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#15,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5854,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#15,#405e,#501
	dw #485
	db 0
	dw #405,#4054
	db 0
	dw #485
	db 0
	dw #404,#5854,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485,#2640
	dw #404,#15,#405e,#501
	dw #481,#805d
	db 0
	dw #401,#805c,#4054
	db 0
	dw #481,#805b
	db 0
	dw #400,#5854,#805a,#408d,#2640
	dw #481,#8059
	db 0
	dw #481,#8058,#2640
	dw #481,#8057
	db 0
	dw #400,#15,#8054,#405e,#501
	dw #481,#8053
	db 0
	dw #401,#8052,#4054
	db 0
	dw #481,#8051
	db 0
	dw #400,#5854,#8050,#408d,#2640
	dw #481,#804f
	db 0
	dw #401,#8054,#4054,#2640
	dw #485
	db 0
	dw #400,#11,#805e,#405e,#501
	dw #485
	db 0
	dw #401,#806a,#406a
	db 0
	dw #485
	db 0
	dw #400,#5846,#8000,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #400,#11,#8000,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485,#2640
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#11,#405e,#501
	dw #485
	db 0
	dw #405,#406a,#2640
	dw #485
	db 0
	dw #400,#5846,#8046,#408d,#2640
	dw #485,#2640
	dw #481,#8054,#2640
	dw #485,#2640
	dw #400,#f,#807e,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#583f,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#f,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#583f,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#f,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#583f,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#f,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#583f,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #400,#f,#805e,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#583f,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#f,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#583f,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#f,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#583f,#408d,#2640
	dw #485
	db 0
	dw #485,#2640
	dw #485
	db 0
	dw #404,#f,#406a,#501
	dw #485
	db 0
	dw #405,#407e
	db 0
	dw #485
	db 0
	dw #404,#583f,#408d,#2640
	dw #485
	db 0
	dw #485,#501
	dw #485
	db 0
	dw #400,#11,#40a8,#407e
	db 0
	dw #485
	db 0
	dw #405,#408d
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#403f
	db 0
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#403f
	db 0
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#403f
	db 0
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#403f
	db 0
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#403f
	db 0
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#403f
	db 0
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#403f
	db 0
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #400,#1011,#406a,#407e
	db 0
	dw #485
	db 0
	dw #405,#408d
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#1011,#403f
	db 0
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#1011,#403f
	db 0
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#1011,#403f
	db 0
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#1011,#403f
	db 0
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#1011,#403f
	db 0
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#1011,#403f
	db 0
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#1011,#403f
	db 0
	dw #485
	db 0
	dw #405,#4046
	db 0
	dw #485
	db 0
	dw #404,#5846,#408d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #400,#11,#402a,#307e
	db 0
	dw #485
	db 0
	dw #405,#308d
	db 0
	dw #485
	db 0
	dw #404,#5846,#308d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#303f
	db 0
	dw #485
	db 0
	dw #405,#3046
	db 0
	dw #485
	db 0
	dw #404,#5846,#308d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#303f
	db 0
	dw #485
	db 0
	dw #405,#3046
	db 0
	dw #485
	db 0
	dw #404,#5846,#308d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#303f
	db 0
	dw #485
	db 0
	dw #405,#3046
	db 0
	dw #485
	db 0
	dw #404,#5846,#308d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#303f
	db 0
	dw #485
	db 0
	dw #405,#3046
	db 0
	dw #485
	db 0
	dw #404,#5846,#308d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#303f
	db 0
	dw #485
	db 0
	dw #405,#3046
	db 0
	dw #485
	db 0
	dw #404,#5846,#308d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#303f
	db 0
	dw #485
	db 0
	dw #405,#3046
	db 0
	dw #485
	db 0
	dw #404,#5846,#308d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#303f
	db 0
	dw #485
	db 0
	dw #405,#3046
	db 0
	dw #485
	db 0
	dw #404,#5846,#308d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #400,#11,#4023,#303f
	db 0
	dw #485
	db 0
	dw #405,#3046
	db 0
	dw #485
	db 0
	dw #404,#5846,#3046
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#301f
	db 0
	dw #485
	db 0
	dw #405,#3023
	db 0
	dw #485
	db 0
	dw #404,#5846,#3046
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#301f
	db 0
	dw #485
	db 0
	dw #405,#3023
	db 0
	dw #485
	db 0
	dw #404,#5846,#3046
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#301f
	db 0
	dw #485
	db 0
	dw #405,#3023
	db 0
	dw #485
	db 0
	dw #404,#5846,#3046
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#301f
	db 0
	dw #485
	db 0
	dw #405,#3023
	db 0
	dw #485
	db 0
	dw #404,#5846,#3046
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#301f
	db 0
	dw #485
	db 0
	dw #405,#3023
	db 0
	dw #485
	db 0
	dw #404,#5846,#3046
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#301f
	db 0
	dw #485
	db 0
	dw #405,#3023
	db 0
	dw #485
	db 0
	dw #404,#5846,#3046
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#301f
	db 0
	dw #485
	db 0
	dw #405,#3023
	db 0
	dw #485
	db 0
	dw #404,#5846,#3046
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #400,#11,#4023,#301f
	db 0
	dw #485
	db 0
	dw #405,#3023
	db 0
	dw #485
	db 0
	dw #404,#5846,#3023
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#300f
	db 0
	dw #485
	db 0
	dw #405,#3011
	db 0
	dw #485
	db 0
	dw #404,#5846,#3023
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#300f
	db 0
	dw #485
	db 0
	dw #405,#3011
	db 0
	dw #485
	db 0
	dw #404,#5846,#3023
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#300f
	db 0
	dw #485
	db 0
	dw #405,#3011
	db 0
	dw #485
	db 0
	dw #404,#5823,#3023
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#300f
	db 0
	dw #485
	db 0
	dw #405,#3011
	db 0
	dw #485
	db 0
	dw #404,#5823,#3023
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#300f
	db 0
	dw #485
	db 0
	dw #405,#3011
	db 0
	dw #485
	db 0
	dw #404,#5823,#3023
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#300f
	db 0
	dw #485
	db 0
	dw #405,#3011
	db 0
	dw #485
	db 0
	dw #404,#5823,#3023
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #404,#11,#300f
	db 0
	dw #485
	db 0
	dw #405,#3011
	db 0
	dw #485
	db 0
	dw #404,#5823,#3023
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #400,#5823,#4022,#3000
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #481,#4021
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #481,#4020
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #481,#401f
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #481,#401e
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #480,#5822,#401d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #480,#5821,#401c
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #480,#5820,#401d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #480,#581f,#401c
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #480,#581e,#401b
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #480,#581d,#401a
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #480,#581c,#4019
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #480,#581d,#4017
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #480,#581c,#401c
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #480,#581b,#4019
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #480,#581a,#401a
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #480,#5819,#4019
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #480,#5817,#4017
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #480,#581c,#4015
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #480,#5819,#4013
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #480,#581a,#4012
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #480,#5819,#4011
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #480,#5817,#4010
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #480,#5815,#400f
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #480,#5813,#400e
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #480,#5812,#400e
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #484,#5811
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #484,#5810
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #484,#580f
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #484,#580e
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #484,#580e
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #484,#580d
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #480,#580b,#4000
	db 0
	dw #485
	db 0
	dw #405,#3000
	db 0
	dw #485
	db 0
	dw #480,#580a,#4000
	db 0
	dw #485
	db 0
	dw #405,#3000
	db 0
	dw #480,#80a,#80a
	db 0
	dw #480,#800,#800
	db 0
	dw #405,#80a
	db 0
	dw #405,#800
	db 0
	dw #485
	db 0
	dw #484,#800
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	dw #485
	db 0
	db #40
