;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Input
;	A			Drive
;	B			Cluster
;	U			Data Pointer
; Output
;	U			Next Data Pointer
;	A			Error Code
;   Carry Set	Error
;	Carry Clear	No Error
;
; FAT buffer must be loaded before calling this function.
; B,X,Y will be preserved.

FSYS_READ_CLUSTER_STACK_SIZE		EQU		3

FSYS_READ_CLUSTER_CLUSTER			EQU		FSYS_READ_CLUSTER_STACK_SIZE+1
FSYS_READ_CLUSTER_DRIVE				EQU		FSYS_READ_CLUSTER_STACK_SIZE

FSYS_READ_CLUSTER_SIDE				EQU		2
FSYS_READ_CLUSTER_SECTOR			EQU		1
FSYS_READ_CLUSTER_TRACK				EQU		0


FSYS_READ_CLUSTER
						PSHS	Y,X,B,A
						; [FSYS_READ_CLUSTER_STACK_SIZE+1,S]	Cluster
						; [FSYS_READ_CLUSTER_STACK_SIZE,S]		Drive
						; [2,S]		Side
						; [1,S]		Sector
						; [,S]		Track

						LEAS	-FSYS_READ_CLUSTER_STACK_SIZE,S

						LDA		FSYS_READ_CLUSTER_CLUSTER,S
						LBSR	FSYS_FAT_CLUSTER_TO_TRACK_SIDE_SECTOR
						STD		FSYS_READ_CLUSTER_TRACK,S

						LDB		FSYS_READ_CLUSTER_DRIVE,S
						ABX		; High-Byte:Side   Low-Byte:Drive

FSYS_READ_CLUSTER_READ_LOOP
						LDD		FSYS_READ_CLUSTER_TRACK,S
						LBSR	FSYS_BIOS_READSECTOR
						BCS		FSYS_READ_CLUSTER_EXIT
						LEAU	$100,U
						LDA		FSYS_READ_CLUSTER_SECTOR,S
						INC		FSYS_READ_CLUSTER_SECTOR,S
						ANDA	#7
						BNE		FSYS_READ_CLUSTER_READ_LOOP


						CLRA
FSYS_READ_CLUSTER_EXIT
						LEAS	1+FSYS_READ_CLUSTER_STACK_SIZE,S	; Skipping A by adding 1.
						PULS	B,Y,X,PC



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Input
;;	A			Drive
;;	B			Cluster
;;	Y			FAT Buffer
;;	U			Data Pointer
;; Output
;;	U			Size in bytes read
;;	A			Error Code
;;   Carry Set	Error
;;	Carry Clear	No Error
;FSYS_READ_CLUSTER_CHAIN_STACK_SIZE	EQU		1
;
;FSYS_READ_CLUSTER_CHAIN_DATA_POINTER	EQU		FSYS_READ_CLUSTER_CHAIN_STACK_SIZE+4
;FSYS_READ_CLUSTER_CHAIN_FAT_BUFFER		EQU		FSYS_READ_CLUSTER_CHAIN_STACK_SIZE+2
;FSYS_READ_CLUSTER_CHAIN_CLUSTER			EQU		FSYS_READ_CLUSTER_CHAIN_STACK_SIZE+1
;FSYS_READ_CLUSTER_CHAIN_DRIVE			EQU		FSYS_READ_CLUSTER_CHAIN_STACK_SIZE
;
;
;FSYS_READ_CLUSTER_CHAIN
;						PSHS	U,Y,X,B,A
;
;						STA		FSYS_READ_CLUSTER_CHAIN_CLUSTER,S
;
;FSYS_READ_CLUSTER_CHAIN_LOOP
;						LDD		FSYS_READ_CLUSTER_CHAIN_DRIVE,S
;						BSR		FSYS_READ_CLUSTER
;						LDB		FSYS_READ_CLUSTER_CHAIN_CLUSTER,S
;						CLRA
;						LDA		D,Y
;						STA		FSYS_READ_CLUSTER_CHAIN_CLUSTER,S
;						CMPA	#$C0
;						BCS		FSYS_READ_CLUSTER_CHAIN_LOOP
;
;						TFR		U,D
;						SUBD	FSYS_READ_CLUSTER_CHAIN_DATA_POINTER,S
;						STD		FSYS_READ_CLUSTER_CHAIN_DATA_POINTER,S
;						CLRA
;
;FSYS_READ_CLUSTER_CHAIN_EXIT
;						LEAS	1,S	; Skipping A by adding 1
;						PULS	B,X,Y,U,PC


