/*
 * Paraguay fades by rimina
 */

THREE.ParaguayFades = {

	uniforms: {
		"tDiffuse":   { type: "t", value: null },
		"brightness": { type: "f", value: 0 },
		"negate":   { type: "i", value: 0},
		"fade" : {type: "f", value: 0},
		"fadeColor" : {type: "v3", value: new THREE.Vector3(0, 0, 0)},
	},

	vertexShader: [

		"varying vec2 vUv;",
		"void main() {",
			"vUv = uv;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",
		"}"

	].join("\n"),

	fragmentShader: [

        "uniform sampler2D tDiffuse;",
        "uniform float brightness;",
		"uniform float fade;",
		"uniform vec3 fadeColor;",
        "uniform int negate;",

        "varying vec2 vUv;",

        "void main() {",
            "vec4 c = texture2D( tDiffuse, vUv );",

            //Brightness
            "c.rgb += brightness;",
			//"c.rgb = clamp(c.rgb, vec3(0.), vec3(1.));",

			//some posterizing
            "c.rgb = smoothstep(-0.1, 1.2, c.rgb);",

			//fade
			"c.rgb = mix(c.rgb, fadeColor, smoothstep(0.0, 1.0, fade));",

            //negate
            "if(negate == 1){",
                "c.rgb = vec3(1.)-c.rgb;",
            "}",

            "gl_FragColor = c;",
        "}"

	].join("\n")

};
