/* MySQL raytracing engine by Nick (holtsetio@gmail.com) */
Select if(repeat(char(
/* Parameters */
@w := 100,            /* width of the output in pixels */
@h := 100,            /* height of the output in pixels */
@cam.x := 0.0,        /* x-position of the camera */
@cam.y := 0.0,        /* y-position of the camera */
@cam.z := -6,         /* z-position of the camera */
@cam.lookatx := 0.0,  /* x-position of a point at which the camera looks at */
@cam.lookaty := 0.0,  /* y-position of a point at which the camera looks at */
@cam.lookatz := 0.0,  /* z-position of a point at which the camera looks at */
@cam.upx := 0.0,      /* x-part of the camera's up vector */
@cam.upy := 1.0,      /* y-part of the camera's up vector */
@cam.upz := 0.0,      /* z-part of the camera's up vector */
  
@light.x := 0.0,      /* x-position of the lightsource */
@light.y := 0.95,     /* y-position of the lightsource */
@light.z := -0.75,    /* z-position of the lightsource */
@light.r := 0.35,     /* radius of the lightsource */
@fov := 33,           /* Field of view in degrees */
@shadows := false,    /* shadows enabled? */
@maxRecDepth := 10,   /* max. recursion depth for reflections */
  
/* List of triangles in the scene, separated by semicolons.                   */
/* Each triangle is given by xyz-coordinates of three vertices, separated by  */
/* commas. Then follows the material which can be either "m" for matte or "r" */
/* for reflective. Matte materials are followed by three values representing  */
/* the color in r,g,b format.                                                 */

@triangles := "-10.0,-1.0,-10.0,10.0,-1.0,-10.0,0.0,-1.0,5.0,m,0.6,0.6,0.6;
-10.0,1.0,-10.0,10.0,1.0,-10.0,0.0,1.0,5.0,m,0.6,0.6,0.6;
-1.0,-10.0,-10.0, -1.0,10.0,-10.0, -1.0,0,5.0, m, 0.85,0.5,0.0;
1.0,-10.0,-10.0, 1.0,10.0,-10.0, 1.0,0,5.0, m, 0.2,0.6,0.75;
-10.0,-10.0,1.0, 10.0,-10.0,1.0, 0.0,5.0,1.0, m, 0.6,0.6,0.6;
-100.0,-100.0,-10.0, 100.0,-100.0,-10.0, 0.0,50.0,-10.0, m, 0.6,0.6,0.6;
0.0186,0.2291,-0.2454,0.0688,0.2425,-0.2097,0.0772,0.1799,-0.3062,m,1.0,1.0,1.0;
0.4687,0.6854,0.3133,0.5415,0.6771,0.2988,0.4721,0.653,0.1947,m,1.0,1.0,1.0;
0.1996,-0.5698,0.1763,0.1972,-0.6564,0.1913,0.2829,-0.6577,0.129,m,1.0,1.0,1.0;
0.055,-0.0951,0.2909,0.0856,-0.0407,0.2368,0.0601,0.0672,0.2075,m,1.0,1.0,1.0;
-0.0537,0.276,-0.1794,-0.0372,0.1985,-0.3281,-0.0882,0.2627,-0.2664,m,1.0,1.0,1.0;
-0.0537,0.276,-0.1794,0.0657,0.2607,-0.1463,0.0688,0.2425,-0.2097,m,1.0,1.0,1.0;
-0.1709,0.2793,-0.2746,-0.0372,0.1985,-0.3281,-0.1682,0.2273,-0.3479,m,1.0,1.0,1.0;
0.3325,0.3501,-0.3305,0.2491,0.293,-0.2696,0.2054,0.3001,-0.1753,m,1.0,1.0,1.0;
-0.4044,0.2769,-0.1853,-0.2882,0.2806,-0.279,-0.3743,0.2708,-0.263,m,1.0,1.0,1.0;
0.0477,-0.6174,-0.3229,0.1007,-0.6448,-0.2922,0.1224,-0.6494,-0.1783,m,1.0,1.0,1.0;
0.0688,0.2425,-0.2097,0.2054,0.3001,-0.1753,0.1589,0.2376,-0.2498,m,1.0,1.0,1.0;
-0.17,0.304,-0.179,-0.0537,0.276,-0.1794,-0.0882,0.2627,-0.2664,m,1.0,1.0,1.0;
-0.1709,0.2793,-0.2746,-0.0882,0.2627,-0.2664,-0.0372,0.1985,-0.3281,m,1.0,1.0,1.0;
0.6681,0.324,-0.0706,0.6203,0.4603,-0.0586,0.627,0.369,-0.0192,m,1.0,1.0,1.0;
0.2863,0.45,-0.1848,0.334,0.5457,-0.1688,0.3435,0.4499,-0.3152,m,1.0,1.0,1.0;
-0.2895,0.3102,-0.1783,-0.1709,0.2793,-0.2746,-0.2882,0.2806,-0.279,m,1.0,1.0,1.0;
0.5579,-0.2922,-0.0686,0.5549,-0.2947,-0.1745,0.6153,-0.1994,-0.0531,m,1.0,1.0,1.0;
0.3928,0.6236,0.3963,0.4526,0.704,0.437,0.4687,0.6854,0.3133,m,1.0,1.0,1.0;
0.4449,0.2839,0.0863,0.5739,0.2963,0.047,0.4497,0.4288,0.0758,m,1.0,1.0,1.0;
-0.2897,0.3086,-0.0579,-0.17,0.304,-0.179,-0.2895,0.3102,-0.1783,m,1.0,1.0,1.0;
0.4585,0.2205,-0.5176,0.4765,0.3063,-0.5025,0.5498,0.3255,-0.5135,m,1.0,1.0,1.0;
0.5506,0.2065,-0.514,0.4585,0.2205,-0.5176,0.5498,0.3255,-0.5135,m,1.0,1.0,1.0;
0.5498,0.3255,-0.5135,0.4361,0.3302,-0.447,0.5679,0.4376,-0.427,m,1.0,1.0,1.0;
0.4361,0.3302,-0.447,0.453,0.4483,-0.4137,0.5679,0.4376,-0.427,m,1.0,1.0,1.0;
0.5549,-0.2947,-0.1745,0.6143,-0.2023,-0.1863,0.6153,-0.1994,-0.0531,m,1.0,1.0,1.0;
-0.1707,0.3021,-0.0595,-0.0537,0.276,-0.1794,-0.17,0.304,-0.179,m,1.0,1.0,1.0;
-0.2882,0.2806,-0.279,-0.1709,0.2793,-0.2746,-0.1682,0.2273,-0.3479,m,1.0,1.0,1.0;
-0.0878,0.7401,0.2598,-0.1333,0.7322,0.2649,-0.1233,0.6754,0.199,m,1.0,1.0,1.0;
-0.287,0.0589,-0.4355,-0.2979,0.1584,-0.3881,-0.1702,0.1541,-0.402,m,1.0,1.0,1.0;
-0.0537,0.276,-0.1794,0.0688,0.2425,-0.2097,0.0186,0.2291,-0.2454,m,1.0,1.0,1.0;
-0.3779,-0.0903,-0.5097,-0.4154,-0.0519,-0.4776,-0.287,0.0589,-0.4355,m,1.0,1.0,1.0;
-0.0564,0.2761,-0.0527,0.0657,0.2607,-0.1463,-0.0537,0.276,-0.1794,m,1.0,1.0,1.0;
0.3364,-0.5298,-0.3058,0.3009,-0.4326,-0.294,0.3428,-0.5676,-0.4286,m,1.0,1.0,1.0;
0.2431,0.4516,-0.0688,0.2863,0.45,-0.1848,0.2635,0.393,-0.148,m,1.0,1.0,1.0;
0.6814,0.1882,-0.2984,0.6749,0.1861,-0.4121,0.6821,0.3142,-0.2953,m,1.0,1.0,1.0;
-0.2818,-0.0683,-0.5359,-0.3779,-0.0903,-0.5097,-0.287,0.0589,-0.4355,m,1.0,1.0,1.0;
0.6143,-0.2023,-0.1863,0.6585,-0.0903,-0.179,0.6153,-0.1994,-0.0531,m,1.0,1.0,1.0;
-0.0549,0.6213,0.1455,-0.0516,0.7048,0.1811,-0.1233,0.6754,0.199,m,1.0,1.0,1.0;
-0.5273,-0.5745,-0.305,-0.6627,-0.5417,-0.2783,-0.5666,-0.4595,-0.3508,m,1.0,1.0,1.0;
0.4495,-0.5814,-0.0668,0.3363,-0.453,-0.0745,0.3641,-0.5286,-0.0629,m,1.0,1.0,1.0;
0.3268,-0.0648,-0.4421,0.4569,-0.0763,-0.422,0.4531,-0.1967,-0.4071,m,1.0,1.0,1.0;
0.3268,-0.0648,-0.4421,0.4487,0.0695,-0.4037,0.4569,-0.0763,-0.422,m,1.0,1.0,1.0;
0.3268,-0.0648,-0.4421,0.325,0.039,-0.4114,0.4487,0.0695,-0.4037,m,1.0,1.0,1.0;
-0.294,-0.563,-0.4683,-0.2677,-0.5224,-0.502,-0.164,-0.5727,-0.4694,m,1.0,1.0,1.0;
-0.294,-0.563,-0.4683,-0.2829,-0.4432,-0.5329,-0.2677,-0.5224,-0.502,m,1.0,1.0,1.0;
0.3289,-0.2074,-0.4353,0.3268,-0.0648,-0.4421,0.4531,-0.1967,-0.4071,m,1.0,1.0,1.0;
-0.0564,0.2761,-0.0527,-0.0537,0.276,-0.1794,-0.1707,0.3021,-0.0595,m,1.0,1.0,1.0;
-0.1703,0.059,-0.4407,-0.287,0.0589,-0.4355,-0.1702,0.1541,-0.402,m,1.0,1.0,1.0;
-0.3009,-0.3268,-0.5534,-0.3006,-0.1881,-0.5582,-0.1693,-0.3229,-0.5645,m,1.0,1.0,1.0;
-0.0564,0.2761,-0.0527,0.0822,0.263,-0.0515,0.0657,0.2607,-0.1463,m,1.0,1.0,1.0;
-0.2979,0.1584,-0.3881,-0.2896,0.225,-0.3463,-0.1682,0.2273,-0.3479,m,1.0,1.0,1.0;
-0.2677,-0.5224,-0.502,-0.2829,-0.4432,-0.5329,-0.1737,-0.435,-0.5388,m,1.0,1.0,1.0;
-0.164,-0.5727,-0.4694,-0.2677,-0.5224,-0.502,-0.1737,-0.435,-0.5388,m,1.0,1.0,1.0;
0.1954,0.5544,0.0749,0.1496,0.6195,0.128,0.0648,0.5829,0.0619,m,1.0,1.0,1.0;
0.6585,-0.0903,-0.179,0.6526,-0.1013,-0.0697,0.6153,-0.1994,-0.0531,m,1.0,1.0,1.0;
-0.0372,0.1985,-0.3281,0.0186,0.2291,-0.2454,0.0772,0.1799,-0.3062,m,1.0,1.0,1.0;
-0.6118,0.0512,-0.2669,-0.6309,0.0521,-0.1734,-0.6004,0.1044,-0.2072,m,1.0,1.0,1.0;
0.5739,0.2963,0.047,0.557,0.4427,0.0389,0.4497,0.4288,0.0758,m,1.0,1.0,1.0;
-0.0539,-0.6139,0.0585,0.0691,-0.6161,0.0583,-0.0522,-0.6175,0.1545,m,1.0,1.0,1.0;
-0.305,-0.0165,-0.4883,-0.287,0.0589,-0.4355,-0.2818,-0.0683,-0.5359,m,1.0,1.0,1.0;
-0.2896,0.225,-0.3463,-0.2979,0.1584,-0.3881,-0.4187,0.1986,-0.3241,m,1.0,1.0,1.0;
-0.0537,0.276,-0.1794,0.0186,0.2291,-0.2454,-0.0372,0.1985,-0.3281,m,1.0,1.0,1.0;
0.1971,-0.5784,-0.427,0.3364,-0.5298,-0.3058,0.3428,-0.5676,-0.4286,m,1.0,1.0,1.0;
0.202,-0.4442,-0.3908,0.3009,-0.4326,-0.294,0.3364,-0.5298,-0.3058,m,1.0,1.0,1.0;
-0.4052,-0.4479,0.2728,-0.4057,-0.3207,0.2894,-0.5474,-0.32,0.1835,m,1.0,1.0,1.0;
0.2068,-0.2108,-0.4289,0.3289,-0.2074,-0.4353,0.3153,-0.2854,-0.397,m,1.0,1.0,1.0;
0.2068,-0.2108,-0.4289,0.2019,-0.0788,-0.4327,0.3268,-0.0648,-0.4421,m,1.0,1.0,1.0;
0.3289,-0.2074,-0.4353,0.2068,-0.2108,-0.4289,0.3268,-0.0648,-0.4421,m,1.0,1.0,1.0;
0.2116,0.0492,-0.4017,0.325,0.039,-0.4114,0.3268,-0.0648,-0.4421,m,1.0,1.0,1.0;
0.2019,-0.0788,-0.4327,0.2116,0.0492,-0.4017,0.3268,-0.0648,-0.4421,m,1.0,1.0,1.0;
0.2116,0.0492,-0.4017,0.3319,0.1128,-0.3737,0.325,0.039,-0.4114,m,1.0,1.0,1.0;
0.2116,0.0492,-0.4017,0.2046,0.1719,-0.317,0.3094,0.1857,-0.3537,m,1.0,1.0,1.0;
0.3319,0.1128,-0.3737,0.2116,0.0492,-0.4017,0.3094,0.1857,-0.3537,m,1.0,1.0,1.0;
-0.6627,-0.5417,-0.2783,-0.6577,-0.4396,-0.3156,-0.5666,-0.4595,-0.3508,m,1.0,1.0,1.0;
0.1971,-0.5784,-0.427,0.202,-0.4442,-0.3908,0.3364,-0.5298,-0.3058,m,1.0,1.0,1.0;
-0.2897,0.3086,-0.0579,-0.1707,0.3021,-0.0595,-0.17,0.304,-0.179,m,1.0,1.0,1.0;
0.3153,-0.2854,-0.397,0.201,-0.3256,-0.4077,0.2068,-0.2108,-0.4289,m,1.0,1.0,1.0;
0.2116,0.0492,-0.4017,0.1798,0.105,-0.3709,0.2046,0.1719,-0.317,m,1.0,1.0,1.0;
0.1954,0.5544,0.0749,0.0648,0.5829,0.0619,0.0847,0.5707,-0.0098,m,1.0,1.0,1.0;
0.2101,0.6704,-0.0232,0.1349,0.7122,-0.0055,0.2064,0.6944,0.055,m,1.0,1.0,1.0;
0.0662,-0.4568,-0.399,0.202,-0.4442,-0.3908,0.1971,-0.5784,-0.427,m,1.0,1.0,1.0;
0.1018,-0.5493,-0.4511,0.0662,-0.4568,-0.399,0.1971,-0.5784,-0.427,m,1.0,1.0,1.0;
0.0662,-0.4568,-0.399,0.201,-0.3256,-0.4077,0.202,-0.4442,-0.3908,m,1.0,1.0,1.0;
0.0829,-0.2017,-0.4349,0.2068,-0.2108,-0.4289,0.201,-0.3256,-0.4077,m,1.0,1.0,1.0;
0.0631,-0.3193,-0.4102,0.0829,-0.2017,-0.4349,0.201,-0.3256,-0.4077,m,1.0,1.0,1.0;
0.0829,-0.2017,-0.4349,0.0686,-0.0599,-0.4448,0.2019,-0.0788,-0.4327,m,1.0,1.0,1.0;
0.2068,-0.2108,-0.4289,0.0829,-0.2017,-0.4349,0.2019,-0.0788,-0.4327,m,1.0,1.0,1.0;
0.0686,-0.0599,-0.4448,0.2116,0.0492,-0.4017,0.2019,-0.0788,-0.4327,m,1.0,1.0,1.0;
0.0686,-0.0599,-0.4448,0.0718,0.0632,-0.3997,0.2116,0.0492,-0.4017,m,1.0,1.0,1.0;
0.2116,0.0492,-0.4017,0.0772,0.1799,-0.3062,0.1798,0.105,-0.3709,m,1.0,1.0,1.0;
0.1798,0.105,-0.3709,0.0772,0.1799,-0.3062,0.2046,0.1719,-0.317,m,1.0,1.0,1.0;
-0.17,-0.2055,-0.578,-0.3006,-0.1881,-0.5582,-0.1702,-0.0597,-0.5426,m,1.0,1.0,1.0;
0.0631,-0.3193,-0.4102,0.201,-0.3256,-0.4077,0.0662,-0.4568,-0.399,m,1.0,1.0,1.0;
-0.6346,0.0514,-0.0641,-0.6173,0.0216,0.0463,-0.6001,0.104,-0.0265,m,1.0,1.0,1.0;
0.0901,0.1047,-0.3704,0.0772,0.1799,-0.3062,0.2116,0.0492,-0.4017,m,1.0,1.0,1.0;
0.0718,0.0632,-0.3997,0.0901,0.1047,-0.3704,0.2116,0.0492,-0.4017,m,1.0,1.0,1.0;
0.1349,0.7122,-0.0055,0.0868,0.7039,0.0635,0.2064,0.6944,0.055,m,1.0,1.0,1.0;
-0.2895,0.3102,-0.1783,-0.17,0.304,-0.179,-0.1709,0.2793,-0.2746,m,1.0,1.0,1.0;
-0.17,0.304,-0.179,-0.0882,0.2627,-0.2664,-0.1709,0.2793,-0.2746,m,1.0,1.0,1.0;
-0.3006,-0.1881,-0.5582,-0.17,-0.2055,-0.578,-0.1693,-0.3229,-0.5645,m,1.0,1.0,1.0;
-0.1702,0.1541,-0.402,-0.2979,0.1584,-0.3881,-0.1682,0.2273,-0.3479,m,1.0,1.0,1.0;
-0.4185,0.0629,-0.4169,-0.2979,0.1584,-0.3881,-0.287,0.0589,-0.4355,m,1.0,1.0,1.0;
0.0718,0.0632,-0.3997,0.0772,0.1799,-0.3062,0.0901,0.1047,-0.3704,m,1.0,1.0,1.0;
0.0628,-0.5823,-0.514,0.0662,-0.4568,-0.399,0.1018,-0.5493,-0.4511,m,1.0,1.0,1.0;
0.2168,0.312,-0.057,0.2715,0.4033,-0.0259,0.2431,0.4516,-0.0688,m,1.0,1.0,1.0;
-0.6491,-0.0836,0.0557,-0.5881,-0.0414,0.1203,-0.5627,0.085,0.0743,m,1.0,1.0,1.0;
0.334,0.5457,-0.1688,0.3445,0.5258,-0.2845,0.3435,0.4499,-0.3152,m,1.0,1.0,1.0;
0.3009,-0.4326,-0.294,0.31,-0.4446,-0.1777,0.3435,-0.5685,-0.2002,m,1.0,1.0,1.0;
-0.0159,-0.453,-0.4464,0.0662,-0.4568,-0.399,0.0628,-0.5823,-0.514,m,1.0,1.0,1.0;
-0.0527,-0.5761,-0.5168,-0.0159,-0.453,-0.4464,0.0628,-0.5823,-0.514,m,1.0,1.0,1.0;
-0.0471,0.0833,-0.4151,0.0718,0.0632,-0.3997,0.0686,-0.0599,-0.4448,m,1.0,1.0,1.0;
-0.0387,-0.014,-0.4567,-0.0471,0.0833,-0.4151,0.0686,-0.0599,-0.4448,m,1.0,1.0,1.0;
-0.0372,0.1985,-0.3281,0.0772,0.1799,-0.3062,0.0718,0.0632,-0.3997,m,1.0,1.0,1.0;
-0.0471,0.0833,-0.4151,-0.0372,0.1985,-0.3281,0.0718,0.0632,-0.3997,m,1.0,1.0,1.0;
-0.436,-0.1289,-0.4923,-0.3779,-0.0903,-0.5097,-0.4094,-0.2073,-0.5189,m,1.0,1.0,1.0;
-0.2895,0.3102,-0.1783,-0.4044,0.2769,-0.1853,-0.4021,0.2766,-0.0513,m,1.0,1.0,1.0;
-0.0527,-0.5761,-0.5168,-0.0568,-0.5621,-0.4327,-0.0159,-0.453,-0.4464,m,1.0,1.0,1.0;
0.4422,0.5616,-0.1789,0.5657,0.5288,-0.2993,0.4363,0.5383,-0.3087,m,1.0,1.0,1.0;
0.6532,0.0576,-0.173,0.6242,0.0539,-0.0339,0.6523,0.0607,-0.0847,m,1.0,1.0,1.0;
-0.2882,0.2806,-0.279,-0.1682,0.2273,-0.3479,-0.2896,0.225,-0.3463,m,1.0,1.0,1.0;
-0.2897,0.3086,-0.0579,-0.2895,0.3102,-0.1783,-0.4021,0.2766,-0.0513,m,1.0,1.0,1.0;
0.0648,0.5829,0.0619,-0.0549,0.6213,0.1455,-0.0239,0.5977,0.0718,m,1.0,1.0,1.0;
-0.7974,-0.4578,-0.0512,-0.7842,-0.3136,-0.059,-0.8047,-0.3178,-0.1714,m,1.0,1.0,1.0;
0.6532,0.0576,-0.173,0.6523,0.0607,-0.0847,0.6242,0.0539,-0.0339,m,1.0,1.0,1.0;
-0.8116,-0.45,-0.1803,-0.7974,-0.4578,-0.0512,-0.8047,-0.3178,-0.1714,m,1.0,1.0,1.0;
-0.4044,0.2769,-0.1853,-0.2895,0.3102,-0.1783,-0.2882,0.2806,-0.279,m,1.0,1.0,1.0;
-0.0868,0.1697,-0.3784,-0.0372,0.1985,-0.3281,-0.0471,0.0833,-0.4151,m,1.0,1.0,1.0;
-0.4154,-0.0519,-0.4776,-0.4185,0.0629,-0.4169,-0.287,0.0589,-0.4355,m,1.0,1.0,1.0;
-0.2829,-0.4432,-0.5329,-0.3009,-0.3268,-0.5534,-0.1693,-0.3229,-0.5645,m,1.0,1.0,1.0;
0.3266,-0.5671,0.0759,0.1996,-0.5698,0.1763,0.3255,-0.6632,0.0619,m,1.0,1.0,1.0;
-0.1737,-0.435,-0.5388,-0.2829,-0.4432,-0.5329,-0.1693,-0.3229,-0.5645,m,1.0,1.0,1.0;
-0.0568,-0.5621,-0.4327,-0.0685,-0.4256,-0.509,-0.0159,-0.453,-0.4464,m,1.0,1.0,1.0;
0.0656,0.6178,0.1434,-0.0549,0.6213,0.1455,0.0648,0.5829,0.0619,m,1.0,1.0,1.0;
-0.0527,-0.5761,-0.5168,-0.164,-0.5727,-0.4694,-0.0568,-0.5621,-0.4327,m,1.0,1.0,1.0;
-0.164,-0.5727,-0.4694,-0.1737,-0.435,-0.5388,-0.0685,-0.4256,-0.509,m,1.0,1.0,1.0;
-0.0568,-0.5621,-0.4327,-0.164,-0.5727,-0.4694,-0.0685,-0.4256,-0.509,m,1.0,1.0,1.0;
-0.1737,-0.435,-0.5388,-0.1693,-0.3229,-0.5645,-0.0608,-0.3178,-0.5315,m,1.0,1.0,1.0;
-0.0685,-0.4256,-0.509,-0.1737,-0.435,-0.5388,-0.0608,-0.3178,-0.5315,m,1.0,1.0,1.0;
-0.1693,-0.3229,-0.5645,-0.17,-0.2055,-0.578,-0.0443,-0.2103,-0.5574,m,1.0,1.0,1.0;
-0.0608,-0.3178,-0.5315,-0.1693,-0.3229,-0.5645,-0.0443,-0.2103,-0.5574,m,1.0,1.0,1.0;
-0.1702,-0.0597,-0.5426,-0.0571,-0.0782,-0.5362,-0.0443,-0.2103,-0.5574,m,1.0,1.0,1.0;
-0.17,-0.2055,-0.578,-0.1702,-0.0597,-0.5426,-0.0443,-0.2103,-0.5574,m,1.0,1.0,1.0;
-0.1703,0.059,-0.4407,-0.1702,0.1541,-0.402,-0.0471,0.0833,-0.4151,m,1.0,1.0,1.0;
-0.1702,0.1541,-0.402,-0.0868,0.1697,-0.3784,-0.0471,0.0833,-0.4151,m,1.0,1.0,1.0;
-0.1682,0.2273,-0.3479,-0.0372,0.1985,-0.3281,-0.0868,0.1697,-0.3784,m,1.0,1.0,1.0;
-0.1702,0.1541,-0.402,-0.1682,0.2273,-0.3479,-0.0868,0.1697,-0.3784,m,1.0,1.0,1.0;
-0.2818,-0.0683,-0.5359,-0.287,0.0589,-0.4355,-0.305,-0.0165,-0.4883,m,1.0,1.0,1.0;
0.1928,-0.3001,0.1615,0.1825,-0.2086,0.1977,0.0981,-0.3354,0.1952,m,1.0,1.0,1.0;
-0.4875,-0.5409,-0.3812,-0.4142,-0.5768,-0.4248,-0.5273,-0.5745,-0.305,m,1.0,1.0,1.0;
-0.3006,-0.1881,-0.5582,-0.2818,-0.0683,-0.5359,-0.1702,-0.0597,-0.5426,m,1.0,1.0,1.0;
0.3009,-0.4326,-0.294,0.3364,-0.5298,-0.3058,0.3428,-0.5676,-0.4286,m,1.0,1.0,1.0;
-0.7689,-0.4425,-0.2662,-0.7646,-0.3436,-0.2643,-0.6537,-0.3274,-0.2958,m,1.0,1.0,1.0;
-0.6577,-0.4396,-0.3156,-0.7689,-0.4425,-0.2662,-0.6537,-0.3274,-0.2958,m,1.0,1.0,1.0;
-0.6482,-0.3248,0.0552,-0.6527,-0.2045,0.0579,-0.7054,-0.2878,-0.0543,m,1.0,1.0,1.0;
-0.294,-0.563,-0.4683,-0.4142,-0.5768,-0.4248,-0.4164,-0.464,-0.4622,m,1.0,1.0,1.0;
-0.5367,-0.5549,0.0618,-0.5282,-0.6409,-0.0489,-0.4048,-0.6479,0.0593,m,1.0,1.0,1.0;
0.1868,-0.5797,0.1,0.3266,-0.5671,0.0759,0.3203,-0.4334,0.0531,m,1.0,1.0,1.0;
0.0033,0.8124,0.1129,0.064,0.7903,0.0788,0.0868,0.7039,0.0635,m,1.0,1.0,1.0;
-0.4164,-0.464,-0.4622,-0.3758,-0.4142,-0.5017,-0.2829,-0.4432,-0.5329,m,1.0,1.0,1.0;
-0.6491,-0.0836,0.0557,-0.6173,0.0216,0.0463,-0.677,-0.0721,-0.0508,m,1.0,1.0,1.0;
-0.6669,-0.588,-0.1772,-0.7429,-0.536,-0.0581,-0.7625,-0.5241,-0.1819,m,1.0,1.0,1.0;
0.2431,0.4516,-0.0688,0.2045,0.5605,-0.0616,0.2863,0.45,-0.1848,m,1.0,1.0,1.0;
-0.4094,-0.2073,-0.5189,-0.3779,-0.0903,-0.5097,-0.3006,-0.1881,-0.5582,m,1.0,1.0,1.0;
0.439,0.1572,-0.4735,0.4585,0.2205,-0.5176,0.4487,0.0695,-0.4037,m,1.0,1.0,1.0;
0.4361,0.3302,-0.447,0.4765,0.3063,-0.5025,0.4585,0.2205,-0.5176,m,1.0,1.0,1.0;
-0.8116,-0.45,-0.1803,-0.7689,-0.4425,-0.2662,-0.7625,-0.5241,-0.1819,m,1.0,1.0,1.0;
0.4361,0.3302,-0.447,0.4585,0.2205,-0.5176,0.439,0.1572,-0.4735,m,1.0,1.0,1.0;
-0.5288,-0.3201,-0.4192,-0.4405,-0.3188,-0.4843,-0.4164,-0.464,-0.4622,m,1.0,1.0,1.0;
-0.6491,-0.0836,0.0557,-0.677,-0.0721,-0.0508,-0.6894,-0.2037,-0.058,m,1.0,1.0,1.0;
-0.0516,0.7048,0.1811,0.0868,0.7039,0.0635,-0.0312,0.664,0.1127,m,1.0,1.0,1.0;
0.2168,0.312,-0.057,0.2431,0.4516,-0.0688,0.2635,0.393,-0.148,m,1.0,1.0,1.0;
0.3644,0.199,-0.3998,0.439,0.1572,-0.4735,0.4487,0.0695,-0.4037,m,1.0,1.0,1.0;
0.3644,0.199,-0.3998,0.4361,0.3302,-0.447,0.439,0.1572,-0.4735,m,1.0,1.0,1.0;
-0.4875,-0.5409,-0.3812,-0.5666,-0.4595,-0.3508,-0.5162,-0.4312,-0.4076,m,1.0,1.0,1.0;
0.3644,0.199,-0.3998,0.3651,0.2835,-0.3996,0.4361,0.3302,-0.447,m,1.0,1.0,1.0;
0.3651,0.2835,-0.3996,0.3644,0.199,-0.3998,0.4361,0.3302,-0.447,m,1.0,1.0,1.0;
0.3644,0.199,-0.3998,0.3651,0.2835,-0.3996,0.4361,0.3302,-0.447,m,1.0,1.0,1.0;
0.0868,0.7039,0.0635,0.1349,0.7122,-0.0055,0.2101,0.6704,-0.0232,m,1.0,1.0,1.0;
-0.5972,-0.0818,-0.3662,-0.5605,0.0703,-0.3195,-0.5301,-0.0672,-0.4215,m,1.0,1.0,1.0;
0.3319,0.1128,-0.3737,0.3644,0.199,-0.3998,0.4487,0.0695,-0.4037,m,1.0,1.0,1.0;
0.3094,0.1857,-0.3537,0.3319,0.1128,-0.3737,0.4487,0.0695,-0.4037,m,1.0,1.0,1.0;
0.3325,0.3501,-0.3305,0.4361,0.3302,-0.447,0.3651,0.2835,-0.3996,m,1.0,1.0,1.0;
0.3435,0.4499,-0.3152,0.453,0.4483,-0.4137,0.4361,0.3302,-0.447,m,1.0,1.0,1.0;
0.3325,0.3501,-0.3305,0.3435,0.4499,-0.3152,0.4361,0.3302,-0.447,m,1.0,1.0,1.0;
-0.0277,0.8185,0.1833,0.0033,0.8124,0.1129,0.064,0.7903,0.0788,m,1.0,1.0,1.0;
-0.0277,0.8185,0.1833,0.0033,0.8124,0.1129,0.0868,0.7039,0.0635,m,1.0,1.0,1.0;
-0.7504,-0.4493,0.0248,-0.6446,-0.5437,0.0355,-0.658,-0.4467,0.0605,m,1.0,1.0,1.0;
0.3319,0.1128,-0.3737,0.3094,0.1857,-0.3537,0.3644,0.199,-0.3998,m,1.0,1.0,1.0;
-0.4185,0.0629,-0.4169,-0.5024,0.0316,-0.3971,-0.48,0.1061,-0.3685,m,1.0,1.0,1.0;
0.1971,-0.5784,-0.427,0.3428,-0.5676,-0.4286,0.3395,-0.6506,-0.4237,m,1.0,1.0,1.0;
-0.0277,0.8185,0.1833,0.064,0.7903,0.0788,0.0033,0.8124,0.1129,m,1.0,1.0,1.0;
-0.0516,0.7048,0.1811,-0.0312,0.664,0.1127,-0.0239,0.5977,0.0718,m,1.0,1.0,1.0;
0.3644,0.199,-0.3998,0.3094,0.1857,-0.3537,0.3651,0.2835,-0.3996,m,1.0,1.0,1.0;
0.3094,0.1857,-0.3537,0.3325,0.3501,-0.3305,0.3651,0.2835,-0.3996,m,1.0,1.0,1.0;
0.3383,0.4639,0.0264,0.2399,0.4743,0.0223,0.2715,0.4033,-0.0259,m,1.0,1.0,1.0;
-0.5162,-0.4312,-0.4076,-0.4164,-0.464,-0.4622,-0.4142,-0.5768,-0.4248,m,1.0,1.0,1.0;
-0.436,-0.1289,-0.4923,-0.4154,-0.0519,-0.4776,-0.3779,-0.0903,-0.5097,m,1.0,1.0,1.0;
-0.4164,-0.464,-0.4622,-0.2829,-0.4432,-0.5329,-0.294,-0.563,-0.4683,m,1.0,1.0,1.0;
-0.0516,0.7048,0.1811,-0.0277,0.8185,0.1833,0.0868,0.7039,0.0635,m,1.0,1.0,1.0;
-0.7429,-0.536,-0.0581,-0.7974,-0.4578,-0.0512,-0.8116,-0.45,-0.1803,m,1.0,1.0,1.0;
-0.5301,-0.0672,-0.4215,-0.4154,-0.0519,-0.4776,-0.436,-0.1289,-0.4923,m,1.0,1.0,1.0;
-0.7625,-0.5241,-0.1819,-0.7429,-0.536,-0.0581,-0.8116,-0.45,-0.1803,m,1.0,1.0,1.0;
-0.5605,0.0703,-0.3195,-0.4187,0.1986,-0.3241,-0.48,0.1061,-0.3685,m,1.0,1.0,1.0;
-0.5301,-0.0672,-0.4215,-0.436,-0.1289,-0.4923,-0.4094,-0.2073,-0.5189,m,1.0,1.0,1.0;
-0.5301,-0.0672,-0.4215,-0.5024,0.0316,-0.3971,-0.4185,0.0629,-0.4169,m,1.0,1.0,1.0;
-0.5368,-0.2045,-0.4315,-0.5301,-0.0672,-0.4215,-0.4094,-0.2073,-0.5189,m,1.0,1.0,1.0;
-0.6019,-0.2075,-0.3679,-0.5972,-0.0818,-0.3662,-0.5368,-0.2045,-0.4315,m,1.0,1.0,1.0;
0.3094,0.1857,-0.3537,0.2491,0.293,-0.2696,0.3325,0.3501,-0.3305,m,1.0,1.0,1.0;
-0.677,-0.0721,-0.0508,-0.6726,-0.0655,-0.1764,-0.6903,-0.2063,-0.1777,m,1.0,1.0,1.0;
-0.6527,-0.2045,0.0579,-0.6491,-0.0836,0.0557,-0.6894,-0.2037,-0.058,m,1.0,1.0,1.0;
-0.5972,-0.0818,-0.3662,-0.5301,-0.0672,-0.4215,-0.5368,-0.2045,-0.4315,m,1.0,1.0,1.0;
-0.3803,-0.3226,-0.5207,-0.4094,-0.2073,-0.5189,-0.3006,-0.1881,-0.5582,m,1.0,1.0,1.0;
-0.677,-0.0721,-0.0508,-0.6173,0.0216,0.0463,-0.6346,0.0514,-0.0641,m,1.0,1.0,1.0;
-0.5301,-0.0672,-0.4215,-0.5605,0.0703,-0.3195,-0.5024,0.0316,-0.3971,m,1.0,1.0,1.0;
-0.0239,0.5977,0.0718,0.0868,0.7039,0.0635,0.0648,0.5829,0.0619,m,1.0,1.0,1.0;
-0.3009,-0.3268,-0.5534,-0.3803,-0.3226,-0.5207,-0.3006,-0.1881,-0.5582,m,1.0,1.0,1.0;
0.2046,0.1719,-0.317,0.2491,0.293,-0.2696,0.3094,0.1857,-0.3537,m,1.0,1.0,1.0;
-0.1227,0.7966,0.2775,-0.1233,0.6754,0.199,-0.1333,0.7322,0.2649,m,1.0,1.0,1.0;
0.0319,-0.4312,0.2827,0.069,-0.574,0.2832,0.0774,-0.4367,0.1852,m,1.0,1.0,1.0;
-0.2829,-0.4432,-0.5329,-0.3758,-0.4142,-0.5017,-0.3803,-0.3226,-0.5207,m,1.0,1.0,1.0;
0.0856,-0.0407,0.2368,0.188,0.0593,0.1987,0.0601,0.0672,0.2075,m,1.0,1.0,1.0;
-0.5162,-0.4312,-0.4076,-0.5288,-0.3201,-0.4192,-0.4164,-0.464,-0.4622,m,1.0,1.0,1.0;
0.6793,0.4605,-0.1904,0.6203,0.4603,-0.0586,0.6681,0.324,-0.0706,m,1.0,1.0,1.0;
-0.6346,0.0514,-0.0641,-0.6309,0.0521,-0.1734,-0.6726,-0.0655,-0.1764,m,1.0,1.0,1.0;
-0.8047,-0.3178,-0.1714,-0.7646,-0.3436,-0.2643,-0.7689,-0.4425,-0.2662,m,1.0,1.0,1.0;
-0.8116,-0.45,-0.1803,-0.8047,-0.3178,-0.1714,-0.7689,-0.4425,-0.2662,m,1.0,1.0,1.0;
-0.0516,0.7048,0.1811,-0.1233,0.6754,0.199,-0.0277,0.8185,0.1833,m,1.0,1.0,1.0;
0.2045,0.5605,-0.0616,0.3292,0.5761,-0.0656,0.2863,0.45,-0.1848,m,1.0,1.0,1.0;
-0.5984,-0.3215,-0.3664,-0.6019,-0.2075,-0.3679,-0.5288,-0.3201,-0.4192,m,1.0,1.0,1.0;
0.4723,0.5426,0.3124,0.3886,0.5842,0.293,0.455,0.4819,0.2873,m,1.0,1.0,1.0;
-0.5273,-0.5745,-0.305,-0.5666,-0.4595,-0.3508,-0.4875,-0.5409,-0.3812,m,1.0,1.0,1.0;
-0.6494,-0.2041,-0.2959,-0.6423,-0.0783,-0.2856,-0.5972,-0.0818,-0.3662,m,1.0,1.0,1.0;
-0.6019,-0.2075,-0.3679,-0.6494,-0.2041,-0.2959,-0.5972,-0.0818,-0.3662,m,1.0,1.0,1.0;
-0.3803,-0.3226,-0.5207,-0.3009,-0.3268,-0.5534,-0.2829,-0.4432,-0.5329,m,1.0,1.0,1.0;
-0.6903,-0.2063,-0.1777,-0.6494,-0.2041,-0.2959,-0.6937,-0.2849,-0.2168,m,1.0,1.0,1.0;
-0.5972,-0.0818,-0.3662,-0.6423,-0.0783,-0.2856,-0.5605,0.0703,-0.3195,m,1.0,1.0,1.0;
-0.6494,-0.2041,-0.2959,-0.6019,-0.2075,-0.3679,-0.5984,-0.3215,-0.3664,m,1.0,1.0,1.0;
-0.6894,-0.2037,-0.058,-0.677,-0.0721,-0.0508,-0.6903,-0.2063,-0.1777,m,1.0,1.0,1.0;
-0.6173,0.0216,0.0463,-0.5627,0.085,0.0743,-0.6001,0.104,-0.0265,m,1.0,1.0,1.0;
-0.6627,-0.5417,-0.2783,-0.7689,-0.4425,-0.2662,-0.6577,-0.4396,-0.3156,m,1.0,1.0,1.0;
-0.3758,-0.4142,-0.5017,-0.4164,-0.464,-0.4622,-0.3803,-0.3226,-0.5207,m,1.0,1.0,1.0;
0.3319,0.1128,-0.3737,0.3094,0.1857,-0.3537,0.4487,0.0695,-0.4037,m,1.0,1.0,1.0;
-0.6537,-0.3274,-0.2958,-0.5984,-0.3215,-0.3664,-0.5666,-0.4595,-0.3508,m,1.0,1.0,1.0;
-0.6423,-0.0783,-0.2856,-0.6118,0.0512,-0.2669,-0.5605,0.0703,-0.3195,m,1.0,1.0,1.0;
-0.6537,-0.3274,-0.2958,-0.6494,-0.2041,-0.2959,-0.5984,-0.3215,-0.3664,m,1.0,1.0,1.0;
-0.6577,-0.4396,-0.3156,-0.6537,-0.3274,-0.2958,-0.5666,-0.4595,-0.3508,m,1.0,1.0,1.0;
-0.1233,0.6754,0.199,-0.1227,0.7966,0.2775,-0.0277,0.8185,0.1833,m,1.0,1.0,1.0;
-0.3803,-0.3226,-0.5207,-0.4405,-0.3188,-0.4843,-0.4094,-0.2073,-0.5189,m,1.0,1.0,1.0;
0.4471,-0.0711,0.1688,0.5267,-0.0882,0.137,0.5655,0.0419,0.062,m,1.0,1.0,1.0;
-0.4213,-0.5722,0.1921,-0.4562,-0.5939,0.0794,-0.4048,-0.6479,0.0593,m,1.0,1.0,1.0;
-0.6019,-0.2075,-0.3679,-0.5368,-0.2045,-0.4315,-0.5288,-0.3201,-0.4192,m,1.0,1.0,1.0;
-0.5605,0.0703,-0.3195,-0.48,0.1061,-0.3685,-0.5024,0.0316,-0.3971,m,1.0,1.0,1.0;
0.6532,0.0576,-0.173,0.6523,0.0607,-0.0847,0.6526,-0.1013,-0.0697,m,1.0,1.0,1.0;
-0.0312,0.664,0.1127,0.0868,0.7039,0.0635,-0.0239,0.5977,0.0718,m,1.0,1.0,1.0;
-0.0277,0.8185,0.1833,-0.1227,0.7966,0.2775,-0.0825,0.819,0.2628,m,1.0,1.0,1.0;
-0.6937,-0.2849,-0.2168,-0.6494,-0.2041,-0.2959,-0.6537,-0.3274,-0.2958,m,1.0,1.0,1.0;
-0.4185,0.0629,-0.4169,-0.4187,0.1986,-0.3241,-0.2979,0.1584,-0.3881,m,1.0,1.0,1.0;
-0.6527,-0.2045,0.0579,-0.6894,-0.2037,-0.058,-0.7054,-0.2878,-0.0543,m,1.0,1.0,1.0;
-0.6655,-0.5889,-0.058,-0.5282,-0.6409,-0.0489,-0.6446,-0.5437,0.0355,m,1.0,1.0,1.0;
-0.3779,-0.0903,-0.5097,-0.2818,-0.0683,-0.5359,-0.3006,-0.1881,-0.5582,m,1.0,1.0,1.0;
0.6845,0.3414,-0.171,0.6793,0.4605,-0.1904,0.6681,0.324,-0.0706,m,1.0,1.0,1.0;
-0.48,0.1061,-0.3685,-0.4187,0.1986,-0.3241,-0.4185,0.0629,-0.4169,m,1.0,1.0,1.0;
-0.4875,-0.5409,-0.3812,-0.5162,-0.4312,-0.4076,-0.4142,-0.5768,-0.4248,m,1.0,1.0,1.0;
0.3245,0.3242,0.0485,0.2715,0.4033,-0.0259,0.2168,0.312,-0.057,m,1.0,1.0,1.0;
-0.5368,-0.2045,-0.4315,-0.4094,-0.2073,-0.5189,-0.4405,-0.3188,-0.4843,m,1.0,1.0,1.0;
0.0868,0.7039,0.0635,0.2101,0.6704,-0.0232,0.2045,0.5605,-0.0616,m,1.0,1.0,1.0;
-0.0239,0.5977,0.0718,-0.0549,0.6213,0.1455,-0.0516,0.7048,0.1811,m,1.0,1.0,1.0;
-0.4164,-0.464,-0.4622,-0.4405,-0.3188,-0.4843,-0.3803,-0.3226,-0.5207,m,1.0,1.0,1.0;
-0.5984,-0.3215,-0.3664,-0.5288,-0.3201,-0.4192,-0.5162,-0.4312,-0.4076,m,1.0,1.0,1.0;
-0.5666,-0.4595,-0.3508,-0.5984,-0.3215,-0.3664,-0.5162,-0.4312,-0.4076,m,1.0,1.0,1.0;
-0.5301,-0.0672,-0.4215,-0.4185,0.0629,-0.4169,-0.4154,-0.0519,-0.4776,m,1.0,1.0,1.0;
-0.5031,0.1797,-0.2862,-0.4187,0.1986,-0.3241,-0.5605,0.0703,-0.3195,m,1.0,1.0,1.0;
0.0648,0.5829,0.0619,0.2045,0.5605,-0.0616,0.0847,0.5707,-0.0098,m,1.0,1.0,1.0;
0.0648,0.5829,0.0619,0.0868,0.7039,0.0635,0.2045,0.5605,-0.0616,m,1.0,1.0,1.0;
-0.7504,-0.4493,0.0248,-0.7974,-0.4578,-0.0512,-0.7429,-0.536,-0.0581,m,1.0,1.0,1.0;
-0.6446,-0.5437,0.0355,-0.7504,-0.4493,0.0248,-0.7429,-0.536,-0.0581,m,1.0,1.0,1.0;
0.1496,0.6195,0.128,0.147,0.6799,0.1304,0.0656,0.6178,0.1434,m,1.0,1.0,1.0;
-0.5288,-0.3201,-0.4192,-0.5368,-0.2045,-0.4315,-0.4405,-0.3188,-0.4843,m,1.0,1.0,1.0;
0.4487,0.0695,-0.4037,0.325,0.039,-0.4114,0.3319,0.1128,-0.3737,m,1.0,1.0,1.0;
-0.0539,-0.6139,0.0585,0.0547,-0.6185,-0.0442,0.0691,-0.6161,0.0583,m,1.0,1.0,1.0;
0.6585,-0.0903,-0.179,0.6532,0.0576,-0.173,0.6526,-0.1013,-0.0697,m,1.0,1.0,1.0;
0.2045,0.5605,-0.0616,0.2399,0.4743,0.0223,0.1954,0.5544,0.0749,m,1.0,1.0,1.0;
0.5338,0.5722,0.1689,0.5415,0.6771,0.2988,0.5343,0.6171,0.2975,m,1.0,1.0,1.0;
0.1832,-0.0931,0.2259,0.1251,-0.182,0.2269,0.1825,-0.2086,0.1977,m,1.0,1.0,1.0;
0.451,0.5672,0.4262,0.3886,0.5842,0.293,0.4723,0.5426,0.3124,m,1.0,1.0,1.0;
0.3928,0.6236,0.3963,0.4687,0.6854,0.3133,0.3886,0.5842,0.293,m,1.0,1.0,1.0;
0.199,-0.4381,0.113,0.1928,-0.3001,0.1615,0.1167,-0.4288,0.115,m,1.0,1.0,1.0;
0.5679,0.4376,-0.427,0.6633,0.4275,-0.2903,0.6553,0.3784,-0.394,m,1.0,1.0,1.0;
0.3928,0.6236,0.3963,0.3886,0.5842,0.293,0.451,0.5672,0.4262,m,1.0,1.0,1.0;
0.6749,0.1861,-0.4121,0.6633,0.2831,-0.428,0.6821,0.3142,-0.2953,m,1.0,1.0,1.0;
-0.4904,-0.5241,0.1658,-0.5367,-0.5549,0.0618,-0.4562,-0.5939,0.0794,m,1.0,1.0,1.0;
0.6526,-0.1013,-0.0697,0.6523,0.0607,-0.0847,0.6242,0.0539,-0.0339,m,1.0,1.0,1.0;
0.5942,-0.0489,-0.3109,0.6143,-0.2023,-0.1863,0.576,-0.1855,-0.3065,m,1.0,1.0,1.0;
0.1007,-0.6448,-0.2922,0.198,-0.6484,-0.4169,0.1894,-0.6563,-0.2997,m,1.0,1.0,1.0;
0.6845,0.3414,-0.171,0.6681,0.324,-0.0706,0.6769,0.203,-0.0668,m,1.0,1.0,1.0;
-0.2882,0.0623,0.209,-0.1703,0.0614,0.2223,-0.1711,0.1662,0.16,m,1.0,1.0,1.0;
0.4497,0.4288,0.0758,0.466,0.4641,0.1803,0.3951,0.4993,0.1503,m,1.0,1.0,1.0;
0.7015,0.1907,-0.1799,0.6845,0.3414,-0.171,0.6769,0.203,-0.0668,m,1.0,1.0,1.0;
0.2054,0.3001,-0.1753,0.2168,0.312,-0.057,0.2635,0.393,-0.148,m,1.0,1.0,1.0;
-0.3921,-0.6415,0.1621,-0.4213,-0.5722,0.1921,-0.4048,-0.6479,0.0593,m,1.0,1.0,1.0;
0.5887,0.0717,-0.3102,0.6532,0.0576,-0.173,0.6259,0.0684,-0.2173,m,1.0,1.0,1.0;
0.5887,0.0717,-0.3102,0.6814,0.1882,-0.2984,0.6532,0.0576,-0.173,m,1.0,1.0,1.0;
-0.1233,0.6754,0.199,-0.0516,0.7048,0.1811,-0.0549,0.6213,0.1455,m,1.0,1.0,1.0;
0.6392,-0.0558,-0.0293,0.6526,-0.1013,-0.0697,0.6242,0.0539,-0.0339,m,1.0,1.0,1.0;
0.627,0.369,-0.0192,0.557,0.4427,0.0389,0.5739,0.2963,0.047,m,1.0,1.0,1.0;
-0.6115,-0.1189,0.1387,-0.6491,-0.0836,0.0557,-0.6527,-0.2045,0.0579,m,1.0,1.0,1.0;
-0.5474,-0.32,0.1835,-0.6482,-0.3248,0.0552,-0.658,-0.4467,0.0605,m,1.0,1.0,1.0;
-0.6482,-0.3248,0.0552,-0.5468,-0.2149,0.1921,-0.6527,-0.2045,0.0579,m,1.0,1.0,1.0;
0.6242,0.0539,-0.0339,0.6523,0.0607,-0.0847,0.6399,0.1352,-0.041,m,1.0,1.0,1.0;
-0.2824,-0.6087,0.2195,-0.4213,-0.5722,0.1921,-0.3921,-0.6415,0.1621,m,1.0,1.0,1.0;
0.7015,0.1907,-0.1799,0.6814,0.1882,-0.2984,0.6845,0.3414,-0.171,m,1.0,1.0,1.0;
-0.6491,-0.0836,0.0557,-0.5627,0.085,0.0743,-0.6173,0.0216,0.0463,m,1.0,1.0,1.0;
0.6814,0.1882,-0.2984,0.6821,0.3142,-0.2953,0.6845,0.3414,-0.171,m,1.0,1.0,1.0;
-0.4232,-0.6417,-0.3132,-0.5273,-0.5745,-0.305,-0.4142,-0.5768,-0.4248,m,1.0,1.0,1.0;
-0.677,-0.0721,-0.0508,-0.6346,0.0514,-0.0641,-0.6726,-0.0655,-0.1764,m,1.0,1.0,1.0;
0.6821,0.3142,-0.2953,0.6633,0.4275,-0.2903,0.6845,0.3414,-0.171,m,1.0,1.0,1.0;
0.388,0.5574,0.2079,0.4108,0.5939,0.1691,0.3951,0.4993,0.1503,m,1.0,1.0,1.0;
-0.5252,-0.4394,0.1759,-0.4481,-0.4841,0.2365,-0.4052,-0.4479,0.2728,m,1.0,1.0,1.0;
-0.6482,-0.3248,0.0552,-0.5474,-0.32,0.1835,-0.5468,-0.2149,0.1921,m,1.0,1.0,1.0;
0.466,0.4641,0.1803,0.388,0.5574,0.2079,0.3951,0.4993,0.1503,m,1.0,1.0,1.0;
0.6845,0.3414,-0.171,0.6633,0.4275,-0.2903,0.6793,0.4605,-0.1904,m,1.0,1.0,1.0;
0.451,0.5672,0.4262,0.4526,0.704,0.437,0.3928,0.6236,0.3963,m,1.0,1.0,1.0;
0.4723,0.5426,0.3124,0.4108,0.5939,0.1691,0.388,0.5574,0.2079,m,1.0,1.0,1.0;
0.6523,0.0607,-0.0847,0.6532,0.0576,-0.173,0.6769,0.203,-0.0668,m,1.0,1.0,1.0;
0.455,0.4819,0.2873,0.3886,0.5842,0.293,0.466,0.4641,0.1803,m,1.0,1.0,1.0;
0.6532,0.0576,-0.173,0.7015,0.1907,-0.1799,0.6769,0.203,-0.0668,m,1.0,1.0,1.0;
-0.5468,-0.2149,0.1921,-0.6095,-0.1828,0.1415,-0.6527,-0.2045,0.0579,m,1.0,1.0,1.0;
-0.6095,-0.1828,0.1415,-0.6115,-0.1189,0.1387,-0.6527,-0.2045,0.0579,m,1.0,1.0,1.0;
0.3886,0.5842,0.293,0.4723,0.5426,0.3124,0.388,0.5574,0.2079,m,1.0,1.0,1.0;
0.3886,0.5842,0.293,0.388,0.5574,0.2079,0.466,0.4641,0.1803,m,1.0,1.0,1.0;
-0.5252,-0.4394,0.1759,-0.5474,-0.32,0.1835,-0.5711,-0.4582,0.0948,m,1.0,1.0,1.0;
-0.2824,-0.6087,0.2195,-0.3921,-0.6415,0.1621,-0.286,-0.6534,0.1793,m,1.0,1.0,1.0;
0.6399,0.1352,-0.041,0.6523,0.0607,-0.0847,0.6769,0.203,-0.0668,m,1.0,1.0,1.0;
0.3364,-0.5298,-0.3058,0.3009,-0.4326,-0.294,0.3435,-0.5685,-0.2002,m,1.0,1.0,1.0;
-0.0513,-0.6168,-0.0599,0.0547,-0.6185,-0.0442,-0.0539,-0.6139,0.0585,m,1.0,1.0,1.0;
0.4721,0.653,0.1947,0.5415,0.6771,0.2988,0.5338,0.5722,0.1689,m,1.0,1.0,1.0;
-0.5252,-0.4394,0.1759,-0.5711,-0.4582,0.0948,-0.5367,-0.5549,0.0618,m,1.0,1.0,1.0;
0.1954,0.5544,0.0749,0.0847,0.5707,-0.0098,0.2045,0.5605,-0.0616,m,1.0,1.0,1.0;
0.4108,0.5939,0.1691,0.4587,0.5777,0.0688,0.4497,0.4288,0.0758,m,1.0,1.0,1.0;
0.3951,0.4993,0.1503,0.4108,0.5939,0.1691,0.4497,0.4288,0.0758,m,1.0,1.0,1.0;
0.0855,-0.657,0.2841,0.1878,-0.6424,0.2641,0.1539,-0.5808,0.264,m,1.0,1.0,1.0;
-0.4904,-0.5241,0.1658,-0.5252,-0.4394,0.1759,-0.5367,-0.5549,0.0618,m,1.0,1.0,1.0;
-0.5474,-0.32,0.1835,-0.658,-0.4467,0.0605,-0.5711,-0.4582,0.0948,m,1.0,1.0,1.0;
-0.6726,-0.0655,-0.1764,-0.6423,-0.0783,-0.2856,-0.6494,-0.2041,-0.2959,m,1.0,1.0,1.0;
-0.6903,-0.2063,-0.1777,-0.6726,-0.0655,-0.1764,-0.6494,-0.2041,-0.2959,m,1.0,1.0,1.0;
-0.6726,-0.0655,-0.1764,-0.6309,0.0521,-0.1734,-0.6423,-0.0783,-0.2856,m,1.0,1.0,1.0;
-0.6309,0.0521,-0.1734,-0.6118,0.0512,-0.2669,-0.6423,-0.0783,-0.2856,m,1.0,1.0,1.0;
0.2863,0.45,-0.1848,0.3435,0.4499,-0.3152,0.3325,0.3501,-0.3305,m,1.0,1.0,1.0;
0.4344,0.5996,0.5337,0.39,0.6742,0.5272,0.4526,0.704,0.437,m,1.0,1.0,1.0;
-0.4213,-0.5722,0.1921,-0.4904,-0.5241,0.1658,-0.4562,-0.5939,0.0794,m,1.0,1.0,1.0;
0.451,0.5672,0.4262,0.4344,0.5996,0.5337,0.4526,0.704,0.437,m,1.0,1.0,1.0;
0.39,0.6742,0.5272,0.427,0.7101,0.5664,0.4526,0.704,0.437,m,1.0,1.0,1.0;
0.2829,-0.6577,0.129,0.3255,-0.6632,0.0619,0.1996,-0.5698,0.1763,m,1.0,1.0,1.0;
0.4344,0.5996,0.5337,0.427,0.7101,0.5664,0.39,0.6742,0.5272,m,1.0,1.0,1.0;
0.4723,0.5426,0.3124,0.455,0.4819,0.2873,0.4754,0.499,0.3873,m,1.0,1.0,1.0;
0.2054,0.3001,-0.1753,0.2635,0.393,-0.148,0.2863,0.45,-0.1848,m,1.0,1.0,1.0;
0.444,0.5526,-0.0581,0.5317,0.5556,0.0593,0.5599,0.5398,-0.0652,m,1.0,1.0,1.0;
0.334,0.5457,-0.1688,0.4363,0.5383,-0.3087,0.3445,0.5258,-0.2845,m,1.0,1.0,1.0;
0.453,0.4483,-0.4137,0.3435,0.4499,-0.3152,0.4363,0.5383,-0.3087,m,1.0,1.0,1.0;
0.3292,0.5761,-0.0656,0.334,0.5457,-0.1688,0.2863,0.45,-0.1848,m,1.0,1.0,1.0;
0.4721,0.653,0.1947,0.4587,0.5777,0.0688,0.4108,0.5939,0.1691,m,1.0,1.0,1.0;
-0.8047,-0.3178,-0.1714,-0.6537,-0.3274,-0.2958,-0.7646,-0.3436,-0.2643,m,1.0,1.0,1.0;
-0.8047,-0.3178,-0.1714,-0.6937,-0.2849,-0.2168,-0.6537,-0.3274,-0.2958,m,1.0,1.0,1.0;
0.4723,0.5426,0.3124,0.4754,0.499,0.3873,0.451,0.5672,0.4262,m,1.0,1.0,1.0;
-0.8047,-0.3178,-0.1714,-0.6903,-0.2063,-0.1777,-0.6937,-0.2849,-0.2168,m,1.0,1.0,1.0;
-0.7054,-0.2878,-0.0543,-0.8047,-0.3178,-0.1714,-0.7842,-0.3136,-0.059,m,1.0,1.0,1.0;
0.5874,0.5439,-0.1773,0.6793,0.4605,-0.1904,0.5657,0.5288,-0.2993,m,1.0,1.0,1.0;
0.5657,0.5288,-0.2993,0.6793,0.4605,-0.1904,0.6633,0.4275,-0.2903,m,1.0,1.0,1.0;
-0.6894,-0.2037,-0.058,-0.6903,-0.2063,-0.1777,-0.8047,-0.3178,-0.1714,m,1.0,1.0,1.0;
-0.7054,-0.2878,-0.0543,-0.6894,-0.2037,-0.058,-0.8047,-0.3178,-0.1714,m,1.0,1.0,1.0;
0.3445,0.5258,-0.2845,0.4363,0.5383,-0.3087,0.3435,0.4499,-0.3152,m,1.0,1.0,1.0;
0.5635,-0.2014,0.0641,0.5058,-0.223,0.122,0.4514,-0.1988,0.1643,m,1.0,1.0,1.0;
0.211,0.2745,0.0328,0.2168,0.312,-0.057,0.0822,0.263,-0.0515,m,1.0,1.0,1.0;
0.2168,0.312,-0.057,0.2054,0.3001,-0.1753,0.0822,0.263,-0.0515,m,1.0,1.0,1.0;
0.334,0.5457,-0.1688,0.4422,0.5616,-0.1789,0.4363,0.5383,-0.3087,m,1.0,1.0,1.0;
0.2054,0.3001,-0.1753,0.0657,0.2607,-0.1463,0.0822,0.263,-0.0515,m,1.0,1.0,1.0;
0.211,0.2745,0.0328,0.0822,0.263,-0.0515,0.0759,0.2238,0.0636,m,1.0,1.0,1.0;
0.2054,0.3001,-0.1753,0.2863,0.45,-0.1848,0.3325,0.3501,-0.3305,m,1.0,1.0,1.0;
0.4526,0.704,0.437,0.534,0.7129,0.411,0.4687,0.6854,0.3133,m,1.0,1.0,1.0;
0.0657,0.2607,-0.1463,0.2054,0.3001,-0.1753,0.0688,0.2425,-0.2097,m,1.0,1.0,1.0;
0.4721,0.653,0.1947,0.4108,0.5939,0.1691,0.4723,0.5426,0.3124,m,1.0,1.0,1.0;
0.4687,0.6854,0.3133,0.4721,0.653,0.1947,0.4723,0.5426,0.3124,m,1.0,1.0,1.0;
0.064,0.7903,0.0788,0.2064,0.6944,0.055,0.0868,0.7039,0.0635,m,1.0,1.0,1.0;
0.5599,0.5398,-0.0652,0.5874,0.5439,-0.1773,0.4422,0.5616,-0.1789,m,1.0,1.0,1.0;
0.4526,0.704,0.437,0.5305,0.7765,0.4715,0.534,0.7129,0.411,m,1.0,1.0,1.0;
0.1589,0.2376,-0.2498,0.2491,0.293,-0.2696,0.2046,0.1719,-0.317,m,1.0,1.0,1.0;
0.4587,0.5777,0.0688,0.4721,0.653,0.1947,0.5338,0.5722,0.1689,m,1.0,1.0,1.0;
0.453,0.4483,-0.4137,0.5657,0.5288,-0.2993,0.5679,0.4376,-0.427,m,1.0,1.0,1.0;
0.4363,0.5383,-0.3087,0.5657,0.5288,-0.2993,0.453,0.4483,-0.4137,m,1.0,1.0,1.0;
-0.6004,0.1044,-0.2072,-0.5342,0.1857,-0.1881,-0.5605,0.0703,-0.3195,m,1.0,1.0,1.0;
-0.046,0.2222,0.0775,0.0822,0.263,-0.0515,-0.0564,0.2761,-0.0527,m,1.0,1.0,1.0;
-0.6309,0.0521,-0.1734,-0.5342,0.1857,-0.1881,-0.6004,0.1044,-0.2072,m,1.0,1.0,1.0;
0.2054,0.3001,-0.1753,0.2491,0.293,-0.2696,0.1589,0.2376,-0.2498,m,1.0,1.0,1.0;
0.5599,0.5398,-0.0652,0.6203,0.4603,-0.0586,0.5874,0.5439,-0.1773,m,1.0,1.0,1.0;
0.6203,0.4603,-0.0586,0.6793,0.4605,-0.1904,0.5874,0.5439,-0.1773,m,1.0,1.0,1.0;
-0.6346,0.0514,-0.0641,-0.5342,0.1849,-0.0574,-0.6309,0.0521,-0.1734,m,1.0,1.0,1.0;
-0.5342,0.1849,-0.0574,-0.5342,0.1857,-0.1881,-0.6309,0.0521,-0.1734,m,1.0,1.0,1.0;
0.4897,0.7785,0.4746,0.4526,0.704,0.437,0.4623,0.7892,0.5427,m,1.0,1.0,1.0;
-0.5342,0.1857,-0.1881,-0.5031,0.1797,-0.2862,-0.5605,0.0703,-0.3195,m,1.0,1.0,1.0;
0.0772,0.1799,-0.3062,0.1589,0.2376,-0.2498,0.2046,0.1719,-0.317,m,1.0,1.0,1.0;
0.0688,0.2425,-0.2097,0.1589,0.2376,-0.2498,0.0772,0.1799,-0.3062,m,1.0,1.0,1.0;
-0.6001,0.104,-0.0265,-0.5342,0.1849,-0.0574,-0.6346,0.0514,-0.0641,m,1.0,1.0,1.0;
0.4897,0.7785,0.4746,0.5305,0.7765,0.4715,0.4526,0.704,0.437,m,1.0,1.0,1.0;
0.4623,0.7892,0.5427,0.4526,0.704,0.437,0.427,0.7101,0.5664,m,1.0,1.0,1.0;
-0.5627,0.085,0.0743,-0.5342,0.1849,-0.0574,-0.6001,0.104,-0.0265,m,1.0,1.0,1.0;
0.5599,0.5398,-0.0652,0.4422,0.5616,-0.1789,0.444,0.5526,-0.0581,m,1.0,1.0,1.0;
0.4422,0.5616,-0.1789,0.5874,0.5439,-0.1773,0.5657,0.5288,-0.2993,m,1.0,1.0,1.0;
0.4143,-0.5854,-0.3045,0.3364,-0.5298,-0.3058,0.3435,-0.5685,-0.2002,m,1.0,1.0,1.0;
0.444,0.5526,-0.0581,0.4422,0.5616,-0.1789,0.334,0.5457,-0.1688,m,1.0,1.0,1.0;
-0.4044,0.2769,-0.1853,-0.5031,0.1797,-0.2862,-0.5342,0.1857,-0.1881,m,1.0,1.0,1.0;
-0.4044,0.2769,-0.1853,-0.4187,0.1986,-0.3241,-0.5031,0.1797,-0.2862,m,1.0,1.0,1.0;
-0.287,0.0589,-0.4355,-0.1702,-0.0597,-0.5426,-0.2818,-0.0683,-0.5359,m,1.0,1.0,1.0;
0.444,0.5526,-0.0581,0.334,0.5457,-0.1688,0.3292,0.5761,-0.0656,m,1.0,1.0,1.0;
0.4587,0.5777,0.0688,0.5317,0.5556,0.0593,0.444,0.5526,-0.0581,m,1.0,1.0,1.0;
-0.4021,0.2766,-0.0513,-0.4044,0.2769,-0.1853,-0.5342,0.1857,-0.1881,m,1.0,1.0,1.0;
-0.5342,0.1849,-0.0574,-0.4021,0.2766,-0.0513,-0.5342,0.1857,-0.1881,m,1.0,1.0,1.0;
0.4897,0.7785,0.4746,0.4623,0.7892,0.5427,0.5305,0.7765,0.4715,m,1.0,1.0,1.0;
-0.4044,0.2769,-0.1853,-0.3743,0.2708,-0.263,-0.4187,0.1986,-0.3241,m,1.0,1.0,1.0;
0.4128,-0.6036,-0.3962,0.3428,-0.5676,-0.4286,0.4143,-0.5854,-0.3045,m,1.0,1.0,1.0;
-0.4021,0.2766,-0.0513,-0.5342,0.1849,-0.0574,-0.5157,0.1691,0.0392,m,1.0,1.0,1.0;
-0.3743,0.2708,-0.263,-0.2896,0.225,-0.3463,-0.4187,0.1986,-0.3241,m,1.0,1.0,1.0;
-0.1703,0.059,-0.4407,-0.0387,-0.014,-0.4567,-0.1702,-0.0597,-0.5426,m,1.0,1.0,1.0;
-0.1702,-0.0597,-0.5426,-0.0387,-0.014,-0.4567,-0.0571,-0.0782,-0.5362,m,1.0,1.0,1.0;
-0.3743,0.2708,-0.263,-0.2882,0.2806,-0.279,-0.2896,0.225,-0.3463,m,1.0,1.0,1.0;
-0.5605,0.0703,-0.3195,-0.6118,0.0512,-0.2669,-0.6004,0.1044,-0.2072,m,1.0,1.0,1.0;
0.0248,-0.2013,-0.5105,0.0242,-0.1134,-0.5038,0.0829,-0.2017,-0.4349,m,1.0,1.0,1.0;
0.5305,0.7765,0.4715,0.4623,0.7892,0.5427,0.5303,0.757,0.5069,m,1.0,1.0,1.0;
0.2399,0.4743,0.0223,0.2045,0.5605,-0.0616,0.2431,0.4516,-0.0688,m,1.0,1.0,1.0;
-0.0159,-0.453,-0.4464,-0.0608,-0.3178,-0.5315,0.0038,-0.3436,-0.451,m,1.0,1.0,1.0;
0.3312,-0.3457,-0.342,0.201,-0.3256,-0.4077,0.2581,-0.3399,-0.374,m,1.0,1.0,1.0;
-0.5157,0.1691,0.0392,-0.4197,0.2151,0.0695,-0.4021,0.2766,-0.0513,m,1.0,1.0,1.0;
0.1496,0.6195,0.128,0.1954,0.5544,0.0749,0.2064,0.6944,0.055,m,1.0,1.0,1.0;
0.3266,-0.5671,0.0759,0.4341,-0.6564,0.0417,0.4268,-0.5917,0.0402,m,1.0,1.0,1.0;
-0.0571,-0.0782,-0.5362,0.0686,-0.0599,-0.4448,0.0242,-0.1134,-0.5038,m,1.0,1.0,1.0;
0.4587,0.5777,0.0688,0.5338,0.5722,0.1689,0.5317,0.5556,0.0593,m,1.0,1.0,1.0;
-0.0159,-0.453,-0.4464,-0.0685,-0.4256,-0.509,-0.0608,-0.3178,-0.5315,m,1.0,1.0,1.0;
0.0829,-0.2017,-0.4349,-0.0443,-0.2103,-0.5574,0.0248,-0.2013,-0.5105,m,1.0,1.0,1.0;
0.0248,-0.2013,-0.5105,-0.0443,-0.2103,-0.5574,-0.0571,-0.0782,-0.5362,m,1.0,1.0,1.0;
0.2064,0.6944,0.055,0.147,0.6799,0.1304,0.1496,0.6195,0.128,m,1.0,1.0,1.0;
0.0662,-0.4568,-0.399,-0.0159,-0.453,-0.4464,0.0631,-0.3193,-0.4102,m,1.0,1.0,1.0;
-0.0159,-0.453,-0.4464,0.0038,-0.3436,-0.451,0.0631,-0.3193,-0.4102,m,1.0,1.0,1.0;
0.4361,0.3302,-0.447,0.5498,0.3255,-0.5135,0.4765,0.3063,-0.5025,m,1.0,1.0,1.0;
0.25,-0.4363,-0.3627,0.201,-0.3256,-0.4077,0.3312,-0.3457,-0.342,m,1.0,1.0,1.0;
0.3009,-0.4326,-0.294,0.25,-0.4363,-0.3627,0.3312,-0.3457,-0.342,m,1.0,1.0,1.0;
0.4569,-0.0763,-0.422,0.5327,-0.0878,-0.3834,0.4531,-0.1967,-0.4071,m,1.0,1.0,1.0;
0.6185,0.3408,-0.4702,0.5498,0.3255,-0.5135,0.5679,0.4376,-0.427,m,1.0,1.0,1.0;
0.6031,0.1564,-0.4683,0.5506,0.2065,-0.514,0.6749,0.1861,-0.4121,m,1.0,1.0,1.0;
-0.0608,-0.3178,-0.5315,-0.0443,-0.2103,-0.5574,0.0829,-0.2017,-0.4349,m,1.0,1.0,1.0;
0.5506,0.2065,-0.514,0.6633,0.2831,-0.428,0.6749,0.1861,-0.4121,m,1.0,1.0,1.0;
-0.0571,-0.0782,-0.5362,-0.0387,-0.014,-0.4567,0.0686,-0.0599,-0.4448,m,1.0,1.0,1.0;
0.3009,-0.4326,-0.294,0.202,-0.4442,-0.3908,0.25,-0.4363,-0.3627,m,1.0,1.0,1.0;
0.4531,-0.1967,-0.4071,0.5327,-0.0878,-0.3834,0.576,-0.1855,-0.3065,m,1.0,1.0,1.0;
-0.5401,-0.0693,0.178,-0.407,0.0598,0.1861,-0.4327,-0.0714,0.2374,m,1.0,1.0,1.0;
0.0242,-0.1134,-0.5038,0.0686,-0.0599,-0.4448,0.0829,-0.2017,-0.4349,m,1.0,1.0,1.0;
0.1167,-0.4288,0.115,0.0774,-0.4367,0.1852,0.0923,-0.5534,0.1675,m,1.0,1.0,1.0;
0.5506,0.2065,-0.514,0.5498,0.3255,-0.5135,0.6185,0.3408,-0.4702,m,1.0,1.0,1.0;
0.6633,0.2831,-0.428,0.5506,0.2065,-0.514,0.6185,0.3408,-0.4702,m,1.0,1.0,1.0;
0.0248,-0.2013,-0.5105,-0.0571,-0.0782,-0.5362,0.0242,-0.1134,-0.5038,m,1.0,1.0,1.0;
0.0923,-0.5534,0.1675,0.199,-0.4381,0.113,0.1167,-0.4288,0.115,m,1.0,1.0,1.0;
0.4205,-0.6467,-0.1622,0.4495,-0.5814,-0.0668,0.446,-0.6597,-0.059,m,1.0,1.0,1.0;
0.4128,-0.6036,-0.3962,0.4143,-0.5854,-0.3045,0.4177,-0.6492,-0.2945,m,1.0,1.0,1.0;
0.6143,-0.2023,-0.1863,0.5942,-0.0489,-0.3109,0.6585,-0.0903,-0.179,m,1.0,1.0,1.0;
0.4132,-0.6477,-0.3879,0.4128,-0.6036,-0.3962,0.4177,-0.6492,-0.2945,m,1.0,1.0,1.0;
0.0038,-0.3436,-0.451,-0.0608,-0.3178,-0.5315,0.0829,-0.2017,-0.4349,m,1.0,1.0,1.0;
0.1496,0.6195,0.128,0.0656,0.6178,0.1434,0.0648,0.5829,0.0619,m,1.0,1.0,1.0;
-0.1703,0.059,-0.4407,-0.1702,-0.0597,-0.5426,-0.287,0.0589,-0.4355,m,1.0,1.0,1.0;
0.6185,0.3408,-0.4702,0.5679,0.4376,-0.427,0.6553,0.3784,-0.394,m,1.0,1.0,1.0;
0.4046,-0.5857,-0.1421,0.4495,-0.5814,-0.0668,0.4205,-0.6467,-0.1622,m,1.0,1.0,1.0;
0.5327,-0.0878,-0.3834,0.4569,-0.0763,-0.422,0.5942,-0.0489,-0.3109,m,1.0,1.0,1.0;
0.147,0.6799,0.1304,0.0685,0.7091,0.1656,0.0656,0.6178,0.1434,m,1.0,1.0,1.0;
0.6183,0.4899,-0.3277,0.5657,0.5288,-0.2993,0.6633,0.4275,-0.2903,m,1.0,1.0,1.0;
0.0631,-0.3193,-0.4102,0.0038,-0.3436,-0.451,0.0829,-0.2017,-0.4349,m,1.0,1.0,1.0;
0.4046,-0.5857,-0.1421,0.3641,-0.5286,-0.0629,0.4495,-0.5814,-0.0668,m,1.0,1.0,1.0;
0.25,-0.4363,-0.3627,0.202,-0.4442,-0.3908,0.201,-0.3256,-0.4077,m,1.0,1.0,1.0;
0.5942,-0.0489,-0.3109,0.4569,-0.0763,-0.422,0.5887,0.0717,-0.3102,m,1.0,1.0,1.0;
0.2045,0.5605,-0.0616,0.2982,0.6265,-0.0297,0.3292,0.5761,-0.0656,m,1.0,1.0,1.0;
0.4046,-0.5857,-0.1421,0.3435,-0.5685,-0.2002,0.3641,-0.5286,-0.0629,m,1.0,1.0,1.0;
0.0639,0.7854,0.1456,-0.0277,0.8185,0.1833,0.0685,0.7091,0.1656,m,1.0,1.0,1.0;
-0.0509,-0.6141,-0.2962,-0.0568,-0.5621,-0.4327,0.0477,-0.6174,-0.3229,m,1.0,1.0,1.0;
0.5679,0.4376,-0.427,0.6183,0.4899,-0.3277,0.6633,0.4275,-0.2903,m,1.0,1.0,1.0;
0.055,-0.0951,0.2909,0.0797,-0.2053,0.3125,0.1251,-0.182,0.2269,m,1.0,1.0,1.0;
0.3383,0.4639,0.0264,0.3245,0.3242,0.0485,0.4497,0.4288,0.0758,m,1.0,1.0,1.0;
0.3435,-0.5685,-0.2002,0.4046,-0.5857,-0.1421,0.4205,-0.6467,-0.1622,m,1.0,1.0,1.0;
0.3435,-0.5685,-0.2002,0.3363,-0.453,-0.0745,0.3641,-0.5286,-0.0629,m,1.0,1.0,1.0;
0.6185,0.3408,-0.4702,0.6553,0.3784,-0.394,0.6633,0.2831,-0.428,m,1.0,1.0,1.0;
0.576,-0.1855,-0.3065,0.5327,-0.0878,-0.3834,0.5942,-0.0489,-0.3109,m,1.0,1.0,1.0;
0.2982,0.6265,-0.0297,0.2045,0.5605,-0.0616,0.2101,0.6704,-0.0232,m,1.0,1.0,1.0;
0.3435,-0.5685,-0.2002,0.31,-0.4446,-0.1777,0.3363,-0.453,-0.0745,m,1.0,1.0,1.0;
-0.5252,-0.4394,0.1759,-0.4052,-0.4479,0.2728,-0.4481,-0.4841,0.2365,m,1.0,1.0,1.0;
0.427,0.7101,0.5664,0.5303,0.757,0.5069,0.4623,0.7892,0.5427,m,1.0,1.0,1.0;
0.4526,0.704,0.437,0.534,0.7129,0.411,0.427,0.7101,0.5664,m,1.0,1.0,1.0;
0.427,0.7101,0.5664,0.534,0.7129,0.411,0.5303,0.757,0.5069,m,1.0,1.0,1.0;
0.5303,0.757,0.5069,0.534,0.7129,0.411,0.5305,0.7765,0.4715,m,1.0,1.0,1.0;
0.4344,0.5996,0.5337,0.4526,0.704,0.437,0.427,0.7101,0.5664,m,1.0,1.0,1.0;
-0.0521,0.1591,0.1578,-0.052,0.0629,0.2178,0.064,0.1592,0.1471,m,1.0,1.0,1.0;
0.4344,0.5996,0.5337,0.451,0.5672,0.4262,0.4526,0.704,0.437,m,1.0,1.0,1.0;
0.1825,-0.2086,0.1977,0.1251,-0.182,0.2269,0.0981,-0.3354,0.1952,m,1.0,1.0,1.0;
0.451,0.5672,0.4262,0.534,0.7129,0.411,0.4526,0.704,0.437,m,1.0,1.0,1.0;
-0.1721,0.2808,0.0285,-0.2927,0.2805,0.0317,-0.1537,0.2327,0.0982,m,1.0,1.0,1.0;
0.4723,0.5426,0.3124,0.451,0.5672,0.4262,0.4754,0.499,0.3873,m,1.0,1.0,1.0;
0.451,0.5672,0.4262,0.4687,0.6854,0.3133,0.534,0.7129,0.411,m,1.0,1.0,1.0;
-0.2261,-0.6485,-0.1342,-0.2836,-0.654,-0.1799,-0.171,-0.6182,-0.1771,m,1.0,1.0,1.0;
0.4723,0.5426,0.3124,0.5343,0.6171,0.2975,0.451,0.5672,0.4262,m,1.0,1.0,1.0;
0.451,0.5672,0.4262,0.5343,0.6171,0.2975,0.4687,0.6854,0.3133,m,1.0,1.0,1.0;
0.5343,0.6171,0.2975,0.5415,0.6771,0.2988,0.534,0.7129,0.411,m,1.0,1.0,1.0;
0.4687,0.6854,0.3133,0.5343,0.6171,0.2975,0.534,0.7129,0.411,m,1.0,1.0,1.0;
0.0639,0.7854,0.1456,0.064,0.7903,0.0788,-0.0277,0.8185,0.1833,m,1.0,1.0,1.0;
-0.3003,-0.0216,0.2461,-0.2882,0.0623,0.209,-0.2831,-0.0669,0.3019,m,1.0,1.0,1.0;
0.1996,-0.5698,0.1763,0.1878,-0.6424,0.2641,0.1972,-0.6564,0.1913,m,1.0,1.0,1.0;
0.1996,-0.5698,0.1763,0.1539,-0.5808,0.264,0.1878,-0.6424,0.2641,m,1.0,1.0,1.0;
0.0774,-0.4367,0.1852,0.0981,-0.3354,0.1952,0.0608,-0.3257,0.2905,m,1.0,1.0,1.0;
0.0319,-0.4312,0.2827,0.0774,-0.4367,0.1852,0.0608,-0.3257,0.2905,m,1.0,1.0,1.0;
0.0981,-0.3354,0.1952,0.1251,-0.182,0.2269,0.0797,-0.2053,0.3125,m,1.0,1.0,1.0;
0.0608,-0.3257,0.2905,0.0981,-0.3354,0.1952,0.0797,-0.2053,0.3125,m,1.0,1.0,1.0;
0.0797,-0.2053,0.3125,0.1825,-0.2086,0.1977,0.1251,-0.182,0.2269,m,1.0,1.0,1.0;
-0.1721,0.2808,0.0285,-0.1537,0.2327,0.0982,-0.046,0.2222,0.0775,m,1.0,1.0,1.0;
0.466,0.4641,0.1803,0.5338,0.5722,0.1689,0.4723,0.5426,0.3124,m,1.0,1.0,1.0;
0.4723,0.5426,0.3124,0.5338,0.5722,0.1689,0.5343,0.6171,0.2975,m,1.0,1.0,1.0;
0.6633,0.2831,-0.428,0.6553,0.3784,-0.394,0.6633,0.4275,-0.2903,m,1.0,1.0,1.0;
-0.3053,-0.6444,0.065,-0.2404,-0.6241,-0.0095,-0.273,-0.616,0.0718,m,1.0,1.0,1.0;
0.0923,-0.5534,0.1675,0.1996,-0.5698,0.1763,0.199,-0.4381,0.113,m,1.0,1.0,1.0;
0.6821,0.3142,-0.2953,0.6633,0.2831,-0.428,0.6633,0.4275,-0.2903,m,1.0,1.0,1.0;
0.3363,-0.453,-0.0745,0.4495,-0.5814,-0.0668,0.3641,-0.5286,-0.0629,m,1.0,1.0,1.0;
0.1832,-0.0931,0.2259,0.188,0.0593,0.1987,0.0856,-0.0407,0.2368,m,1.0,1.0,1.0;
0.055,-0.0951,0.2909,0.1832,-0.0931,0.2259,0.0856,-0.0407,0.2368,m,1.0,1.0,1.0;
-0.1711,0.1662,0.16,-0.1703,0.0614,0.2223,-0.0521,0.1591,0.1578,m,1.0,1.0,1.0;
0.1996,-0.5698,0.1763,0.0923,-0.5534,0.1675,0.0774,-0.4367,0.1852,m,1.0,1.0,1.0;
0.5635,-0.2014,0.0641,0.5943,-0.0719,0.0556,0.5267,-0.0882,0.137,m,1.0,1.0,1.0;
0.4514,-0.1988,0.1643,0.5635,-0.2014,0.0641,0.5267,-0.0882,0.137,m,1.0,1.0,1.0;
0.5943,-0.0719,0.0556,0.5655,0.0419,0.062,0.5267,-0.0882,0.137,m,1.0,1.0,1.0;
0.5058,-0.223,0.122,0.5635,-0.2014,0.0641,0.4514,-0.1988,0.1643,m,1.0,1.0,1.0;
0.4497,0.4288,0.0758,0.557,0.4427,0.0389,0.5338,0.5722,0.1689,m,1.0,1.0,1.0;
0.466,0.4641,0.1803,0.4497,0.4288,0.0758,0.5338,0.5722,0.1689,m,1.0,1.0,1.0;
0.557,0.4427,0.0389,0.5317,0.5556,0.0593,0.5338,0.5722,0.1689,m,1.0,1.0,1.0;
0.2064,0.6944,0.055,0.0685,0.7091,0.1656,0.0868,0.7039,0.0635,m,1.0,1.0,1.0;
0.2064,0.6944,0.055,0.064,0.7903,0.0788,0.0685,0.7091,0.1656,m,1.0,1.0,1.0;
-0.3816,0.261,0.0266,-0.4197,0.2151,0.0695,-0.2833,0.2366,0.0997,m,1.0,1.0,1.0;
-0.2927,0.2805,0.0317,-0.3816,0.261,0.0266,-0.2833,0.2366,0.0997,m,1.0,1.0,1.0;
0.6532,0.0576,-0.173,0.5887,0.0717,-0.3102,0.6259,0.0684,-0.2173,m,1.0,1.0,1.0;
0.147,0.6799,0.1304,0.2064,0.6944,0.055,0.0685,0.7091,0.1656,m,1.0,1.0,1.0;
-0.0524,-0.6567,0.2591,0.0855,-0.657,0.2841,0.069,-0.574,0.2832,m,1.0,1.0,1.0;
0.1251,-0.182,0.2269,0.1832,-0.0931,0.2259,0.055,-0.0951,0.2909,m,1.0,1.0,1.0;
-0.4197,0.2151,0.0695,-0.3912,0.1563,0.1455,-0.3033,0.1824,0.153,m,1.0,1.0,1.0;
-0.2833,0.2366,0.0997,-0.4197,0.2151,0.0695,-0.3033,0.1824,0.153,m,1.0,1.0,1.0;
-0.4327,-0.0714,0.2374,-0.3986,-0.1007,0.2691,-0.407,0.0598,0.1861,m,1.0,1.0,1.0;
0.4687,0.6854,0.3133,0.4723,0.5426,0.3124,0.3886,0.5842,0.293,m,1.0,1.0,1.0;
0.4576,-0.3133,0.0655,0.5437,-0.2674,0.041,0.5635,-0.2014,0.0641,m,1.0,1.0,1.0;
0.5813,0.1797,0.0359,0.4937,0.1006,0.0943,0.5655,0.0419,0.062,m,1.0,1.0,1.0;
0.3025,0.5746,0.0282,0.2064,0.6944,0.055,0.1954,0.5544,0.0749,m,1.0,1.0,1.0;
-0.0367,-0.0207,0.2479,-0.0459,-0.0519,0.3074,-0.052,0.0629,0.2178,m,1.0,1.0,1.0;
0.0923,-0.5534,0.1675,0.0774,-0.4367,0.1852,0.069,-0.574,0.2832,m,1.0,1.0,1.0;
0.3641,-0.5286,-0.0629,0.3266,-0.5671,0.0759,0.4268,-0.5917,0.0402,m,1.0,1.0,1.0;
0.3641,-0.5286,-0.0629,0.3363,-0.453,-0.0745,0.3266,-0.5671,0.0759,m,1.0,1.0,1.0;
0.3363,-0.453,-0.0745,0.3203,-0.4334,0.0531,0.3266,-0.5671,0.0759,m,1.0,1.0,1.0;
0.5005,-0.3458,-0.0553,0.5579,-0.2922,-0.0686,0.5437,-0.2674,0.041,m,1.0,1.0,1.0;
0.4576,-0.3133,0.0655,0.5005,-0.3458,-0.0553,0.5437,-0.2674,0.041,m,1.0,1.0,1.0;
0.5579,-0.2922,-0.0686,0.6153,-0.1994,-0.0531,0.5635,-0.2014,0.0641,m,1.0,1.0,1.0;
0.5437,-0.2674,0.041,0.5579,-0.2922,-0.0686,0.5635,-0.2014,0.0641,m,1.0,1.0,1.0;
0.6153,-0.1994,-0.0531,0.6526,-0.1013,-0.0697,0.5943,-0.0719,0.0556,m,1.0,1.0,1.0;
0.5635,-0.2014,0.0641,0.6153,-0.1994,-0.0531,0.5943,-0.0719,0.0556,m,1.0,1.0,1.0;
0.6526,-0.1013,-0.0697,0.6392,-0.0558,-0.0293,0.5943,-0.0719,0.0556,m,1.0,1.0,1.0;
0.6392,-0.0558,-0.0293,0.6242,0.0539,-0.0339,0.5943,-0.0719,0.0556,m,1.0,1.0,1.0;
0.6242,0.0539,-0.0339,0.5655,0.0419,0.062,0.5943,-0.0719,0.0556,m,1.0,1.0,1.0;
0.6242,0.0539,-0.0339,0.5813,0.1797,0.0359,0.5655,0.0419,0.062,m,1.0,1.0,1.0;
0.6242,0.0539,-0.0339,0.6769,0.203,-0.0668,0.5813,0.1797,0.0359,m,1.0,1.0,1.0;
0.6769,0.203,-0.0668,0.6681,0.324,-0.0706,0.5813,0.1797,0.0359,m,1.0,1.0,1.0;
0.6681,0.324,-0.0706,0.5739,0.2963,0.047,0.5813,0.1797,0.0359,m,1.0,1.0,1.0;
0.6681,0.324,-0.0706,0.627,0.369,-0.0192,0.5739,0.2963,0.047,m,1.0,1.0,1.0;
0.627,0.369,-0.0192,0.6203,0.4603,-0.0586,0.557,0.4427,0.0389,m,1.0,1.0,1.0;
0.6203,0.4603,-0.0586,0.5599,0.5398,-0.0652,0.557,0.4427,0.0389,m,1.0,1.0,1.0;
0.5599,0.5398,-0.0652,0.5317,0.5556,0.0593,0.557,0.4427,0.0389,m,1.0,1.0,1.0;
0.3292,0.5761,-0.0656,0.2982,0.6265,-0.0297,0.3025,0.5746,0.0282,m,1.0,1.0,1.0;
0.2982,0.6265,-0.0297,0.2101,0.6704,-0.0232,0.2064,0.6944,0.055,m,1.0,1.0,1.0;
0.3025,0.5746,0.0282,0.2982,0.6265,-0.0297,0.2064,0.6944,0.055,m,1.0,1.0,1.0;
0.4143,-0.5854,-0.3045,0.3428,-0.5676,-0.4286,0.3364,-0.5298,-0.3058,m,1.0,1.0,1.0;
0.4495,-0.5814,-0.0668,0.3363,-0.453,-0.0745,0.3641,-0.5286,-0.0629,m,1.0,1.0,1.0;
0.1928,-0.3001,0.1615,0.0981,-0.3354,0.1952,0.0774,-0.4367,0.1852,m,1.0,1.0,1.0;
0.1167,-0.4288,0.115,0.1928,-0.3001,0.1615,0.0774,-0.4367,0.1852,m,1.0,1.0,1.0;
0.6242,0.0539,-0.0339,0.6399,0.1352,-0.041,0.6769,0.203,-0.0668,m,1.0,1.0,1.0;
0.6585,-0.0903,-0.179,0.5942,-0.0489,-0.3109,0.5887,0.0717,-0.3102,m,1.0,1.0,1.0;
0.3641,-0.5286,-0.0629,0.3363,-0.453,-0.0745,0.4495,-0.5814,-0.0668,m,1.0,1.0,1.0;
0.3245,0.3242,0.0485,0.3383,0.4639,0.0264,0.2715,0.4033,-0.0259,m,1.0,1.0,1.0;
-0.1703,0.0614,0.2223,-0.2831,-0.0669,0.3019,-0.1668,-0.0683,0.3289,m,1.0,1.0,1.0;
-0.5401,-0.0693,0.178,-0.6115,-0.1189,0.1387,-0.5468,-0.2149,0.1921,m,1.0,1.0,1.0;
-0.7449,-0.3627,0.0175,-0.7842,-0.3136,-0.059,-0.7504,-0.4493,0.0248,m,1.0,1.0,1.0;
0.4495,-0.5814,-0.0668,0.3641,-0.5286,-0.0629,0.4268,-0.5917,0.0402,m,1.0,1.0,1.0;
-0.0811,0.2607,0.0252,-0.1721,0.2808,0.0285,-0.046,0.2222,0.0775,m,1.0,1.0,1.0;
-0.1703,0.0614,0.2223,-0.2882,0.0623,0.209,-0.2831,-0.0669,0.3019,m,1.0,1.0,1.0;
-0.4197,0.2151,0.0695,-0.407,0.0598,0.1861,-0.3912,0.1563,0.1455,m,1.0,1.0,1.0;
-0.5881,-0.0414,0.1203,-0.6491,-0.0836,0.0557,-0.5401,-0.0693,0.178,m,1.0,1.0,1.0;
-0.6173,0.0216,0.0463,-0.5627,0.085,0.0743,-0.5401,-0.0693,0.178,m,1.0,1.0,1.0;
-0.5158,0.0518,0.1424,-0.5627,0.085,0.0743,-0.5401,-0.0693,0.178,m,1.0,1.0,1.0;
0.0415,-0.6484,-0.5093,0.0628,-0.5823,-0.514,0.0778,-0.6524,-0.433,m,1.0,1.0,1.0;
-0.5627,0.085,0.0743,-0.5158,0.0518,0.1424,-0.407,0.0598,0.1861,m,1.0,1.0,1.0;
-0.5627,0.085,0.0743,-0.6173,0.0216,0.0463,-0.5401,-0.0693,0.178,m,1.0,1.0,1.0;
0.069,-0.574,0.2832,0.1539,-0.5808,0.264,0.1996,-0.5698,0.1763,m,1.0,1.0,1.0;
-0.4021,0.2766,-0.0513,-0.4197,0.2151,0.0695,-0.3816,0.261,0.0266,m,1.0,1.0,1.0;
-0.2927,0.2805,0.0317,-0.2833,0.2366,0.0997,-0.1537,0.2327,0.0982,m,1.0,1.0,1.0;
-0.5627,0.085,0.0743,-0.4197,0.2151,0.0695,-0.5157,0.1691,0.0392,m,1.0,1.0,1.0;
0.0685,0.7091,0.1656,0.2064,0.6944,0.055,0.0868,0.7039,0.0635,m,1.0,1.0,1.0;
-0.407,0.0598,0.1861,-0.5158,0.0518,0.1424,-0.5401,-0.0693,0.178,m,1.0,1.0,1.0;
-0.2882,0.0623,0.209,-0.3003,-0.0216,0.2461,-0.2831,-0.0669,0.3019,m,1.0,1.0,1.0;
-0.2897,0.3086,-0.0579,-0.4021,0.2766,-0.0513,-0.2927,0.2805,0.0317,m,1.0,1.0,1.0;
-0.5627,0.085,0.0743,-0.5881,-0.0414,0.1203,-0.5401,-0.0693,0.178,m,1.0,1.0,1.0;
0.444,0.5526,-0.0581,0.4497,0.4288,0.0758,0.4587,0.5777,0.0688,m,1.0,1.0,1.0;
0.0822,0.263,-0.0515,-0.046,0.2222,0.0775,0.0759,0.2238,0.0636,m,1.0,1.0,1.0;
0.444,0.5526,-0.0581,0.3383,0.4639,0.0264,0.4497,0.4288,0.0758,m,1.0,1.0,1.0;
-0.4197,0.2151,0.0695,-0.5627,0.085,0.0743,-0.407,0.0598,0.1861,m,1.0,1.0,1.0;
0.3383,0.4639,0.0264,0.444,0.5526,-0.0581,0.3292,0.5761,-0.0656,m,1.0,1.0,1.0;
-0.1668,-0.0683,0.3289,-0.0855,-0.1207,0.3803,-0.0459,-0.0519,0.3074,m,1.0,1.0,1.0;
0.3025,0.5746,0.0282,0.3383,0.4639,0.0264,0.3292,0.5761,-0.0656,m,1.0,1.0,1.0;
0.0923,-0.5534,0.1675,0.1996,-0.5698,0.1763,0.0774,-0.4367,0.1852,m,1.0,1.0,1.0;
-0.0459,-0.0519,0.3074,-0.0367,-0.0207,0.2479,-0.052,0.0629,0.2178,m,1.0,1.0,1.0;
-0.0855,-0.1207,0.3803,-0.037,-0.1899,0.3843,-0.0459,-0.0519,0.3074,m,1.0,1.0,1.0;
-0.046,0.2222,0.0775,-0.1537,0.2327,0.0982,-0.0521,0.1591,0.1578,m,1.0,1.0,1.0;
0.3194,0.0635,0.1856,0.4346,0.0478,0.1486,0.4344,0.172,0.0987,m,1.0,1.0,1.0;
0.3222,0.1746,0.1337,0.3194,0.0635,0.1856,0.4344,0.172,0.0987,m,1.0,1.0,1.0;
0.064,0.1592,0.1471,-0.052,0.0629,0.2178,0.0601,0.0672,0.2075,m,1.0,1.0,1.0;
-0.0516,0.7048,0.1811,-0.0878,0.7401,0.2598,-0.1233,0.6754,0.199,m,1.0,1.0,1.0;
-0.3986,-0.1007,0.2691,-0.5401,-0.0693,0.178,-0.3919,-0.1952,0.2922,m,1.0,1.0,1.0;
-0.3912,0.1563,0.1455,-0.407,0.0598,0.1861,-0.3033,0.1824,0.153,m,1.0,1.0,1.0;
-0.3033,0.1824,0.153,-0.407,0.0598,0.1861,-0.2882,0.0623,0.209,m,1.0,1.0,1.0;
-0.1707,0.3021,-0.0595,-0.2927,0.2805,0.0317,-0.1721,0.2808,0.0285,m,1.0,1.0,1.0;
-0.046,0.2222,0.0775,-0.0521,0.1591,0.1578,0.064,0.1592,0.1471,m,1.0,1.0,1.0;
0.0759,0.2238,0.0636,-0.046,0.2222,0.0775,0.064,0.1592,0.1471,m,1.0,1.0,1.0;
-0.5401,-0.0693,0.178,-0.4791,-0.1748,0.2459,-0.3919,-0.1952,0.2922,m,1.0,1.0,1.0;
-0.0564,0.2761,-0.0527,-0.0811,0.2607,0.0252,-0.046,0.2222,0.0775,m,1.0,1.0,1.0;
-0.0568,-0.5673,0.2829,-0.1781,-0.5695,0.2733,-0.0524,-0.6567,0.2591,m,1.0,1.0,1.0;
-0.1703,0.0614,0.2223,-0.052,0.0629,0.2178,-0.0521,0.1591,0.1578,m,1.0,1.0,1.0;
-0.1537,0.2327,0.0982,-0.1711,0.1662,0.16,-0.0521,0.1591,0.1578,m,1.0,1.0,1.0;
0.0855,-0.657,0.2841,0.1539,-0.5808,0.264,0.069,-0.574,0.2832,m,1.0,1.0,1.0;
-0.3816,0.261,0.0266,-0.2927,0.2805,0.0317,-0.4021,0.2766,-0.0513,m,1.0,1.0,1.0;
-0.6491,-0.0836,0.0557,-0.6115,-0.1189,0.1387,-0.5401,-0.0693,0.178,m,1.0,1.0,1.0;
0.1796,0.1717,0.1458,0.3222,0.1746,0.1337,0.3222,0.2251,0.0946,m,1.0,1.0,1.0;
0.3222,0.1746,0.1337,0.1796,0.1717,0.1458,0.3222,0.2251,0.0946,m,1.0,1.0,1.0;
-0.1537,0.2327,0.0982,-0.2833,0.2366,0.0997,-0.1711,0.1662,0.16,m,1.0,1.0,1.0;
0.0923,-0.5534,0.1675,0.069,-0.574,0.2832,0.1996,-0.5698,0.1763,m,1.0,1.0,1.0;
0.211,0.2745,0.0328,0.1825,0.232,0.0958,0.3222,0.2251,0.0946,m,1.0,1.0,1.0;
0.3245,0.3242,0.0485,0.211,0.2745,0.0328,0.3222,0.2251,0.0946,m,1.0,1.0,1.0;
0.1796,0.1717,0.1458,0.188,0.0593,0.1987,0.3222,0.1746,0.1337,m,1.0,1.0,1.0;
0.188,0.0593,0.1987,0.3194,0.0635,0.1856,0.3222,0.1746,0.1337,m,1.0,1.0,1.0;
-0.1707,0.3021,-0.0595,-0.1721,0.2808,0.0285,-0.0811,0.2607,0.0252,m,1.0,1.0,1.0;
-0.0459,-0.0519,0.3074,0.055,-0.0951,0.2909,0.0601,0.0672,0.2075,m,1.0,1.0,1.0;
-0.7449,-0.3627,0.0175,-0.658,-0.4467,0.0605,-0.6482,-0.3248,0.0552,m,1.0,1.0,1.0;
-0.0564,0.2761,-0.0527,-0.1707,0.3021,-0.0595,-0.0811,0.2607,0.0252,m,1.0,1.0,1.0;
0.211,0.2745,0.0328,0.3245,0.3242,0.0485,0.2168,0.312,-0.057,m,1.0,1.0,1.0;
0.1796,0.1717,0.1458,0.3222,0.1746,0.1337,0.3222,0.2251,0.0946,m,1.0,1.0,1.0;
0.1825,0.232,0.0958,0.1796,0.1717,0.1458,0.3222,0.2251,0.0946,m,1.0,1.0,1.0;
-0.052,0.0629,0.2178,-0.0459,-0.0519,0.3074,0.0601,0.0672,0.2075,m,1.0,1.0,1.0;
0.0685,0.7091,0.1656,0.064,0.7903,0.0788,0.0639,0.7854,0.1456,m,1.0,1.0,1.0;
-0.7842,-0.3136,-0.059,-0.7974,-0.4578,-0.0512,-0.7504,-0.4493,0.0248,m,1.0,1.0,1.0;
-0.5342,0.1849,-0.0574,-0.5627,0.085,0.0743,-0.5157,0.1691,0.0392,m,1.0,1.0,1.0;
-0.1707,0.3021,-0.0595,-0.2897,0.3086,-0.0579,-0.2927,0.2805,0.0317,m,1.0,1.0,1.0;
-0.5401,-0.0693,0.178,-0.4327,-0.0714,0.2374,-0.407,0.0598,0.1861,m,1.0,1.0,1.0;
0.4687,0.6854,0.3133,0.534,0.7129,0.411,0.5415,0.6771,0.2988,m,1.0,1.0,1.0;
0.3266,-0.5671,0.0759,0.3255,-0.6632,0.0619,0.4341,-0.6564,0.0417,m,1.0,1.0,1.0;
-0.2833,0.2366,0.0997,-0.3033,0.1824,0.153,-0.1711,0.1662,0.16,m,1.0,1.0,1.0;
-0.407,0.0598,0.1861,-0.3986,-0.1007,0.2691,-0.2831,-0.0669,0.3019,m,1.0,1.0,1.0;
-0.2882,0.0623,0.209,-0.407,0.0598,0.1861,-0.2831,-0.0669,0.3019,m,1.0,1.0,1.0;
-0.1703,0.0614,0.2223,-0.1668,-0.0683,0.3289,-0.052,0.0629,0.2178,m,1.0,1.0,1.0;
-0.7449,-0.3627,0.0175,-0.6482,-0.3248,0.0552,-0.7054,-0.2878,-0.0543,m,1.0,1.0,1.0;
-0.7842,-0.3136,-0.059,-0.7449,-0.3627,0.0175,-0.7054,-0.2878,-0.0543,m,1.0,1.0,1.0;
-0.7504,-0.4493,0.0248,-0.658,-0.4467,0.0605,-0.7449,-0.3627,0.0175,m,1.0,1.0,1.0;
0.1224,-0.6494,-0.1783,0.1007,-0.6448,-0.2922,0.1894,-0.6563,-0.2997,m,1.0,1.0,1.0;
-0.1668,-0.0683,0.3289,-0.0459,-0.0519,0.3074,-0.052,0.0629,0.2178,m,1.0,1.0,1.0;
0.0759,0.2238,0.0636,0.1825,0.232,0.0958,0.211,0.2745,0.0328,m,1.0,1.0,1.0;
0.1825,0.232,0.0958,0.0759,0.2238,0.0636,0.1796,0.1717,0.1458,m,1.0,1.0,1.0;
0.0759,0.2238,0.0636,0.064,0.1592,0.1471,0.1796,0.1717,0.1458,m,1.0,1.0,1.0;
0.0601,0.0672,0.2075,0.188,0.0593,0.1987,0.1796,0.1717,0.1458,m,1.0,1.0,1.0;
0.064,0.1592,0.1471,0.0601,0.0672,0.2075,0.1796,0.1717,0.1458,m,1.0,1.0,1.0;
0.019,-0.185,0.3711,0.055,-0.0951,0.2909,-0.0459,-0.0519,0.3074,m,1.0,1.0,1.0;
0.3397,-0.3484,0.0958,0.3259,-0.277,0.1612,0.1928,-0.3001,0.1615,m,1.0,1.0,1.0;
0.0797,-0.2053,0.3125,0.1251,-0.182,0.2269,0.1825,-0.2086,0.1977,m,1.0,1.0,1.0;
-0.6446,-0.5437,0.0355,-0.5367,-0.5549,0.0618,-0.658,-0.4467,0.0605,m,1.0,1.0,1.0;
-0.5367,-0.5549,0.0618,-0.5711,-0.4582,0.0948,-0.658,-0.4467,0.0605,m,1.0,1.0,1.0;
0.1825,-0.2086,0.1977,0.3153,-0.1915,0.2017,0.1832,-0.0931,0.2259,m,1.0,1.0,1.0;
0.3025,0.5746,0.0282,0.1954,0.5544,0.0749,0.2399,0.4743,0.0223,m,1.0,1.0,1.0;
0.4079,-0.2873,0.1385,0.3259,-0.277,0.1612,0.3397,-0.3484,0.0958,m,1.0,1.0,1.0;
0.4576,-0.3133,0.0655,0.4079,-0.2873,0.1385,0.3397,-0.3484,0.0958,m,1.0,1.0,1.0;
0.064,0.7903,0.0788,0.0033,0.8124,0.1129,-0.0277,0.8185,0.1833,m,1.0,1.0,1.0;
0.4079,-0.2873,0.1385,0.4514,-0.1988,0.1643,0.3259,-0.277,0.1612,m,1.0,1.0,1.0;
0.4576,-0.3133,0.0655,0.3397,-0.3484,0.0958,0.3203,-0.4334,0.0531,m,1.0,1.0,1.0;
0.3237,-0.0802,0.2118,0.3194,0.0635,0.1856,0.188,0.0593,0.1987,m,1.0,1.0,1.0;
0.4937,0.1006,0.0943,0.5813,0.1797,0.0359,0.4344,0.172,0.0987,m,1.0,1.0,1.0;
0.1928,-0.3001,0.1615,0.3153,-0.1915,0.2017,0.1825,-0.2086,0.1977,m,1.0,1.0,1.0;
-0.3986,-0.1007,0.2691,-0.4327,-0.0714,0.2374,-0.5401,-0.0693,0.178,m,1.0,1.0,1.0;
-0.5401,-0.0693,0.178,-0.5468,-0.2149,0.1921,-0.4791,-0.1748,0.2459,m,1.0,1.0,1.0;
-0.6446,-0.5437,0.0355,-0.7429,-0.536,-0.0581,-0.6655,-0.5889,-0.058,m,1.0,1.0,1.0;
-0.4048,-0.6479,0.0593,-0.4562,-0.5939,0.0794,-0.5367,-0.5549,0.0618,m,1.0,1.0,1.0;
-0.4213,-0.5722,0.1921,-0.4481,-0.4841,0.2365,-0.5252,-0.4394,0.1759,m,1.0,1.0,1.0;
-0.4904,-0.5241,0.1658,-0.4213,-0.5722,0.1921,-0.5252,-0.4394,0.1759,m,1.0,1.0,1.0;
-0.4481,-0.4841,0.2365,-0.4052,-0.4479,0.2728,-0.5252,-0.4394,0.1759,m,1.0,1.0,1.0;
-0.3919,-0.1952,0.2922,-0.5468,-0.2149,0.1921,-0.5474,-0.32,0.1835,m,1.0,1.0,1.0;
-0.4057,-0.3207,0.2894,-0.3919,-0.1952,0.2922,-0.5474,-0.32,0.1835,m,1.0,1.0,1.0;
-0.5468,-0.2149,0.1921,-0.3919,-0.1952,0.2922,-0.4791,-0.1748,0.2459,m,1.0,1.0,1.0;
0.1868,-0.5797,0.1,0.199,-0.4381,0.113,0.1996,-0.5698,0.1763,m,1.0,1.0,1.0;
0.4471,-0.0711,0.1688,0.5267,-0.0882,0.137,0.4346,0.0478,0.1486,m,1.0,1.0,1.0;
0.4576,-0.3133,0.0655,0.4514,-0.1988,0.1643,0.4079,-0.2873,0.1385,m,1.0,1.0,1.0;
0.5739,0.2963,0.047,0.4449,0.2839,0.0863,0.4344,0.172,0.0987,m,1.0,1.0,1.0;
0.5267,-0.0882,0.137,0.4471,-0.0711,0.1688,0.4346,0.0478,0.1486,m,1.0,1.0,1.0;
-0.4213,-0.5722,0.1921,-0.4052,-0.4479,0.2728,-0.4481,-0.4841,0.2365,m,1.0,1.0,1.0;
0.4346,0.0478,0.1486,0.5655,0.0419,0.062,0.4937,0.1006,0.0943,m,1.0,1.0,1.0;
0.4341,-0.6564,0.0417,0.4495,-0.5814,-0.0668,0.4268,-0.5917,0.0402,m,1.0,1.0,1.0;
-0.4213,-0.5722,0.1921,-0.4481,-0.4841,0.2365,-0.4052,-0.4479,0.2728,m,1.0,1.0,1.0;
-0.4213,-0.5722,0.1921,-0.3733,-0.5265,0.2515,-0.4481,-0.4841,0.2365,m,1.0,1.0,1.0;
-0.4481,-0.4841,0.2365,-0.3733,-0.5265,0.2515,-0.4052,-0.4479,0.2728,m,1.0,1.0,1.0;
0.3383,0.4639,0.0264,0.3025,0.5746,0.0282,0.2399,0.4743,0.0223,m,1.0,1.0,1.0;
0.5813,0.1797,0.0359,0.5739,0.2963,0.047,0.4344,0.172,0.0987,m,1.0,1.0,1.0;
-0.407,0.0598,0.1861,-0.5401,-0.0693,0.178,-0.4327,-0.0714,0.2374,m,1.0,1.0,1.0;
-0.6115,-0.1189,0.1387,-0.6095,-0.1828,0.1415,-0.5468,-0.2149,0.1921,m,1.0,1.0,1.0;
0.3222,0.2251,0.0946,0.3222,0.1746,0.1337,0.4344,0.172,0.0987,m,1.0,1.0,1.0;
-0.0228,-0.3272,0.3655,0.0319,-0.4312,0.2827,0.0608,-0.3257,0.2905,m,1.0,1.0,1.0;
-0.2824,-0.6087,0.2195,-0.2925,-0.5404,0.2638,-0.3733,-0.5265,0.2515,m,1.0,1.0,1.0;
-0.4213,-0.5722,0.1921,-0.2824,-0.6087,0.2195,-0.3733,-0.5265,0.2515,m,1.0,1.0,1.0;
-0.3733,-0.5265,0.2515,-0.2925,-0.5404,0.2638,-0.4052,-0.4479,0.2728,m,1.0,1.0,1.0;
-0.2925,-0.5404,0.2638,-0.2904,-0.4449,0.3043,-0.4052,-0.4479,0.2728,m,1.0,1.0,1.0;
-0.2904,-0.4449,0.3043,-0.2866,-0.3238,0.3292,-0.4057,-0.3207,0.2894,m,1.0,1.0,1.0;
-0.4052,-0.4479,0.2728,-0.2904,-0.4449,0.3043,-0.4057,-0.3207,0.2894,m,1.0,1.0,1.0;
-0.2869,-0.2095,0.3392,-0.3919,-0.1952,0.2922,-0.4057,-0.3207,0.2894,m,1.0,1.0,1.0;
-0.2866,-0.3238,0.3292,-0.2869,-0.2095,0.3392,-0.4057,-0.3207,0.2894,m,1.0,1.0,1.0;
-0.2869,-0.2095,0.3392,-0.2831,-0.0669,0.3019,-0.3919,-0.1952,0.2922,m,1.0,1.0,1.0;
-0.2831,-0.0669,0.3019,-0.3986,-0.1007,0.2691,-0.3919,-0.1952,0.2922,m,1.0,1.0,1.0;
0.3397,-0.3484,0.0958,0.1928,-0.3001,0.1615,0.199,-0.4381,0.113,m,1.0,1.0,1.0;
0.3203,-0.4334,0.0531,0.3397,-0.3484,0.0958,0.199,-0.4381,0.113,m,1.0,1.0,1.0;
0.4471,-0.0711,0.1688,0.5655,0.0419,0.062,0.4346,0.0478,0.1486,m,1.0,1.0,1.0;
0.4346,0.0478,0.1486,0.4937,0.1006,0.0943,0.4344,0.172,0.0987,m,1.0,1.0,1.0;
0.5267,-0.0882,0.137,0.4471,-0.0711,0.1688,0.4514,-0.1988,0.1643,m,1.0,1.0,1.0;
0.4449,0.2839,0.0863,0.4497,0.4288,0.0758,0.3245,0.3242,0.0485,m,1.0,1.0,1.0;
-0.0471,0.0833,-0.4151,-0.0387,-0.014,-0.4567,-0.1703,0.059,-0.4407,m,1.0,1.0,1.0;
-0.0513,-0.6168,-0.0599,0.0319,-0.6224,-0.177,0.0547,-0.6185,-0.0442,m,1.0,1.0,1.0;
0.3203,-0.4334,0.0531,0.199,-0.4381,0.113,0.1868,-0.5797,0.1,m,1.0,1.0,1.0;
0.1928,-0.3001,0.1615,0.3259,-0.277,0.1612,0.3153,-0.1915,0.2017,m,1.0,1.0,1.0;
0.4449,0.2839,0.0863,0.3245,0.3242,0.0485,0.3222,0.2251,0.0946,m,1.0,1.0,1.0;
-0.161,-0.6536,0.2022,-0.1781,-0.5695,0.2733,-0.2824,-0.6087,0.2195,m,1.0,1.0,1.0;
-0.286,-0.6534,0.1793,-0.161,-0.6536,0.2022,-0.2824,-0.6087,0.2195,m,1.0,1.0,1.0;
-0.1781,-0.5695,0.2733,-0.2925,-0.5404,0.2638,-0.2824,-0.6087,0.2195,m,1.0,1.0,1.0;
-0.2925,-0.5404,0.2638,-0.1781,-0.5695,0.2733,-0.2904,-0.4449,0.3043,m,1.0,1.0,1.0;
-0.1781,-0.5695,0.2733,-0.1687,-0.4536,0.3263,-0.2904,-0.4449,0.3043,m,1.0,1.0,1.0;
-0.1687,-0.4536,0.3263,-0.1615,-0.3203,0.3594,-0.2866,-0.3238,0.3292,m,1.0,1.0,1.0;
-0.2904,-0.4449,0.3043,-0.1687,-0.4536,0.3263,-0.2866,-0.3238,0.3292,m,1.0,1.0,1.0;
-0.1615,-0.3203,0.3594,-0.1962,-0.1955,0.3672,-0.2869,-0.2095,0.3392,m,1.0,1.0,1.0;
-0.2866,-0.3238,0.3292,-0.1615,-0.3203,0.3594,-0.2869,-0.2095,0.3392,m,1.0,1.0,1.0;
-0.1668,-0.0683,0.3289,-0.2831,-0.0669,0.3019,-0.2869,-0.2095,0.3392,m,1.0,1.0,1.0;
-0.1962,-0.1955,0.3672,-0.1668,-0.0683,0.3289,-0.2869,-0.2095,0.3392,m,1.0,1.0,1.0;
-0.3033,0.1824,0.153,-0.2882,0.0623,0.209,-0.1711,0.1662,0.16,m,1.0,1.0,1.0;
0.4344,0.172,0.0987,0.4449,0.2839,0.0863,0.3222,0.2251,0.0946,m,1.0,1.0,1.0;
0.4341,-0.6564,0.0417,0.4268,-0.5917,0.0402,0.3266,-0.5671,0.0759,m,1.0,1.0,1.0;
0.4487,0.0695,-0.4037,0.5887,0.0717,-0.3102,0.4569,-0.0763,-0.422,m,1.0,1.0,1.0;
-0.1615,-0.3203,0.3594,-0.1346,-0.2059,0.3799,-0.1962,-0.1955,0.3672,m,1.0,1.0,1.0;
-0.1346,-0.2059,0.3799,-0.1668,-0.0683,0.3289,-0.1962,-0.1955,0.3672,m,1.0,1.0,1.0;
0.4346,0.0478,0.1486,0.3194,0.0635,0.1856,0.3237,-0.0802,0.2118,m,1.0,1.0,1.0;
0.4471,-0.0711,0.1688,0.4346,0.0478,0.1486,0.3237,-0.0802,0.2118,m,1.0,1.0,1.0;
0.5887,0.0717,-0.3102,0.6532,0.0576,-0.173,0.6585,-0.0903,-0.179,m,1.0,1.0,1.0;
-0.037,-0.1899,0.3843,-0.0855,-0.1207,0.3803,-0.1668,-0.0683,0.3289,m,1.0,1.0,1.0;
-0.1346,-0.2059,0.3799,-0.037,-0.1899,0.3843,-0.1668,-0.0683,0.3289,m,1.0,1.0,1.0;
-0.0825,0.819,0.2628,-0.1227,0.7966,0.2775,-0.1333,0.7322,0.2649,m,1.0,1.0,1.0;
-0.0878,0.7401,0.2598,-0.0825,0.819,0.2628,-0.1333,0.7322,0.2649,m,1.0,1.0,1.0;
-0.0568,-0.5673,0.2829,-0.0393,-0.4533,0.3186,-0.1687,-0.4536,0.3263,m,1.0,1.0,1.0;
-0.1781,-0.5695,0.2733,-0.0568,-0.5673,0.2829,-0.1687,-0.4536,0.3263,m,1.0,1.0,1.0;
-0.1687,-0.4536,0.3263,-0.0393,-0.4533,0.3186,-0.1615,-0.3203,0.3594,m,1.0,1.0,1.0;
-0.0393,-0.4533,0.3186,-0.0228,-0.3272,0.3655,-0.1615,-0.3203,0.3594,m,1.0,1.0,1.0;
-0.0228,-0.3272,0.3655,-0.0543,-0.2945,0.3823,-0.1615,-0.3203,0.3594,m,1.0,1.0,1.0;
-0.0543,-0.2945,0.3823,-0.037,-0.1899,0.3843,-0.1346,-0.2059,0.3799,m,1.0,1.0,1.0;
-0.1615,-0.3203,0.3594,-0.0543,-0.2945,0.3823,-0.1346,-0.2059,0.3799,m,1.0,1.0,1.0;
0.4514,-0.1988,0.1643,0.3237,-0.0802,0.2118,0.3153,-0.1915,0.2017,m,1.0,1.0,1.0;
0.3153,-0.1915,0.2017,0.3237,-0.0802,0.2118,0.1832,-0.0931,0.2259,m,1.0,1.0,1.0;
0.4514,-0.1988,0.1643,0.4471,-0.0711,0.1688,0.3237,-0.0802,0.2118,m,1.0,1.0,1.0;
0.3266,-0.5671,0.0759,0.4268,-0.5917,0.0402,0.4341,-0.6564,0.0417,m,1.0,1.0,1.0;
0.446,-0.6597,-0.059,0.4495,-0.5814,-0.0668,0.4341,-0.6564,0.0417,m,1.0,1.0,1.0;
0.4514,-0.1988,0.1643,0.3153,-0.1915,0.2017,0.3259,-0.277,0.1612,m,1.0,1.0,1.0;
0.0778,-0.6524,-0.433,0.198,-0.6484,-0.4169,0.1007,-0.6448,-0.2922,m,1.0,1.0,1.0;
-0.0277,0.8185,0.1833,-0.0825,0.819,0.2628,-0.0878,0.7401,0.2598,m,1.0,1.0,1.0;
-0.0516,0.7048,0.1811,-0.0277,0.8185,0.1833,-0.0878,0.7401,0.2598,m,1.0,1.0,1.0;
0.1832,-0.0931,0.2259,0.3237,-0.0802,0.2118,0.188,0.0593,0.1987,m,1.0,1.0,1.0;
-0.161,-0.6536,0.2022,-0.0494,-0.6474,0.1954,-0.0524,-0.6567,0.2591,m,1.0,1.0,1.0;
0.1868,-0.5797,0.1,0.1996,-0.5698,0.1763,0.3266,-0.5671,0.0759,m,1.0,1.0,1.0;
0.4177,-0.6492,-0.2945,0.4143,-0.5854,-0.3045,0.3435,-0.5685,-0.2002,m,1.0,1.0,1.0;
0.5635,-0.2014,0.0641,0.4514,-0.1988,0.1643,0.4576,-0.3133,0.0655,m,1.0,1.0,1.0;
0.4177,-0.6492,-0.2945,0.3435,-0.5685,-0.2002,0.4205,-0.6467,-0.1622,m,1.0,1.0,1.0;
-0.0524,-0.6567,0.2591,0.069,-0.574,0.2832,-0.0568,-0.5673,0.2829,m,1.0,1.0,1.0;
0.0319,-0.4312,0.2827,-0.0393,-0.4533,0.3186,-0.0568,-0.5673,0.2829,m,1.0,1.0,1.0;
0.0319,-0.4312,0.2827,-0.0228,-0.3272,0.3655,-0.0393,-0.4533,0.3186,m,1.0,1.0,1.0;
0.0608,-0.3257,0.2905,-0.0228,-0.3272,0.3655,-0.0393,-0.4533,0.3186,m,1.0,1.0,1.0;
-0.0228,-0.3272,0.3655,0.0608,-0.3257,0.2905,-0.0393,-0.4533,0.3186,m,1.0,1.0,1.0;
0.019,-0.185,0.3711,-0.037,-0.1899,0.3843,-0.0543,-0.2945,0.3823,m,1.0,1.0,1.0;
-0.0228,-0.3272,0.3655,0.019,-0.185,0.3711,-0.0543,-0.2945,0.3823,m,1.0,1.0,1.0;
0.0685,0.7091,0.1656,-0.0516,0.7048,0.1811,-0.0549,0.6213,0.1455,m,1.0,1.0,1.0;
-0.0516,0.7048,0.1811,0.0685,0.7091,0.1656,-0.0277,0.8185,0.1833,m,1.0,1.0,1.0;
-0.0459,-0.0519,0.3074,-0.037,-0.1899,0.3843,0.019,-0.185,0.3711,m,1.0,1.0,1.0;
-0.6655,-0.5889,-0.058,-0.7429,-0.536,-0.0581,-0.6669,-0.588,-0.1772,m,1.0,1.0,1.0;
-0.0549,0.6213,0.1455,0.0656,0.6178,0.1434,0.0685,0.7091,0.1656,m,1.0,1.0,1.0;
0.069,-0.574,0.2832,0.0319,-0.4312,0.2827,-0.0568,-0.5673,0.2829,m,1.0,1.0,1.0;
-0.4052,-0.4479,0.2728,-0.5474,-0.32,0.1835,-0.5252,-0.4394,0.1759,m,1.0,1.0,1.0;
0.0797,-0.2053,0.3125,0.019,-0.185,0.3711,-0.0228,-0.3272,0.3655,m,1.0,1.0,1.0;
0.0608,-0.3257,0.2905,0.0797,-0.2053,0.3125,-0.0228,-0.3272,0.3655,m,1.0,1.0,1.0;
0.0797,-0.2053,0.3125,-0.037,-0.1899,0.3843,0.019,-0.185,0.3711,m,1.0,1.0,1.0;
-0.037,-0.1899,0.3843,0.0797,-0.2053,0.3125,0.019,-0.185,0.3711,m,1.0,1.0,1.0;
0.0797,-0.2053,0.3125,0.055,-0.0951,0.2909,0.019,-0.185,0.3711,m,1.0,1.0,1.0;
-0.0527,-0.5761,-0.5168,0.0628,-0.5823,-0.514,0.0415,-0.6484,-0.5093,m,1.0,1.0,1.0;
-0.2414,-0.6234,-0.2234,-0.171,-0.6182,-0.1771,-0.2836,-0.654,-0.1799,m,1.0,1.0,1.0;
0.5887,0.0717,-0.3102,0.4487,0.0695,-0.4037,0.5542,0.1013,-0.4179,m,1.0,1.0,1.0;
-0.4142,-0.5768,-0.4248,-0.294,-0.563,-0.4683,-0.2883,-0.6489,-0.4209,m,1.0,1.0,1.0;
-0.3824,-0.6439,-0.4127,-0.4142,-0.5768,-0.4248,-0.2883,-0.6489,-0.4209,m,1.0,1.0,1.0;
-0.4192,-0.6489,-0.05,-0.5166,-0.6416,-0.1875,-0.4232,-0.6482,-0.1966,m,1.0,1.0,1.0;
-0.2414,-0.6234,-0.2234,-0.285,-0.6144,-0.2966,-0.171,-0.6182,-0.1771,m,1.0,1.0,1.0;
-0.285,-0.6144,-0.2966,-0.1703,-0.6111,-0.2993,-0.171,-0.6182,-0.1771,m,1.0,1.0,1.0;
-0.0466,-0.6476,-0.5079,-0.0527,-0.5761,-0.5168,0.0415,-0.6484,-0.5093,m,1.0,1.0,1.0;
-0.5282,-0.6409,-0.0489,-0.5166,-0.6416,-0.1875,-0.4192,-0.6489,-0.05,m,1.0,1.0,1.0;
0.1224,-0.6494,-0.1783,0.0319,-0.6224,-0.177,0.0477,-0.6174,-0.3229,m,1.0,1.0,1.0;
-0.0466,-0.6476,-0.5079,0.0415,-0.6484,-0.5093,-0.0492,-0.6519,-0.4588,m,1.0,1.0,1.0;
-0.5282,-0.6409,-0.0489,-0.4192,-0.6489,-0.05,-0.4048,-0.6479,0.0593,m,1.0,1.0,1.0;
-0.4232,-0.6417,-0.3132,-0.3303,-0.645,-0.2966,-0.285,-0.6144,-0.2966,m,1.0,1.0,1.0;
-0.3303,-0.645,-0.2966,-0.4232,-0.6417,-0.3132,-0.285,-0.6144,-0.2966,m,1.0,1.0,1.0;
0.6532,0.0576,-0.173,0.6814,0.1882,-0.2984,0.7015,0.1907,-0.1799,m,1.0,1.0,1.0;
-0.4048,-0.6479,0.0593,-0.3053,-0.6444,0.065,-0.3921,-0.6415,0.1621,m,1.0,1.0,1.0;
0.6183,0.4899,-0.3277,0.5679,0.4376,-0.427,0.5657,0.5288,-0.2993,m,1.0,1.0,1.0;
-0.2205,-0.6426,-0.1035,-0.2261,-0.6485,-0.1342,-0.171,-0.6182,-0.1771,m,1.0,1.0,1.0;
-0.1715,-0.6166,-0.0591,-0.0513,-0.6168,-0.0599,-0.1706,-0.6105,0.0592,m,1.0,1.0,1.0;
-0.4048,-0.6479,0.0593,-0.2812,-0.6516,-0.0558,-0.3053,-0.6444,0.065,m,1.0,1.0,1.0;
-0.5166,-0.6416,-0.1875,-0.4232,-0.6417,-0.3132,-0.4232,-0.6482,-0.1966,m,1.0,1.0,1.0;
-0.273,-0.616,0.0718,-0.1715,-0.6166,-0.0591,-0.1706,-0.6105,0.0592,m,1.0,1.0,1.0;
-0.5166,-0.6416,-0.1875,-0.5273,-0.5745,-0.305,-0.4232,-0.6417,-0.3132,m,1.0,1.0,1.0;
-0.4232,-0.6417,-0.3132,-0.3303,-0.645,-0.2966,-0.2836,-0.654,-0.1799,m,1.0,1.0,1.0;
-0.0492,-0.6519,-0.4588,0.0415,-0.6484,-0.5093,0.0778,-0.6524,-0.433,m,1.0,1.0,1.0;
-0.4232,-0.6417,-0.3132,-0.4142,-0.5768,-0.4248,-0.3824,-0.6439,-0.4127,m,1.0,1.0,1.0;
-0.2836,-0.654,-0.1799,-0.285,-0.6144,-0.2966,-0.2414,-0.6234,-0.2234,m,1.0,1.0,1.0;
-0.0509,-0.6141,-0.2962,0.0477,-0.6174,-0.3229,-0.0519,-0.618,-0.1781,m,1.0,1.0,1.0;
-0.4232,-0.6482,-0.1966,-0.4232,-0.6417,-0.3132,-0.2836,-0.654,-0.1799,m,1.0,1.0,1.0;
-0.1645,-0.6496,-0.454,-0.164,-0.5727,-0.4694,-0.0527,-0.5761,-0.5168,m,1.0,1.0,1.0;
-0.6669,-0.588,-0.1772,-0.5273,-0.5745,-0.305,-0.5641,-0.6238,-0.2101,m,1.0,1.0,1.0;
-0.0527,-0.5761,-0.5168,-0.0466,-0.6476,-0.5079,-0.0492,-0.6519,-0.4588,m,1.0,1.0,1.0;
-0.273,-0.616,0.0718,-0.1706,-0.6105,0.0592,-0.1698,-0.6188,0.1452,m,1.0,1.0,1.0;
-0.286,-0.6534,0.1793,-0.3053,-0.6444,0.065,-0.2824,-0.6087,0.2195,m,1.0,1.0,1.0;
0.5887,0.0717,-0.3102,0.5542,0.1013,-0.4179,0.6814,0.1882,-0.2984,m,1.0,1.0,1.0;
0.6814,0.1882,-0.2984,0.5542,0.1013,-0.4179,0.6749,0.1861,-0.4121,m,1.0,1.0,1.0;
-0.2824,-0.6087,0.2195,-0.273,-0.616,0.0718,-0.1698,-0.6188,0.1452,m,1.0,1.0,1.0;
-0.6669,-0.588,-0.1772,-0.5641,-0.6238,-0.2101,-0.5166,-0.6416,-0.1875,m,1.0,1.0,1.0;
0.2715,0.4033,-0.0259,0.2399,0.4743,0.0223,0.2431,0.4516,-0.0688,m,1.0,1.0,1.0;
-0.1698,-0.6188,0.1452,-0.0539,-0.6139,0.0585,-0.0522,-0.6175,0.1545,m,1.0,1.0,1.0;
-0.6446,-0.5437,0.0355,-0.5282,-0.6409,-0.0489,-0.5367,-0.5549,0.0618,m,1.0,1.0,1.0;
-0.1715,-0.6166,-0.0591,-0.0519,-0.618,-0.1781,-0.0513,-0.6168,-0.0599,m,1.0,1.0,1.0;
0.6749,0.1861,-0.4121,0.5542,0.1013,-0.4179,0.6031,0.1564,-0.4683,m,1.0,1.0,1.0;
-0.6627,-0.5417,-0.2783,-0.5273,-0.5745,-0.305,-0.6669,-0.588,-0.1772,m,1.0,1.0,1.0;
-0.0522,-0.6175,0.1545,0.0691,-0.6161,0.0583,0.0923,-0.5534,0.1675,m,1.0,1.0,1.0;
-0.3921,-0.6415,0.1621,-0.3053,-0.6444,0.065,-0.286,-0.6534,0.1793,m,1.0,1.0,1.0;
-0.161,-0.6536,0.2022,-0.286,-0.6534,0.1793,-0.1698,-0.6188,0.1452,m,1.0,1.0,1.0;
-0.1703,-0.6111,-0.2993,-0.164,-0.5727,-0.4694,-0.0568,-0.5621,-0.4327,m,1.0,1.0,1.0;
-0.0494,-0.6474,0.1954,-0.161,-0.6536,0.2022,-0.0522,-0.6175,0.1545,m,1.0,1.0,1.0;
0.439,0.1572,-0.4735,0.4487,0.0695,-0.4037,0.4585,0.2205,-0.5176,m,1.0,1.0,1.0;
0.4754,0.499,0.3873,0.455,0.4819,0.2873,0.4723,0.5426,0.3124,m,1.0,1.0,1.0;
0.0778,-0.6524,-0.433,0.1018,-0.5493,-0.4511,0.1971,-0.5784,-0.427,m,1.0,1.0,1.0;
0.5005,-0.3458,-0.0553,0.4999,-0.3439,-0.1817,0.5579,-0.2922,-0.0686,m,1.0,1.0,1.0;
0.5579,-0.2922,-0.0686,0.4999,-0.3439,-0.1817,0.5549,-0.2947,-0.1745,m,1.0,1.0,1.0;
0.5549,-0.2947,-0.1745,0.5434,-0.2728,-0.2665,0.6143,-0.2023,-0.1863,m,1.0,1.0,1.0;
0.6143,-0.2023,-0.1863,0.5434,-0.2728,-0.2665,0.576,-0.1855,-0.3065,m,1.0,1.0,1.0;
-0.1703,-0.6111,-0.2993,-0.0519,-0.618,-0.1781,-0.171,-0.6182,-0.1771,m,1.0,1.0,1.0;
0.5542,0.1013,-0.4179,0.5506,0.2065,-0.514,0.6031,0.1564,-0.4683,m,1.0,1.0,1.0;
0.5005,-0.3458,-0.0553,0.4305,-0.3889,-0.0586,0.4999,-0.3439,-0.1817,m,1.0,1.0,1.0;
0.4305,-0.3889,-0.0586,0.4254,-0.3921,-0.1757,0.4999,-0.3439,-0.1817,m,1.0,1.0,1.0;
-0.4192,-0.6489,-0.05,-0.2812,-0.6516,-0.0558,-0.4048,-0.6479,0.0593,m,1.0,1.0,1.0;
0.4576,-0.3133,0.0655,0.4305,-0.3889,-0.0586,0.5005,-0.3458,-0.0553,m,1.0,1.0,1.0;
0.458,-0.3143,-0.3066,0.576,-0.1855,-0.3065,0.5434,-0.2728,-0.2665,m,1.0,1.0,1.0;
0.4999,-0.3439,-0.1817,0.5434,-0.2728,-0.2665,0.5549,-0.2947,-0.1745,m,1.0,1.0,1.0;
-0.2812,-0.6516,-0.0558,-0.2205,-0.6426,-0.1035,-0.1715,-0.6166,-0.0591,m,1.0,1.0,1.0;
0.4999,-0.3439,-0.1817,0.458,-0.3143,-0.3066,0.5434,-0.2728,-0.2665,m,1.0,1.0,1.0;
0.439,0.1572,-0.4735,0.5542,0.1013,-0.4179,0.4487,0.0695,-0.4037,m,1.0,1.0,1.0;
0.5542,0.1013,-0.4179,0.439,0.1572,-0.4735,0.5506,0.2065,-0.514,m,1.0,1.0,1.0;
-0.6627,-0.5417,-0.2783,-0.7625,-0.5241,-0.1819,-0.7689,-0.4425,-0.2662,m,1.0,1.0,1.0;
-0.164,-0.5727,-0.4694,-0.1645,-0.6496,-0.454,-0.2883,-0.6489,-0.4209,m,1.0,1.0,1.0;
-0.3053,-0.6444,0.065,-0.2812,-0.6516,-0.0558,-0.2404,-0.6241,-0.0095,m,1.0,1.0,1.0;
0.3203,-0.4334,0.0531,0.3363,-0.453,-0.0745,0.4576,-0.3133,0.0655,m,1.0,1.0,1.0;
0.4576,-0.3133,0.0655,0.3363,-0.453,-0.0745,0.4305,-0.3889,-0.0586,m,1.0,1.0,1.0;
-0.1706,-0.6105,0.0592,-0.0513,-0.6168,-0.0599,-0.0539,-0.6139,0.0585,m,1.0,1.0,1.0;
-0.4232,-0.6417,-0.3132,-0.3824,-0.6439,-0.4127,-0.2883,-0.6489,-0.4209,m,1.0,1.0,1.0;
0.458,-0.3143,-0.3066,0.4531,-0.1967,-0.4071,0.576,-0.1855,-0.3065,m,1.0,1.0,1.0;
-0.0519,-0.618,-0.1781,0.0319,-0.6224,-0.177,-0.0513,-0.6168,-0.0599,m,1.0,1.0,1.0;
-0.161,-0.6536,0.2022,-0.1698,-0.6188,0.1452,-0.0522,-0.6175,0.1545,m,1.0,1.0,1.0;
-0.3303,-0.645,-0.2966,-0.285,-0.6144,-0.2966,-0.2836,-0.654,-0.1799,m,1.0,1.0,1.0;
0.4254,-0.3921,-0.1757,0.458,-0.3143,-0.3066,0.4999,-0.3439,-0.1817,m,1.0,1.0,1.0;
0.0778,-0.6524,-0.433,0.1971,-0.5784,-0.427,0.198,-0.6484,-0.4169,m,1.0,1.0,1.0;
0.3363,-0.453,-0.0745,0.31,-0.4446,-0.1777,0.4305,-0.3889,-0.0586,m,1.0,1.0,1.0;
0.4305,-0.3889,-0.0586,0.31,-0.4446,-0.1777,0.4254,-0.3921,-0.1757,m,1.0,1.0,1.0;
0.3203,-0.6638,-0.0584,0.446,-0.6597,-0.059,0.4341,-0.6564,0.0417,m,1.0,1.0,1.0;
0.3255,-0.6632,0.0619,0.3203,-0.6638,-0.0584,0.4341,-0.6564,0.0417,m,1.0,1.0,1.0;
0.458,-0.3143,-0.3066,0.4054,-0.2834,-0.3795,0.4531,-0.1967,-0.4071,m,1.0,1.0,1.0;
-0.7625,-0.5241,-0.1819,-0.6627,-0.5417,-0.2783,-0.6669,-0.588,-0.1772,m,1.0,1.0,1.0;
0.3203,-0.6638,-0.0584,0.4205,-0.6467,-0.1622,0.446,-0.6597,-0.059,m,1.0,1.0,1.0;
0.3009,-0.4326,-0.294,0.4254,-0.3921,-0.1757,0.31,-0.4446,-0.1777,m,1.0,1.0,1.0;
0.3009,-0.4326,-0.294,0.458,-0.3143,-0.3066,0.4254,-0.3921,-0.1757,m,1.0,1.0,1.0;
0.3332,-0.6632,-0.1753,0.4205,-0.6467,-0.1622,0.3203,-0.6638,-0.0584,m,1.0,1.0,1.0;
-0.5641,-0.6238,-0.2101,-0.5273,-0.5745,-0.305,-0.5166,-0.6416,-0.1875,m,1.0,1.0,1.0;
0.3009,-0.4326,-0.294,0.3312,-0.3457,-0.342,0.458,-0.3143,-0.3066,m,1.0,1.0,1.0;
-0.273,-0.616,0.0718,-0.2404,-0.6241,-0.0095,-0.1715,-0.6166,-0.0591,m,1.0,1.0,1.0;
0.455,0.4819,0.2873,0.466,0.4641,0.1803,0.4723,0.5426,0.3124,m,1.0,1.0,1.0;
-0.0524,-0.6567,0.2591,-0.1781,-0.5695,0.2733,-0.161,-0.6536,0.2022,m,1.0,1.0,1.0;
0.1972,-0.6564,0.1913,0.3255,-0.6632,0.0619,0.2829,-0.6577,0.129,m,1.0,1.0,1.0;
0.1971,-0.5784,-0.427,0.3395,-0.6506,-0.4237,0.198,-0.6484,-0.4169,m,1.0,1.0,1.0;
0.3312,-0.3457,-0.342,0.3153,-0.2854,-0.397,0.458,-0.3143,-0.3066,m,1.0,1.0,1.0;
0.458,-0.3143,-0.3066,0.3153,-0.2854,-0.397,0.4054,-0.2834,-0.3795,m,1.0,1.0,1.0;
0.4054,-0.2834,-0.3795,0.3153,-0.2854,-0.397,0.4531,-0.1967,-0.4071,m,1.0,1.0,1.0;
-0.2261,-0.6485,-0.1342,-0.2836,-0.654,-0.1799,-0.171,-0.6182,-0.1771,m,1.0,1.0,1.0;
0.3243,-0.6574,-0.298,0.4177,-0.6492,-0.2945,0.4205,-0.6467,-0.1622,m,1.0,1.0,1.0;
0.3332,-0.6632,-0.1753,0.3243,-0.6574,-0.298,0.4205,-0.6467,-0.1622,m,1.0,1.0,1.0;
-0.2812,-0.6516,-0.0558,-0.2836,-0.654,-0.1799,-0.2261,-0.6485,-0.1342,m,1.0,1.0,1.0;
0.3153,-0.2854,-0.397,0.3289,-0.2074,-0.4353,0.4531,-0.1967,-0.4071,m,1.0,1.0,1.0;
-0.2205,-0.6426,-0.1035,-0.2812,-0.6516,-0.0558,-0.2261,-0.6485,-0.1342,m,1.0,1.0,1.0;
-0.2836,-0.654,-0.1799,-0.2261,-0.6485,-0.1342,-0.171,-0.6182,-0.1771,m,1.0,1.0,1.0;
0.2003,-0.6586,0.0566,0.3255,-0.6632,0.0619,0.1972,-0.6564,0.1913,m,1.0,1.0,1.0;
-0.1715,-0.6166,-0.0591,-0.2205,-0.6426,-0.1035,-0.171,-0.6182,-0.1771,m,1.0,1.0,1.0;
0.1946,-0.6569,-0.0591,0.3203,-0.6638,-0.0584,0.3255,-0.6632,0.0619,m,1.0,1.0,1.0;
0.2003,-0.6586,0.0566,0.1946,-0.6569,-0.0591,0.3255,-0.6632,0.0619,m,1.0,1.0,1.0;
-0.164,-0.5727,-0.4694,-0.2883,-0.6489,-0.4209,-0.294,-0.563,-0.4683,m,1.0,1.0,1.0;
0.0778,-0.6524,-0.433,0.0628,-0.5823,-0.514,0.1018,-0.5493,-0.4511,m,1.0,1.0,1.0;
-0.4232,-0.6417,-0.3132,-0.2883,-0.6489,-0.4209,-0.3303,-0.645,-0.2966,m,1.0,1.0,1.0;
-0.2824,-0.6087,0.2195,-0.3053,-0.6444,0.065,-0.273,-0.616,0.0718,m,1.0,1.0,1.0;
0.0855,-0.657,0.2841,0.1972,-0.6564,0.1913,0.1878,-0.6424,0.2641,m,1.0,1.0,1.0;
0.3243,-0.6574,-0.298,0.4132,-0.6477,-0.3879,0.4177,-0.6492,-0.2945,m,1.0,1.0,1.0;
-0.1706,-0.6105,0.0592,-0.0539,-0.6139,0.0585,-0.1698,-0.6188,0.1452,m,1.0,1.0,1.0;
-0.0519,-0.618,-0.1781,0.0477,-0.6174,-0.3229,0.0319,-0.6224,-0.177,m,1.0,1.0,1.0;
0.3395,-0.6506,-0.4237,0.4132,-0.6477,-0.3879,0.3243,-0.6574,-0.298,m,1.0,1.0,1.0;
-0.6655,-0.5889,-0.058,-0.5166,-0.6416,-0.1875,-0.5282,-0.6409,-0.0489,m,1.0,1.0,1.0;
-0.1703,-0.6111,-0.2993,-0.0568,-0.5621,-0.4327,-0.0509,-0.6141,-0.2962,m,1.0,1.0,1.0;
-0.1645,-0.6496,-0.454,-0.0527,-0.5761,-0.5168,-0.0492,-0.6519,-0.4588,m,1.0,1.0,1.0;
0.0858,-0.6415,0.1797,0.1972,-0.6564,0.1913,0.0855,-0.657,0.2841,m,1.0,1.0,1.0;
0.4132,-0.6477,-0.3879,0.3395,-0.6506,-0.4237,0.4128,-0.6036,-0.3962,m,1.0,1.0,1.0;
0.1868,-0.5797,0.1,0.2003,-0.6586,0.0566,0.1972,-0.6564,0.1913,m,1.0,1.0,1.0;
0.0858,-0.6415,0.1797,0.1868,-0.5797,0.1,0.1972,-0.6564,0.1913,m,1.0,1.0,1.0;
0.3395,-0.6506,-0.4237,0.3428,-0.5676,-0.4286,0.4128,-0.6036,-0.3962,m,1.0,1.0,1.0;
0.0858,-0.6415,0.1797,0.0923,-0.5534,0.1675,0.1972,-0.6564,0.1913,m,1.0,1.0,1.0;
0.0923,-0.5534,0.1675,0.0858,-0.6415,0.1797,0.1972,-0.6564,0.1913,m,1.0,1.0,1.0;
0.0923,-0.5534,0.1675,0.1868,-0.5797,0.1,0.0858,-0.6415,0.1797,m,1.0,1.0,1.0;
0.1868,-0.5797,0.1,0.0691,-0.6161,0.0583,0.2003,-0.6586,0.0566,m,1.0,1.0,1.0;
0.439,0.1572,-0.4735,0.4585,0.2205,-0.5176,0.5506,0.2065,-0.514,m,1.0,1.0,1.0;
0.2581,-0.3399,-0.374,0.3153,-0.2854,-0.397,0.3312,-0.3457,-0.342,m,1.0,1.0,1.0;
0.201,-0.3256,-0.4077,0.3153,-0.2854,-0.397,0.2581,-0.3399,-0.374,m,1.0,1.0,1.0;
0.0691,-0.6161,0.0583,0.1868,-0.5797,0.1,0.0923,-0.5534,0.1675,m,1.0,1.0,1.0;
-0.6669,-0.588,-0.1772,-0.5166,-0.6416,-0.1875,-0.6655,-0.5889,-0.058,m,1.0,1.0,1.0;
-0.286,-0.6534,0.1793,-0.2824,-0.6087,0.2195,-0.1698,-0.6188,0.1452,m,1.0,1.0,1.0;
0.1894,-0.6563,-0.2997,0.3395,-0.6506,-0.4237,0.3243,-0.6574,-0.298,m,1.0,1.0,1.0;
0.1894,-0.6563,-0.2997,0.198,-0.6484,-0.4169,0.3395,-0.6506,-0.4237,m,1.0,1.0,1.0;
-0.171,-0.6182,-0.1771,-0.0519,-0.618,-0.1781,-0.1715,-0.6166,-0.0591,m,1.0,1.0,1.0;
-0.2404,-0.6241,-0.0095,-0.2812,-0.6516,-0.0558,-0.1715,-0.6166,-0.0591,m,1.0,1.0,1.0;
-0.0494,-0.6474,0.1954,0.0858,-0.6415,0.1797,0.0855,-0.657,0.2841,m,1.0,1.0,1.0;
-0.0524,-0.6567,0.2591,-0.0494,-0.6474,0.1954,0.0855,-0.657,0.2841,m,1.0,1.0,1.0;
-0.0522,-0.6175,0.1545,0.0923,-0.5534,0.1675,0.0858,-0.6415,0.1797,m,1.0,1.0,1.0;
-0.0494,-0.6474,0.1954,-0.0522,-0.6175,0.1545,0.0858,-0.6415,0.1797,m,1.0,1.0,1.0;
-0.1703,-0.6111,-0.2993,-0.0509,-0.6141,-0.2962,-0.0519,-0.618,-0.1781,m,1.0,1.0,1.0;
0.1224,-0.6494,-0.1783,0.1946,-0.6569,-0.0591,0.1123,-0.6624,-0.0718,m,1.0,1.0,1.0;
",


/* List of spheres in the scene, separated by semicolons.                     */
/* Each sphere is given by its xyz-coordinates and a radius, separated by     */
/* commas. Then follows the material which can be either "m" for matte or "r" */
/* for reflective. Matte materials are followed by three values representing  */
/* the color in r,g,b format.                                                 */ 
@spheres := "",


/* end of parameters */
@spheres:=concat(@spheres,@light.x,",",@light.y,",",@light.z,",",@light.r,",l;")
,@triangles:=replace(replace(replace(@triangles," ",""),"\t",""),"\n",""),
@spheres:=replace(replace(replace(@spheres," ",""),"\t",""),"\n",""),@ntriangles
:=(length(@triangles)-length(replace(@triangles,";",""))),@nspheres:=(length(
@spheres)-length(replace(@spheres,";",""))),@nprimitives:=@ntriangles+@nspheres,
@aspectRatio:=@w/@h,@fov:=@fov*(3.14159/180.0),@epsilon:=0.000001,@linelen:=4*
floor((@w*24+31)/32),@cdx:=@cam.lookatx-@cam.x,@cdy:=@cam.lookaty-@cam.y,@cdz:=
@cam.lookatz-@cam.z,@tlen:=sqrt(@cdx*@cdx+@cdy*@cdy+@cdz*@cdz),@rotz1:=@cdx/
@tlen,@rotz2:=@cdy/@tlen,@rotz3:=@cdz/@tlen,@rotx1:=@cam.upy*@rotz3-@cam.upz*
@rotz2,@rotx2:=@cam.upz*@rotz1-@cam.upx*@rotz3,@rotx3:=@cam.upx*@rotz2-@cam.upy*
@rotz1,@tlen:=sqrt(@rotx1*@rotx1+@rotx2*@rotx2+@rotx3*@rotx3),@rotx1:=@rotx1/
@tlen,@rotx2:=@rotx2/@tlen,@rotx3:=@rotx3/@tlen,@roty1:=@rotz2*@rotx3-@rotz3*
@rotx2,@roty2:=@rotz3*@rotx1-@rotz1*@rotx3,@roty3:=@rotz1*@rotx2-@rotz2*@rotx1,
@r:=concat(0x424d,reverse(lpad(char(26+@h*@linelen),4,0x00)),0x00000000,
0x1A000000,0x0C000000,reverse(lpad(char(@w),2,0x00)),reverse(lpad(char(@h),2,
0x00)),0x01001800),@pxy:=0,Benchmark(@h,char(@pxx:=0,@line:=repeat(0xff,0),
Benchmark(@w,char(@degx:=(((@pxx+0.5)/@w)-0.5)*@fov*@aspectRatio,@degy:=(((@pxy+
0.5)/@h)-0.5)*@fov,@tx:=sin(@degx),@ty:=sin(@degy),@tz:=1.0,@rdx:=@tx*@rotx1+@ty
*@roty1+@tz*@rotz1,@rdy:=@tx*@rotx2+@ty*@roty2+@tz*@rotz2,@rdz:=@tx*@rotx3+@ty*
@roty3+@tz*@rotz3,@rox:=@cam.x,@roy:=@cam.y,@roz:=@cam.z,@doray:=true,
@shadowdone:=false,@cr:=0,@cg:=0,@cb:=0,@inside:=false,benchmark(@maxRecDepth+if
(@shadows,2,1),if(@doray,char(@doray:=false,@tlen:=sqrt(@rdx*@rdx+@rdy*@rdy+@rdz
*@rdz),@rdx:=@rdx/@tlen,@rdy:=@rdy/@tlen,@rdz:=@rdz/@tlen,@i:=0,@triangleptr:=1,
@sphereptr:=1,@intersect:=false,@mindist:=999999,@material:="n",@nox:=0,@noy:=0,
@noz:=0,@primitive:="",@ptr:=0,benchmark(@nprimitives,char(@primhit:=false,if(@i
<@ntriangles,concat(@tpos:=locate(";",@triangles,@triangleptr),@primitive:=mid(
@triangles,@triangleptr,@tpos-@triangleptr+1),@triangleptr:=@tpos+1,@tpos:=instr
(@primitive,","),@v1x:=left(@primitive,@tpos-1),@ptr:=@tpos+1,@tpos:=locate(",",
@primitive,@ptr),@v1y:=mid(@primitive,@ptr,@tpos-@ptr),@ptr:=@tpos+1,@tpos:=
locate(",",@primitive,@ptr),@v1z:=mid(@primitive,@ptr,@tpos-@ptr),@ptr:=@tpos+1,
@tpos:=locate(",",@primitive,@ptr),@v2x:=mid(@primitive,@ptr,@tpos-@ptr),@ptr:=
@tpos+1,@tpos:=locate(",",@primitive,@ptr),@v2y:=mid(@primitive,@ptr,@tpos-@ptr)
,@ptr:=@tpos+1,@tpos:=locate(",",@primitive,@ptr),@v2z:=mid(@primitive,@ptr,
@tpos-@ptr),@ptr:=@tpos+1,@tpos:=locate(",",@primitive,@ptr),@v3x:=mid(
@primitive,@ptr,@tpos-@ptr),@ptr:=@tpos+1,@tpos:=locate(",",@primitive,@ptr),
@v3y:=mid(@primitive,@ptr,@tpos-@ptr),@ptr:=@tpos+1,@tpos:=locate(",",@primitive
,@ptr),@v3z:=mid(@primitive,@ptr,@tpos-@ptr),@ptr:=@tpos+1,@e1x:=@v2x-@v1x,@e1y
:=@v2y-@v1y,@e1z:=@v2z-@v1z,@e2x:=@v3x-@v1x,@e2y:=@v3y-@v1y,@e2z:=@v3z-@v1z,@Px
:=@rdy*@e2z-@rdz*@e2y,@Py:=@rdz*@e2x-@rdx*@e2z,@Pz:=@rdx*@e2y-@rdy*@e2x,@det:=
@e1x*@Px+@e1y*@Py+@e1z*@Pz,if(1.0*@det<-1.0*@epsilon||1.0*@det>1.0*@epsilon,char
(@det:=1.0/@det,@Tx:=@rox-@v1x,@Ty:=@roy-@v1y,@Tz:=@roz-@v1z,@u:=(@Tx*@Px+@Ty*
@Py+@Tz*@Pz)*@det,if(1.0*@u>=0.0&&1.0*@u<=1.0,char(@Qx:=@Ty*@e1z-@Tz*@e1y,@Qy:=
@Tz*@e1x-@Tx*@e1z,@Qz:=@Tx*@e1y-@Ty*@e1x,@v:=(@rdx*@Qx+@rdy*@Qy+@rdz*@Qz)*@det,
if(1.0*@v>=0.0&&1.0*(@u+@v)<=1.0,char(@tdist:=(@e2x*@Qx+@e2y*@Qy+@e2z*@Qz)*@det,
if(1.0*@tdist>1.0*@epsilon&&1.0*@tdist<1.0*@mindist,/*Intersection!*/char(
@primhit:=true,@intersect:=true,@mindist:=@tdist,@nox:=@e2y*@e1z-@e2z*@e1y,@noy
:=@e2z*@e1x-@e2x*@e1z,@noz:=@e2x*@e1y-@e2y*@e1x,@tlen:=sqrt(@nox*@nox+@noy*@noy+
@noz*@noz),@nox:=@nox/@tlen,@noy:=@noy/@tlen,@noz:=@noz/@tlen,@tdot:=(@nox*@rdx+
@noy*@rdy+@noz*@rdz),if(1.0*@tdot>0.0,char(@nox:=-1.0*@nox,@noy:=-1.0*@noy,@noz
:=-1.0*@noz),0)),0)),0)),0)),0)),char(@tpos:=locate(";",@spheres,@sphereptr),
@primitive:=mid(@spheres,@sphereptr,@tpos-@sphereptr+1),@sphereptr:=@tpos+1,
@tpos:=instr(@primitive,","),@spx:=left(@primitive,@tpos-1),@ptr:=@tpos+1,@tpos
:=locate(",",@primitive,@ptr),@spy:=mid(@primitive,@ptr,@tpos-@ptr),@ptr:=@tpos+
1,@tpos:=locate(",",@primitive,@ptr),@spz:=mid(@primitive,@ptr,@tpos-@ptr),@ptr
:=@tpos+1,@tpos:=locate(",",@primitive,@ptr),@spr:=mid(@primitive,@ptr,@tpos-
@ptr),@ptr:=@tpos+1,@Lx:=@spx-@rox,@Ly:=@spy-@roy,@Lz:=@spz-@roz,@tca:=@Lx*@rdx+
@Ly*@rdy+@Lz*@rdz,@d2:=@Lx*@Lx+@Ly*@Ly+@Lz*@Lz-@tca*@tca,if(1.0*@d2<=1.0*(@spr*
@spr),char(@thc:=sqrt(@spr*@spr-@d2),@tdist:=if(1.0*@tca-1.0*@thc>0.0,@tca-@thc,
0),@tdist:=if(1.0*@tca+1.0*@thc>0.0,least(@tca+@thc,@tdist),@tdist),if(1.0*
@tdist>0.0&&1.0*@tdist<1.0*@mindist,char(@primhit:=true,@intersect:=true,
@mindist:=@tdist,@nox:=@rox+@tdist*@rdx-@spx,@noy:=@roy+@tdist*@rdy-@spy,@noz:=
@roz+@tdist*@rdz-@spz,@tlen:=sqrt(@nox*@nox+@noy*@noy+@noz*@noz),@nox:=@nox/
@tlen,@noy:=@noy/@tlen,@noz:=@noz/@tlen),0)),0))),if(@primhit,char(@material:=
mid(@primitive,@ptr,1),@ptr:=@ptr+2,if(@material="m",char(@tpos:=locate(",",
@primitive,@ptr),@hor:=mid(@primitive,@ptr,@tpos-@ptr),@ptr:=@tpos+1,@tpos:=
locate(",",@primitive,@ptr),@hog:=mid(@primitive,@ptr,@tpos-@ptr),@ptr:=@tpos+1,
@tpos:=locate(";",@primitive,@ptr),@hob:=mid(@primitive,@ptr,@tpos-@ptr)),0),if(
@material="t",char(@tpos:=locate(";",@primitive,@ptr),@href:=mid(@primitive,@ptr
,@tpos-@ptr)),0)),0),@i:=@i+1)),if(@shadowdone,char(if(@material!="l",char(@cr:=
0.0,@cg:=0.0,@cb:=0.0),0)),char(if(@material="l",char(@cr:=1.0,@cg:=1.0,@cb:=1.0
),0),if(@material="m",char(@lix:=@light.x-(@rox+@rdx*@mindist),@liy:=@light.y-(
@roy+@rdy*@mindist),@liz:=@light.z-(@roz+@rdz*@mindist),@tlen:=sqrt(@lix*@lix+
@liy*@liy+@liz*@liz),@lix:=@lix/@tlen,@liy:=@liy/@tlen,@liz:=@liz/@tlen,@tdot:=
greatest(0.0,(@lix*@nox)+(@liy*@noy)+(@liz*@noz)),@cr:=@hor*@tdot,@cg:=@hog*
@tdot,@cb:=@hob*@tdot,if(@shadows&&@shadowdone=false,char(@shadowdone:=true,@rox
:=@rox+@rdx*@mindist+@nox*@epsilon,@roy:=@roy+@rdy*@mindist+@noy*@epsilon,@roz:=
@roz+@rdz*@mindist+@noz*@epsilon,@rdx:=@light.x-@rox,@rdy:=@light.y-@roy,@rdz:=
@light.z-@roz,@doray:=true),0)),0),if(@material="t",char(if(@inside,char(@nox:=-
@nox,@noy:=-@noy,@noz:=-@noz),0),@tdot:=-(@rdx*@nox)-(@rdy*@noy)-(@rdz*@noz),
@refb:=if(@inside,@href,1.0/@href),@refd2:=1.0-@refb*@refb*(1.0-@tdot*@tdot),if(
1.0*@refd2>=0.0,char(@refa:=@refb*@tdot+if(1.0*@tdot>=0.0,-1.0,1.0)*sqrt(@refd2)
,@rox:=@rox+@rdx*@mindist-@nox*@epsilon,@roy:=@roy+@rdy*@mindist-@noy*@epsilon,
@roz:=@roz+@rdz*@mindist-@noz*@epsilon,@rdx:=@refa*@nox+@refb*@rdx,@rdy:=@refa*
@noy+@refb*@rdy,@rdz:=@refa*@noz+@refb*@rdz,@inside:=!@inside,@doray:=true),char
(@material:="r"))),0),if(@material="r",char(@tdot:=(@rdx*@nox)+(@rdy*@noy)+(@rdz
*@noz),@rox:=@rox+@rdx*@mindist+@nox*@epsilon,@roy:=@roy+@rdy*@mindist+@noy*
@epsilon,@roz:=@roz+@rdz*@mindist+@noz*@epsilon,@rdx:=@rdx-2.0*@nox*@tdot,@rdy:=
@rdy-2.0*@noy*@tdot,@rdz:=@rdz-2.0*@noz*@tdot,@doray:=true),0)))),0)),@line:=
concat(@line,if(@intersect,concat(char(@cb*255),char(@cg*255),char(@cr*255)),
0x000000)),@pxx:=@pxx+1)),@r:=concat(@r,rpad(@line,@linelen,0x00)),@pxy:=@pxy+1)
)),0),0,@r) as bmpdata from (select 1) as tmp INTO DUMPFILE '/var/lib/mysql-files/sqlray-bunny.bmp'
