//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDb9ed517f_bd01_4f5e_94c2_6450b079579e
{
    public class Class_TimeClip : OperatorPart.Function,
                                  Framefield.Core.OperatorPartTraits.ITimeClip,
                                  Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            Input = 0,
            ClipIn = 1,
            ClipOut = 2,
            SourceIn = 3,
            SourceOut = 4,
            Layer = 5
        }
        //<<< _inputids

        public double StartTime
        {
            get { return GetInputValue((int)InputId.ClipIn); } 
            set { SetInputValue((int)InputId.ClipIn, value); } 
        }

        public double EndTime
        {
            get { return GetInputValue((int)InputId.ClipOut); } 
            set { SetInputValue((int)InputId.ClipOut, value); } 
        }

        public double SourceStartTime
        {
            get { return GetInputValue((int)InputId.SourceIn); } 
            set { SetInputValue((int)InputId.SourceIn, value); } 
        }

        public double SourceEndTime
        {
            get { return GetInputValue((int)InputId.SourceOut); } 
            set { SetInputValue((int)InputId.SourceOut, value); } 
        }

        public int Layer
        {
            get { return (int)GetInputValue((int)InputId.Layer); } 
            set { SetInputValue((int)InputId.Layer, value); } 
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            var prevValue = context.Value;
            //>>> _params
            var Input = inputs[(int)InputId.Input];
            var ClipIn = inputs[(int)InputId.ClipIn].Eval(context).Value;
            var ClipOut = inputs[(int)InputId.ClipOut].Eval(context).Value;
            var SourceIn = inputs[(int)InputId.SourceIn].Eval(context).Value;
            var SourceOut = inputs[(int)InputId.SourceOut].Eval(context).Value;
            var Layer = inputs[(int)InputId.Layer].Eval(context).Value;
            //<<< _params

            if (context.Time < ClipIn || context.Time >= ClipOut)
            {
                context.Value = prevValue;
                return context;
            }

            var oldTime = context.Time;
            context.Time = SourceIn + (context.Time - ClipIn)*(SourceOut - SourceIn)/(ClipOut - ClipIn);

            _timeAccessorInvalidator.Clear();
            Input.TraverseWithFunctionUseSpecificBehavior(null, _timeAccessorInvalidator);
            Input.Eval(context);
            
            context.Time = oldTime;

            return context;
        }

        private double GetInputValue(int index)
        {
            return OperatorPartUtilities.GetInputFloatValue(OperatorPart.Connections[index]);
        }

        private void SetInputValue(int index, double val)
        {
            OperatorPart opPart = OperatorPart.Connections[index];
            if (opPart.Connections.Count == 0)
            {
                opPart.Func = Utilities.CreateValueFunction(new Float((float)val));
            }
        }

        OperatorPart.InvalidateTimeAccessors _timeAccessorInvalidator = new OperatorPart.InvalidateTimeAccessors();
    }
}