using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;

namespace Framefield.Core.ID8e3054f7_1174_47b7_a526_ab74e0b500ec
{
    public class Class_Repeat : OperatorPart.Function
    {
    //>>> _inputids
    private enum InputId
    {
        SceneInput = 0,
        TranslateX = 1,
        TranslateY = 2,
        TranslateZ = 3,
        RotateX = 4,
        RotateY = 5,
        RotateZ = 6,
        ScaleX = 7,
        ScaleY = 8,
        ScaleZ = 9,
        Count = 10,
        Offset = 11,
        PivotX = 12,
        PivotY = 13,
        PivotZ = 14
    }
    //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var SceneInput = inputs[(int)InputId.SceneInput];
            var TranslateX = inputs[(int)InputId.TranslateX].Eval(context).Value;
            var TranslateY = inputs[(int)InputId.TranslateY].Eval(context).Value;
            var TranslateZ = inputs[(int)InputId.TranslateZ].Eval(context).Value;
            var Translate = new Vector3(TranslateX, TranslateY, TranslateZ);
            var RotateX = inputs[(int)InputId.RotateX].Eval(context).Value;
            var RotateY = inputs[(int)InputId.RotateY].Eval(context).Value;
            var RotateZ = inputs[(int)InputId.RotateZ].Eval(context).Value;
            var Rotate = new Vector3(RotateX, RotateY, RotateZ);
            var ScaleX = inputs[(int)InputId.ScaleX].Eval(context).Value;
            var ScaleY = inputs[(int)InputId.ScaleY].Eval(context).Value;
            var ScaleZ = inputs[(int)InputId.ScaleZ].Eval(context).Value;
            var Scale = new Vector3(ScaleX, ScaleY, ScaleZ);
            var Count = inputs[(int)InputId.Count].Eval(context).Value;
            var Offset = inputs[(int)InputId.Offset].Eval(context).Value;
            var PivotX = inputs[(int)InputId.PivotX].Eval(context).Value;
            var PivotY = inputs[(int)InputId.PivotY].Eval(context).Value;
            var PivotZ = inputs[(int)InputId.PivotZ].Eval(context).Value;
            var Pivot = new Vector3(PivotX, PivotY, PivotZ);
            //<<< _params
            
            var prevTransform = context.ObjectTWorld;
            
            
            Vector3 translation;
            Quaternion rotation;
            Vector3 scale;
            Matrix transform;
            
            for (var i = 1; i <= Count; ++i) 
            {
                float u = (i + Offset);
                        
                translation = new Vector3(TranslateX, TranslateY, TranslateZ) * u;
                rotation = Quaternion.RotationYawPitchRoll(    RotateX / 360.0f * (float)(2.0 * Math.PI) * u,
                                                               RotateY / 360.0f * (float)(2.0 * Math.PI) * u,
                                                               RotateZ / 360.0f * (float)(2.0 * Math.PI) * u);
                scale = (Vector3.One - new Vector3(ScaleX, ScaleY, ScaleZ)) * u + Vector3.One;
                //var scale = Vector3.One;
                
                transform = Matrix.Transformation(new Vector3(), new Quaternion(), scale, Pivot, rotation, translation);
            
                context.ObjectTWorld = transform * prevTransform;
                SceneInput.Eval(context);
            }
            
            context.ObjectTWorld = prevTransform;
            
            return context;
        }
    }
}

