using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;

namespace Framefield.Core.ID1fc674ad_a74f_4551_b442_09f44c554421
{
    public class Class_Random : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Seed = 0,
            Min = 1,
            Max = 2
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var Seed = inputs[(int)InputId.Seed].Eval(context).Value;
            var Min = inputs[(int)InputId.Min].Eval(context).Value;
            var Max = inputs[(int)InputId.Max].Eval(context).Value;
            //<<< _params

            //>>> function
            if (Min > Max) 
                Utilities.Swap(ref Min, ref Max);
            
            var random = new Random(98764 + (int)( Seed * Math.PI));
            var t2 = random.Next(9876672);
            t2 += random.Next(5341324);
            t2 += random.Next(1242324);
            var random2 = new Random( (int)t2);
            
            context.Value = (float)(random2.NextDouble() * (Max-Min) + Min);
            //<<< function
            return context;
        }
    }
}

