//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID58414df0_519e_4bb4_871c_0509c8bed46b
{
    public class Class_ColorGradeVignette : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            GainR = 2,
            GainG = 3,
            GainB = 4,
            GainA = 5,
            GammaR = 6,
            GammaG = 7,
            GammaB = 8,
            GammaA = 9,
            LiftR = 10,
            LiftG = 11,
            LiftB = 12,
            LiftA = 13,
            PreSaturate = 14,
            CenterX = 15,
            CenterY = 16,
            Radius = 17,
            Bias = 18,
            VignetteColorR = 19,
            VignetteColorG = 20,
            VignetteColorB = 21,
            VignetteColorA = 22
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            return PrepareAndEvalOnChange(context, () =>
            {
                //>>> _params
                var Code = inputs[(int)InputId.Code].Eval(context).Text;
                var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
                var GainR = inputs[(int)InputId.GainR].Eval(context).Value;
                var GainG = inputs[(int)InputId.GainG].Eval(context).Value;
                var GainB = inputs[(int)InputId.GainB].Eval(context).Value;
                var GainA = inputs[(int)InputId.GainA].Eval(context).Value;
                var Gain = new Color4(GainR, GainG, GainB, GainA);
                var GammaR = inputs[(int)InputId.GammaR].Eval(context).Value;
                var GammaG = inputs[(int)InputId.GammaG].Eval(context).Value;
                var GammaB = inputs[(int)InputId.GammaB].Eval(context).Value;
                var GammaA = inputs[(int)InputId.GammaA].Eval(context).Value;
                var Gamma = new Color4(GammaR, GammaG, GammaB, GammaA);
                var LiftR = inputs[(int)InputId.LiftR].Eval(context).Value;
                var LiftG = inputs[(int)InputId.LiftG].Eval(context).Value;
                var LiftB = inputs[(int)InputId.LiftB].Eval(context).Value;
                var LiftA = inputs[(int)InputId.LiftA].Eval(context).Value;
                var Lift = new Color4(LiftR, LiftG, LiftB, LiftA);
                var PreSaturate = inputs[(int)InputId.PreSaturate].Eval(context).Value;
                var CenterX = inputs[(int)InputId.CenterX].Eval(context).Value;
                var CenterY = inputs[(int)InputId.CenterY].Eval(context).Value;
                var Center = new Vector2(CenterX, CenterY);
                var Radius = inputs[(int)InputId.Radius].Eval(context).Value;
                var Bias = inputs[(int)InputId.Bias].Eval(context).Value;
                var VignetteColorR = inputs[(int)InputId.VignetteColorR].Eval(context).Value;
                var VignetteColorG = inputs[(int)InputId.VignetteColorG].Eval(context).Value;
                var VignetteColorB = inputs[(int)InputId.VignetteColorB].Eval(context).Value;
                var VignetteColorA = inputs[(int)InputId.VignetteColorA].Eval(context).Value;
                var VignetteColor = new Color4(VignetteColorR, VignetteColorG, VignetteColorB, VignetteColorA);
                //<<< _params
                
                if (Image == null)
                    return;

                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Gain").AsVector().Set(new Vector4(GainR, GainG, GainB, GainA));
                    _effect.GetVariableByName("Gamma").AsVector().Set(new Vector4(GammaR, GammaG, GammaB, GammaA));
                    _effect.GetVariableByName("Lift").AsVector().Set(new Vector4(LiftR, LiftG, LiftB, LiftA));
                    _effect.GetVariableByName("PreSaturate").AsScalar().Set(PreSaturate);
                    _effect.GetVariableByName("Center").AsVector().Set(new Vector2(CenterX, CenterY));
                    _effect.GetVariableByName("Radius").AsScalar().Set(Radius);
                    _effect.GetVariableByName("Bias").AsScalar().Set(Bias);
                    _effect.GetVariableByName("VignetteColor").AsVector().Set(new Vector4(VignetteColorR, VignetteColorG, VignetteColorB, VignetteColorA));
                //<<< _setup

                var prevBlendState = context.BlendState;
                context.BlendState = OperatorPartContext.DefaultRenderer.DisabledBlendState;

                Render(context);

                context.BlendState = prevBlendState;

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}
