//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID90b83442_e7fd_4eeb_9275_be80a1b7f421
{
    public class Class_BlendImagesAdd : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image1 = 1,
            Image2 = 2
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            return PrepareAndEvalOnChange(context, () =>
            {
                //>>> __params
                var Code = inputs[(int)InputId.Code].Eval(context).Text;
                var Image1 = inputs[(int)InputId.Image1].Eval(context).Image; 
                var Image2 = inputs[(int)InputId.Image2].Eval(context).Image; 
                //<<< __params
                
                if (Image1 == null || Image2 == null) {
                    return;
                }

                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var Image1View = new ShaderResourceView(context.D3DDevice, Image1))
                using (var Image2View = new ShaderResourceView(context.D3DDevice, Image2))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image1").AsShaderResource().SetResource(Image1View);
                    _effect.GetVariableByName("Image2").AsShaderResource().SetResource(Image2View);
                //<<< _setup

                var prevBlendState = context.BlendState;
                context.BlendState = OperatorPartContext.DefaultRenderer.DisabledBlendState;
                Render(context);
                context.BlendState = prevBlendState;

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

