DOS_INIT	EQU #0100
DOS_READ	EQU #0112
DOS_OPEN	EQU #0106
DOS_CLOSE	EQU #0109
DOS_MOTOR_OFF	EQU #019C
DOS_SET_1346	EQU #013F
CMR0	EQU #7FFD
BANKM	EQU 23388
CHARS	EQU #5C36


LOADER_START:
	CALL	DISABLE_RAM_DISK

	LD HL, FILENAME : CALL FOPEN 
	LD C, 0 : LD DE, 6912  : LD HL, #4000 : CALL FREAD ; SCREEN
	LD C, 1 : LD DE, 9201  : LD HL, #C000 : CALL FREAD ; PAGE 1
	LD C, 3 : LD DE, 16075 : LD HL, #C000 : CALL FREAD ; PAGE 3
	LD C, 0 : LD DE, 11555 : LD HL, #C000 : CALL FREAD ; PAGE 0 
	LD C, 0 : LD DE, 21344 : LD HL, 24500 : CALL FREAD ; MAIN PART
	CALL FCLOSE
MOTOR_OFF
	LD IX, DOS_MOTOR_OFF : JR PLUS3DOS
INITDOS:
	LD IX,DOS_INIT : CALL PLUS3DOS
DISABLE_RAM_DISK:
	LD IX,DOS_SET_1346 : LD HL,0 : LD D,H : LD E,D : JR PLUS3DOS ; disable RAM DISK
SETDOS: 
	DI
	PUSH	BC
	PUSH	AF
	LD	BC,CMR0
	LD	A,(BANKM)
	RES	4,A
	OR	7
	LD	(BANKM),A
	OUT	(C),A
	POP	AF
	POP	BC
	RET
FCLOSE:
	LD B,1 : LD IX,DOS_CLOSE
	CALL PLUS3DOS
	RET 

; C - page
; DE - byte count
; HL - Address
FREAD:
	LD B,1 : LD IX,DOS_READ
	CALL PLUS3DOS
	RET 
; HL - filename
FOPEN:
	LD DE,1 : LD B,1 : LD C,1	; READ. POSITION TO DATA
	LD IX,DOS_OPEN : CALL PLUS3DOS
	RET C
ERROR:
    LD A, 2
    OUT (254), A
    DI : HALT
PLUS3DOS:
	call	SETDOS
	LD	(ADDS+1),IX
ADDS:	CALL	0
SETBASIC:
	DI
	PUSH	AF
	LD	BC,CMR0
	LD	A,(BANKM)
	SET	4,A
	AND	#0F8
	LD	(BANKM),A
	OUT	(C),A
	POP	AF
	RET
FILENAME DB "yazzie.dat", #FF
    