//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
BUFF		EQU	#BE00-768-256
DRAG_INI	EQU	5

//======================================================== FX_INIT
EFF_INI_
	LD	HL,BUFF
	LD	DE,BUFF+1
	LD	BC,767
	LD	(HL),L
	LDIR

	LD	A,#17
	CALL	PAGER
	;--
	LD	C,6
	LD	HL,#D800
	CALL	FINI00
	LD	C,5
	LD	HL,#5800
	CALL	FINI00
	LD	C,1
	LD	HL,#4400
	LD	LX,15
	LD	DE,#FFFF
	CALL	FINI0
	LD	HL,#4000
	LD	DE,#4001
	LD	BC,64
	LD	(HL),#FF
	LDIR
	RET
FINI00	LD	LX,16
	LD	DE,#0000
FINI0	LD	(SOHRSP_INI),SP
	LD	SP,HL
FINI2	LD	B,LX
FINI1	DUP	32
	PUSH	DE
	EDUP
	DJNZ	FINI1
	;-
	LD	A,D
	XOR	#FF
	LD	D,A
	LD	E,A
	;-
	DEC	C
	JP	NZ,FINI2
	;----
	LD	SP,#3131
SOHRSP_INI EQU $-2

	CALL	CUBENEXT
	
	LD	HL,FX_SWAP_PG
	LD	(IM2CALL),HL
	RET
;---------------------------------
FX_SWAP_PG
	LD	A,(FXPAGE)
	XOR	#08
	LD	(FXPAGE),A
	JP	IM2CALL_PAGER_RET
//======================================================== FX_MAINLOOP
EFF_RUN_
	EI
	HALT
	LD	A,#10
FXPAGE	EQU	$-1
	CALL	PAGER
	CALL	MAPPING1
	
	EI
	HALT
	CALL	MAPPING2


	EI
	HALT
	CALL	MAPPING3

	LD	A,(FXPAGE)
	INC	A
	CALL	PAGER
	LD	HL,CUBE_0
CUBESPR	EQU	$-2
	CALL	CUBEOUT

	EI
	HALT
	CALL	OUTBUFF

	EI
	HALT
	LD	HL,BUFF
	LD	DE,BUFF+1
	LD	BC,32*9-1
	LD	(HL),L
	LDIR
	
	
	LD	A,5
WAIT_A EQU $-1
	DEC	A
	JP	NZ,NOWAIT
	EI
	HALT
	LD	A,5
NOWAIT	LD	(WAIT_A),A

	CALL	CUBENEXT
	
	LD	A,(DRAG)
	DEC	A
	JR	NZ,NODRAG
	LD	A,5
NODRAG	LD	(DRAG),A

	RET

//======================================================== FX_PROCEDURES
MAPPING3
	LD	HL,MAPDATA+128*8+128*8
	LD	C,0+8+7
	LD	B,16+8+7
	LD	DE,BUFF+32*7 + 32*8 + 32*8
	LD	LY,1
	JR	MAPPING

MAPPING2
	LD	HL,MAPDATA+128*8
	LD	C,0+8
	LD	B,16+8
	LD	DE,BUFF+32*7 + 32*8
	LD	LY,8
	JR	MAPPING
MAPPING1
	LD	HL,MAPDATA
	LD	C,0
	LD	B,16
	LD	DE,BUFF+32*7
	LD	LY,8
	;--
MAPPING	
	LD	(SOHRSP_MAP),SP
	LD	SP,HL
	
	LD	A,DRAG_INI
DRAG	EQU	$-1
	CP	3
	JR	NC,NODRAG1
	LD	HL,32
	CP	2
	JR	Z,NODRAG2
	LD	HL,0-32
NODRAG2	ADD	HL,DE
	EX	DE,HL
NODRAG1	LD	L,B
	EXX		;4
	;---
	LD	IX,#0000 ;14
MDXY	EQU	$-2
MDX	EQU	$-2
MDY	EQU	$-1
	LD	BC,#0808
	ADD	IX,BC
	LD	DE,#C0E0 ;10
COSA	EQU	$-2
SINA	EQU	$-1
	LD	H,E	;4	COS1_1
MAP1	;---
TMP_X=0
	;-----------------
	DUP	32
	;-----------------
		POP	BC	;10
		;-----------------	координаты C=x B=y
		LD	L,C	;4
		LD	A,(HL)	;7	a=(hl)=x*cos(a)
		LD	H,D	;4	SIN1_1
		LD	L,B	;4	(hl)=y*sin(a)
		SUB	(HL)	;7	a=mx
		;-----------------
		ADD	A,LX	;8	mx+=mdx
		OR	#C0	;7
		;-----------------
		LD	L,C	;4
			LD C,A	;4
		LD	A,(HL)	;7	a=(hl)=x*sin(a)
		LD	H,E	;4	COS2_1
		LD	L,B	;4	(hl)=y*cos(a)
		ADD	A,(HL)	;7	a=my
		;-----------------
		ADD	A,HX	;8	my+=mdy
		OR	#C0	;7
			LD B,A	;4
		;-----------------
		LD	A,(BC)	;7
		;----------------- /107
		EXX		;4
		LD	B,A	;4
		EXX		;4 /12 //119
	;-------------------------
		POP	BC	;10
		;-----------------	координаты C=x B=y
		LD	L,C	;4
		LD	A,(HL)	;7	a=(hl)=x*cos(a)
		LD	H,D	;4	SIN1_1
		LD	L,B	;4	(hl)=y*sin(a)
		SUB	(HL)	;7	a=mx
		;-----------------
		ADD	A,LX	;8	mx+=mdx
		OR	#C0	;7
		;-----------------
		LD	L,C	;4
			LD C,A	;4
		LD	A,(HL)	;7	a=(hl)=x*sin(a)
		LD	H,E	;4	COS2_1
		LD	L,B	;4	(hl)=y*cos(a)
		ADD	A,(HL)	;7	a=my
		;-----------------
		ADD	A,HX	;8	my+=mdy
		OR	#C0	;7
			LD B,A	;4
		;-----------------
		LD	A,(BC)	;7
		;----------------- /107
		EXX		;4
		LD	H,A	;4
		LD	A,(BC)	;7
		OR	(HL)	;7
		LD	(DE),A	;7
		;-----
		IF TMP_X=31
			INC	DE	;6
			INC	C	;4
			INC	L	;4
		ELSE
			INC	E	;4
		ENDIF
		;-----
		EXX		;4 /37 //144		 ~=131.5 per byte
TMP_X=TMP_X+1
	;-----------------
	EDUP
	;----------------- 8426t
	DEC	LY
	JP	NZ,MAP1
	;--
	LD	SP,0
SOHRSP_MAP EQU $-2
	RET
;-------------------------------------------------------------------
CUBENEXT
	LD	A,0
CFRAMES	EQU $-1
	INC	A
	CP	161
	RET	Z
	LD	(CFRAMES),A
	CP	81
	JP	NC,CFAZE2
	;------------------
	LD	A,4
CNFRM EQU $-1
	INC	A
	CP	5
	JR	NZ,CNONEXT
	;---
	LD	A,0
STP	EQU	$-1
	XOR	16
	LD	(STP),A
	LD	H,0
	LD	L,A
	LD	(MDXY),HL
	LD	HL,CDIR_TBL
CDIR_TBL_ADR EQU $-2
	LD	A,(HL)
	INC	HL
	LD	(CURRDIR),A
	LD	(CDIR_TBL_ADR),HL
	XOR	A
CNONEXT	LD	(CNFRM),A
	ADD	A,A
	LD	D,A
	;------------------
	LD	A,0
CURRDIR	EQU	$-1
	ADD	A,A
	LD	E,A
	ADD	A,A
	ADD	A,A
	ADD	A,E
	ADD	A,D
	LD	E,A
	LD	D,0
	LD	HL,C_TBL
	ADD	HL,DE
	;--
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	(CUBESPR),DE

	LD	A,(CNFRM)
	OR	A
	RET	Z

	;--	MOVEBG
	LD	A,(CURRDIR)
	ADD	A,A
	LD	L,A
	LD	H,0
	LD	DE,BGSTEP_TBL
	ADD	HL,DE
	LD	A,(MDX)
	ADD	A,(HL)
	AND	31
	LD	(MDX),A
	INC	HL
	LD	A,(MDY)
	ADD	A,(HL)
	AND	31
	LD	(MDY),A
	RET
;-------------------------
CFAZE2	
	LD	A,1
CFZ2INI EQU $-1
	OR	A
	JP	Z,NOCFZ2INI
	LD	A,16
	LD	(MDX),A
	XOR	A
	LD	(MDY),A
NOCFZ2INI
	XOR	A
	LD	(CFZ2INI),A
	;---
	LD	HL,C_TBL2
C_TBL2_ADR EQU $-2
	LD	C,(HL)
	INC	HL
	LD	B,(HL)
	INC	HL
	LD	(CUBESPR),BC
	LD	(C_TBL2_ADR),HL
	;---
	LD	A,(CFRAMES)
	CP	135
	JR	NC,STEPY
	
	LD	A,(COSA)
	DEC	A
	AND	#1F
	OR	#C0
	LD	(COSA),A
	LD	A,(SINA)
	SUB	#E0
	DEC	A
	AND	#1F
	ADD	A,#E0
	LD	(SINA),A

	LD	A,(CFRAMES)
	LD	DE,#FCFC
	LD	L,16
	CP	81+5
	JR	C,STEPYDO
	CP	81+32
	JR	Z,STEPY0
	JR	NC,STEPY1

CFZA11	LD	A,16+3
	SUB	3
	CP	1
	JP	NZ,CFZA12
	LD	A,(MDY)
	XOR	16
	LD	(MDY),A
	LD	A,16
CFZA12	LD	(CFZA11+1),A
	ADD	A,16
	LD	(MDX),A
	RET
STEPY1	LD	A,0
	INC	A
	LD	(STEPY1+1),A
	RRA
	AND	%00111111
	LD	(ADDY2),A
	JR	STEPY
STEPY0	LD	A,16
	LD	(MDX),A
	LD	A,3
	LD	(CFZA1+1),A
STEPY	LD	DE,#0302
	LD	L,0
STEPYDO	LD	C,D
	LD	A,(CFRAMES)
	CP	135
	JP	C,CFZA1
	LD	C,E
CFZA1	LD	A,0
	ADD	A,C
	CP	16
	JP	C,CFZA2
	LD	A,(MDX)
	XOR	16
	LD	(MDX),A
	LD	A,L
CFZA2	LD	(CFZA1+1),A
	ADD	A,0
ADDY2	EQU	$-1
	AND	31
	LD	(MDY),A
	RET
;0 right
;1 down
;2 left
;3 up


;--------------------------------------
OUTBUFF
	LD	A,(FXPAGE)
	OR	#07
	CALL	PAGER
	;--
	LD	A,0
BORDER EQU $-1
	OUT	(#FE),A
	;--
	LD	HL,#5800
	LD	DE,#D800
	LD	B,PALETTE/256
	EXX
	LD	HL,BUFF
	LD	B,24
OUTBUFF1
	;-------------
	DUP	31
	;-------------
	LD	A,(HL)
	INC	L
	EXX
	LD	C,A
	;-
	LD	A,(BC)
	LD	(HL),A
	INC	L
	INC	B
	;-
	LD	A,(BC)
	LD	(DE),A
	INC	E
	DEC	B
	EXX
	;-------------
	EDUP
	;-------------
	LD	A,(HL)
	INC	HL
	EXX
	LD	C,A
	;-
	LD	A,(BC)
	LD	(HL),A
	INC	HL
	INC	B
	;-
	LD	A,(BC)
	LD	(DE),A
	INC	DE
	DEC	B
	EXX
	;-------------
	DEC	B
	JP	NZ,OUTBUFF1
	RET


CUBE_CODE
	include "bin/cube_code.asm"
CUBE_CODE_END

CUBE_DATA2
	include "bin/cube_data2.asm"
CUBE_DATA2_END

	ALIGN	256
PALETTE	include "bin/cube_palette.asm"
PALETTE_END

;--------------------------------------
	ALIGN 256
BGPAL0	DB	15,15,15,15, 14,14,13,13, 12,12,11,11, 11,11,11,11
	DB	15*16,15*16,15*16,15*16,14*16,14*16,13*16,13*16,12*16,12*16,11*16,11*16,11*16,11*16,11*16,11*16
	
CDIR_TBL
	DB	0,0,0,3
	DB	3,2,2,1
	DB	0,0,0,1
	DB	2,1,1,2
	;--
	DB	2,1,1,1
	DB	1,1,1,1
	DB	1,1,1,1
	DB	1,1,1,1,1

C_TBL
	DW	CUBE_0, CUBE_1, CUBE_2, CUBE_3, CUBE_4
	DW	CUBE_0, CUBE_6, CUBE_7, CUBE_8, CUBE_9
	DW	CUBE_0, CUBE_11, CUBE_12, CUBE_13, CUBE_14
	DW	CUBE_0, CUBE_16, CUBE_17, CUBE_18, CUBE_19
	
BGSTEP_TBL
	DB	0,-3
	DB	3,0
	DB	0,3
	DB	-3,0

;--------------------------------------
	ALIGN 256
BGPAL1	DB	13,13,12,12, 11,11,10,10, 9,9,8,8, 7,7,7,7
	DB	13*16,13*16,12*16,12*16,11*16,11*16,10*16,10*16,9*16,9*16,8*16,8*16,7*16,7*16,7*16,7*16

C_TBL2	include "bin/cubetbl2.asm"

MAPDATA	include "bin/cube_grid_map.asm"


	DISPLAY "CUBE CODE SIZE: ", /A, CUBE_CODE_END - CUBE_CODE
	DISPLAY "CUBE_DATA2 SIZE: ", /A, CUBE_DATA2_END - CUBE_DATA2
	DISPLAY "PALETTE SIZE: ", /A, PALETTE_END - PALETTE
	
	DISPLAY "BUFF: ", /A, BUFF
	DISPLAY "SOHRSP_MAP: ", /A, SOHRSP_MAP
	
	
	
	