	DEVICE	ZXSPECTRUM128
	
;====================================================
; show current muspos counter value:
; INCLUDE "debug_getstat.asm"
; JP GETSTAT
;====================================================
; Compile constant declaration
;====================================================
; LOADSTEP: 0x649E, 25758

LOW_KERNAL_BEGIN EQU	#6200	;25088
FILL_PATTERN	EQU	%01010101	;memory clear pattern for control use undefined memory values
KERNAL_4TCORR	EQU	0
;====================================================
CM_PREVIEW	EQU	0	; compile effect for preview on emulator/real
CM_DEMO		EQU	1	; compile KERNAL and FX for DEMO
MT_PENTAGON	EQU	0	; zx-hardware type
MT_ZX128	EQU	1
MT_ZX2A		EQU	2
;====================================================
T_FX_INI	EQU	0
T_FX_RUN	EQU	1
T_ASM		EQU	2
T_IM2DEMO	EQU	3
T_NEXTFAZE	EQU	4
T_DEPACK	EQU	5
T_FX_NOP	EQU	6
T_SET_INT_PROC	EQU	7
T_CLEAR_INT_PROC EQU	8
T_BLINK_ON	EQU	9
T_BLINK_OFF	EQU	10
;====================================================
; Compile parameters setup
;====================================================
	DEFINE	SHOW_BORDER_ALLOCATION	0
	DEFINE	SHOW_FRAMES	0
MACHINE_TYPE	EQU	MT_ZX2A
COMPILE_MODE	EQU	CM_DEMO	;CM_PREVIEW / CM_DEMO, fx03
	DEFINE	EFFECT	03
	;effect number for "preview/effect" compile mode
;====================================================
; Memory Pages Layout
;====================================================
PGSCR5	EQU	#15
PGSCR7	EQU	#17
PGFAST0	EQU	#10
PGFAST1	EQU	#12
	IF MACHINE_TYPE=MT_PENTAGON OR MACHINE_TYPE=MT_ZX128
PGSLOW0	EQU	#11
PGSLOW1	EQU	#13
PGFAST2	EQU	#14
PGFAST3	EQU	#16
	ENDIF
	IF MACHINE_TYPE=MT_ZX2A
PGSLOW0	EQU	#11
PGSLOW1	EQU	#13
PGFAST2	EQU	#14
PGFAST3	EQU	#16
	ENDIF
;====================================================
;	CONST
;====================================================
VAR_STACK	EQU	#BEFF
MUS_PAGE	EQU	#16
;====================================================
;	LOW MEMORY KERNAL (LOW_KERNAL)
;====================================================
		;clear
		ORG	LOW_KERNAL_BEGIN
		DS	#C000 - LOW_KERNAL_BEGIN, FILL_PATTERN
		;compile
		ORG	LOW_KERNAL_BEGIN
		JP	MAIN_DEMO
;====================================================
;	KERNAL ROUTINES (JUMP TABLE)
;====================================================
DEPACK_PL5	JP	DEPACK_PL5_
CLEAR_RGB	JP	CLEAR_RGB_
BLINK_ON	JP	COMM_BLINK_ON_
BLINK_OFF	JP	COMM_BLINK_OFF_
LOADSTEP	JP	LOADSTEP_
;====================================================
;	VARIABLES
;====================================================
EFF_FAZE	DB	0
FRAMES_QTY	DB	0
;====================================================
;	DEMO STARTUP PROCEDURE
;====================================================
MAIN_DEMO
	LD	(DEMOSP),SP
	//------ kernal initialization
	CALL	CLEAR_RGB_
	CALL	MUSIC_OFF
MAIN_DEMO2 //-------
	DI
	LD	SP,VAR_STACK
	CALL	MUSIC_INIT
	IF KERNAL_4TCORR = 1
	  CALL	IM2CORR
	  CALL	INTCORR
	ELSE
	  CALL	IM2DEMO
	ENDIF
	//----- main loop procedure
	LD	IY,EFFTABLE
EFFTABLE_IY EQU $-2
MLOOP	LD	A,(IY)
	INC	IY
	ADD	A,A
	LD	C,A
	LD	B,0
	LD	HL,COMMTBL	;    
	ADD	HL,BC
	LD	E,(HL)
	INC	L
	LD	D,(HL)
	EX	DE,HL
	LD	DE,MLOOP1
	PUSH	DE
	JP	(HL)		; CALL
MLOOP1	JP	MLOOP

;====================================================
; ROUTINES
;====================================================
COMM_DEPACK
	LD	A,(IY)
	INC	IY
	LD	E,(IY)
	INC	IY
	LD	D,(IY)
	INC	IY
	EX	DE,HL
	LD	E,(IY)
	INC	IY
	LD	D,(IY)
	INC	IY	
	PUSH	IY
	CALL	PAGER
	CALL	DEPACK_PL5_
	POP	IY
	RET
COMM_INI //---------------
	PUSH	IY
	CALL	EFF_INI
	POP	IY
	RET
COMM_NEXTFAZE
	LD	HL,EFF_FAZE
	INC	(HL)
	JP	COMM_E2
COMM_EXE //---------------
	XOR	A
	LD	(EFF_FAZE),A
COMM_E2	LD	E,(IY)
	INC	IY
	LD	D,(IY)
	INC	IY
	PUSH	IY
COMM_E1	PUSH	DE
	CALL	EFF_RUN
	POP	DE
	LD	HL,(MUSPOS)
	AND	A
	SBC	HL,DE
	JP	C,COMM_E1
	POP	IY
	LD	A,#10
	CALL	PAGER
	RET
COMM_NOP //---------------
	LD	E,(IY)
	INC	IY
	LD	D,(IY)
	INC	IY
COMM_NOP1
	LD	HL,(MUSPOS)
	AND	A
	SBC	HL,DE
	JP	C,COMM_NOP1
	RET
COMM_ASM //-------------   
	PUSH	IY
	POP	HL
	JP	(HL)
	;   :
	;	
	;	LD	IY,$+5
	;	RET
;------
COMM_SET_INT_PROC
	LD	E,(IY)
	INC	IY
	LD	D,(IY)
	INC	IY
	LD	(IM2CALL),DE
	RET
;------
COMM_CLEAR_INT_PROC
	LD	HL,IM2CALL_RET
	LD	(IM2CALL),HL
	RET
;------
DEPACK_PL5_
	PUSH	IY
	CALL	DEPACK_PL5_CODE
	POP	IY
	RET
DEPACK_PL5_CODE
	INCLUDE "system/unpack/unpletter5d_fast_v1.asm"
;-----------------------
BLINK_ATTR_5
	LD	LX,7*8+7
	JR	FILL_ATTR_5
CLEAR_ATTR_5
	LD	LX,0
FILL_ATTR_5
	EI
	HALT
	LD	A,#17
	CALL	PAGER
	LD	A,LX
	LD	HL,#5800
	LD	(HL),A
	AND	7
	OUT	(#FE),A
FILL_ATTR_
	LD	D,H
	LD	E,L
	INC	DE
	LD	BC,767
	LDIR
	RET
;-----------------------
CLEAR_BLINK
	LD	IX,256*(7*8+7)
	JR	FILL_ATTR	
;-----------------------
CLEAR_RGB_
COMM_BLINK_OFF_
	LD	IX,0
	JR	FILL_ATTR
;-----------------------
COMM_BLINK_ON_
	LD	IX,256*(7*8+7) + 7*8+7
;-----------------------
FILL_ATTR
;in LX = #5800 HX = #D800
	CALL	FILL_ATTR_5
	LD	A,HX
	LD	HL,#D800
	LD	(HL),A
	JR	FILL_ATTR_
;-----------------------------
COMMTBL //---
	DW	COMM_INI	;0 init fx
	DW	COMM_EXE	;1 execute fx
	DW	COMM_ASM	;2   
	DW	IM2DEMO		;3  
	DW	COMM_NEXTFAZE	;4      
	DW	COMM_DEPACK	;5   
	DW	COMM_NOP	;6 nop
	DW	COMM_SET_INT_PROC ;7
	DW	COMM_CLEAR_INT_PROC ;8
	DW	COMM_BLINK_ON_
	DW	COMM_BLINK_OFF_
;====================================================
LOADSTEP_
	LD	A,#14
	CALL	PAGER
	JP	LOADSTEP_DO
;====================================================
;	MUSIC PLAYER
;====================================================
	INCLUDE	"music/player_direct1.asm"
;====================================================
;	TIMELINE
;====================================================
EFFTABLE
	IF COMPILE_MODE=CM_PREVIEW
		INCLUDE effects/EFFECT/_timeline.asm
	ENDIF
	IF  COMPILE_MODE=CM_DEMO
		INCLUDE timeline.asm
	ENDIF
;-------------
LOW_KERNAL_END	EQU	$
LOW_KERNAL_SIZE	EQU	LOW_KERNAL_END-LOW_KERNAL_BEGIN
;====================================================
; EFFECT CODE SECTION
;====================================================
	ORG	#8000
EFF_BEGIN
//-----------
	IF COMPILE_MODE=CM_PREVIEW
		INCLUDE	effects/EFFECT/effect.asm
	ELSE
		INCLUDE	effects/EFFECT/effect.asm
	ENDIF
//-----------
EFF_END
EFF_SIZE	EQU	EFF_END-EFF_BEGIN
;====================================================
; High memory kernal (HIGH_KERNAL)
;====================================================
//       INT_ROUTINES
	ORG	#BF01
HI_KERNAL_BEGIN
PAGER	LD	BC,#7FFD
	LD	(PAGE),A
	OUT	(C),A
	RET
;-------------------------------------
IM2EXEC
	DI			;4 /4
	;-------------------------
	PUSH	HL,DE,BC,AF	;44
	EX	AF,AF		;4
	PUSH	AF		;11 /59
	;-------------------------
		IF (SHOW_FRAMES)
		  LD	HL,FRAMES_QTY
		  INC	(HL)
		ENDIF
	;-------------------------
	LD	HL,0		;10
MUSPOS	EQU	$-2
	INC	HL		;6
	LD	(MUSPOS),HL	;16 /32
	;-------------------------
	LD	A,MUS_PAGE	;7
IM2MPLPAGE EQU	$-1
	LD	BC,#7FFD	;10
	OUT	(C),A		;12
	CALL	IM2RET		;17 /46 + mus_play_takts
IM2MPLADR EQU	$-2
	;-------------------------
	JP	IM2CALL_RET	;10 /10
IM2CALL	EQU	$-2
IM2CALL_RET
	;-------------------------
	LD	A,0		;7
PAGE	EQU	$-1
IM2CALL_PAGER_RET
	LD	BC,#7FFD	;10
	OUT	(C),A		;12 /29
	;-------------------------
	POP	AF		;10
	EX	AF,AF		;4
	POP	AF,BC,DE,HL	;40 /54
	;-------------------------
	EI			;4
IM2RET	RET			;10 /14 //248 + mus_play_takts
;--------------------------------------------
IM2DEMO DI
	LD	A,#BE	;    INT
	LD	I,A
	IM	2
	LD	HL,IM2EXEC
	LD	(#BEFF),HL
	RET
;--------------------------------------------
IM1SET	DI
	LD	HL,#2758
	EXX
	LD	IY,#5C3A
	LD	A,#3F
	LD	I,A
	IM	1
	RET
;--------------------------------------
MUSIC_OFF
	LD	E,15
	XOR	A
MUSIC_OFF_LP
	LD	BC,#FFFD
	OUT	(C),E
	LD	B,#BF
	OUT	(C),A
	DEC	E
	JP	NZ,MUSIC_OFF_LP
	RET
;--------------------------------------
MUSIC_ON
	LD	A,MUS_PAGE
	LD	(IM2MPLPAGE),A
	LD	HL,MUS_PLAY
	LD	(IM2MPLADR),HL
	LD	HL,0
	LD	(MUSPOS),HL
	RET
;--------------------------------------
MUSIC_INIT
	LD	A,MUS_PAGE
	CALL	PAGER
	LD	HL,#C000
	JP	MUS_INIT
;--------------------------------------
DEMOSP	DW	0
;----------------------------------------------------
	IF	KERNAL_4TCORR = 1
;---------
IM2CORR	DI
	LD	A,#BE	;    INT
	LD	I,A
	IM	2
	LD	HL,IM2CORR_
	LD	(#BEFF),HL
	RET
;  int`   
;   6 ! (   3)
;  2  - :
; 1- -    IMER   INT,
; 2- -   D.
INTCORR LD BC,#6FF
	DI
	LD	HL,IM2CORR_
	LD	(#BEFF),HL
IM2BACK	XOR	A
	LD	HL,IM2LOOP ;+2t
	EI
IM2LOOP	DEC	A
	JP	(HL)
	;-1t (INT=11t)
IM2CORR_
	POP	HL	;+2t
	LD	E,(HL)	;-1t
	RL	E	;"JP (HL)">128
	RLA
	LD	E,D
	LD	D,A
	SUB	E
	SUB	C	;   D?
	SBC	A,A
	OR	4	;-1t 4=EXIT,#FF=NO EXIT
	DEC	B	; +1   
	AND	B	;  NO EXIT
	JR	NZ,IM2BACK
	;--
	LD	HL,IM2EXEC	;10
	LD	(#BEFF),HL	;16
	RET			;10 /36
;------------
	ENDIF
;----------------------------------------------------

HI_KERNAL_END
;====================================================
;	INFO
;====================================================
	DISPLAY	"--------------------------------"
	DISPLAY	"LOW_KERN BEGIN: ",/A,#6400
	DISPLAY	"LOW_KERN END: ",/A,LOW_KERNAL_END
	DISPLAY	"LOW_KERN SIZE: ",/A,LOW_KERNAL_SIZE
	DISPLAY	"LOW_KERN FREE: ",/A, (#8000-LOW_KERNAL_END)
	DISPLAY	"HI_KERN END: ",/A,HI_KERNAL_END," (#BFBF max)"
	DISPLAY	"--------------------------------"
	DISPLAY	"EFFECT END: ", /A, EFF_END
	DISPLAY	"EFFECT SIZE: ", /A, EFF_SIZE
	DISPLAY	"EFFECT FREE: ", /A, (#BE00 - EFF_END)
	DISPLAY	"--------------------------------"
	DISPLAY "LOADSTEP: ", /A, LOADSTEP
	DISPLAY	"--------------------------------"

;====================================================
;	SAVE FX BINARY CODE & TRY TO COMPRESS
;====================================================
	SAVEBIN	"compile/effect.bin", #8000, EFF_SIZE
;====================================================
;	SAVE PREVIEW
;====================================================
	IF COMPILE_MODE = CM_PREVIEW
	;--------------------------
LOADSTEP_DO	EQU	#FFFF
		;--------------------------
		DISPLAY	"PREVIEW EFFECT: ", EFFECT
		DISPLAY " "
		;--------------------------
		EMPTYTRD "demo.trd"
		EMPTYTAP "demo.tap"
		
		;----------------------------------------- basic
		ORG	#4000
		INCBIN "bin/basic_tap_prev.bin"
		SAVETAP "demo.tap", BASIC, "PREV", #4000, $-#4000, 10
		
		;----------------------------------------- kernal.low + effect + kernal.hi
		SAVETRD "demo.trd", "EFFECT.C", LOW_KERNAL_BEGIN, #C000 - LOW_KERNAL_BEGIN
		SAVETAP "demo.tap", CODE, "EFFECT", LOW_KERNAL_BEGIN, #C000 - LOW_KERNAL_BEGIN
		;----------------------------------------- page 0
		ORG	#C000
		DS	16384, FILL_PATTERN
		INCLUDE	effects/EFFECT/eff_page0.asm
		IF $-PG0_BEGIN > 0
			SAVETRD "demo.trd", "PAGE0.C", PG0_BEGIN, $-PG0_BEGIN
			SAVEBIN	"compile/pg0.bin", PG0_BEGIN, $-PG0_BEGIN
		ENDIF
		IF $ = PG0_BEGIN
		  DEFINE PG0_END $
		ELSE
		  DEFINE PG0_END $-1
		ENDIF
		SAVETAP "demo.tap", CODE, "PAGE0", PG0_BEGIN, #FFFF-PG0_BEGIN+1
		DISPLAY "PAGE_0: ", PG0_BEGIN, "..", PG0_END, "  ", /D, PG0_BEGIN, "..", /D, PG0_END, "\tSIZE: ", /A, ($-PG0_BEGIN)
		;----------------------------------------- page 1
		ORG	#C000
		DS	16384, FILL_PATTERN
		INCLUDE	effects/EFFECT/eff_page1.asm
		IF $-PG1_BEGIN > 0
			SAVETRD "demo.trd", "PAGE1.C", PG1_BEGIN, $-PG1_BEGIN
			SAVEBIN	"compile/pg1.bin", PG1_BEGIN, $-PG1_BEGIN
		ENDIF
		IF $ = PG1_BEGIN
		  DEFINE PG1_END $
		ELSE
		  DEFINE PG1_END $-1
		ENDIF
		SAVETAP "demo.tap", CODE, "PAGE1", PG1_BEGIN, #FFFF-PG1_BEGIN+1
		DISPLAY "PAGE_1: ", PG1_BEGIN, "..", PG1_END, "  ", /D, PG1_BEGIN, "..", /D, PG1_END, "\tSIZE: ", /A, ($-PG1_BEGIN)
		;----------------------------------------- page 7
		ORG	#C000
		DS	16384, FILL_PATTERN
		INCLUDE	effects/EFFECT/eff_page7.asm
		IF $-PG7_BEGIN > 0
			SAVETRD "demo.trd", "PAGE7.C", PG7_BEGIN, $-PG7_BEGIN
			SAVEBIN	"compile/pg7.bin", PG7_BEGIN, $-PG7_BEGIN
		ENDIF
		IF $ = PG7_BEGIN
		  DEFINE PG7_END $
		ELSE
		  DEFINE PG7_END $-1
		ENDIF
		SAVETAP "demo.tap", CODE, "PAGE7", PG7_BEGIN, #FFFF-PG7_BEGIN+1
		DISPLAY "PAGE_7: ", PG7_BEGIN, "..", PG7_END, "  ", /D, PG7_BEGIN, "..", /D, PG7_END, "\tSIZE: ", /A, ($-PG7_BEGIN)
		;----------------------------------------- page music
		ORG	#C000
		DS	16384, FILL_PATTERN
		ORG	#C000
		INCBIN	"music/nq-tiratok-28-part1-tmk1.psg.packed"
		SAVETRD "demo.trd", "MUSIC.C", #C000, $-#C000
		SAVEBIN "compile/music.bin", #C000, $-#C000
		SAVETAP "demo.tap", CODE, "MUSIC", #C000, $-#C000
		;----------------------------------------- basic
		ORG	#8000
		DS	2048,0
		ORG	#8000
		INCBIN "bin/basic_trdos_prev.bin"
		SAVETRD "demo.trd", "PREVIEW.B", #8000, $-#8000
		DISPLAY " "
		DISPLAY	"--------------------------------"
	ENDIF

;====================================================
;	SAVE DEMO
;====================================================
	IF COMPILE_MODE=CM_DEMO
		DISPLAY "MUS_PAGE: ", /A, MUS_PAGE
	
		EMPTYTRD "demo.trd"
		EMPTYTAP "demo.tap"
		
		ORG	#C000
		DS	16384,0
		ORG	#C000
		INCBIN "bin/basic_trdos_demo.bin"
		SAVETRD "demo.trd","TIRATOK.B",#C000,$-#C000

		ORG	#C000
		DS	16384,0
		ORG	#C000		
		IF MACHINE_TYPE = MT_ZX128
		  INCBIN "bin/basic_zx128_demo.bin"
		  SAVETAP "demo.tap", BASIC, "TIRATOK", #C000, $-#C000, 10
		ENDIF
		IF MACHINE_TYPE = MT_ZX2A
		  INCBIN "bin/basic_zx128_demo.bin"
		  SAVETAP "demo.tap", BASIC, "TIRATOK", #C000, $-#C000, 10
		ENDIF
		
		DISPLAY "---------------------------- SAVE KERNAL"

		SAVEBIN "compile/effect.bin", EFF_BEGIN, EFF_END - EFF_BEGIN
		SAVEBIN "compile/kernal_low.bin", LOW_KERNAL_BEGIN, LOW_KERNAL_END - LOW_KERNAL_BEGIN
		SAVEBIN "compile/kernal_hi.bin", HI_KERNAL_BEGIN, HI_KERNAL_END - HI_KERNAL_BEGIN
		
		SHELLEXEC "kernal_loader.bat"
		
		ORG	#C000
		DI
		PUSH	IY
		LD	HL,K_LOW
		LD	DE,LOW_KERNAL_BEGIN
		CALL	DEPACK_MLZ
		LD	HL,K_HI
		LD	DE,HI_KERNAL_BEGIN
		CALL	DEPACK_MLZ
		LD	HL,K_EFFECT
		LD	DE,EFF_BEGIN
		CALL	DEPACK_PL5
		POP	IY
		RET
DEPACK_MLZ	INCLUDE "system/unpack/unmegalz_small_v2.asm"
K_LOW		INCBIN "compile/kernal_low.bin.mlz"
K_LOW_END
K_HI		INCBIN "compile/kernal_hi.bin.mlz"
K_HI_END
K_EFFECT	INCBIN "compile/effect.bin.pl5d"
K_EFFECT_END
		SAVETRD "demo.trd", "2.C", #C000, $ - #C000
		SAVETAP "demo.tap", CODE, "2", #C000, $ - #C000
		
		DISPLAY "---------------------------- pages part 1"
		
		ORG	#DB00
		INCLUDE "page07.asm"
		SAVETRD "demo.trd", "7.C", #DB00, $-#DB00
		SAVETAP "demo.tap", CODE, "7", #DB00, $-#DB00
		DISPLAY "PAGE_7_END: ", /A, $
		DISPLAY "PAGE_7_FREE: ", /A, #FFFF - $
		DISPLAY "----------------------------"
		
		;ORG	#C000
		;INCLUDE "page00.asm"
		;SAVETRD "demo.trd", "0.C", #C000, $-#C000
		;DISPLAY "PAGE_0_END: ", /A, $
		;DISPLAY "PAGE_0_FREE: ", /A, #FFFF - $
		;DISPLAY "----------------------------"
		
		ORG	#C000
		INCLUDE "page01.asm"
		SAVETRD "demo.trd", "1.C", #C000, $-#C000
		SAVETAP "demo.tap", CODE, "1", #C000, $-#C000
		DISPLAY "PAGE_1_END: ", /A, $
		DISPLAY "PAGE_1_FREE: ", /A, #FFFF - $
		DISPLAY "----------------------------"
		
		ORG	#C000
		INCLUDE "page03.asm"
		SAVETRD "demo.trd", "3.C", #C000, $-#C000
		SAVETAP "demo.tap", CODE, "3", #C000, $-#C000
		DISPLAY "PAGE_3_END: ", /A, $
		DISPLAY "PAGE_3_FREE: ", /A, #FFFF - $
		DISPLAY "----------------------------"
		
		ORG	#C000
		INCLUDE "page04.asm"
		SAVETRD "demo.trd", "4.C", #C000, $-#C000
		SAVETAP "demo.tap", CODE, "4", #C000, $-#C000
		DISPLAY "PAGE_4_END: ", /A, $
		DISPLAY "PAGE_4_FREE: ", /A, #FFFF - $
		DISPLAY "----------------------------"

		ORG	#C000
		INCLUDE "page06.asm"
		SAVETRD "demo.trd", "6.C", #C000, $-#C000
		SAVETAP "demo.tap", CODE, "6", #C000, $-#C000
		DISPLAY "PAGE_6_END: ", /A, $
		DISPLAY "PAGE_6_FREE: ", /A, #FFFF - $

		;-------------- PART 2
		DISPLAY "---------------------------- pages part 2"
		
		
		ORG	#C000
		INCLUDE "page13.asm"
		SAVETRD "demo.trd", "13.C", #C000, $-#C000
		SAVETAP "demo.tap", CODE, "13", #C000, $-#C000
		DISPLAY "PAGE_13_END: ", /A, $
		DISPLAY "PAGE_13_FREE: ", /A, #FFFF - $
		DISPLAY "----------------------------"
		
		ORG	#C000
		INCLUDE "page11.asm"
		SAVETRD "demo.trd", "11.C", #C000, $-#C000
		SAVETAP "demo.tap", CODE, "11", #C000, $-#C000
		DISPLAY "PAGE_11_END: ", /A, $
		DISPLAY "PAGE_11_FREE: ", /A, #FFFF - $
		DISPLAY "----------------------------"

		ORG	#C000
		INCLUDE "page16.asm"
		SAVETRD "demo.trd", "16.C", #C000, $-#C000
		SAVETAP "demo.tap", CODE, "16", #C000, $-#C000
		DISPLAY "PAGE_16_END: ", /A, $
		DISPLAY "PAGE_16_FREE: ", /A, #FFFF - $
		DISPLAY "----------------------------"
		
		ORG	#DB00
		INCLUDE "page17.asm"
		SAVETRD "demo.trd", "17.C", #DB00, $-#DB00
		SAVETAP "demo.tap", CODE, "17", #DB00, $-#DB00
		DISPLAY "PAGE_17_END: ", /A, $
		DISPLAY "PAGE_17_FREE: ", /A, #FFFF - $
		DISPLAY "----------------------------"

		ORG	#C000
		INCLUDE "page10.asm"
		SAVETRD "demo.trd", "10.C", #C000, $-#C000
		SAVETAP "demo.tap", CODE, "10", #C000, $-#C000
		DISPLAY "PAGE_10_END: ", /A, $
		DISPLAY "PAGE_10_FREE: ", /A, #FFFF - $
		DISPLAY "----------------------------"
		

	ENDIF
