//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
OUTBUFF_W	EQU	74*2+2	+37
NOISE_W		EQU	74*6+6
OUTCIRC_W	EQU	30+16*3-5

SIZE_Y		EQU	48
CIRC_QTY	EQU	10
OUTCIRC_BC	EQU	64-12

TBL_NOISE	EQU	#7D00
TBL_BUFF	EQU	#7E00
TBL_ATTR	EQU	#7F00
//======================================================== FX_INIT
EFF_INI_
	LD	A,#17
	CALL	PAGER
	LD	HL,#4000
	CALL	FILLSCR_SLOW	
	LD	HL,#C400
	CALL	FILLSCR_SLOW

;---------------------------- make tbl attr
INI_ATTR	
	LD	DE,#5800
	LD	BC,32
	LD	HL,TBL_ATTR
	LD	A,24
INI_ATTR_1
	LD	(HL),E
	INC	L
	LD	(HL),D
	INC	L
	SET	7,D
	LD	(HL),E
	INC	L
	LD	(HL),D
	INC	L
	RES	7,D
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
	DEC	A
	JP	NZ,INI_ATTR_1
;---------------------------- make tbl buff
	LD	DE,BUFF + 16
	LD	BC,64
	LD	HL,TBL_BUFF
	LD	A,48
INI_BUFF_1
	LD	(HL),E
	INC	L
	LD	(HL),D
	INC	L
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
	DEC	A
	JP	NZ,INI_BUFF_1
;---------------------------- make tbl noise	
	LD	HL,TBL_NOISE
INI_NOISE_1
	CALL	GET_RANDOM
	LD	C,0
	CP	48
	JP	NC,INI_NOISE_2
	LD	C,#01
INI_NOISE_2
	CALL	GET_RANDOM
	CP	200
	LD	A,#00
	JP	C,INI_NOISE_3
	LD	A,#10
INI_NOISE_3
	OR	C
	LD	(HL),A
	;---
	INC	L
	JP	NZ,INI_NOISE_1
	;---
	RET
;-----------------------------
;------- fillscr
FILLSCR_SLOW
	LD	LX,3
	LD	D,H
	LD	E,L
	INC	E
FILLSCRS1
	LD	(HL),#F0
	LD	BC,256*4-1
	LDIR
	INC	HL
	INC	DE
	LD	A,H
	ADD	A,4
	LD	H,A
	LD	A,D
	ADD	A,4
	LD	D,A
	DEC	LX
	JP	NZ,FILLSCRS1
	RET
//======================================================== FX_MAINLOOP
EFF_RUN_
	EI
	HALT
	CALL	OUTBUFF
	CALL	SYNC

	EI
	HALT
	CALL	NOISE
	CALL	ROTATE

	EI
	HALT
	LD	HL,CIRC_TBL
	CALL	OUTCIRC

	EI
	HALT
	LD	HL,CIRC_TBL + 5*4
	CALL	OUTCIRC

	RET
//======================================================== FX_PROCEDURES
GET_RANDOM
	LD  A,137
SEED	EQU	$-1
	LD	B,A
	ADD	A,A
	XOR	B
	LD	B,A
	SRL	A
	XOR	B
	LD	B,A
	ADD	A,A
	ADD	A,A
	XOR	B
	LD	(SEED),A
	RET
;---------------------------
NOISE_ADD EQU 34
NOISE_ADD2 EQU 63
NOISE
	LD	BC,NOISE_W
W2	DEC	BC
	LD	A,B
	OR	C
	JP	NZ,W2 ;24
	
	LD	A,#17
	CALL	PAGER
	
	;-------------------------
	LD	(NOISE_SOHR_SP),SP
	;--
	CALL	GET_RANDOM
	AND	#1F
	LD	H,A
	CALL	GET_RANDOM
	LD	L,A
	LD	SP,HL
	;--
	LD	D,TBL_NOISE / 256
	;------------------------- fill right char
	LD	HL,BUFF + 16 + 31
	LD	LX,48
NOISE2	;---
	POP	BC	;10
	LD	E,C	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4
	LD	E,B	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7 /50
	LD	BC,NOISE_ADD2
	ADD	HL,BC
	DEC	LX
	JP	NZ,NOISE2
	;-------------------------
	LD	HL,BUFF + 16
	EXX
	LD	BC,#7FFD
	LD	DE,#1F17
	LD	L,24
NOISE1	EXX			; /=>869
	;----
	DUP	15
	;----
	POP	BC	;10
	LD	E,C	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4
	LD	E,B	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4 /54 * 15 = 810
	;----
	EDUP
	;----
	POP	BC	;10
	LD	E,C	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7 /28
	;----
	NOP
	
	LD	BC,NOISE_ADD	;10
	ADD	HL,BC	;15 /25 /=>835
	;----
	EXX		;4
	OUT	(C),E	;12
	EXX		;4 /20 /=>855
	;----------------
	DUP	15
	;----
	POP	BC	;10
	LD	E,C	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4
	LD	E,B	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4 /54 * 15 = 810
	;----
	EDUP
	;----
	POP	BC	;10
	LD	E,C	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7 /28

	NOP:NOP:NOP:NOP
	;----
	LD	BC,NOISE_ADD	;10
	ADD	HL,BC	;15 /25 /=>835
	;----
	EXX		;4
	OUT	(C),D	;12 /16 /=>851
	;----
	DEC	L	  ;4
	JP	NZ,NOISE1 ;10 /14 /=>865
	;----
	LD	SP,0
NOISE_SOHR_SP EQU $-2
	RET

;-869 27free
;-855 41free



;------------------------------------------------
OUTCIRC_END
	LD	SP,0
OUTCIRC_SOHR_SP EQU $-2
	RET
OUTCIRC	;------------------------
	NOP
	LD	A,OUTCIRC_W
	DEC	A
	JP	NZ,$-1
	;--
	LD	(OUTCIRC_SOHR_SP),SP
	LD	SP,HL
CIRC_TBL_ADR EQU $-2
	LD	BC,OUTCIRC_BC
	EXX
	LD	BC,#7FFD
	LD	A,#17+#08
	OUT	(C),A
	EX	AF,AF
	
	LD	DE,#0806
	LD	HL,#0D0D
OUTCIRCNEXT
	DEC	E		;4
	JR	Z,OUTCIRC_END	;7
	LD	L,H	;4
	EXX		;4
	POP	HL	;10
	POP	DE	;10
	LD	LX,13	;11 /50 ////=> 896
OUTCIRCLP ;------------------------
	DUP	2
	;---
	DUP	6
	;---
	LD	A,(DE)	;7
	OR	(HL)	;7
	LD	(HL),A	;7
	INC	E	;4
	INC	L	;4 /29
	;-
	LD	A,(DE)	;7
	OR	(HL)	;7
	LD	(HL),A	;7
	INC	DE	;6
	INC	L	;4 /31 //60 /=> 360
	;---
	EDUP
	;---
	LD	A,(DE)	;7
	OR	(HL)	;7
	LD	(HL),A	;7
	INC	E	;4
	INC	DE	;6 /31
	;----
	ADD	HL,BC	;15 next line /=> 402
	;---
	EDUP
	;--- //=>804
	EXX		;4
	EX	AF,AF	;4
	XOR	D	;4
	OUT	(C),A	;12
	EX	AF,AF	;4 /28 /=>832
	;--
	DEC	L		;4
	JP	Z,OUTCIRCNEXT	;10 /14 /=>846
	;------------------------
	;w36
	LD A,R:LD A,R:LD A,R:LD A,R
	;--
	EXX			;4
	JP	OUTCIRCLP	;10 /14 /=>860
;----------------------------------------
FX_BLINK
	LD	HL,#5800
	LD	DE,#5801
	LD	(HL),7*8+7
	LD	BC,767
	LDIR
	LD	HL,#5800
	LD	DE,#D800
	LD	BC,768
	LDIR
	XOR	A
	LD	(BORDER),A
	RET
;----------------------------------------
OUTBUFF	
	LD	A,#17
	CALL	PAGER
	;---
	LD	A,7
BORDER	EQU	$-1
	OUT	(#FE),A
	CP	7
	JR	Z,FX_BLINK
	;---
	LD	BC,OUTBUFF_W
W1	DEC	BC
	LD	A,B
	OR	C
	JP	NZ,W1 ;24
	;-----------------------
	LD	(OUTBUFF_SOHR_SP),SP
	;----------------------- out right char column
	LD	HL,BUFF + 31 + 16
	LD	DE,#581F
	LD	LX,24
OUTBUFF4	
	LD	B,PAL / 256
	LD	A,(HL)
	LD	C,A
	LD	A,(BC)
	LD	(DE),A
	LD	BC,64
	ADD	HL,BC
	SET	7,D
	;-
	LD	B,PAL / 256
	LD	A,(HL)
	LD	C,A
	LD	A,(BC)
	LD	(DE),A
	LD	BC,64
	ADD	HL,BC
	RES	7,D
	EX	HL,DE
	LD	BC,32
	ADD	HL,BC
	EX	HL,DE
	DEC	LX
	JP	NZ,OUTBUFF4
	;----------------------- make ATTR ADR
	LD	HL,BUFF + 32 + 16
	LD	DE,TBL_ATTR + 2
	LD	BC,63
	LD	LX,SIZE_Y
OUTBUFF2 ;---
	LD	A,(DE)
	LD	(HL),A
	INC	E
	INC	L
	LD	A,(DE)
	LD	(HL),A
	INC	E
	ADD	HL,BC
	DEC	LX
	JP	NZ,OUTBUFF2
	;----------------------- make BUFF ADR
	LD	HL,BUFF + 34 + 16
	LD	DE,TBL_BUFF + 2
	LD	BC,63
	LD	LX,SIZE_Y
OUTBUFF3 ;---
	LD	A,(DE)
	LD	(HL),A
	INC	E
	INC	L
	LD	A,(DE)
	LD	(HL),A
	INC	E
	ADD	HL,BC
	DEC	LX
	JP	NZ,OUTBUFF3
OUTBUFF_MAIN	;-----------------------
	LD	BC,#7FFD	;7FFD
	LD	DE,#1F17	;171F
	EXX
	LD	SP,BUFF + 16
	LD	DE,#5800
	LD	B,PAL / 256
	LD	LX,24
OUTBUFF1 ;-----
	DUP	15
	;-----
	POP	HL	;10
	LD	C,L	;4
	LD	A,(BC)	;7
	LD	(DE),A	;7
	INC	E	;4
	LD	C,H	;4
	LD	A,(BC)	;7
	LD	(DE),A	;7
	INC	E	;4 /54 * 15 = 810
	;-----
	EDUP
	;-----
	POP	HL	;10
	LD	C,L	;4
	LD	A,(BC)	;7
	LD	(DE),A	;7 /28 /=>838
XXX	;-
	POP	DE	;10
	POP	HL	;10
	LD	SP,HL	;6 /26 /=> 864
	;-
	EXX		;4
	OUT	(C),E	;12
	  DEC HL	;wait6
	EXX		;4 /20 /=>884 ;12free
	;---------------------
	DUP	15
	;-----
	POP	HL	;10
	LD	C,L	;4
	LD	A,(BC)	;7
	LD	(DE),A	;7
	INC	E	;4
	LD	C,H	;4
	LD	A,(BC)	;7
	LD	(DE),A	;7
	INC	E	;4 /54 * 15 = 810
	;-----
	EDUP
	;-----
	POP	HL	;10
	LD	C,L	;4
	LD	A,(BC)	;7
	LD	(DE),A	;7 /28 /=>838
	;-
	POP	DE	;10
	POP	HL	;10
	LD	SP,HL	;6 /26 /=> 864
	;-
	EXX		;4
	OUT	(C),D	;12
	EXX		;4 /20 /=>884 ;12free
	;-
	DEC	LX	    ;8
	JP	NZ,OUTBUFF1 ;10 /18
	;-----
	LD	SP,0
OUTBUFF_SOHR_SP EQU $-2
	RET
;--------------------------------------
; Начальные координаты точек хранятся в формате 
; X=X+COR_Z 
; Y=Y+COR_Z 
; Z=Z+COR_Z 
; (т.е. с прибавленным смещением до начала таблиц)
;---------------------------------------- 
; Диапазон изменения угла вращения 0..127 
; Поворот осуществляется вокруг осей Ox,Oy 
; по адресу Ay - угол вращения вокруг Oy 
; по адресу Ax - угол вращения вокруг Ox
;---------------------------------------- 
; Таблица произведений: 
;        #C000          +128	   +212	
;        +--------------+----------+----------+ 
;   Coord| Coord*cos(A) | projectY | projectX | Z
;        +--------------+----------+----------+ 
;        Alpha          
;---------------------------------------- 
; Формулы вращения 
;-Ox: 
; y` = y*cos(Ax) - z*sin(Ax) 
; z` = y*sin(Ax) + z*cos(Ax) 
;-Oy: 
; x` = x*cos(Ay) + z*sin(Ay) 
; z` = z*cos(Ay) - x*sin(Ay)

XYZMAX	EQU	21	; максимальная длина по осям (в одну сторону) 
COR_TBL	EQU	#C0
COR_Z	EQU	COR_TBL + XYZMAX 
PROJ_PY EQU	128	;#80
PROJ_PX EQU	212	;#D4

CSDIV	EQU	COR_TBL + XYZMAX*2

COS_AX	EQU	0
SIN_AX	EQU	COS_AX + 32
COS_AY	EQU	0
SIN_AY	EQU	COS_AY + 32


ANGLE_AX_STEP	EQU  896;700;796;896
ANGLE_AY_STEP	EQU  384;300;341;384


ROTATE	;------------------------
	LD	A,#18
	CALL	PAGER
	;-----------------------
	LD	HL,0
ANGLE_AX EQU $-2
	LD	BC,ANGLE_AX_STEP
	ADD	HL,BC
	LD	(ANGLE_AX),HL
	LD	A,H
	AND	127
	LD	(CAX1 + 1),A
	LD	(CAX2 + 1),A
	ADD	A,32
	AND	127
	LD	(SAX1 + 1),A
	LD	(SAX2 + 1),A
	;-----------------------
	LD	HL,0
ANGLE_AY EQU $-2
	LD	BC,ANGLE_AY_STEP
	ADD	HL,BC
	LD	(ANGLE_AY),HL
	LD	A,H
	AND	127
	LD	(CAY1 + 1),A
	LD	(CAY2 + 1),A
	ADD	A,32
	AND	127
	LD	(SAY1 + 1),A
	LD	(SAY2 + 1),A
	;-----------------------
	LD	(ROT_SOHR_SP),SP
	LD	SP,POINTS0
POINTS_ADR EQU $-2
	LD	IY,CIRC_TBL
	LD	LX,10
ROT1	;------
	POP	BC	;10	координаты C=z B=y
	;---------------------- Ox: y` = y*cos(Ax) - z*sin(Ax) 
CAX1	LD	L,COS_AX	;7
	LD	H,B		;4
	LD	A,(HL)		;7 a=(hl)=y*cos(Ax)
SAX1	LD	L,SIN_AX	;7
	LD	H,C		;4 (hl)=z*sin(Ax)
	SUB	(HL)		;7 a=y`
	;---
	ADD	A,XYZMAX*4
	RRA
	RRA
	AND	%00111111
	ADD	A,A
	ADD	A,PROJ_PY	;A = таблица проекции Y
	EXX
	LD	L,A
	EXX
	;---------------------- Ox: z` = y*sin(Ax) + z*cos(Ax) 
SAX2	LD	L,SIN_AX	;7
	LD	H,B		;4
	LD	A,(HL)		;7 a=(hl)=y*sin(Ax)
CAX2	LD	L,COS_AX	;7
	LD	H,C		;4 (hl)=z*sin(Ax)
	ADD	A,(HL)		;7 a=z`
	;---
	ADD	A,XYZMAX*4
	RRA
	RRA
	AND	%00111111
	ADD	A,COR_TBL
	;----------------------
	POP	BC
	DEC	SP
	LD	B,A		; координаты C=x B=z
	;---------------------- Oy: x` = x*cos(Ay) + z*sin(Ay)
SAY1	LD	L,SIN_AY	;7
	LD	H,B		;4
	LD	A,(HL)		;7 a=(hl)=z*sin(Ay)
CAY1	LD	L,COS_AY	;7
	LD	H,C		;4 (hl)=x*cos(Ay)
	ADD	A,(HL)		;7 a=x`
	;--
	ADD	A,XYZMAX*4
	RRA
	RRA
	AND	%00111111
	ADD	A,PROJ_PX ; a = projectX
	EX	AF,AF
	;---------------------- Oy: z` = z*cos(Ay) - x*sin(Ay)
CAY2	LD	L,COS_AY	;7
	LD	H,B		;4
	LD	A,(HL)		;7 a=(hl)=z*cos(Ay)
SAY2	LD	L,SIN_AY	;7
	LD	H,C		;4 (hl)=x*sin(Ay)
	SUB	(HL)		;7 a=z`
	;--
	ADD	A,XYZMAX*4
	RRA
	RRA
	AND	%00111111
	LD	L,A		;4
	;----------------------- get buff adr
	EXX
	ADD	A,COR_TBL
	LD	H,A		;H = z
	LD	E,(HL)
	INC	L
	LD	D,(HL)		;DE = BUFF ADR by Py
	EX	AF,AF
	LD	L,A
	LD	A,(HL)		;L = Px
	EX	AF,AF
	LD	A,(HL)		;L = Px
	RRA
	AND	%01111111
	LD	L,A
	LD	H,0
	ADD	HL,DE
	EX	DE,HL
	LD	(IY),E
	INC	IY
	LD	(IY),D
	INC	IY
	EXX
	;------------------------ get spr size
	LD	A,L
	ADD	A,A
	LD	L,A
	LD	H,0
	LD	BC,SIZETBL
	EX	AF,AF
	AND	1
	JP	Z,ROTSZ
	LD	BC,SIZETBLX
ROTSZ
	ADD	HL,BC
	LD	C,(HL)
	INC	HL
	LD	B,(HL)
	LD	(IY),C
	INC	IY
	LD	(IY),B
	INC	IY
	;---------------
	DEC	LX
	JP	NZ,ROT1
	;---
	LD	SP,0
ROT_SOHR_SP EQU $-2
	RET
SIZETBL
	DUP	3
	DW	SPR0
	EDUP
	DUP	3
	DW	SPR1
	EDUP
	DUP	4
	DW	SPR2
	EDUP
	DUP	4
	DW	SPR3
	EDUP
	DUP	4
	DW	SPR4
	EDUP
	DUP	4
	DW	SPR5
	EDUP
	DUP	4
	DW	SPR6
	EDUP
	DUP	4
	DW	SPR7
	EDUP
	DUP	4
	DW	SPR8
	EDUP
	DUP	4
	DW	SPR9
	EDUP
	DUP	8
	DW	SPR10
	EDUP
SIZETBLX
	DUP	3
	DW	SPR0X
	EDUP
	DUP	3
	DW	SPR1X
	EDUP
	DUP	4
	DW	SPR2X
	EDUP
	DUP	4
	DW	SPR3X
	EDUP
	DUP	4
	DW	SPR4X
	EDUP
	DUP	4
	DW	SPR5X
	EDUP
	DUP	4
	DW	SPR6X
	EDUP
	DUP	4
	DW	SPR7X
	EDUP
	DUP	4
	DW	SPR8X
	EDUP
	DUP	4
	DW	SPR9X
	EDUP
	DUP	8
	DW	SPR10X
	EDUP




//======================================================== FX_INCLUDE_DATA
SYNC	LD	HL,POINTS0
POINTS_ADR_NEXT EQU $-2
	LD	(POINTS_ADR),HL
	XOR	A
	LD	(BORDER),A
	;---
	LD	HL,SYNC_TBL
SYNC_ADR	EQU $-2
	LD	C,(HL)
	INC	HL
	LD	B,(HL)
	INC	HL
	EX	DE,HL
	;---
	LD	HL,(MUSPOS)
	AND	A
	SBC	HL,BC
	EX	DE,HL
	RET	C
	;---
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	PUSH	DE
	RET
SYNC_BLINK
	LD	A,7
	LD	(BORDER),A
SYNC_FIGURE
	LD	C,(HL)
	INC	HL
	LD	B,(HL)
	INC	HL
	LD	(SYNC_ADR),HL
	LD	(POINTS_ADR_NEXT),BC
	RET
	
SYNC_TBL
	;---
		DW	2893-5	;=>2892 need 2893	;or need 2899 ?
		DW	SYNC_FIGURE
		DW	POINTS2
	;---
	DW	2912-4	;=>2912
	DW	SYNC_FIGURE
	DW	POINTS1
	;---
		DW	3081-5	;=>3080	nedd 3081
		DW	SYNC_FIGURE
		DW	POINTS2
	;---
		DW	3101-5	;=>3100	need3101
		DW	SYNC_FIGURE
		DW	POINTS1
	;---
	DW	3120-4 ;=>3120
	DW	SYNC_BLINK
	DW	POINTS2
	;---
		DW	3309-5	;=>3308 need 3309	;or need 3315
		DW	SYNC_FIGURE
		DW	POINTS1
	;---
	DW	3328-4	;=>3328
	DW	SYNC_FIGURE
	DW	POINTS3
	;---
		DW	3497-5	;=>3496
		DW	SYNC_BLINK
		DW	POINTS1
	;---
	DW	#FFFF
//======================================================== FX_TABLES
POINTS2
	DB	12 + COR_Z,	-12 + COR_Z,	7 + COR_Z
	DB	15 + COR_Z,	-11 + COR_Z,	9 + COR_Z
	DB	-11 + COR_Z,	2 + COR_Z,	9 + COR_Z
	DB	10 + COR_Z,	-13 + COR_Z,	-11 + COR_Z
	DB	9 + COR_Z,	8 + COR_Z,	-9 + COR_Z
	DB	7 + COR_Z,	5 + COR_Z,	0 + COR_Z
	DB	-11 + COR_Z,	-9 + COR_Z,	1 + COR_Z
	DB	8 + COR_Z,	-9 + COR_Z,	12 + COR_Z
	DB	-10 + COR_Z,	-7 + COR_Z,	-6 + COR_Z
	DB	-10 + COR_Z,	8 + COR_Z,	-9 + COR_Z


POINTS0
	DB	1 + COR_Z,	-6 + COR_Z,	-9 + COR_Z
	DB	6 + COR_Z,	11 + COR_Z,	-3 + COR_Z
	DB	-1 + COR_Z,	10 + COR_Z,	5 + COR_Z
	DB	1 + COR_Z,	-8 + COR_Z,	3 + COR_Z
	DB	-11 + COR_Z,	1 + COR_Z,	5 + COR_Z
	DB	-3 + COR_Z,	6 + COR_Z,	7 + COR_Z
	DB	12 + COR_Z,	7 + COR_Z,	7 + COR_Z
	DB	6 + COR_Z,	4 + COR_Z,	7 + COR_Z
	DB	0 + COR_Z,	-4 + COR_Z,	3 + COR_Z
	DB	-9 + COR_Z,	3 + COR_Z,	9 + COR_Z
POINTS1
	DB	11 + COR_Z,	-8 + COR_Z,	-5 + COR_Z
	DB	11 + COR_Z,	-9 + COR_Z,	13 + COR_Z
	DB	10 + COR_Z,	-6 + COR_Z,	3 + COR_Z
	DB	6 + COR_Z,	-5 + COR_Z,	0 + COR_Z
	DB	5 + COR_Z,	8 + COR_Z,	0 + COR_Z
	DB	-4 + COR_Z,	14 + COR_Z,	3 + COR_Z
	DB	11 + COR_Z,	12 + COR_Z,	-9 + COR_Z
	DB	-12 + COR_Z,	-4 + COR_Z,	-12 + COR_Z
	DB	5 + COR_Z,	0 + COR_Z,	3 + COR_Z
	DB	-7 + COR_Z,	12 + COR_Z,	9 + COR_Z



POINTS3	;z y x
	
	DB	COR_Z + 11, COR_Z + 11, COR_Z + 11
	DB	COR_Z + 11, COR_Z - 11, COR_Z + 11
	DB	COR_Z - 11, COR_Z - 11, COR_Z + 11
	DB	COR_Z - 11, COR_Z + 11, COR_Z + 11
	DB	COR_Z + 11, COR_Z + 11, COR_Z - 11
	DB	COR_Z + 11, COR_Z - 11, COR_Z - 11
	DB	COR_Z - 11, COR_Z - 11, COR_Z - 11
	DB	COR_Z - 11, COR_Z + 11, COR_Z - 11
	DB	COR_Z + 0, COR_Z + 0, COR_Z + 0
	DB	COR_Z + 0, COR_Z + 0, COR_Z + 0

CIRC_TBL
	DW	BUFF - 7*64 + 16
	DW	SPR2
	DW	BUFF + 6 - 7*64 + 16
	DW	SPR2
	DW	BUFF + 12 - 7*64 + 16
	DW	SPR2
	DW	BUFF + 18 - 7*64 + 16
	DW	SPR2
	DW	BUFF + 5*64 + 16
	DW	SPR2
	DW	BUFF + 6 + 5*64 + 16
	DW	SPR2
	DW	BUFF + 12 + 5*64 + 16
	DW	SPR2
	DW	BUFF + 18 + 5*64 + 16
	DW	SPR2
	DW	BUFF + 17*64 + 16
	DW	SPR2
	DW	BUFF + 6 + 17*64 + 16
	DW	SPR2
;--------------------
	ALIGN	2
	INCLUDE	"bin/circle_sprites.asm"
;--------------------	
	ALIGN	256
PAL	INCBIN "bin/3d_black_circles_palette.bin"
;--------------------
	ALIGN	256
BUFF	EQU	$ + 64*16
;--------------------
	DISPLAY "BUFF: ", /A, BUFF
	DISPLAY "BUFF END: ", /A, BUFF + 64*48 + 64*13

	DISPLAY "ROTATE: ", /A, ROTATE
	DISPLAY "CIRC_TBL: ", /A, CIRC_TBL
	

	DISPLAY "OUTBUFF_MAIN: ", /A, OUTBUFF_MAIN
	DISPLAY "OUTBUFF: ", /A, OUTBUFF
	DISPLAY "XXX: ", /A, XXX