//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
BUFF	EQU	#9D00
COS_A	EQU	#C0
SIN_A	EQU	#C0 + 16
MDX0	EQU	0
MDY0	EQU	0


ROT_STEP	EQU	#0200
MOV_X_STEP	EQU	#0300
MOV_Y_STEP	EQU	#0200

//======================================================== FX_INIT
EFF_INI_
	EI
	HALT
	LD	A,#17
	CALL	PAGER
	;--
	CALL	MRTCLR
	CALL	NEXT
	;--
	LD	HL,#4000
	LD	E,L
	
	LD	LX,2
INI3	LD	C,24
INI2	LD	B,4
INI1	PUSH	HL
	DUP	32
	LD	(HL),E
	INC	L
	EDUP
	POP	HL
	CALL	DOWNHL
	DJNZ	INI1
	LD	A,E
	XOR	#FF
	LD	E,A
	DEC	C
	JP	NZ,INI2
	;--
	LD	A,E
	XOR	#FF
	LD	E,A
	DEC	LX
	JP	NZ,INI3
	
	
	
	
	;--
	LD	HL,#4000
	LD	DE,#C000
	LD	BC,6912
	LDIR
	;----
	EI
	HALT
	LD	HL,FX_SWAP_PG
	LD	(IM2CALL),HL
	;---
	RET
	;---
DOWNHL	INC	H
	LD	A,H
	AND	7
	RET	NZ
	LD	A,L
	ADD	A,#20
	LD	L,A
	RET	C
	LD	A,H
	SUB	8
	LD	H,A
	RET
;---------------------------------
FX_SWAP_PG
	LD	A,(PAGE)
	XOR	#08
	LD	(PAGE),A
	RET
//======================================================== FX_MAINLOOP

EFF_RUN_
		IF SHOW_FRAMES=1
		LD	A,(FRAMES_QTY)
		PUSH	AF
		XOR	A
		LD	(FRAMES_QTY),A
		ENDIF
	EI
	HALT
		IF SHOW_FRAMES=1
		POP AF:OUT (#FE),A
		ENDIF
	CALL	MRT
	CALL	MRTOUT
	CALL	MRTCLR
	CALL	NEXT
		IF SHOW_FRAMES=1
		XOR A:OUT (#FE),A
		ENDIF
	RET
//======================================================== FX_PROCEDURES
NEXT	
	LD	HL,0
ROTHL	EQU	$-2
	LD	BC,ROT_STEP
	ADD	HL,BC
	LD	(ROTHL),HL
	LD	L,H
	LD	H,TBL_ROT / 256
	LD	A,(HL)
	LD	(ROTA),A
	;---
	LD	HL,0
MOV_X	EQU	$-2
	LD	BC,MOV_X_STEP
	ADD	HL,BC
	LD	(MOV_X),HL
	LD	L,H
	LD	H,TBL_MOV_X / 256
	LD	A,(HL)
	LD	(MDX),A
	;---
	LD	HL,0
MOV_Y	EQU	$-2
	LD	BC,MOV_Y_STEP
	ADD	HL,BC
	LD	(MOV_Y),HL
	LD	L,H
	LD	H,TBL_MOV_Y / 256
	LD	A,(HL)
	LD	(MDY),A
	;---
	RET
;--------------------------------------
MRTOUT
	LD	A,(PAGE)
	OR	#07
	CALL	PAGER
	;---
	LD	B,PAL_A / 256
	LD	DE,#59A0
	CALL	MRTOUT0
	LD	HL,#5AC0
	LD	DE,#5800
	CALL	MRTMV
	
	
	LD	B,PAL_B / 256
	LD	DE,#D9A0
	CALL	MRTOUT0
	LD	HL,#DAC0
	LD	DE,#D800

MRTMV	LD	A,12
MO1	DUP	32
	LDI
	EDUP
	LD	BC,0-64
	ADD	HL,BC
	DEC	A
	JP	NZ,MO1
	RET
	;----
MRTOUT0	LD	LX,11
	LD	L,low BUFF
	PUSH	DE
MRTOUT1	;---
	LD	H,BUFF / 256
	;-
	DUP	31
	LD	C,(HL)	;7
	LD	A,(BC)	;7
	LD	(DE),A	;7
	INC	E	;4
	INC	H	;4
	EDUP
	;-
	LD	C,(HL)	;7
	LD	A,(BC)	;7
	LD	(DE),A	;7
	INC	DE	;6
	INC	L	;4
	INC	L	;4
	;--
	DEC	LX	   ;8
	JP	NZ,MRTOUT1 ;10
	;----------------------
	POP	HL
	LD	LX,11
	LD	E,low BUFF + 1
	INC	B
MRTOUT3 ;---
	LD	D,BUFF / 256
	;-
	DUP	31
	LD	A,(DE)	;7
	LD	C,A	;4
	LD	A,(BC)	;7
	OR	(HL)	;7
	LD	(HL),A	;7
	INC	L	;4
	INC	D	;4
	EDUP
	;-
	LD	A,(DE)	;7
	LD	C,A	;4
	LD	A,(BC)	;7
	OR	(HL)	;7
	LD	(HL),A	;7
	INC	HL	;4
	INC	E	;4
	INC	E	;4
	;--
	DEC	LX	   ;8
	JP	NZ,MRTOUT3 ;10
	
	
	RET
;-------------------------------------------
MRTCLR
	LD	(MRTCLR_SOHR_SP),SP
	;---
	LD	B,32
	LD	DE,0
	LD	HL,BUFF+26
MRTCLR1	LD	SP,HL
	DUP	13
	PUSH	DE
	EDUP
	INC	H
	DJNZ	MRTCLR1
	;---
	LD	SP,0
MRTCLR_SOHR_SP EQU $-2
	RET
;-------------------------------------------
;tx = x*cos(a)-y*sin(a);
;ty = x*sin(a)+y*cos(a);
MRT	
	LD	A,(PAGE)
	AND	#18
	CALL	PAGER
	;---
	LD	A,0
ROTA	EQU	$-1
	OR	#C0
	LD	(ROTH+1),A
	LD	(COS1+1),A
	LD	(COS2+1),A
	;--
	ADD	A,16
	OR	#C0
	LD	(SIN1+1),A
	;---
	LD	H,high BUFF
	LD	C,low BUFF
	LD	B,6 + low BUFF
ROTH	LD	D,0
	EXX
	LD	DE,FLY2DMAP
	LD	HX,26
MRT2	;----------------
	LD	LX,32
MRT1	;----------------
	EX	DE,HL
	LD	C,(HL)
	INC	L
	LD	B,(HL)
	INC	L	
	EX	DE,HL
	; -- координаты C=x B=y
COS1	LD	H,COS_A	;7
	LD	L,C	;4
	LD	A,(HL)	;7 a=(hl)=x*cos(a)
SIN1	LD	H,SIN_A	;7
	LD	L,B	;4 (hl)=y*sin(a)
	SUB	(HL)	;7 a=y`
	ADD	A,MDX0	;7
MDX	EQU	$-1
	OR	#C0	;7
	EX	AF,AF	;4
	;--
	LD	L,C	;4
	LD	A,(HL)	;7 a=(hl)=x*sin(a)
COS2	LD	H,COS_A	;7
	LD	L,B	;4
	ADD	A,(HL)	;7
	ADD	A,MDY0	;7
MDY	EQU	$-1
	OR	#C0	;7
	LD	B,A	;4
	EX	AF,AF	;4
	LD	C,A	;4
	;--------
	LD	A,(BC)	;7
	;--------
	EXX		;4
	CP	3	;4
	JP	NC,NOBLACK ;10
	;--
	LD	L,B	;4
	LD	(HL),A	;7
	JP	BLACK
NOBLACK	;--
	LD	E,A	;7
	;-
	LD	L,C	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	E	;4
	INC	L	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4
	LD	(HL),A	;7 /51
	;-
BLACK	INC	H	;4
	EXX		;4 /122
	;----------------
	DEC	LX
	JP	NZ,MRT1
	;----------------
	EXX
	LD	H,BUFF / 256
	INC	C
	INC	B
	EXX
	DEC	E
	INC	DE
	;------------------
	DEC	HX	;8
	JP	NZ,MRT2 ;10 /18
	;------------------
	RET

//======================================================== FX_INCLUDE_DATA
	ALIGN	256
FLY2DMAP	INCLUDE "bin/fly2d_map.asm"
//======================================================== FX_TABLES
	ALIGN	256
TXCOR	INCLUDE "bin/fly2d_txcor.asm"
	ALIGN	256
TBL_ROT INCLUDE "bin/tbl_rot.asm"
TBL_MOV_X INCLUDE "bin/tbl_mov_x.asm"
TBL_MOV_Y INCLUDE "bin/tbl_mov_y.asm"

;----------------------------------------------
	ALIGN	256
PAL_A
	DB	#00
	DB	#00
	DB	#01
	DB	#02,#00,#02,#06,#02,#07,#02,#06
	DB	#03,#00,#03,#06,#03,#07,#03,#03
;----------------------------------------------
	ALIGN	256
PAL_AD
	DB	#00
	DB	#00
	DB	#01*8
	DB	#02*8,#00*8,#02*8,#06*8,#02*8,#07*8,#02*8,#06*8
	DB	#03*8,#00*8,#03*8,#06*8,#03*8,#07*8,#03*8,#03*8
;----------------------------------------------
	ALIGN	256
PAL_B
	DB	#40
	DB	#41
	DB	#41
	DB	#40,#42,#42,#42,#46,#42,#47,#47
	DB	#40,#43,#43,#43,#46,#43,#47,#47
;----------------------------------------------
	ALIGN	256
PAL_BD
	DB	#40
	DB	#40+8*1
	DB	#40+8*1
	DB	#40+8*0,#40+8*2,#40+8*2,#40+8*2,#40+8*6,#40+8*2,#40+8*7,#40+8*7
	DB	#40+8*0,#40+8*3,#40+8*3,#40+8*3,#40+8*6,#40+8*3,#40+8*7,#40+8*7
	
	
	
	
	
	
	
	
	
	