<?php
$usePackedAttr = 0;

/*
$usePackedAttr = 0

pl5 = 8755
mlz = 9026
lzsa1 = 10513
lzsa2 = 9073

$usePackedAttr = 1

pl5 = 7655
mlz = 7771
lzsa1 = 8992
lzsa2 = 7902

*/


$eol = "\r\n";
$pathImg = __DIR__ . '/images/img/';
$pathFrames = __DIR__ . '/images/frames/';

$imgNameList = array(
	'00','01','02','03','04',
	'10','11','12','13','14',
	'20','21','22','23','24',
	'30','31','32','33','34',
	'40','41','42','43','44',
);

$chunks = array();
$attrChunks = array();
$attrChunksQty = array();
$scrList = array();
$rgbList = array();
$attrList = array();

foreach ($imgNameList as $imgName) {
	$content = file_get_contents($pathImg . 'squad-' . $imgName . '.mgs.img');
	$scrList[$imgName] = array();
	$attrList[$imgName] = array();
	$rgbList[$imgName] = array();
	for ($y = 0; $y < 24; $y++) {
		for ($x = 0; $x < 32; $x++) {
			$adrPix = 2048 * floor($y / 8) + 32 * ($y & 7) + $x;
			$adrAttr = 6144 + $y * 32 + $x;
			$attr = ord(substr($content, $adrAttr, 1));
			$attr_ink = $attr & 7;
			$attr_pap = ($attr >> 3) & 7;
			$chunkData = array();
			for ($by = 0; $by < 8; $by++) {
				$pix = ord(substr($content, $adrPix + 256 * $by, 1));
				$pix = $attr_ink != $attr_pap ? $pix : 255;
				$chunkData[] = $pix;
			}
			$chunkData = implode('_', $chunkData);
			if (!isset($chunks[$chunkData])) {
				$chunksId = count($chunks);
				$chunks[$chunkData] = $chunksId;
			}
			$chunksId = $chunks[$chunkData];
			$scrList[$imgName][] = $chunksId;
			if ($chunkData == '255_255_255_255_255_255_255_255') {
				if ($usePackedAttr == 1) {
					$attr_pap = 0;
				}
			}
			$attrList[$imgName][] = 0x40 + $attr_pap * 8 + $attr_ink;
			
			$attrChunkData = $attr_ink . '_' . $attr_pap;
			if (!isset($attrChunks[$attrChunkData])) {
				$attrChunkId = count($attrChunks);
				$attrChunks[$attrChunkData] = $attrChunkId;
				$attrChunksQty[$attrChunkData] = 0;
			}
			$attrChunkId = $attrChunks[$attrChunkData];
			$attrChunksQty[$attrChunkData]++;
			$rgbList[$imgName][] = $attrChunkId;
		}
	}
	$f = fopen($pathFrames . $imgName . '.bin', 'wb');
	foreach ($scrList[$imgName] as $byte) {
		fwrite($f, chr($byte));
	}
	if ($usePackedAttr == 0) {
		foreach ($attrList[$imgName] as $byte) {
			fwrite($f, chr($byte));
		}
	} else {
		for ($i = 0; $i < count($rgbList[$imgName]); $i += 2) {
			$byte = 16 * $rgbList[$imgName][$i] + $rgbList[$imgName][$i];
			fwrite($f, chr($byte));
		}
	}
	
	fclose($f);
}
echo 'images qty: ' . count($imgNameList) . $eol;
echo 'byte: ' . (2 * 768 * count($imgNameList)) . $eol;
echo 'pix chunks qty: ' . count($chunks) . ', bytes:' . 8*(count($chunks)) . $eol;
echo 'attr chunks qty: ' . count($attrChunks) . ', bytes:' . (count($attrChunks)) . $eol;

echo 'packing' . $eol;
$packerList = array(
	'pl5' => '"' . __DIR__ . '/../_packers/pletter5.exe" "[%in%]" "[%out%]"',
	'pl5d' => '"' . __DIR__ . '/../_packers/pletter5d.exe" "[%in%]" "[%out%]"',
	'mlz' => '"' . __DIR__ . '/../_packers/MegaLZ.exe" "[%in%]" "[%out%]"',
	'lzsa1' => '"' . __DIR__ . '/../_packers/lzsa.exe" -f1 "[%in%]" "[%out%]"',
	'lzsa2' => '"' . __DIR__ . '/../_packers/lzsa.exe" -f2 "[%in%]" "[%out%]"',
);

foreach ($packerList as $packerId => $packerCmd) {
	$size = 0;
	echo $packerId . ' = ';
	foreach ($imgNameList as $imgName) {
		$fileIn = __DIR__ . '/images/frames/' . $imgName . '.bin';
		$fileOut = __DIR__ . '/images/frames/' . $imgName . '.bin.' . $packerId;
		$cmdStr = str_replace('[%out%]', $fileOut, str_replace('[%in%]', $fileIn, $packerCmd));
		exec($cmdStr);
		$size += filesize($fileOut);
	}
	echo ($size + ($usePackedAttr ? 256 : 0)) . $eol;
}

echo 'create inlude files' . $eol;

foreach ($packerList as $packerId => $packerCmd) {
	$code = '';
	foreach ($imgNameList as $imgName) {
		$code .= 'FRM' . $imgName . "\t" . 'INCBIN "frames/' . $imgName . '.bin.' . $packerId . '"' . $eol;
	}
	file_put_contents(__DIR__ . '/include_frames_' . $packerId . '.asm', $code);
}

echo 'create pix_chunks.bin' . $eol;

$f = fopen(__DIR__ . '/pix_chunks.bin', 'wb');
$chunksValues = array_keys($chunks);
for ($i = 0; $i < 8; $i++) {
	for ($j = 0; $j < 256; $j++) {
		$byte = 0;
		if (isset($chunksValues[$j])) {
			$chunksBytes = explode('_', $chunksValues[$j]);
			$byte = (int)$chunksBytes[$i];
		}
		if ($j >= 128) {
			if (isset($chunksValues[$j-128])) {
				$chunksBytes = explode('_', $chunksValues[$j-128]);
				$byte = (int)$chunksBytes[$i];
				$byteNew = 0;
				for ($bit = 0; $bit < 8; $bit++) {
					$notbit = 7 - $bit;
					if (($byte & pow(2,$notbit)) != 0) {
						$byteNew += pow(2,$bit);
					}
				}
				$byte = $byteNew;
			}
		}
		fwrite ($f, chr($byte));
	}
}
fclose($f);

echo 'create attr_chunks.bin' . $eol;
$f = fopen('attr_chunks.bin', 'wb');
$attrChunksNew = array_combine($attrChunks, array_keys($attrChunks));
for ($i = 0; $i < 256; $i++) {
	$idx = ($i/16) & 15;
	list($attr_ink, $attr_pap) = explode('_', $attrChunksNew[$idx]);
	$byte = 0x40 + 8 * $attr_pap + $attr_ink;
	fwrite ($f, chr($byte));
}
for ($i = 0; $i < 256; $i++) {
	$idx = ($i) & 15;
	list($attr_ink, $attr_pap) = explode('_', $attrChunksNew[$idx]);
	$byte = 0x40 + 8 * $attr_pap + $attr_ink;
	fwrite ($f, chr($byte));
}
fclose($f);

echo 'create cos tbl' . $eol;
$r = 31.25;
$f = fopen('squad_cos_tbl.bin', 'wb');
for ($i = 0; $i < 256; $i++) {
	$byte = $r + $r * cos($i * pi() / 128);
	fwrite ($f, chr($byte));
}
fclose($f);

