//-----------------------------------------------------------------------------
// CONSTANTS
//-----------------------------------------------------------------------------

BABY_1_BLINK_COLOR	EQU	5
BABY_2_BLINK_COLOR	EQU	6
BABY_3_BLINK_COLOR	EQU	4

BLINK_BABY_SIZE	EQU	3

//-----------------------------------------------------------------------------
// 10. INTRO
//-----------------------------------------------------------------------------

	;init_fx
	DB	T_FX_INI

	;pause after init
	;DB	T_FX_NOP
	;DW	0		; pause while fx-local frame counter <= this value
	
	; start music after first effect init
	DB	2 ;COMM_ASM
	EI
	HALT
	CALL	MUSIC_ON
	LD	IY,$+5
	RET
	
	;run_fx
	DB	T_FX_RUN
	DW	1536+9	;1728-24		; fx run while fx-local frame counter <= this value

	;--------- INTRO OUT
	DB	T_SET_INT_PROC
	DW	INTRO_OUT

//-----------------------------------------------------------------------------
// 04. BUMP
//-----------------------------------------------------------------------------

	DB	2 ;COMM_ASM
	;--
	LD	A,BUMP_BIN_PG
	CALL	PAGER
	LD	HL,BUMP_BIN
	LD	DE,#8000
	CALL	DEPACK_PL5
	;--
	LD	A,BUMP_PG10_PG
	CALL	PAGER
	LD	HL,BUMP_PG10
	LD	DE,#BE00-(BUMP_PG10_END - BUMP_PG10)
	LD	BC,BUMP_PG10_END - BUMP_PG10
	LDIR
	;--
	LD	A,#10
	CALL	PAGER
	LD	HL,#BE00-(BUMP_PG10_END - BUMP_PG10)
	LD	DE,#C000
	CALL	DEPACK_PL5
	;--
	LD	IY,$+5
	RET
	
	DB	T_FX_NOP
	DW	1728 - 4 - 12
	;clear int proc
	DB	T_CLEAR_INT_PROC
	;init_fx
	DB	T_FX_INI
	
	DB	2 ;COMM_ASM
	CALL	BLINKER		;fr=1727
	LD	IY,$+5
	RET
	
	;run_fx			;fr=1730
	DB	T_FX_RUN
	DW	2496-24-24-24-24		; fx run while fx-local frame counter <= this value
	;2400
//-----------------------------------------------------------------------------
// 11. KARDIO
//-----------------------------------------------------------------------------
	DB	2 ;COMM_ASM
	EI
	HALT
	LD	A,#17
	CALL	PAGER
	CALL	CLEARATTR
	;--
	LD	A,TEXTER_PG7_PG
	CALL	PAGER
	LD	HL,TEXTER_PG7
	LD	DE,#8000
	LD	BC,TEXTER_PG7_END - TEXTER_PG7
	LDIR
	LD	A,#17
	CALL	PAGER
	LD	HL,#8000
	LD	DE,#DB00
	CALL	DEPACK_PL5
	;--
	LD	A,KARDIO_BIN_PG
	CALL	PAGER
	LD	HL,KARDIO_BIN
	LD	DE,#8000
	CALL	DEPACK_PL5
	LD	IY,$+5
	RET

	;init_fx
	DB	T_FX_INI
	;nop
	DB	T_FX_NOP
	DW	2496-24 - 8
	;run_fx
	DB	T_FX_RUN
	DW	3264-24 - 6	; fx run while fx-local frame counter <= this value
	
//-----------------------------------------------------------------------------
// 01. TUNNEL
//-----------------------------------------------------------------------------
	DB	2 ;COMM_ASM
	;--
	LD	A,TUNNEL_PG10_PG
	CALL	PAGER
	LD	HL,TUNNEL_PG10
	LD	DE,#8000
	LD	BC,TUNNEL_PG10_END - TUNNEL_PG10
	LDIR
	LD	A,#10
	CALL	PAGER
	LD	HL,#8000
	LD	DE,#C000
	CALL	DEPACK_PL5_
	;--
	LD	A,TUNNEL_BIN_PG
	CALL	PAGER
	LD	HL,TUNNEL_BIN
	LD	DE,#8000
	CALL	DEPACK_PL5_
	LD	IY,$+5
	RET

	DB	T_FX_INI

	;run_fx
	DB	T_FX_RUN	;fr=3264
	DW	4032-24-24		; fx run while fx-local frame counter <= this value
	
//-----------------------------------------------------------------------------
// UNPACK MUSIC PART 2
//-----------------------------------------------------------------------------
	DB	2 ;COMM_ASM
	CALL	BLINKER
	;--- depack texter
	CALL	TEXTER_DEPACK
	LD	HL,BABY1_TEXT
	CALL	TEXTER_INI
	LD	A,BABY_1_BLINK_COLOR * 8 + BABY_1_BLINK_COLOR
	LD	(BABY_BLINK_COLOR),A
	LD	A,5
	LD	(BABY_FRAME),A
	;--- move music 1 from page
	LD	A,MUSIC2_BIN_PG
	CALL	PAGER
	LD	HL,MUSIC2_BIN
	LD	DE,#8000
	LD	BC,MUSIC2_BIN_END - MUSIC2_BIN
	LDIR
	;--- depack music 1 to page
	LD	A,#16
	CALL	PAGER
	;JP GETSTAT ;---fr=4001 set pldump1	musdump = 4001..4032
	CALL INIDUMP1
	LD	HL,#8000
	LD	DE,#C000
	CALL	DEPACK_PL5_
	;--
	LD	IY,$+5
	RET
//-----------------------------------------------------------------------------
// 12. BABY 1
//-----------------------------------------------------------------------------
	DB	2 ;COMM_ASM

	LD	A,BABY1_BIN_PG
	CALL	PAGER
	LD	HL,BABY1_BIN
	LD	DE,#8000
	CALL	DEPACK_PL5_
	LD	IY,$+5
	RET

	;nop
	DB	T_FX_NOP
	DW	4032

	DB	2 ;COMM_ASM
	;--
	LD	A,(PAGE)
	AND	#08
	OR	#16
	CALL	PAGER
	CALL	#C000
	LD	HL,MUS_PLAY
	LD	(MPLADR),HL
	;--
	LD	IY,$+5
	RET
	
	;init_fx
	DB	T_FX_INI
	
	;int proc fr=4037
	DB	T_SET_INT_PROC
	DW	PROC_BABY1

//-----------------------------------------------------------------------------
// 03. SOSKA
//-----------------------------------------------------------------------------
	DB	2 ;COMM_ASM
	;--
	LD	A,(PAGE)
	AND	#08
	OR	SOSKA_PG0_PG
	CALL	PAGER
	LD	HL,SOSKA_PG0
	LD	DE,#8000
	LD	BC,SOSKA_PG0_END - SOSKA_PG0
	LDIR
	LD	A,(PAGE)
	AND	#08
	CALL	PAGER
	LD	HL,#8000
	LD	DE,#C000
	CALL	DEPACK_PL5_
	;--
	LD	A,(PAGE)
	AND	#08
	OR	SOSKA_BIN_PG
	CALL	PAGER
	LD	HL,SOSKA_BIN
	LD	DE,#8000
	CALL	DEPACK_PL5_
	;--
	LD	IY,$+5
	RET

	;nop
	DB	T_FX_NOP
	DW	4800 - 6

	;clear int proc
	DB	T_CLEAR_INT_PROC

	DB	2 ;COMM_ASM
	EI
	HALT
	;--
	LD	A,#17
	CALL	PAGER
	LD	A,7
	OUT	(#FE),A
	LD	HL,#5800
	LD	DE,#5801
	LD	BC,767
	LD	(HL),7*8+7
	LDIR
	;--
	LD	IY,$+5
	RET

	;init_fx
	DB	T_FX_INI

	;nop
	DB	T_FX_NOP
	DW	4800	;//12

	;run_fx
	DB	T_FX_RUN
	DW	6336-16-8	; fx run while fx-local frame counter <= this value

//-----------------------------------------------------------------------------
// 13. BABY 2
//-----------------------------------------------------------------------------
	DB	2 ;COMM_ASM
	EI
	HALT
	LD	A,#17
	CALL	PAGER
	CALL	CLEARATTR_BRD
	;--
	CALL	TEXTER_DEPACK
	LD	HL,BABY2_TEXT
	CALL	TEXTER_INI
	;--
	LD	A,BABY2_BIN_PG
	CALL	PAGER
	LD	HL,BABY2_BIN
	LD	DE,#8000
	CALL	DEPACK_PL5_
	;--
	LD HL,BABY2_BLINK_ON_TBL: LD (BABY_BLINK_ON_TBL_ADR),HL
	LD	A,BABY_2_BLINK_COLOR * 8 + BABY_2_BLINK_COLOR
	LD	(BABY_BLINK_COLOR),A
	LD	A,6
	LD	(BABY_FRAME),A
	;--
	LD	IY,$+5
	RET

	;nop
	DB	T_FX_NOP
	DW	6336

	;init_fx
	DB	T_FX_INI
	;int proc
	DB	T_SET_INT_PROC
	DW	PROC_BABY2
	

//-----------------------------------------------------------------------------
// 02. FLOWERS
//-----------------------------------------------------------------------------

	;nop
	DB	T_FX_NOP
	DW	7104 - 24 - 3; - 4
	;clear int proc
	DB	T_CLEAR_INT_PROC

	DB	2 ;COMM_ASM
	CALL	BLINKER_CLS
	;--
	LD	A,FLOWERS_PG0_PG
	CALL	PAGER
	LD	HL,FLOWERS_PG0
	LD	DE,#8000
	LD	BC,FLOWERS_PG0_END - FLOWERS_PG0
	LDIR
	LD	A,#10
	CALL	PAGER
	LD	HL,#8000
	LD	DE,#E000
	CALL	DEPACK_PL5_
	;--
	LD	A,FLOWERS_PG7_PG
	CALL	PAGER
	LD	HL,FLOWERS_PG7
	LD	DE,#8000
	LD	BC,FLOWERS_PG7_END - FLOWERS_PG7
	LDIR
	LD	A,#17
	CALL	PAGER
	LD	HL,#8000
	LD	DE,#E000
	CALL	DEPACK_PL5_
	;--
	LD	A,(PAGE)
	AND	#08
	OR	FLOWERS_BIN_PG
	CALL	PAGER
	LD	HL,FLOWERS_BIN
	LD	DE,#8000
	CALL	DEPACK_PL5_
	LD	IY,$+5
	RET

	;init_fx
	DB	T_FX_INI
	;nop
	DB	T_FX_NOP
	DW	7104

	DB	2 ;COMM_ASM
	CALL	BLINKER
	LD	IY,$+5
	RET

	;run_fx
	DB	T_FX_RUN
	DW	8544 ;or 8568
	
	DB	2 ;COMM_ASM
	;80F0 = 0-682	;2.66 (#FD56)
	LD	HL,0-682-682	;or 0-682-682-682
	LD	(#8085),HL
	LD	IY,$+5
	RET
	
	;run_fx
	DB	T_FX_RUN
	DW	8592-16	;8592-24 ;8640-16-16-16-8		; fx run while fx-local frame counter <= this value
	
//-----------------------------------------------------------------------------
// MUSIC PART 3
//-----------------------------------------------------------------------------
	DB	2 ;COMM_ASM
	;JP GETSTAT ;---fr=8579 set pldump1	musdump = 8579..8604
	LD A,#16: CALL PAGER: CALL INIDUMP2
	;----------------------- [~12frm]
	LD	A,MUSIC3_BIN_PG
	CALL	PAGER
	LD	HL,MUSIC3_BIN
	LD	DE,#8000
	LD	BC,MUSIC3_BIN_END - MUSIC3_BIN
	LDIR
	LD	A,#16
	CALL	PAGER
	LD	HL,#8000
	LD	DE,#C000
	CALL	DEPACK_PL5_
	;-- depack cubes pg 0
	LD	A,CUBES_PG0_PG
	CALL	PAGER
	LD	HL,CUBES_PG0
	LD	DE,#8000
	LD	BC,CUBES_PG0_END - CUBES_PG0
	LDIR
	LD	A,#10
	CALL	PAGER
	LD	HL,#8000
	LD	DE,#C000
	CALL	DEPACK_PL5
	;---
	LD	IY,$+5
	RET
	;--
	DB	T_FX_NOP
	DW	8604
	;--- music part 3 start
	DB	2 ;COMM_ASM
	;--
	LD	A,#16
	CALL	PAGER
	CALL	#C000
	LD	HL,MUS_PLAY
	LD	(MPLADR),HL
	;--
	LD	IY,$+5
	RET
	
//-----------------------------------------------------------------------------
// 05. CUBES
//-----------------------------------------------------------------------------
	DB	2 ;COMM_ASM
	;--
	LD	A,CUBES_PG1_PG
	CALL	PAGER
	LD	HL,CUBES_PG1
	LD	DE,#8000
	LD	BC,CUBES_PG1_END - CUBES_PG1
	LDIR
	LD	A,#11
	CALL	PAGER
	LD	HL,#8000
	LD	DE,#C000
	CALL	DEPACK_PL5
	;--
	LD	A,CUBES_PG7_PG
	CALL	PAGER
	LD	HL,CUBES_PG7
	LD	DE,#8000
	LD	BC,CUBES_PG7_END - CUBES_PG7
	LDIR
	LD	A,#17
	CALL	PAGER
	LD	HL,#8000
	LD	DE,#DB00
	CALL	DEPACK_PL5
	;--
	LD	A,CUBES_BIN_PG
	CALL	PAGER
	LD	HL,CUBES_BIN
	LD	DE,#8000
	CALL	DEPACK_PL5
	;--
	LD	IY,$+5
	RET
	
	DB	T_FX_INI
	
	DB	T_FX_NOP
	DW	8640+2

	DB	T_FX_RUN
	DW	11712 - 48 ;or 49?

//-----------------------------------------------------------------------------
// 14. BABY 3
//-----------------------------------------------------------------------------
	DB	2 ;COMM_ASM

	CALL	TEXTER_DEPACK
	LD	HL,BABY3_TEXT
	CALL	TEXTER_INI

	LD	A,BABY3_BIN_PG
	CALL	PAGER
	LD	HL,BABY3_BIN
	LD	DE,#8000
	CALL	DEPACK_PL5_
	
	LD HL,BABY3_BLINK_ON_TBL: LD (BABY_BLINK_ON_TBL_ADR),HL
	LD	A,BABY_3_BLINK_COLOR * 8 + BABY_3_BLINK_COLOR
	LD	(BABY_BLINK_COLOR),A
	
	LD	A,4
	LD	(BABY_FRAME),A

	LD	IY,$+5
	RET

	DB	T_FX_NOP
	DW	11712
	
	;init_fx
	DB	T_FX_INI
	;int proc
	DB	T_SET_INT_PROC
	DW	PROC_BABY3
	
	
	DB	T_FX_NOP
	DW	12288+6+4

	DB	T_CLEAR_INT_PROC
	DB	2 ;COMM_ASM
	
	LD	A,#17
	CALL	PAGER
	LD	HX,16
CPG3	EI
	HALT
	LD	A,(#D800)
	RRA:RRA:RRA
	AND	7
	OUT	(#FE),A
CPG4	LD	A,#17
CPG	EQU	$-1
	XOR	#08+#02
	CALL	PAGER
	LD	(CPG),A

	LD	HL,#D800
	LD	LX,3
CPG2	LD	B,0
CPG1	;--
	LD	A,(HL)
	AND	7
	SUB	1
	ADC	A,0
	LD	C,A
	;--
	LD	A,(HL)
	RRA:RRA:RRA
	AND	7
	SUB	1
	ADC	A,0
	ADD A,A:ADD A,A:ADD A,A
	OR	C
	LD	C,A
	;--
	LD	A,(HL)
	AND	#40
	OR	C
	LD	(HL),A
	INC	HL
	DJNZ	CPG1
	;--
	DEC	LX
	JP	NZ,CPG2
	;--
	DEC	HX
	JP	NZ,CPG3

	LD	IY,$+5
	RET
	
//-----------------------------------------------------------------------------
// DEMO ENDED
//-----------------------------------------------------------------------------	
	DB	T_FX_NOP
	DW	12354 - 18
	;--
	DB	2 ;COMM_ASM
	LD	A,#16
	CALL	PAGER
	CALL	MUSOFF
	LD	HL,#2758
	EXX
	DI
	LD	A,#3F
	LD	I,A
	IM	1
	LD	IY,#5C3A
	LD	SP,(DEMOSP)
	EI
	RET
;------------------------

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
BABY1_BLINK_ON_TBL
	DB	5,	0,60,96,156,180
BABY2_BLINK_ON_TBL
	DB	4,	0,60,96,156
BABY3_BLINK_ON_TBL
	DB	9,	0,36,48,84,96,114,132,144,180

PROC_BABY1
	LD	HL,BABY1_BLINK_TBL
	JP	PROC_BABY
PROC_BABY2
	LD	HL,BABY2_BLINK_TBL
	JP	PROC_BABY
PROC_BABY3
	LD	HL,BABY3_BLINK_TBL
	;---
PROC_BABY
	LD	(BABY_BLINK_TBL),HL
	LD	A,(PAGE)
	XOR	#08
	LD	(PAGE),A
	AND	#08
	LD	C,A
	LD	A,5
BABY_PG	EQU	$-1
	XOR	#02
	LD	(BABY_PG),A
	OR	C
	LD	BC,#7FFD
	OUT	(C),A
	LD	A,#FF
BABY_FRAME EQU	$-1
	INC	A
	LD	(BABY_FRAME),A
	LD	DE,0
BABY_BLINK_TBL	EQU	$-2
	LD	HL,BABY1_BLINK_ON_TBL
BABY_BLINK_ON_TBL_ADR EQU $-2
	LD	B,(HL)
	INC	HL
BABY_BLINK_1
	CP	(HL)
	JP	Z,BABY_BLINK_ON
	INC	HL
	DJNZ	BABY_BLINK_1
	;--
	CP	191
	JP	NZ,BABY1_1
	LD	A,#FF
	LD	(BABY_FRAME),A
	JP	BABY1_1
BABY_BLINK_ON
	JP	XXX
XXX
	LD	A,BLINK_BABY_SIZE
	LD	(BLINKA),A
BABY1_1 ;---
	LD	A,BLINK_BABY_SIZE
BLINKA	EQU	$-1
	SUB	1
	LD	C,7*8+7
	JP	C,BLINKB
	LD	C,6*8+6
BABY_BLINK_COLOR EQU	$-1
BLINKB	ADC	A,0
	LD	(BLINKA),A
	
	LD	A,C
	AND	7
	OUT	(#FE),A
	LD	A,C
	AND	%00111000
	LD	C,A
	LD	HL,#D800
BABY_BLINK_LP0 ;--
	LD	A,(DE)
	INC	DE
	LD	B,A
	CALL	BABY_BLINK_LP
	LD	A,(DE)
	INC	DE
	CP	#FF
	JP	Z,BABY_RET
	PUSH	DE
	LD	E,A
	LD	D,0
	ADD	HL,DE
	POP	DE
	JP	BABY_BLINK_LP0
BABY_RET
	LD	A,(PAGE)
	OR	#17
	LD	BC,#7FFD
	OUT	(C),A
	CALL	TEXTER_PRINT

	LD	A,(PAGE)
	JP	PAGER
BABY_BLINK_LP
	LD	A,(HL)
	AND	%11000111
	OR	C
	LD	(HL),A
	INC	HL
	DJNZ	BABY_BLINK_LP
	RET

//-----------------------------------------------------------------------------
TEXTER_DEPACK	
	LD	A,TEXTER_PG7_PG
	CALL	PAGER
	LD	HL,TEXTER_PG7
	LD	DE,#8000
	LD	BC,TEXTER_PG7_END - TEXTER_PG7
	LDIR
	;--
	LD	A,TEXTER_PG
	CALL	PAGER
	LD	HL,#8000
	LD	DE,TEXTER_INI
	;--
	LD	A,5
	LD	(BABY_PG),A
	LD	A,#FF
	LD (BABY_FRAME),A
	LD	A,BLINK_BABY_SIZE
	LD (BLINKA),A
	;--
	JP	DEPACK_PL5
	
BABY3_TEXT
	db new,#ff,00,"There will come"
	db new,16,64,"a time",new,36,01,"when you believe"
	db new,56,14,"everything",new,78,43,"is finished"
	db wait,23
	db new,140,00,"That will be"
	db new,160,16,"the beginning"
	db end
	
BABY2_TEXT
	db new,#ff,100,"In any nuclear"
	db new,14,180,"situation"
	db new,36,116,"keep screaming",new,53,128,"until it gets",new,68,210,"better"
	db wait,18
	db new,92,126,"Because it gets",new,110,170,"better"
	db wait,18
	db new,138,140,"It gets a little",new,156,174,"better",new,174,145,"all the time..."
	db end

BABY2_BLINK_TBL
	DB	69,4
	DB	26,8
	DB	23,10
	DB	21,11
	DB	21,12
	DB	19,13
	DB	19,13
	DB	20,12
	DB	20,12
	DB	20,11
	DB	22,11
	DB	22,11
	DB	20,12
	DB	20,13
	DB	19,13
	DB	19,13
	DB	19,13
	DB	20,13
	DB	19,13
	DB	18,14
	DB	18,7
	DB	3,3
	DB	20,4
	DB	25,#FF
BABY3_BLINK_TBL
	DB	59,1
	DB	26,7
	DB	24,9
	DB	22,11
	DB	21,11
	DB	21,12
	DB	19,13
	DB	19,12
	DB	21,12
	DB	20,11
	DB	20,11
	DB	21,10
	DB	20,13
	DB	18,14
	DB	17,15
	DB	18,13
	DB	20,11
	DB	21,3
	DB	1,7
	DB	22,2
	DB	3,4
	DB	29,3
	DB	29,2
	DB	25,10
	DB	21,12
	DB	2,#FF
BABY1_BLINK_TBL
	DB	85,4
	DB	26,8
	DB	23,10
	DB	22,10
	DB	21,12
	DB	19,14
	DB	19,12
	DB	20,11
	DB	1,2
	DB	16,2
	DB	1,13
	DB	16,15
	DB	19,12
	DB	21,10
	DB	23,9
	DB	22,10
	DB	20,12
	DB	19,13
	DB	18,13
	DB	19,13
	DB	19,13
	DB	18,16
	DB	17,15
	DB	20,9
	DB	6,#FF
BABY1_TEXT
	db new,#ff,00,"Don",127,"t cry my boy"
	db wait,28+6
	db new,40,01,"Things won",127,"t",new,58,12,"always go",new,76,09,"your way..."
	db wait,27
	db new,116,00,"Take it easy"
	db wait,36
	db new,154,05,"It will",new,172,30,"all pass"
	db end
	
;Don't cry my boy
;Things won't always go your way...
;Take it easy.
;It'll all pass.

	
//-----------------------------------------------------------------------------	INTRO
IO_PG0	EQU	#10
IO_PG1	EQU	#18
INTRO_OUT_TBL
	DB	64,62,60,58,56,54,52,50,48,46,44,42,40,38,36,34,32,30,28,26,24,22,20,18,16,14,12,10,8,6,4,2
	DB	#00
INTRO_OUT
	XOR	A
	OUT	(#FE),A
	LD	BC,#7FFD
	LD	A,IO_PG0
	OUT	(C),A
	;--
	LD	HL,INTRO_OUT_TBL
IO_HL	EQU	$-2
	LD	A,(HL)
	OR	A
	RET	Z
	;--
	LD	D,A
	LD	A,68
	SUB	D
	DEC	D
	RRA
	AND	%01111111
	LD	E,A
	;--
	EXX
	CALL	CLEARATTR
	;--
	NOP:NOP
	LD	DE,584
IO_W	DEC	DE
	LD	A,D
	OR	E
	JP	NZ,IO_W
	EXX
	
	;--
IO_1	LD	A,14	;7
	LD	A,14	;7
	DEC	A
	JP	NZ,$-1	;14*14 = 196
	DEC	E	;4
	JP	NZ,IO_1 ;10
	;--
	LD	A,IO_PG1	;7
	OUT	(C),A		;12
	LD	A,1		;7
	OUT	(#FE),A		;11

	;--
IO_2	LD	A,14	;7
	LD	A,14	;7
	DEC	A
	JP	NZ,$-1	;14*14 = 196
	DEC	D	;4
	JP	NZ,IO_2 ;10

	NOP:NOP
	LD	A,14	;7
	DEC	A
	JP	NZ,$-1	;14*13 = 182
	;--
	XOR	A		;4
	OUT	(#FE),A		;11
	LD	A,IO_PG0	;7
	OUT	(C),A		;12 /34
	;--
	LD	A,128 - 2
IO_SHOW	EQU	$-1
	OR	A
	JP	Z,IO_INC_HL
	DEC	A
	LD	(IO_SHOW),A
	RET
IO_INC_HL ;--
	LD	HL,(IO_HL)
	INC	HL
	LD	(IO_HL),HL
	RET
	
	;INCLUDE "getstat.asm"
	
	DISPLAY	"LOW END: ", /A, $
	DISPLAY	"LOW USAGE: ", /A, #6BDB
	
	